/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wspolicy.attachment;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.wspolicy.Policy;
import com.ibm.ws.wspolicy.PolicyConstants;
import com.ibm.ws.wspolicy.PolicyContext;
import com.ibm.ws.wspolicy.PolicyFactory;
import com.ibm.ws.wspolicy.PolicyReference;
import com.ibm.ws.wspolicy.PolicyWriter;
import com.ibm.ws.wspolicy.PolicyWriterContext;
import com.ibm.ws.wspolicy.WSPolicyInternalException;
import com.ibm.ws.wspolicy.attachment.AppliesTo;
import com.ibm.ws.wspolicy.attachment.PolicyAttachment;
import com.ibm.ws.wspolicy.attachment.PolicyAttachmentExtensibilityElement;
import com.ibm.ws.wspolicy.attachment.PolicyAttachmentScopeElement;
import com.ibm.ws.wspolicy.attachment.PolicyAttachmentScopeSerializer;
import com.ibm.ws.wspolicy.attachment.ScopeExtensionRegistry;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class PolicyAttachmentWriter {
    private static final TraceComponent TRACE_COMPONENT = Tr.register(PolicyAttachmentWriter.class, "WS-Policy", "com.ibm.ws.wspolicy.resources.CWPOLMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.wspolicy.resources.CWPOLMessages");
    private HashMap<String, String> _nsAliasMap;
    private ScopeExtensionRegistry _scopeExtensionRegistry;
    private PolicyContext _context;

    public PolicyAttachmentWriter(PolicyContext pContext) {
        this._context = pContext;
        this._scopeExtensionRegistry = new ScopeExtensionRegistry();
    }

    public void writePolicyAttachment(PolicyAttachment pa, Writer sink) throws WSPolicyInternalException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "writePolicyAttachment", "Writer,PolicyAttachment:" + pa);
        }
        AppliesTo appliesTo = null;
        Vector waps = null;
        PolicyAttachmentScopeElement attachPoint = null;
        this._nsAliasMap = new HashMap();
        Vector<QName> ns = new Vector<QName>(pa.getNamespaceDeclarations().keySet());
        Vector<String> nsValues = new Vector<String>(ns.size());
        for (int i = 0; i < ns.size(); ++i) {
            nsValues.add(pa.getAttribute(ns.get(i)));
        }
        String headerElement = this.getHeader(pa);
        try {
            sink.write(headerElement);
            Vector<QName> v = pa.getAllAttributeNames();
            for (QName key : v) {
                String value = pa.getAttribute(key);
                if (key.getNamespaceURI() != "") {
                    String nsAlias = null;
                    if (!nsValues.contains(key.getNamespaceURI())) {
                        nsAlias = this.addNs(key.getNamespaceURI());
                        nsValues.add(key.getNamespaceURI());
                        this._nsAliasMap.put(key.getNamespaceURI(), nsAlias);
                        sink.write(PolicyConstants.TAG_XMLNS + ":" + nsAlias + "=\"" + key.getNamespaceURI() + "\" " + nsAlias + ":" + key.getLocalPart() + "=\"" + value + "\"\n");
                        continue;
                    }
                    nsAlias = this.getNsAlias(key.getNamespaceURI());
                    sink.write(nsAlias + ":" + key.getLocalPart() + "=\"" + value + "\"\n");
                    continue;
                }
                sink.write(key + "=\"" + value + "\"\n");
            }
            sink.write(">\n");
            sink.flush();
            sink.write("<" + PolicyConstants.TAG_WSP + ":" + PolicyConstants.TAG_APPLIESTO + ">\n");
            appliesTo = pa.getAppliesTo();
            waps = appliesTo.getScopePoints();
            ListIterator sli = waps.listIterator();
            while (sli.hasNext()) {
                attachPoint = (PolicyAttachmentScopeElement)sli.next();
                QName elementType = attachPoint.getElementType();
                PolicyAttachmentScopeSerializer ss = this._scopeExtensionRegistry.getSerializer(elementType);
                if (ss == null) continue;
                ss.marshall(attachPoint, elementType, sink);
            }
            sink.write("</" + PolicyConstants.TAG_WSP + ":" + PolicyConstants.TAG_APPLIESTO + ">\n");
            Vector pref = pa.getPolicyRefs();
            ListIterator ri = pref.listIterator();
            while (ri.hasNext()) {
                StringBuffer buffer = new StringBuffer();
                PolicyReference pr = (PolicyReference)ri.next();
                buffer.append("<").append(PolicyConstants.TAG_WSP).append(":").append(PolicyConstants.TAG_POLICYREFERENCE);
                if (pr.getReferenceType() == PolicyConstants.TYPE_URI) {
                    buffer.append(" ").append(PolicyConstants.TYPE_URI).append("=\"").append(pr.getUri()).append("\"");
                }
                if (pr.getDigest() != null) {
                    buffer.append(" Digest=\"").append(pr.getDigest()).append("\"");
                }
                if (pr.getDigestAlgorithm() != null) {
                    buffer.append(" DigestAlgorithm=\"").append(pr.getDigestAlgorithm().toString()).append("\"");
                }
                buffer.append("/>\n");
                sink.write(buffer.toString());
            }
            PolicyWriterContext format = null;
            if (this._context != null) {
                format = (PolicyWriterContext)this._context.getProperty("SerializerFormatting");
            }
            if (format == null) {
                format = new PolicyWriterContext();
                format.setOmitXmlDecl(true);
                format.setIndenting(true);
                format.setLineSeparator("\n");
            }
            if (this._context != null) {
                this._context.setProperty("SerializerFormatting", format);
            }
            Vector pols = pa.getPolicies();
            ListIterator pi = pols.listIterator();
            while (pi.hasNext()) {
                Policy pol = (Policy)pi.next();
                PolicyFactory pf = new PolicyFactory(this._context);
                PolicyWriter pw = pf.newPolicyWriter();
                pw.writePolicy(pol, sink, this._context);
            }
            if (pa.getExtensibilityElements() != null && pa.getExtensibilityElements().size() > 0) {
                Vector extensibilityElements = pa.getExtensibilityElements();
                for (int j = 0; j < extensibilityElements.size(); ++j) {
                    PolicyAttachmentExtensibilityElement ee = (PolicyAttachmentExtensibilityElement)extensibilityElements.get(j);
                }
            }
            sink.write("</" + PolicyConstants.TAG_WSP + ":" + PolicyConstants.TAG_POLICYATTACHMENT + ">\n");
            sink.flush();
        }
        catch (Exception e) {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "writePolicyAttachment", "Exception");
            }
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.wspolicy.attachment.PolicyAttachmentWriter.writePolicyAttachment", "240", this);
            throw new WSPolicyInternalException(e);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "writePolicyAttachment");
        }
    }

    private String getHeader(PolicyAttachment pa) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getHeader", pa);
        }
        Vector<QName> ns = new Vector<QName>(pa.getNamespaceDeclarations().keySet());
        StringBuffer retVal = new StringBuffer("<" + PolicyConstants.TAG_WSP + ":" + PolicyConstants.TAG_POLICYATTACHMENT + " ");
        if (!ns.contains(new QName("http://www.w3.org/2000/xmlns/", PolicyConstants.TAG_WSP))) {
            retVal.append(PolicyConstants.TAG_XMLNS + ":" + PolicyConstants.TAG_WSP + "=\"" + "http://www.w3.org/ns/ws-policy" + "\"\n");
        }
        if (!ns.contains(new QName("http://www.w3.org/2000/xmlns/", "wsa"))) {
            retVal.append(PolicyConstants.TAG_XMLNS + ":" + "wsa" + "=\"" + "http://schemas.xmlsoap.org/ws/2004/08/addressing" + "\"\n");
        }
        for (int i = 0; i < ns.size(); ++i) {
            QName qname = ns.get(i);
            String value = pa.getAttribute(qname);
            retVal.append(PolicyConstants.TAG_XMLNS + ":" + qname.getLocalPart() + "=\"" + value + "\"\n");
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getHeader", retVal);
        }
        return retVal.toString();
    }

    public void writePolicyAttachment(PolicyAttachment policyAttachment, OutputStream sink) throws WSPolicyInternalException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "writePolicyAttachment", policyAttachment);
        }
        StringWriter sw = new StringWriter();
        this.writePolicyAttachment(policyAttachment, sw);
        try {
            sink.write(sw.toString().getBytes());
        }
        catch (IOException ioe) {
            FFDCFilter.processException((Throwable)ioe, "com.ibm.ws.wspolicy.attachment.PolicyAttachmentWriter.writePolicyAttachment", "314", this);
            throw new WSPolicyInternalException(ioe);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "writePolicyAttachment");
        }
    }

    private String getNsAlias(String namespace) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getNsAlias", namespace);
        }
        String retVal = this.isNsExtant(namespace) ? this._nsAliasMap.get(namespace) : null;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getNsAlias", retVal);
        }
        return retVal;
    }

    private void initilizeNsAliasMap(Element el) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "initilizeNsAliasMap");
        }
        this._nsAliasMap = new HashMap();
        NamedNodeMap nnm = el.getAttributes();
        if (nnm != null) {
            for (int j = 0; j < nnm.getLength(); ++j) {
                Node polAttrs = nnm.item(j);
                this._nsAliasMap.put(polAttrs.getNamespaceURI(), polAttrs.getPrefix());
            }
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "initilizeNsAliasMap");
        }
    }

    private boolean isNsExtant(String namespace) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "isNsExtant", namespace);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "isNsExtant");
        }
        return this._nsAliasMap.containsKey(namespace);
    }

    private String addNs(String namespace) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "addNs", namespace);
        }
        int val = this._nsAliasMap.size() + 1;
        String newAlias = PolicyConstants.TAG_NS + val;
        this._nsAliasMap.put(namespace, newAlias);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "addNs", newAlias);
        }
        return newAlias;
    }

    private QName caseQName(QName key) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "caseQName", key);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "caseQName");
        }
        return new QName(key.getNamespaceURI().toLowerCase(), key.getLocalPart().toLowerCase());
    }
}

