/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wspolicy.attachment;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.wspolicy.Policy;
import com.ibm.ws.wspolicy.PolicyConstants;
import com.ibm.ws.wspolicy.PolicyContext;
import com.ibm.ws.wspolicy.PolicyFactory;
import com.ibm.ws.wspolicy.PolicyReader;
import com.ibm.ws.wspolicy.PolicyReference;
import com.ibm.ws.wspolicy.PolicyReferenceException;
import com.ibm.ws.wspolicy.UnsupportedNamespaceException;
import com.ibm.ws.wspolicy.UnsupportedPolicyElementException;
import com.ibm.ws.wspolicy.WSPolicyInternalException;
import com.ibm.ws.wspolicy.attachment.AppliesTo;
import com.ibm.ws.wspolicy.attachment.PolicyAttachment;
import com.ibm.ws.wspolicy.attachment.PolicyAttachmentScopeDeserializer;
import com.ibm.ws.wspolicy.attachment.PolicyAttachmentScopeElement;
import com.ibm.ws.wspolicy.attachment.ScopeExtensionRegistry;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class PolicyAttachmentReader {
    private static final TraceComponent TRACE_COMPONENT = Tr.register(PolicyAttachmentReader.class, "WS-Policy", "com.ibm.ws.wspolicy.resources.CWPOLMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.wspolicy.resources.CWPOLMessages");
    private DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
    private DocumentBuilder db = null;
    private ScopeExtensionRegistry scopeExtensionRegistry = null;

    public PolicyAttachmentReader(PolicyContext pContext) throws WSPolicyInternalException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "PolicyAttachmentReader", pContext);
        }
        this.scopeExtensionRegistry = new ScopeExtensionRegistry();
        this.dbf.setNamespaceAware(true);
        try {
            this.db = this.dbf.newDocumentBuilder();
        }
        catch (Exception e) {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "Exception " + e + "was unexpectedly thrown during PolicyAttachmentReader");
            }
            throw new WSPolicyInternalException(e);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "PolicyAttachmentReader", this);
        }
    }

    public PolicyAttachment readPolicyAttachment(InputSource inSource) throws WSPolicyInternalException, UnsupportedNamespaceException, UnsupportedPolicyElementException, PolicyReferenceException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "readPolicyAttachment", new Object[]{inSource, this});
        }
        if (inSource == null) {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "The InputSource passed to the policy attachment reader was unexpectedly null");
            }
            throw new WSPolicyInternalException();
        }
        PolicyAttachment pa = null;
        InputStream byteStream = inSource.getByteStream();
        if (byteStream != null) {
            pa = this.readPolicyAttachment(inSource.getByteStream());
        } else {
            Reader reader = inSource.getCharacterStream();
            if (reader != null) {
                try {
                    pa = this.readPolicyAttachment(this.getByteArrayInputStream(reader));
                }
                catch (IOException e) {
                    throw new WSPolicyInternalException(e);
                }
            }
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "readPolicyAttachment", new Object[]{inSource, this});
        }
        return pa;
    }

    public PolicyAttachment readPolicyAttachment(InputStream inStream) throws WSPolicyInternalException, UnsupportedNamespaceException, UnsupportedPolicyElementException, PolicyReferenceException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "readPolicyAttachment", new Object[]{inStream, this});
        }
        PolicyAttachment pa = null;
        Document d = null;
        if (inStream == null) {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "The InputStream passed to the policy attachment reader was unexpectedly null");
            }
            throw new WSPolicyInternalException();
        }
        try {
            d = this.db.parse(inStream);
        }
        catch (Exception e) {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "Problem parsing policy document" + e);
            }
            throw new WSPolicyInternalException(e);
        }
        pa = this.readPolicyAttachment(d);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "readPolicyAttachment", pa);
        }
        return pa;
    }

    public PolicyAttachment readPolicyAttachment(Document polAttachmentDoc) throws WSPolicyInternalException, UnsupportedNamespaceException, UnsupportedPolicyElementException, PolicyReferenceException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "readPolicyAttachment", new Object[]{polAttachmentDoc, this});
        }
        if (polAttachmentDoc == null) {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "The Policy Attachment Document passed to the policy attachment reader was unexpectedly null");
            }
            throw new WSPolicyInternalException();
        }
        Element el = polAttachmentDoc.getDocumentElement();
        PolicyAttachment result = this.readPolicyAttachment(el, polAttachmentDoc);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "readPolicyAttachment", result);
        }
        return result;
    }

    public PolicyAttachment readPolicyAttachment(Element element) throws WSPolicyInternalException, UnsupportedNamespaceException, UnsupportedPolicyElementException, PolicyReferenceException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "readPolicyAttachment", new Object[]{element, this});
        }
        Document d = this.db.newDocument();
        Node n = d.importNode(element, true);
        Element el = (Element)d.appendChild(n);
        PolicyAttachment result = this.readPolicyAttachment(el, d);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "readPolicyAttachment", result);
        }
        return result;
    }

    private PolicyAttachment readPolicyAttachment(Element element, Document document) throws WSPolicyInternalException, UnsupportedNamespaceException, UnsupportedPolicyElementException, PolicyReferenceException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "readPolicyAttachment", new Object[]{element, document, this});
        }
        PolicyAttachment policyAttachment = new PolicyAttachment(null);
        AppliesTo appliesTo = new AppliesTo();
        if (element != null) {
            if (element.getLocalName().equalsIgnoreCase(PolicyConstants.TAG_POLICYATTACHMENT) && element.getNamespaceURI().equalsIgnoreCase("http://www.w3.org/ns/ws-policy")) {
                NamedNodeMap nla = element.getAttributes();
                Node attr = null;
                for (int a = 0; a < nla.getLength(); ++a) {
                    attr = nla.item(a);
                    QName qname = new QName(attr.getNamespaceURI(), attr.getLocalName());
                    policyAttachment.addAttribute(qname, attr.getNodeValue());
                }
                NodeList nl = element.getElementsByTagNameNS(element.getNamespaceURI(), PolicyConstants.TAG_APPLIESTO);
                if (nl.getLength() == 0) {
                    if (TRACE_COMPONENT.isDebugEnabled()) {
                        Tr.debug(TRACE_COMPONENT, "wsp:AppliesTo was expected but was not found.");
                    }
                    throw new WSPolicyInternalException();
                }
                Node appliesToNode = nl.item(0);
                if (appliesToNode.hasChildNodes()) {
                    NodeList attachPoints = appliesToNode.getChildNodes();
                    for (int j = 0; j < attachPoints.getLength(); ++j) {
                        Node attachPoint = attachPoints.item(j);
                        String ns = attachPoint.getNamespaceURI();
                        String local = attachPoint.getLocalName();
                        if (ns == null && local == null) continue;
                        QName elementType = new QName(ns, local);
                        PolicyAttachmentScopeDeserializer sd = this.scopeExtensionRegistry.getDeserializer(elementType);
                        if (sd != null) {
                            PolicyAttachmentScopeElement se = sd.unmarshall((Element)attachPoint, elementType);
                            appliesTo.addScopePoint(se);
                            continue;
                        }
                        if (TRACE_COMPONENT.isDebugEnabled()) {
                            Tr.debug(TRACE_COMPONENT, "No PolicyAttachmentScopeSerializer has been registered for element type " + elementType);
                        }
                        throw new WSPolicyInternalException();
                    }
                    policyAttachment.setAppliesTo(appliesTo);
                }
                nl = element.getElementsByTagNameNS(element.getNamespaceURI(), PolicyConstants.TAG_POLICYREFERENCE);
                for (int i = 0; i < nl.getLength(); ++i) {
                    Node n = nl.item(i);
                    PolicyFactory pf = new PolicyFactory();
                    PolicyReference pref = null;
                    if (!n.hasAttributes()) continue;
                    boolean test = false;
                    if (n.getAttributes().getNamedItem(PolicyConstants.TYPE_URI) != null) {
                        URI uri = null;
                        try {
                            uri = new URI(n.getAttributes().getNamedItem(PolicyConstants.TYPE_URI).getNodeValue());
                        }
                        catch (URISyntaxException e) {
                            FFDCFilter.processException((Throwable)e, "com.ibm.ws.wspolicy.attachment.PolicyAttachmentReader.readPolicyAttachment", "309", this);
                            throw new WSPolicyInternalException(e);
                        }
                        pref = pf.newPolicyReference(uri);
                        test = true;
                    }
                    if (n.getAttributes().getNamedItem(PolicyConstants.TAG_DIGEST) != null) {
                        String digest = n.getAttributes().getNamedItem(PolicyConstants.TAG_DIGEST).getNodeValue();
                        pref.setDigest(digest);
                    }
                    if (n.getAttributes().getNamedItem(PolicyConstants.TAG_DIGESTALGORITHM) != null) {
                        String digestAl = n.getAttributes().getNamedItem(PolicyConstants.TAG_DIGESTALGORITHM).getNodeValue();
                        URI digUri = null;
                        try {
                            digUri = new URI(digestAl);
                        }
                        catch (URISyntaxException e) {
                            FFDCFilter.processException((Throwable)e, "com.ibm.ws.wspolicy.attachment.PolicyAttachmentReader.readPolicyAttachment", "326", this);
                            throw new WSPolicyInternalException();
                        }
                        pref.setDigestAlgorithm(digUri);
                    }
                    if (!test) {
                        if (TRACE_COMPONENT.isDebugEnabled()) {
                            Tr.debug(TRACE_COMPONENT, "The PolicyAttachment XML document was ill-formed");
                        }
                        throw new WSPolicyInternalException();
                    }
                    policyAttachment.addPolicyRef(pref);
                }
                nl = element.getElementsByTagNameNS(element.getNamespaceURI(), PolicyConstants.TAG_POLICY);
                Node n = nl.item(0);
                PolicyFactory pf = new PolicyFactory();
                PolicyReader polReader = pf.newPolicyReader();
                ByteArrayOutputStream outStream = new ByteArrayOutputStream();
                try {
                    OutputFormat format = new OutputFormat(document);
                    format.setOmitXMLDeclaration(true);
                    XMLSerializer output = new XMLSerializer((OutputStream)outStream, format);
                    output.serialize(document);
                }
                catch (IOException ioe) {
                    FFDCFilter.processException((Throwable)ioe, "com.ibm.ws.wspolicy.attachment.PolicyAttachmentReader.readPolicyAttachment", "356", this);
                    throw new WSPolicyInternalException(ioe);
                }
                byte[] ba = outStream.toByteArray();
                ByteArrayInputStream inStream = new ByteArrayInputStream(ba);
                Vector<Policy> polList = polReader.readPolicies(inStream);
                Iterator<Policy> polIt = polList.iterator();
                while (polIt.hasNext()) {
                    policyAttachment.addPolicy(polIt.next());
                }
                nl = element.getChildNodes();
                for (int i = 0; i < nl.getLength(); ++i) {
                    n = nl.item(i);
                    if (!(n instanceof Element) || n.getLocalName().equalsIgnoreCase(PolicyConstants.TAG_POLICYREFERENCE) && n.getNamespaceURI().equalsIgnoreCase("http://www.w3.org/ns/ws-policy") || n.getLocalName().equalsIgnoreCase(PolicyConstants.TAG_POLICY) && n.getNamespaceURI().equalsIgnoreCase("http://www.w3.org/ns/ws-policy") || n.getLocalName().equalsIgnoreCase(PolicyConstants.TAG_APPLIESTO) && n.getNamespaceURI().equalsIgnoreCase("http://www.w3.org/ns/ws-policy")) continue;
                    String ns = n.getNamespaceURI();
                    String local = n.getLocalName();
                    QName elementType = new QName(ns, local);
                    if (TRACE_COMPONENT.isDebugEnabled()) {
                        Tr.debug(TRACE_COMPONENT, "No PolicyAttachmentExtensibilityElementDeserializer has been registered for the element " + elementType);
                    }
                    throw new WSPolicyInternalException();
                }
            } else {
                if (TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "Policy Attachment Element could not be found");
                }
                throw new WSPolicyInternalException();
            }
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "readPolicyAttachment", policyAttachment);
        }
        return policyAttachment;
    }

    public PolicyAttachment readPolicyAttachment(URL url) throws WSPolicyInternalException, UnsupportedNamespaceException, UnsupportedPolicyElementException, PolicyReferenceException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "readPolicyAttachment", new Object[]{url, this});
        }
        PolicyAttachment pa = null;
        try {
            pa = this.readPolicyAttachment(url.openStream());
        }
        catch (IOException e) {
            throw new WSPolicyInternalException(e);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "readPolicyAttachment", pa);
        }
        return pa;
    }

    private ByteArrayInputStream getByteArrayInputStream(Reader in) throws IOException {
        return new ByteArrayInputStream(this.getByteArray(in));
    }

    private byte[] getByteArray(Reader in) throws IOException {
        int count;
        int BUF_SIZE = 1024;
        StringBuffer everything = new StringBuffer();
        char[] polCharArray = new char[BUF_SIZE];
        while ((count = in.read(polCharArray, 0, BUF_SIZE)) > 0) {
            everything.append(new String(polCharArray, 0, count));
        }
        return everything.toString().getBytes();
    }
}

