/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wspolicy.attachment;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.wspolicy.Policy;
import com.ibm.ws.wspolicy.PolicyContext;
import com.ibm.ws.wspolicy.PolicyReference;
import com.ibm.ws.wspolicy.attachment.AppliesTo;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolicyAttachment {
    private AppliesTo appliesTo = new AppliesTo();
    private Vector<PolicyReference> policyRefs = new Vector();
    private Vector<Policy> policies = new Vector();
    private static final TraceComponent tc = Tr.register(PolicyAttachment.class, "WS-Policy", "com.ibm.ws.wspolicy.resources.CWPOLMessages");
    private HashMap<QName, String> attributes = new HashMap();
    private Vector extensibilityElements = new Vector();

    public PolicyAttachment(PolicyContext pContext) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "PolicyAttachment", pContext);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "PolicyAttachment", this);
        }
    }

    public AppliesTo getAppliesTo() {
        return this.appliesTo;
    }

    public void setAppliesTo(AppliesTo applTo) {
        this.appliesTo = applTo;
    }

    public Vector getPolicyRefs() {
        return this.policyRefs;
    }

    public void addPolicyRef(PolicyReference reference) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "addPolicyRef", new Object[]{reference, this});
        }
        if (!this.policyRefs.contains(reference)) {
            this.policyRefs.add(reference);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "addPolicyRef");
        }
    }

    public void removePolicyRef(PolicyReference reference) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "removePolicyRef", new Object[]{reference, this});
        }
        this.policyRefs.remove(reference);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "removePolicyRef");
        }
    }

    public void clearPolicyRefs() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "clearPolicyRefs", this);
        }
        this.policyRefs.clear();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "clearPolicyRefs");
        }
    }

    public Vector getPolicies() {
        return this.policies;
    }

    public Vector<QName> getAllAttributeNames() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getAllAttributeNames", this);
        }
        Vector<QName> keys = new Vector<QName>(this.attributes.keySet());
        Vector<QName> result = new Vector<QName>(keys.size());
        for (int i = 0; i < keys.size(); ++i) {
            QName qname = keys.get(i);
            if (qname.getNamespaceURI().equals("http://www.w3.org/2000/xmlns/")) continue;
            result.add(qname);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getAllAttributeNames", result);
        }
        return result;
    }

    protected HashMap<QName, String> getNamespaceDeclarations() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getNamespaceDeclarations", this);
        }
        Vector<QName> keys = new Vector<QName>(this.attributes.keySet());
        HashMap<QName, String> result = new HashMap<QName, String>(keys.size());
        for (int i = 0; i < keys.size(); ++i) {
            QName qname = keys.get(i);
            if (!qname.getNamespaceURI().equals("http://www.w3.org/2000/xmlns/")) continue;
            result.put(qname, this.attributes.get(qname));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getNamespaceDeclarations", result);
        }
        return result;
    }

    public void addPolicy(Policy policy) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "addPolicy", new Object[]{policy, this});
        }
        if (!this.policies.contains(policy)) {
            this.policies.add(policy);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "addPolicy");
        }
    }

    public void removePolicy(Policy policy) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "removePolicy", new Object[]{policy, this});
        }
        this.policies.remove(policy);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "removePolicy");
        }
    }

    public void clearPolicies() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "clearPolicies", this);
        }
        this.policies.clear();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "clearPolicies");
        }
    }

    public void addAttribute(QName name, String value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "addAttribute", new Object[]{name, value, this});
        }
        this.attributes.put(name, value);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "addAttribute");
        }
    }

    public void removeAttribute(QName name) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "removeAttribute", new Object[]{name, this});
        }
        this.attributes.remove(name);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "removeAttribute");
        }
    }

    public String getAttribute(QName name) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getAttribute", new Object[]{name, this});
        }
        String retVal = this.attributes.get(name);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getAttribute", retVal);
        }
        return retVal;
    }

    public void clearAllAttributes() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "clearAllAttributes", this);
        }
        Set<QName> keys = this.attributes.keySet();
        Iterator<QName> iter = keys.iterator();
        Vector<QName> attrsDelete = new Vector<QName>(keys.size());
        while (iter.hasNext()) {
            QName key = iter.next();
            if (key.getNamespaceURI().equals("http://www.w3.org/2000/xmlns/")) continue;
            attrsDelete.add(key);
        }
        for (int i = 0; i < attrsDelete.size(); ++i) {
            this.attributes.remove(attrsDelete.get(i));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "clearAllAttributes");
        }
    }

    public Vector getExtensibilityElements() {
        return this.extensibilityElements;
    }

    public void setExtensibilityElements(Vector vector) {
        this.extensibilityElements = vector;
    }
}

