/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wspolicy.assertions;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.wspolicy.Policy;
import com.ibm.ws.wspolicy.PolicyConstants;
import com.ibm.ws.wspolicy.PolicyFactory;
import com.ibm.ws.wspolicy.PolicyReferenceException;
import com.ibm.ws.wspolicy.WSPolicyBindingsException;
import com.ibm.ws.wspolicy.WSPolicyInternalException;
import com.ibm.ws.wspolicy.alternatives.Alternative;
import com.ibm.ws.wspolicy.alternatives.AlternativesIterator;
import com.ibm.ws.wspolicy.assertions.AssertionImpl;
import com.ibm.ws.wspolicy.domain.Assertion;
import com.ibm.ws.wspolicy.domain.PolicyProviderRegistry;
import com.ibm.ws.wspolicy.operators.AllOperator;
import com.ibm.ws.wspolicy.operators.ExactlyOneOperator;
import java.util.Vector;
import javax.xml.namespace.QName;

public class NestedPolicyElementUtil {
    private static final TraceComponent tc = Tr.register(NestedPolicyElementUtil.class, "WS-Policy", "com.ibm.ws.wspolicy.resources.CWPOLMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.wspolicy.resources.CWPOLMessages");
    private static final PolicyProviderRegistry _policyProviderRegistry = PolicyProviderRegistry.getInstance();

    private static Policy buildPolicy(Vector assertions) {
        PolicyFactory fact = new PolicyFactory();
        Policy result = fact.newPolicy();
        ExactlyOneOperator eo = new ExactlyOneOperator();
        Vector<ExactlyOneOperator> topLevelAssertion = new Vector<ExactlyOneOperator>();
        topLevelAssertion.add(eo);
        Vector<AllOperator> vEO = new Vector<AllOperator>();
        eo.setChildAssertions(vEO);
        AllOperator ao = new AllOperator();
        ao.setChildAssertions(assertions);
        vEO.add(ao);
        result.setChildAssertions(topLevelAssertion);
        return result;
    }

    public static Vector normalize(AssertionImpl assertion) throws WSPolicyInternalException, PolicyReferenceException {
        Vector<AssertionImpl> result = new Vector<AssertionImpl>();
        assertion.getPolicy().normalize();
        AlternativesIterator altItr = assertion.getPolicy().iterator();
        while (altItr.hasNext()) {
            AssertionImpl newAssertion;
            Alternative alternative = (Alternative)altItr.next();
            try {
                newAssertion = (AssertionImpl)assertion.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new WSPolicyInternalException();
            }
            Policy newPolicy = NestedPolicyElementUtil.buildPolicy(alternative.getAssertions());
            newAssertion.setPolicy(newPolicy);
            result.add(newAssertion);
        }
        return result;
    }

    public static boolean singularizeSubPolicies(AssertionImpl assertion, String iterationType) throws WSPolicyInternalException, PolicyReferenceException {
        Policy p1;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "singularizeSubPolicies");
        }
        if ((p1 = assertion.getPolicy()) == null) {
            return false;
        }
        AlternativesIterator altItr1 = p1.iterator(iterationType);
        if (altItr1.hasNext()) {
            Alternative a1 = (Alternative)altItr1.next();
            if (a1.containsNestedAssertions()) {
                a1.singularizeSubPolicies(iterationType);
            }
            assertion.setPolicy(NestedPolicyElementUtil.buildPolicy(a1.getAssertions()));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "singularizeSubPolicies", Boolean.TRUE);
            }
            return true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "singularizeSubPolicies", Boolean.FALSE);
        }
        return false;
    }

    public static boolean intersectAndNormalizeSubPolicies(AssertionImpl assertion, AssertionImpl assertion2, String iterationType, String intersectionType) throws PolicyReferenceException, WSPolicyInternalException, WSPolicyBindingsException {
        Policy p1;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "intersectAndNormalizeSubPolicies", new Object[]{assertion, iterationType});
        }
        if ((p1 = assertion.getPolicy()) == null) {
            return false;
        }
        Policy p2 = assertion2.getPolicy();
        if (p2 == null) {
            return false;
        }
        AlternativesIterator altItr1 = p1.iterator(iterationType);
        AlternativesIterator altItr2 = p2.iterator(iterationType);
        while (altItr1.hasNext()) {
            Alternative a1 = (Alternative)altItr1.next();
            altItr2.reset();
            while (altItr2.hasNext()) {
                Alternative a2 = (Alternative)altItr2.next();
                if ((!"Lax".equals(intersectionType) || !a1.getVocabulary().containsAll(a2.getNonIgnorableVocabulary()) || !a2.getVocabulary().containsAll(a1.getNonIgnorableVocabulary())) && (!"Strict".equals(intersectionType) || !a1.getVocabularyStr().equals(a2.getVocabularyStr())) || a1.containsNestedAssertions() && !a1.intersectAndNormalizeNested(p1, a2, iterationType, intersectionType)) continue;
                Vector<Assertion> mergedAlternatives = new Vector<Assertion>(a1.getAssertions());
                mergedAlternatives.addAll(a2.getAssertions());
                Alternative result = new Alternative(mergedAlternatives);
                if (result != null) {
                    boolean support = p1.alternativeCheck(result, iterationType, intersectionType);
                    if (!support) continue;
                    assertion.setPolicy(NestedPolicyElementUtil.buildPolicy(result.getAssertions()));
                    assertion2.setPolicy(NestedPolicyElementUtil.buildPolicy(result.getAssertions()));
                }
                return true;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "intersectAndNormalizeSubPolicies", Boolean.FALSE);
        }
        return false;
    }

    public static boolean intersectAndNormalizeSubPoliciesWithClientCapabilities(AssertionImpl clientAssertion, AssertionImpl providerAssertion, String iterationType, String intersectionType, Policy clientTopLevelPolicy) throws PolicyReferenceException, WSPolicyInternalException, WSPolicyBindingsException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "intersectAndNormalizeSubPoliciesWithClientCapabilities", new Object[]{clientAssertion, iterationType});
        }
        WSPolicyBindingsException wspbe = null;
        Policy clientPolicy = clientAssertion.getPolicy();
        if (clientPolicy == null) {
            return false;
        }
        Policy providerPolicy = providerAssertion.getPolicy();
        if (providerPolicy == null) {
            return false;
        }
        AlternativesIterator clientAltIt = clientPolicy.iterator(iterationType);
        AlternativesIterator providerAltIt = providerPolicy.iterator(iterationType);
        while (clientAltIt.hasNext()) {
            Alternative clientAlternative = (Alternative)clientAltIt.next();
            providerAltIt.reset();
            while (providerAltIt.hasNext()) {
                Alternative providerAlternative;
                block16: {
                    providerAlternative = (Alternative)providerAltIt.next();
                    Vector<QName> providerVocab = providerAlternative.getVocabulary();
                    Vector<QName> clientVocab = null;
                    clientVocab = "Lax".equals(intersectionType) ? clientAlternative.getNonIgnorableVocabulary() : clientAlternative.getVocabulary();
                    if (!providerVocab.containsAll(clientVocab)) continue;
                    providerVocab.removeAll(clientAlternative.getVocabulary());
                    boolean capabilitiesOK = true;
                    for (QName qn : providerVocab) {
                        if (_policyProviderRegistry.isClientCapability(qn, clientTopLevelPolicy)) continue;
                        capabilitiesOK = false;
                        break;
                    }
                    if (!capabilitiesOK) continue;
                    if (providerAlternative.containsNestedAssertions() || clientAlternative.containsNestedAssertions()) {
                        try {
                            if (!clientAlternative.intersectAndNormalizeNestedWithClientCapabilities(clientPolicy, providerAlternative, iterationType, intersectionType, clientTopLevelPolicy)) {
                            }
                            break block16;
                        }
                        catch (WSPolicyBindingsException e) {
                            wspbe = e;
                        }
                        continue;
                    }
                }
                Vector<Assertion> mergedAlternatives = new Vector<Assertion>(clientAlternative.getAssertions());
                mergedAlternatives.addAll(providerAlternative.getAssertions());
                Alternative result = new Alternative(mergedAlternatives);
                if (result != null) {
                    boolean support = false;
                    try {
                        support = clientPolicy.alternativeCheck(result, iterationType, intersectionType);
                    }
                    catch (WSPolicyBindingsException e) {
                        wspbe = e;
                    }
                    if (!support) continue;
                    clientAssertion.setPolicy(NestedPolicyElementUtil.buildPolicy(result.getAssertions()));
                    providerAssertion.setPolicy(NestedPolicyElementUtil.buildPolicy(result.getAssertions()));
                }
                return true;
            }
        }
        if (wspbe != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "intersectAndNormalizeSubPoliciesWithClientCapabilities", wspbe);
            }
            throw wspbe;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "intersectAndNormalizeSubPoliciesWithClientCapabilities", Boolean.FALSE);
        }
        return false;
    }

    public static boolean isCompatible(AssertionImpl assertion, AssertionImpl assertion2, String mode) throws PolicyReferenceException, WSPolicyInternalException, WSPolicyBindingsException {
        Policy p1 = assertion.getPolicy();
        Policy p2 = assertion2.getPolicy();
        if (p1 == null || p2 == null) {
            return true;
        }
        Policy intersectedPolicy = p1.intersect(p2, mode);
        boolean result = false;
        AlternativesIterator it = intersectedPolicy.iterator(PolicyConstants.FILTER_LOGICAL);
        if (it != null && it.hasNext()) {
            result = true;
        }
        return result;
    }
}

