/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wspolicy.assertions;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.wspolicy.ParameterImpl;
import com.ibm.ws.wspolicy.Policy;
import com.ibm.ws.wspolicy.PolicyConstants;
import com.ibm.ws.wspolicy.PolicyContext;
import com.ibm.ws.wspolicy.PolicyFactory;
import com.ibm.ws.wspolicy.PolicyReader;
import com.ibm.ws.wspolicy.PolicyWriter;
import com.ibm.ws.wspolicy.PolicyWriterContext;
import com.ibm.ws.wspolicy.WSPolicyException;
import com.ibm.ws.wspolicy.alternatives.Alternative;
import com.ibm.ws.wspolicy.assertions.AssertionImpl;
import com.ibm.ws.wspolicy.attachment.PolicyAttachmentScopeElement;
import com.ibm.ws.wspolicy.attachment.WSDLAttachPoint;
import com.ibm.ws.wspolicy.domain.Parameter;
import com.ibm.ws.wspolicy.utils.InternalUtils;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultAssertion
implements AssertionImpl {
    private transient Policy _owningPolicy;
    private QName _qName;
    private HashMap<QName, String> _attributes;
    private HashMap<String, String> _namespaces;
    private int _cacheHash;
    private boolean _clonedCopy;
    private WSDLAttachPoint _attachPoint;
    private DefaultAssertion _clonedReference;
    private String _comment;
    private Policy _nestedpolicy;
    private PolicyReader _policyReader;
    protected boolean _choiceMade;
    protected boolean _subAssertionsExtracted;
    private Alternative _alternative;
    private Element _element;
    private PolicyFactory _policyFactory;
    private String _parametersAsString = "";
    private boolean _dirtyAssertion = true;
    private boolean _containsNestedAssertions;
    protected Vector<Parameter> _parameters = new Vector();
    private static final QName OPTIONAL_QNAME = new QName("http://www.w3.org/ns/ws-policy", PolicyConstants.ATTRIBUTE_OPTIONAL);
    private static final QName IGNORABLE_QNAME = new QName("http://www.w3.org/ns/ws-policy", PolicyConstants.ATTRIBUTE_IGNORABLE);
    private static final TraceComponent tc = Tr.register(DefaultAssertion.class, "WS-Policy", "com.ibm.ws.wspolicy.resources.CWPOLMessages");

    public DefaultAssertion(QName qName) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "DefaultAssertion", qName);
        }
        this._qName = qName;
        this._namespaces = new HashMap();
        this._attributes = new HashMap();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "DefaultAssertion", this);
        }
    }

    public DefaultAssertion(Element element, QName qName) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "DefaultAssertion", qName);
        }
        this._qName = qName;
        this._namespaces = new HashMap();
        this._attributes = new HashMap();
        this._element = element;
        this._containsNestedAssertions = true;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "DefaultAssertion", this);
        }
    }

    @Override
    public QName getQName() {
        return this._qName;
    }

    @Override
    public QName getAssertionName() {
        return this._qName;
    }

    @Override
    public boolean isOptional() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "isOptional", this);
        }
        boolean result = false;
        String optional = this.getAttribute(OPTIONAL_QNAME);
        if (optional == null || optional.length() == 0) {
            result = false;
        } else if (optional.equals("1") || optional.equalsIgnoreCase("true")) {
            result = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "isOptional", result);
        }
        return result;
    }

    @Override
    public void setOptional(boolean flag) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "setOptional", new Object[]{flag, this});
        }
        this.signalPolicyAmend();
        this.removeAttribute(OPTIONAL_QNAME);
        if (flag) {
            this.addAttribute(OPTIONAL_QNAME, "true");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "setOptional");
        }
    }

    public String getNamespaceURI() {
        return this._qName.getNamespaceURI();
    }

    public void parseParameters(Element element) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "parseParameters");
        }
        NodeList nl = element.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() == 1) {
                if ((n.getLocalName().equalsIgnoreCase(PolicyConstants.ELEMENT_POLICY) || n.getLocalName().equalsIgnoreCase(PolicyConstants.ELEMENT_POLICYREF)) && n.getNamespaceURI().equalsIgnoreCase("http://www.w3.org/ns/ws-policy")) continue;
                Parameter param = this.processParameter(n);
                this.setParameter(param);
                continue;
            }
            if (n.getNodeType() != 3) continue;
            String nodeValue = n.getNodeValue();
            if ((nodeValue = nodeValue.trim()).length() <= 0) continue;
            this.setParameter(new ParameterImpl(null, nodeValue));
        }
        this.flattenParameters(null);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "parseParameters");
        }
    }

    private Parameter processParameter(Node n) {
        String prefix;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "processParameter");
        }
        if ((prefix = n.getPrefix()) == null) {
            prefix = "";
        }
        ParameterImpl param = new ParameterImpl(new QName(n.getNamespaceURI(), n.getLocalName(), prefix));
        NamedNodeMap map = n.getAttributes();
        for (int j = 0; j < map.getLength(); ++j) {
            Node nAttr = map.item(j);
            if (nAttr.getLocalName().equals(n.getPrefix()) && "xmlns".equals(nAttr.getPrefix())) continue;
            String ns = nAttr.getNamespaceURI();
            if (ns == null || ns.equals("")) {
                param.setAttribute(new QName(nAttr.getLocalName()), nAttr.getNodeValue());
                continue;
            }
            String aPrefix = nAttr.getPrefix();
            if (aPrefix == null || aPrefix.equals("")) {
                param.setAttribute(new QName(ns, nAttr.getLocalName()), nAttr.getNodeValue());
                continue;
            }
            param.setAttribute(new QName(ns, nAttr.getLocalName(), aPrefix), nAttr.getNodeValue());
        }
        this.processParameterValue(n, param);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "processParameter");
        }
        return param;
    }

    private void processParameterValue(Node n, Parameter param) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "processParameterValue");
        }
        NodeList nl = n.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node nChild = nl.item(i);
            if (nChild.getNodeType() == 1) {
                Parameter subParam = this.processParameter(nChild);
                param.addSubParameter(subParam);
                continue;
            }
            if (nChild.getNodeType() != 3) continue;
            String nodeValue = nChild.getNodeValue();
            if ((nodeValue = nodeValue.trim()).length() <= 0) continue;
            param.setParameterValue(nodeValue);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "processParameterValue");
        }
    }

    @Override
    public Policy getPolicy() {
        if (this._nestedpolicy == null) {
            Policy policy = this.extractPolicyFromDom(this.getDomElement());
            this.setPolicy(policy);
        }
        return this._nestedpolicy;
    }

    @Override
    public void setPolicy(Policy policy) {
        this._nestedpolicy = policy;
        this._dirtyAssertion = true;
        this.clearCacheHash();
        if (policy != null) {
            this._containsNestedAssertions = true;
            this._policyReader = policy.getReader();
            this._choiceMade = false;
            this._alternative = null;
            this._subAssertionsExtracted = false;
        }
    }

    public void setDomElement(Element element) {
        this._element = element;
    }

    public Element getDomElement() {
        return this._element;
    }

    private Policy extractPolicyFromDom(Element element) {
        Policy result;
        block3: {
            result = null;
            try {
                if (element == null) break block3;
                NodeList nodeList = element.getChildNodes();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Element child;
                    if (nodeList.item(i).getNodeType() != 1 || !(child = (Element)nodeList.item(i)).getLocalName().equalsIgnoreCase(PolicyConstants.ELEMENT_POLICY) && !child.getLocalName().equalsIgnoreCase(PolicyConstants.ELEMENT_POLICYREF) || !child.getNamespaceURI().equalsIgnoreCase("http://www.w3.org/ns/ws-policy")) continue;
                    result = this.getPolicyReader().readPolicy(child);
                    break;
                }
            }
            catch (WSPolicyException wSPolicyException) {
                // empty catch block
            }
        }
        return result;
    }

    private PolicyReader getPolicyReader() {
        if (this._policyReader == null) {
            if (this.getOwningPolicy() != null) {
                this._policyReader = this.getOwningPolicy().getReader();
            }
            if (this._policyReader == null) {
                this._policyReader = this.getPolicyFactory().newPolicyReader();
            }
        }
        return this._policyReader;
    }

    protected PolicyFactory getPolicyFactory() {
        if (this._policyFactory == null) {
            this._policyFactory = new PolicyFactory();
        }
        return this._policyFactory;
    }

    protected Policy getOwningPolicy() {
        return this._owningPolicy;
    }

    public void setOwningPolicy(Policy policy) {
        this._owningPolicy = policy;
    }

    private void signalPolicyAmend() {
        Policy pol;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "signalPolicyAmend", this);
        }
        if (!this._clonedCopy && (pol = this.getOwningPolicy()) != null) {
            pol.signalAmended();
        }
        this._cacheHash = 0;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "signalPolicyAmend");
        }
    }

    @Override
    public PolicyAttachmentScopeElement getScope() {
        return this._attachPoint;
    }

    @Override
    public void setScope(PolicyAttachmentScopeElement scope) {
        this._attachPoint = (WSDLAttachPoint)scope;
    }

    @Override
    public String getComment() {
        return this._comment;
    }

    @Override
    public void setComment(String comment) {
        this._dirtyAssertion = true;
        this.clearCacheHash();
        this._comment = comment;
    }

    public String getParametersAsString() {
        if (this._dirtyAssertion) {
            this.flattenParameters(null);
        }
        return this._parametersAsString;
    }

    public String flattenParameters(HashMap<String, String> namespaces) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "flattenParameters");
        }
        this._parametersAsString = "";
        if (this._parameters != null) {
            for (int i = 0; i < this._parameters.size(); ++i) {
                this._parametersAsString = this._parametersAsString.concat(this._parameters.get(i).getXMLString(namespaces));
            }
        }
        this._dirtyAssertion = false;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "flattenParameters");
        }
        return this._parametersAsString;
    }

    @Override
    public Iterator getParameters(QName parameterName) {
        Vector<Parameter> params = new Vector<Parameter>();
        for (int i = 0; i < this._parameters.size(); ++i) {
            if (parameterName == null) {
                if (this._parameters.get(i).getParameterName() != null) continue;
                params.add(this._parameters.get(i));
                continue;
            }
            if (!parameterName.equals(this._parameters.get(i).getParameterName())) continue;
            params.add(this._parameters.get(i));
        }
        return params.iterator();
    }

    @Override
    public Iterator getAllParameterNames() {
        HashSet<QName> params = new HashSet<QName>();
        for (int i = 0; i < this._parameters.size(); ++i) {
            params.add(this._parameters.get(i).getParameterName());
        }
        return params.iterator();
    }

    @Override
    public void setParameter(Parameter parameter) {
        this._dirtyAssertion = true;
        this.clearCacheHash();
        this._parameters.add(parameter);
    }

    public String toString(PolicyContext policyContext) {
        if (!this._containsNestedAssertions) {
            HashMap namespaces = null;
            String indent = InternalUtils.getIndentAsString(policyContext);
            if (policyContext != null) {
                namespaces = (HashMap)policyContext.getProperty("DeclaredNamespaces");
            }
            String elementAlias = InternalUtils.getElementAlias(this, namespaces);
            String contentString = null;
            HashMap<String, String> thisNS2PrefixMap = namespaces == null ? new HashMap<String, String>() : new HashMap(namespaces);
            thisNS2PrefixMap.put(this.getNamespaceURI(), elementAlias);
            contentString = this.flattenParameters(thisNS2PrefixMap);
            return InternalUtils.formatString(this, contentString, elementAlias, namespaces, indent);
        }
        HashMap namespaces = null;
        if (policyContext != null) {
            namespaces = (HashMap)policyContext.getProperty("DeclaredNamespaces");
        }
        String elementAlias = InternalUtils.getElementAlias(this, namespaces);
        String contentString = "";
        try {
            StringWriter sw = new StringWriter();
            PolicyContext serContext = DefaultAssertion.prepareSerializationContext(this, policyContext, namespaces, elementAlias);
            PolicyWriter pWriter = this.getPolicyFactory().newPolicyWriter();
            pWriter.writePolicy(this.getPolicy(), sw, serContext);
            contentString = contentString + sw.toString();
        }
        catch (WSPolicyException pex) {
            contentString = pex.toString();
        }
        return InternalUtils.formatString(this, contentString, elementAlias, namespaces, InternalUtils.getIndentAsString(policyContext));
    }

    public static PolicyContext prepareSerializationContext(DefaultAssertion assertion, PolicyContext policyContext, HashMap<String, String> currentNamespaces, String elementAlias) {
        PolicyContext result = new PolicyContext(policyContext);
        PolicyWriterContext format = InternalUtils.getPolicyWriterContext(result);
        format.increaseIndentation();
        HashMap<String, String> namespacesDeclaredHere = DefaultAssertion.checkNamespaceDeclarations(assertion, elementAlias, currentNamespaces);
        if (currentNamespaces != null) {
            namespacesDeclaredHere.putAll(currentNamespaces);
        }
        result.setProperty("DeclaredNamespaces", namespacesDeclaredHere);
        return result;
    }

    private static HashMap<String, String> checkNamespaceDeclarations(DefaultAssertion assertion, String elementAlias, HashMap existingNamespaces) {
        if (existingNamespaces == null) {
            existingNamespaces = new HashMap();
        }
        HashMap<String, String> localNamespaces = new HashMap<String, String>();
        if (!existingNamespaces.containsValue(elementAlias)) {
            localNamespaces.put(assertion.getQName().getNamespaceURI(), elementAlias);
        }
        Vector<QName> attributeNames = assertion.getAllAttributeNames();
        for (int i = 0; i < attributeNames.size(); ++i) {
            QName tName = attributeNames.get(i);
            String attributelocalPart = tName.getLocalPart();
            String attributeNamespaceURI = tName.getNamespaceURI();
            String alias = null;
            if (!localNamespaces.containsKey(attributeNamespaceURI) && !existingNamespaces.containsKey(attributeNamespaceURI)) {
                alias = attributelocalPart.toLowerCase();
                int counter = 1;
                while (existingNamespaces.containsValue(alias) || localNamespaces.containsValue(alias)) {
                    alias = attributelocalPart.toLowerCase() + counter++;
                }
                localNamespaces.put(attributeNamespaceURI, alias);
                continue;
            }
            alias = localNamespaces.get(attributeNamespaceURI) != null ? localNamespaces.get(attributeNamespaceURI) : (String)existingNamespaces.get(attributeNamespaceURI);
        }
        return localNamespaces;
    }

    public String toString() {
        return this.toString(null);
    }

    @Override
    public final int hashCode() {
        if (this._cacheHash == 0) {
            this._cacheHash = this.calcNewHash();
        }
        return this._cacheHash;
    }

    public int calcNewHash() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "calcNewHash", this);
        }
        if (this._nestedpolicy != null) {
            return this.calcNewHashSubPolicy();
        }
        int retVal = 0;
        String bigStr = "";
        bigStr = bigStr + this.getQName().toString();
        if (this.getParametersAsString() != null) {
            bigStr = bigStr + this.getParametersAsString();
        }
        Vector<QName> names = this.getAllAttributeNames();
        for (int i = 0; i < names.size(); ++i) {
            QName name = names.get(i);
            String value = this.getAttribute(name);
            if (name.getNamespaceURI().equals("http://www.w3.org/ns/ws-policy") || name.getNamespaceURI().equals(PolicyConstants.TAG_XMLNS)) continue;
            bigStr = bigStr + (name + value).toUpperCase();
        }
        retVal = bigStr.hashCode();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "calcNewHash", retVal);
        }
        return retVal;
    }

    public int calcNewHashSubPolicy() {
        StringBuffer hashBase = new StringBuffer(this.getQName().toString());
        if (this._choiceMade && this._alternative != null) {
            hashBase.append(this._alternative.hashCode());
        } else {
            hashBase.append(this.getPolicy().hashCode());
        }
        Vector<QName> names = this.getAllAttributeNames();
        Vector<Integer> attribHashCodes = new Vector<Integer>();
        for (int i = 0; i < names.size(); ++i) {
            QName name = names.get(i);
            String value = this.getAttribute(name);
            if (name.getNamespaceURI().equals("http://www.w3.org/ns/ws-policy") || name.getNamespaceURI().equals(PolicyConstants.TAG_XMLNS)) continue;
            attribHashCodes.add(name.toString().hashCode() + value.hashCode());
        }
        Object[] sortedHashCodes = attribHashCodes.toArray();
        Arrays.sort(sortedHashCodes);
        for (int j = 0; j < sortedHashCodes.length; ++j) {
            hashBase.append(sortedHashCodes[j].toString());
        }
        int retVal = hashBase.toString().toUpperCase().hashCode();
        return retVal;
    }

    public void clearCacheHash() {
        this._cacheHash = 0;
    }

    public int compareTo(Object obj) {
        return this.hashCode() - obj.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof AssertionImpl) {
            AssertionImpl l = (AssertionImpl)obj;
            return ((Object)l).hashCode() == this.hashCode();
        }
        return false;
    }

    public void addAttribute(QName name, String value) {
        this._dirtyAssertion = true;
        this.signalPolicyAmend();
        this.clearCacheHash();
        this.removeAttribute(name);
        this._attributes.put(name, value);
    }

    @Override
    public void setAttribute(QName name, String value) {
        this.addAttribute(name, value);
    }

    public void removeAttribute(QName name) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "removeAttribute", new Object[]{name, this});
        }
        this._attributes.remove(name);
        this._dirtyAssertion = true;
        this.clearCacheHash();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "removeAttribute");
        }
    }

    public String getAttribute(QName name) {
        String retVal = this._attributes.get(name);
        return retVal;
    }

    @Override
    public String getAttributeValue(QName name) {
        return this.getAttribute(name);
    }

    public void clearAllAttributes() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "clearAllAttributes", this);
        }
        this.signalPolicyAmend();
        this.clearCacheHash();
        this._attributes.clear();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "clearAllAttributes");
        }
    }

    public Vector<QName> getAllAttributeNames() {
        Vector<QName> retVal = new Vector<QName>(this._attributes.keySet());
        return retVal;
    }

    @Override
    public Iterator getAttributeNames() {
        Iterator<QName> retVal = this._attributes.keySet().iterator();
        return retVal;
    }

    public void removeOptionalAttribute() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "removeOptionalAttribute", this);
        }
        this.removeAttribute(OPTIONAL_QNAME);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "removeOptionalAttribute");
        }
    }

    public HashMap<String, String> getNamespaceDeclarations() {
        return this._namespaces;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "clone", this);
        }
        DefaultAssertion assertion = (DefaultAssertion)super.clone();
        assertion._namespaces = new HashMap<String, String>(assertion._namespaces);
        assertion._attributes = new HashMap<QName, String>(assertion._attributes);
        assertion._clonedCopy = true;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "clone", assertion);
        }
        return assertion;
    }

    public DefaultAssertion getCloneInstance() throws CloneNotSupportedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getCloneInstance", this);
        }
        if (this._clonedReference == null) {
            this._clonedReference = (DefaultAssertion)this.clone();
            this._clonedReference.removeOptionalAttribute();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getCloneInstance", this._clonedReference);
        }
        return this._clonedReference;
    }

    @Override
    public boolean isIgnorable() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "isIgnorable", this);
        }
        boolean result = false;
        String ignorable = this.getAttribute(IGNORABLE_QNAME);
        if (ignorable == null || ignorable.length() == 0) {
            result = false;
        } else if (ignorable.equals("1") || ignorable.equalsIgnoreCase("true")) {
            result = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "isIgnorable", result);
        }
        return result;
    }

    @Override
    public void setIgnorable(boolean flag) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "setIgnorable", new Object[]{flag, this});
        }
        this.signalPolicyAmend();
        this.removeAttribute(IGNORABLE_QNAME);
        if (flag) {
            this.addAttribute(IGNORABLE_QNAME, "true");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "setIgnorable");
        }
    }

    @Override
    public boolean containsNestedAssertions() {
        return this._containsNestedAssertions;
    }
}

