/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wspolicy.assertions;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.wspolicy.AssertionSerializerImpl;
import com.ibm.ws.wspolicy.assertions.AssertionDeserializer;
import com.ibm.ws.wspolicy.assertions.AssertionSerializer;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.xml.namespace.QName;
import sun.misc.Service;
import sun.misc.ServiceConfigurationError;

public class AssertionExtensionRegistry {
    private static final TraceComponent tc = Tr.register(AssertionExtensionRegistry.class, "WS-Policy", "com.ibm.ws.wspolicy.resources.CWPOLMessages");
    private Map serializers = new Hashtable();
    private Map deserializers = new Hashtable();
    private AssertionSerializer defaultAssertionSerializer;
    private AssertionDeserializer defaultAssertionDeserializer;
    private static AssertionExtensionRegistry selfReference;

    private AssertionExtensionRegistry() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "AssertionExtensionRegistry");
        }
        Iterator dIter = Service.providers(AssertionDeserializer.class);
        while (dIter != null && dIter.hasNext()) {
            try {
                AssertionDeserializer ds = (AssertionDeserializer)dIter.next();
                Vector elements = ds.getSupportedElementType();
                for (int i = 0; i < elements.size(); ++i) {
                    QName key = (QName)elements.get(i);
                    this.deserializers.put(key, ds);
                }
            }
            catch (ServiceConfigurationError e) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Assertion deserializer class could not be found " + e.toString());
            }
            catch (NoClassDefFoundError e) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Assertion deserializer class could not be found " + e.toString());
            }
        }
        Iterator sIter = Service.providers(AssertionSerializer.class);
        while (sIter != null && sIter.hasNext()) {
            try {
                AssertionSerializer ss = (AssertionSerializer)sIter.next();
                Vector elements = ss.getSupportedElementType();
                for (int i = 0; i < elements.size(); ++i) {
                    QName key = (QName)elements.get(i);
                    this.serializers.put(key, ss);
                }
            }
            catch (ServiceConfigurationError e) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Assertion serializer class could not be found " + e.toString());
            }
            catch (NoClassDefFoundError e) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Assertion serializer class could not be found " + e.toString());
            }
        }
        AssertionSerializerImpl ds = new AssertionSerializerImpl();
        this.defaultAssertionSerializer = ds;
        this.defaultAssertionDeserializer = ds;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "AssertionExtensionRegistry", this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AssertionExtensionRegistry getAssertionExtensionRegistry() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getAssertionExtensionRegistry");
        }
        Class<AssertionExtensionRegistry> clazz = AssertionExtensionRegistry.class;
        synchronized (AssertionExtensionRegistry.class) {
            if (selfReference == null) {
                selfReference = new AssertionExtensionRegistry();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getAssertionExtensionRegistry", selfReference);
            }
            return selfReference;
        }
    }

    public void registerSerializer(QName elementType, AssertionSerializer scopeSerializer) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "registerSerializer", new Object[]{elementType, scopeSerializer, this});
        }
        this.serializers.put(elementType, scopeSerializer);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "registerSerializer");
        }
    }

    public AssertionSerializer getSerializer(QName elementType) {
        AssertionSerializer as;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getSerializer", new Object[]{elementType, this});
        }
        if ((as = (AssertionSerializer)this.serializers.get(elementType)) == null) {
            as = this.defaultAssertionSerializer;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getSerializer", as);
        }
        return as;
    }

    public void registerDeserializer(QName elementType, AssertionDeserializer scopeDeserializer) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "registerDeserializer", new Object[]{elementType, scopeDeserializer, this});
        }
        this.deserializers.put(elementType, scopeDeserializer);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "registerDeserializer");
        }
    }

    public AssertionDeserializer getDeserializer(QName elementType) {
        AssertionDeserializer ad;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getDeserializer", new Object[]{elementType, this});
        }
        if ((ad = (AssertionDeserializer)this.deserializers.get(elementType)) == null) {
            ad = this.defaultAssertionDeserializer;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getDeserializer", ad);
        }
        return ad;
    }
}

