/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wspolicy.alternatives;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.wspolicy.Policy;
import com.ibm.ws.wspolicy.WSPolicyInternalException;
import com.ibm.ws.wspolicy.assertions.AssertionImpl;
import com.ibm.ws.wspolicy.domain.Assertion;
import com.ibm.ws.wspolicy.domain.PolicyProviderRegistry;
import com.ibm.ws.wspolicy.domain.WSPolicyAssertionProcessor;
import java.util.HashMap;
import javax.xml.namespace.QName;

public class AssertionCombinations {
    private static final TraceComponent TRACE_COMPONENT = Tr.register(AssertionCombinations.class, "WS-Policy", "com.ibm.ws.wspolicy.resources.CWPOLMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.wspolicy.resources.CWPOLMessages");
    private static AssertionCombinations selfReference;
    private HashMap<QName, int[][]> _qName2Table;
    private HashMap<Integer, Assertion> _assertionMap = new HashMap(10);
    private static final int INITIAL_TABLE_SIZE = 10;
    private static final int INITIAL_QN_HASHMAP_SIZE = 5;
    private int _growthFactor = 2;
    private static final int INCOMPATIBLE_FLAG = -1;
    private static final int EQUIVALENT_FLAG = -2;
    private static final int NOT_FOUND = -1;
    private PolicyProviderRegistry _polProviderReg;

    private AssertionCombinations() {
        this._qName2Table = new HashMap(5);
        if (this._polProviderReg == null) {
            this._polProviderReg = PolicyProviderRegistry.getInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AssertionCombinations getInstance() {
        Class<AssertionCombinations> clazz = AssertionCombinations.class;
        synchronized (AssertionCombinations.class) {
            if (selfReference == null) {
                selfReference = new AssertionCombinations();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return selfReference;
        }
    }

    private synchronized int[][] growTable(QName qName, int[][] table) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "growTable", qName);
        }
        int currentSize = table[1].length;
        int tableSize = currentSize * this._growthFactor;
        if (TRACE_COMPONENT.isDebugEnabled()) {
            Tr.entry(TRACE_COMPONENT, "growTable", "Table for " + qName + " increased to " + tableSize);
        }
        int[][] newTable = new int[tableSize][tableSize];
        for (int i = 0; i < currentSize; ++i) {
            System.arraycopy(table[i], 0, newTable[i], 0, currentSize);
        }
        this._qName2Table.put(qName, newTable);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "growTable");
        }
        return newTable;
    }

    protected Assertion get(Assertion a1, Assertion a2) throws WSPolicyInternalException {
        if (!a1.getAssertionName().equals(a2.getAssertionName())) {
            return null;
        }
        Assertion result = null;
        int hash1 = a1.hashCode();
        int hash2 = a2.hashCode();
        int[][] table = this.getTable(a1.getAssertionName());
        int x_index = this.getIndex(table, hash1);
        int y_index = this.getIndex(table, hash2);
        if (x_index == -1 || y_index == -1) {
            int tableEntries = this.getEntries(table);
            if (tableEntries + 3 > table[0].length) {
                table = this.growTable(a1.getAssertionName(), table);
            }
            result = this.addNew(table, a1, a2);
        } else {
            int mergeIndex = table[x_index][y_index];
            switch (mergeIndex) {
                case -2: {
                    result = a1;
                    break;
                }
                case -1: {
                    result = null;
                    break;
                }
                case 0: {
                    result = this.addNew(table, a1, a2);
                    break;
                }
                default: {
                    result = this._assertionMap.get(mergeIndex);
                }
            }
        }
        return result;
    }

    private int[][] getTable(QName qName) {
        int[][] result = null;
        result = this._qName2Table.get(qName);
        if (result == null) {
            result = new int[10][10];
            this._qName2Table.put(qName, result);
        }
        return result;
    }

    private Assertion addNew(int[][] table, Assertion a1, Assertion a2) throws WSPolicyInternalException {
        WSPolicyAssertionProcessor processor = null;
        processor = this._polProviderReg.getWSPolicyProcessor(a1);
        if (processor == null && !a1.isIgnorable()) {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "Policy processor object (a1) was unexpectedly null");
            }
            throw new WSPolicyInternalException();
        }
        if (processor != this._polProviderReg.getWSPolicyProcessor(a2) && !a2.isIgnorable()) {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "Policy processor object (a2) was unexpectedly null");
            }
            throw new WSPolicyInternalException();
        }
        int result = 0;
        int a1Index = this.getIndex(table, a1.hashCode());
        int a2Index = this.getIndex(table, a2.hashCode());
        int tableEntries = this.getEntries(table);
        Assertion mergedResult = null;
        Policy subPolicy = null;
        if (this._polProviderReg.hasMergeBehavior(a1.getAssertionName())) {
            try {
                subPolicy = ((AssertionImpl)a1).getPolicy();
                if (subPolicy == null || subPolicy.isEmpty()) {
                    subPolicy = ((AssertionImpl)a2).getPolicy();
                }
                mergedResult = processor.combine(a1, a2);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.wspolicy.AssertionCombinations.addNew", "372", this);
                throw new WSPolicyInternalException(e);
            }
        }
        try {
            subPolicy = ((AssertionImpl)a1).getPolicy();
            mergedResult = this._polProviderReg.getDefaultAssertionMerger().combine(a1, a2);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.wspolicy.AssertionCombinations.addNew", "398", this);
            throw new WSPolicyInternalException(e);
        }
        if (mergedResult == null) {
            throw new WSPolicyInternalException("Assertions are incompatible for combine");
        }
        ((AssertionImpl)mergedResult).setPolicy(subPolicy);
        if (mergedResult == a1 || mergedResult == a2) {
            result = -2;
        } else {
            result = mergedResult.hashCode();
            this._assertionMap.put(result, mergedResult);
        }
        if (a1Index == -1) {
            table[0][tableEntries + 1] = a1.hashCode();
            table[tableEntries + 1][0] = a1.hashCode();
            a1Index = ++tableEntries;
        }
        if (a2Index == -1) {
            table[0][tableEntries + 1] = a2.hashCode();
            table[tableEntries + 1][0] = a2.hashCode();
            a2Index = ++tableEntries;
        }
        table[a1Index][a2Index] = result;
        table[a2Index][a1Index] = result;
        return mergedResult;
    }

    private int getEntries(int[][] table) {
        int result = 0;
        for (int i = 1; i < table[0].length; ++i) {
            if (table[0][i] != 0) continue;
            result = i - 1;
            break;
        }
        return result;
    }

    private int getIndex(int[][] table, int hash) {
        int result = -1;
        for (int i = 0; i < table[0].length; ++i) {
            if (table[0][i] != hash) continue;
            result = i;
            break;
        }
        return result;
    }

    protected boolean hasMergeBehavior(QName qn) {
        return this._polProviderReg.hasMergeBehavior(qn);
    }
}

