/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wspolicy.alternatives;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.wspolicy.Policy;
import com.ibm.ws.wspolicy.PolicyConstants;
import com.ibm.ws.wspolicy.PolicyContext;
import com.ibm.ws.wspolicy.PolicyElement;
import com.ibm.ws.wspolicy.PolicyFactory;
import com.ibm.ws.wspolicy.PolicyReference;
import com.ibm.ws.wspolicy.PolicyReferenceException;
import com.ibm.ws.wspolicy.WSPolicyBindingsException;
import com.ibm.ws.wspolicy.WSPolicyException;
import com.ibm.ws.wspolicy.WSPolicyInternalException;
import com.ibm.ws.wspolicy.alternatives.Alternative;
import com.ibm.ws.wspolicy.alternatives.AssertionCombinations;
import com.ibm.ws.wspolicy.assertions.AssertionImpl;
import com.ibm.ws.wspolicy.assertions.DefaultAssertion;
import com.ibm.ws.wspolicy.domain.Assertion;
import com.ibm.ws.wspolicy.domain.PolicyProviderRegistry;
import com.ibm.ws.wspolicy.domain.WSPolicyAssertionProcessor;
import com.ibm.ws.wspolicy.domain.WSPolicyPreferenceResolver;
import com.ibm.ws.wspolicy.operators.AllOperator;
import com.ibm.ws.wspolicy.operators.ExactlyOneOperator;
import com.ibm.ws.wspolicy.operators.Operator;
import java.net.URI;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Stack;
import java.util.Vector;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlternativesIterator
implements Iterator {
    private static final TraceComponent TRACE_COMPONENT = Tr.register(AlternativesIterator.class, "WS-Policy", "com.ibm.ws.wspolicy.resources.CWPOLMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.wspolicy.resources.CWPOLMessages");
    private NodeIterDetail _rootNID;
    private Alternative _cachedAlternative;
    private static final Vector<Assertion> _blank = new Vector(0);
    private Boolean _deliveredFlag;
    private boolean _finalDelivered;
    private String _iterationType = PolicyConstants.FILTER_LOGICAL;
    private AssertionCombinations _assCom;
    private boolean _nullDelivered;
    private Policy _owningPolicy;
    private Vector _owningPolicyVocabulary;
    private int _amended;

    public AlternativesIterator(Policy policy, String iterationType) throws WSPolicyInternalException, PolicyReferenceException {
        this._iterationType = iterationType;
        this._owningPolicy = policy;
        this._amended = policy.getAmended();
        if (this._iterationType.equals(PolicyConstants.FILTER_SUPPORTED)) {
            this._assCom = policy.getAssertionCombinations();
        }
        this._rootNID = new NodeIterDetail(policy, this, policy.getContext());
        this._rootNID.reset();
    }

    @Override
    public boolean hasNext() {
        if (this._deliveredFlag != null && !this._deliveredFlag.booleanValue()) {
            return true;
        }
        if (this._finalDelivered) {
            return false;
        }
        this._cachedAlternative = (Alternative)this.next();
        if (this._cachedAlternative == null) {
            this._finalDelivered = true;
            return false;
        }
        this._deliveredFlag = false;
        return true;
    }

    public static boolean checkAlternative(AssertionCombinations assertionCombinations, Alternative alternative, String iterationType, String intersectionType, Map bindings) throws WSPolicyBindingsException {
        if (!PolicyConstants.FILTER_LOGICAL.equals(iterationType) && !alternative.isSupported(bindings)) {
            return false;
        }
        Vector<QName> qNames = alternative.getVocabulary();
        Vector<Assertion> newAssertions = new Vector<Assertion>(alternative.getAssertions().size());
        boolean ok = true;
        try {
            for (int i = 0; i < qNames.size(); ++i) {
                QName qn = qNames.get(i);
                Vector<Assertion> qnAssertions = alternative.getAssertions(qn);
                boolean allIgnorable = false;
                if ("Lax".equals(intersectionType)) {
                    allIgnorable = true;
                    for (int j = 0; j < qnAssertions.size(); ++j) {
                        boolean bl = allIgnorable = allIgnorable && qnAssertions.elementAt(j).isIgnorable();
                        if (!allIgnorable) break;
                    }
                }
                if (!allIgnorable) {
                    qnAssertions = AlternativesIterator.checkAssertions4QN(assertionCombinations, qnAssertions);
                }
                newAssertions.addAll(qnAssertions);
            }
        }
        catch (WSPolicyException pe) {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "checkAlternative", "   >>> INVALID ALTERNATIVE[" + alternative + "] SUPPORT = false");
            }
            ok = false;
        }
        if (ok) {
            alternative.setAssertions(newAssertions);
        }
        return ok;
    }

    @Override
    public void remove() {
    }

    private static Vector<Assertion> checkAssertions4QN(AssertionCombinations assertionCombinations, Vector<Assertion> assertions) throws WSPolicyInternalException {
        int size = assertions.size();
        if (size < 2) {
            return assertions;
        }
        Assertion before = assertions.get(0);
        Assertion after = null;
        Assertion merged = null;
        for (int i = 1; i < size && (merged = assertionCombinations.get(before, after = assertions.get(i))) != null; ++i) {
            before = merged;
        }
        if (merged == null) {
            throw new WSPolicyInternalException("");
        }
        Vector<Assertion> result = new Vector<Assertion>(1);
        result.add(merged);
        return result;
    }

    public Object next() {
        Alternative result;
        block6: {
            result = null;
            try {
                result = this.nextAlternative();
                if (!this._iterationType.equals(PolicyConstants.FILTER_SUPPORTED)) break block6;
                boolean rowCheck = false;
                while (result != null && !rowCheck) {
                    try {
                        rowCheck = AlternativesIterator.checkAlternative(this._assCom, result, this._iterationType, "Strict", this.getBindingsMap());
                    }
                    catch (WSPolicyBindingsException wspbe) {
                        rowCheck = false;
                    }
                    if (!rowCheck) {
                        result = this.nextAlternative();
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                throw new NoSuchElementException(e.toString());
            }
        }
        return result;
    }

    public void reset() {
        if (this._rootNID != null) {
            this._rootNID.reset();
        }
        this._deliveredFlag = null;
        this._nullDelivered = false;
        this._finalDelivered = false;
    }

    private Alternative nextAlternative() throws WSPolicyInternalException {
        Vector<Assertion> assertionSet;
        if (this._owningPolicy.getAmended() != this._amended) {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.debug(TRACE_COMPONENT, "Internal error - invalid iterator");
            }
            throw new WSPolicyInternalException();
        }
        if (this._deliveredFlag != null && !this._deliveredFlag.booleanValue()) {
            this._deliveredFlag = true;
            return this._cachedAlternative;
        }
        if (this._finalDelivered) {
            return null;
        }
        Alternative result = null;
        while (result == null && (assertionSet = this._rootNID.next()) != null) {
            result = new Alternative(assertionSet);
            result.setOwningPolicyVocabulary(this.getOwningPolicyVocabulary());
            if (assertionSet.size() != 0) continue;
            if (!this._nullDelivered) {
                this._nullDelivered = true;
                continue;
            }
            result = null;
        }
        return result;
    }

    public String toString() {
        return this._rootNID.toString();
    }

    public Policy getCompressedPolicy() {
        PolicyFactory factory = new PolicyFactory();
        Policy pol = factory.newPolicy();
        Vector<PolicyElement> children = new Vector<PolicyElement>(this._rootNID._totalSupportedChildren);
        for (int i = 0; i < this._rootNID._totalSupportedChildren; ++i) {
            children.add(this._rootNID.getChildNodeForOrderedIndex(i).getPolicyForTree());
        }
        pol.setChildAssertions(children);
        return pol;
    }

    public Map getBindingsMap() {
        Map result = null;
        if (this._owningPolicy != null) {
            result = this._owningPolicy.getBindingsMap();
        }
        return result;
    }

    public Vector getOwningPolicyVocabulary() {
        if (this._owningPolicyVocabulary == null) {
            this._owningPolicyVocabulary = this._owningPolicy != null ? this._owningPolicy.getVocabulary() : new Vector();
        }
        return this._owningPolicyVocabulary;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class NodeIterDetail
    implements PolicyConstants {
        private BitSet _unsupportedChild;
        private int _currentPointer;
        private int _totalSupportedChildren = 1;
        private int _totalChildren = 1;
        private Vector _childAssertions;
        private Vector<NodeIterDetail> _childAssertionNIDs;
        private int _policyElementType = 0;
        private static final int NODE_TYPE_ASSERTION = 0;
        private static final int NODE_TYPE_ALLOPERATOR = 1;
        private static final int NODE_TYPE_EXACTLYONEOPERATOR = 2;
        private Operator operator;
        private AssertionImpl assertion;
        private AlternativesIterator _parentAlternativesIterator;
        private Vector<Assertion> _currentAlternative;
        private AssertionImpl _clonedCopy;
        private boolean _assertionSupported;
        private boolean _exactlyOneAlreadyReturnedAnEmptyAlternative = false;
        private int _score;
        private boolean _preferAbsent;
        private boolean _preferWithNested;
        private int[] _ordered;
        private boolean _canReturnEmpty;
        private boolean _willOnlyReturnEmpty;

        NodeIterDetail(PolicyElement policyElement, AlternativesIterator ai, PolicyContext policyContext) throws WSPolicyInternalException, PolicyReferenceException {
            this._parentAlternativesIterator = ai;
            this._currentPointer = -2;
            if (policyElement instanceof DefaultAssertion) {
                this.assertion = (DefaultAssertion)policyElement;
                this.verifySupport();
                try {
                    this._clonedCopy = ((DefaultAssertion)this.assertion).getCloneInstance();
                    this.setScoreFromDomainInfo();
                    this._canReturnEmpty = this.assertion.isOptional();
                    this._willOnlyReturnEmpty = false;
                }
                catch (CloneNotSupportedException e) {
                    if (TRACE_COMPONENT.isDebugEnabled()) {
                        Tr.debug(TRACE_COMPONENT, "NodeIterDetail", "Could not clone assertion");
                    }
                    this._clonedCopy = this.assertion;
                }
            } else if (policyElement instanceof AssertionImpl) {
                this.assertion = (AssertionImpl)policyElement;
                this.verifySupport();
                try {
                    this._clonedCopy = (AssertionImpl)this.assertion.clone();
                    this._clonedCopy.setOptional(false);
                    this.setScoreFromDomainInfo();
                    this._canReturnEmpty = this.assertion.isOptional();
                    this._willOnlyReturnEmpty = false;
                }
                catch (CloneNotSupportedException e) {
                    if (TRACE_COMPONENT.isDebugEnabled()) {
                        Tr.debug(TRACE_COMPONENT, "NodeIterDetail", "Could not clone assertion");
                    }
                    this._clonedCopy = this.assertion;
                }
            } else if (policyElement instanceof AllOperator) {
                this.operator = (AllOperator)policyElement;
                this._policyElementType = 1;
                this._childAssertions = this.operator.getChildAssertions();
                this.createChildNids(policyContext);
                this._totalChildren = this._childAssertionNIDs.size();
                this._unsupportedChild = new BitSet(this._totalChildren);
                this.flagUnsupportedChildren();
                this._totalSupportedChildren = this._totalChildren - this._unsupportedChild.cardinality();
                this.buildDummyRemappingIndex();
                this._willOnlyReturnEmpty = true;
                for (int i = 0; i < this._totalSupportedChildren; ++i) {
                    this._willOnlyReturnEmpty &= this.getChildNodeForOrderedIndex((int)i)._willOnlyReturnEmpty;
                }
            } else if (policyElement instanceof ExactlyOneOperator) {
                this.operator = (Operator)policyElement;
                this._policyElementType = 2;
                this._childAssertions = this.operator.getChildAssertions();
                this.createChildNids(policyContext);
                this._totalChildren = this._childAssertionNIDs.size();
                this._unsupportedChild = new BitSet(this._totalChildren);
                this.flagUnsupportedChildren();
                this._totalSupportedChildren = this._totalChildren - this._unsupportedChild.cardinality();
                this.buildRemappingIndex();
                if (this._totalSupportedChildren > 0) {
                    this._willOnlyReturnEmpty = true;
                    for (int i = 0; i < this._totalSupportedChildren; ++i) {
                        this._willOnlyReturnEmpty &= this.getChildNodeForOrderedIndex((int)i)._willOnlyReturnEmpty;
                    }
                } else {
                    this._willOnlyReturnEmpty = false;
                }
            } else if (TRACE_COMPONENT.isDebugEnabled()) {
                if (policyElement != null) {
                    Tr.debug(TRACE_COMPONENT, "NodeIterDetail", "Unknown policy element " + policyElement.getClass().getName());
                } else {
                    Tr.debug(TRACE_COMPONENT, "NodeIterDetail", "Unknown policy element NULL");
                }
            }
        }

        private void setScoreFromDomainInfo() {
            WSPolicyPreferenceResolver.WSPolicyPreferenceInformationForQName pi;
            WSPolicyPreferenceResolver ppr;
            this._score = 0;
            this._preferAbsent = false;
            WSPolicyAssertionProcessor wspap = PolicyProviderRegistry.getInstance().getWSPolicyProcessor(this.assertion);
            if (wspap != null && (ppr = wspap.getWSPolicyPreferenceResolver()) != null && (pi = ppr.getWSPolicyPreferenceInformationForQName(this.assertion.getQName())) != null) {
                this._score = pi.getScore();
                this._preferAbsent = pi.getPreferredAbsent();
                this._preferWithNested = pi.getPreferredWithNested();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void createChildNids(PolicyContext policyContext) throws WSPolicyInternalException, PolicyReferenceException {
            if (this._childAssertionNIDs == null) {
                this._childAssertionNIDs = new Vector();
                switch (this._policyElementType) {
                    case 1: {
                        this._canReturnEmpty = true;
                        break;
                    }
                    case 2: {
                        this._canReturnEmpty = false;
                    }
                }
                for (int i = 0; i < this._childAssertions.size(); ++i) {
                    PolicyElement pe = (PolicyElement)this._childAssertions.get(i);
                    Stack stack = null;
                    try {
                        if (pe instanceof PolicyReference) {
                            PolicyReference pr = (PolicyReference)pe;
                            URI uri = pr.getUri();
                            stack = (Stack)policyContext.getProperty(PolicyConstants.REFERENCE_STACK);
                            if (stack == null) {
                                stack = new Stack();
                                policyContext.setProperty(PolicyConstants.REFERENCE_STACK, stack);
                            }
                            if (stack.contains(uri)) {
                                if (TRACE_COMPONENT.isDebugEnabled()) {
                                    Tr.debug(TRACE_COMPONENT, "createChildNids found cyclic policy references.  The stack is " + stack.toString() + " attempting to reference " + uri);
                                }
                                stack = null;
                                throw new WSPolicyInternalException();
                            }
                            stack.push(uri);
                            pe = pr.getPolicy();
                        }
                        NodeIterDetail result = new NodeIterDetail(pe, this._parentAlternativesIterator, policyContext);
                        if (this._policyElementType == result._policyElementType && (this._policyElementType == 1 && result.allSupported() || this._policyElementType == 2 && result.anySupported())) {
                            for (int j = 0; j < result._totalSupportedChildren; ++j) {
                                NodeIterDetail node = result.getChildNodeForOrderedIndex(j);
                                if (this._canReturnEmpty && node._willOnlyReturnEmpty) continue;
                                this._childAssertionNIDs.add(node);
                                if (this._policyElementType == 1) {
                                    this._canReturnEmpty &= result._canReturnEmpty;
                                    continue;
                                }
                                this._canReturnEmpty |= result._canReturnEmpty;
                            }
                            continue;
                        }
                        if (result._totalSupportedChildren == 1 && (this._policyElementType == 1 && result._policyElementType == 2 || this._policyElementType == 2 && result._policyElementType == 1 && result.allSupported())) {
                            NodeIterDetail node = result.getChildNodeForOrderedIndex(0);
                            if (this._canReturnEmpty && node._willOnlyReturnEmpty) continue;
                            this._childAssertionNIDs.add(node);
                            if (this._policyElementType == 1) {
                                this._canReturnEmpty &= result._canReturnEmpty;
                                continue;
                            }
                            this._canReturnEmpty |= result._canReturnEmpty;
                            continue;
                        }
                        if (this._policyElementType == 1 && result._policyElementType == 1 && result._totalSupportedChildren == 0 && result.allSupported()) {
                            continue;
                        }
                        if (this._policyElementType == 2 && result._policyElementType == 1 && result._totalSupportedChildren == 0 && result.allSupported()) {
                            if (this._canReturnEmpty) continue;
                            this._childAssertionNIDs.add(result);
                            this._canReturnEmpty |= result._canReturnEmpty;
                            continue;
                        }
                        if (result._willOnlyReturnEmpty && this._canReturnEmpty) continue;
                        this._childAssertionNIDs.add(result);
                        if (this._policyElementType == 1) {
                            this._canReturnEmpty &= result._canReturnEmpty;
                            continue;
                        }
                        this._canReturnEmpty |= result._canReturnEmpty;
                        continue;
                    }
                    finally {
                        if (stack != null) {
                            stack.pop();
                        }
                    }
                }
                if (this._policyElementType == 2 && this._canReturnEmpty) {
                    Vector<NodeIterDetail> newChildren = new Vector<NodeIterDetail>();
                    NodeIterDetail onlyEmptyNode = null;
                    for (int i = 0; i < this._childAssertionNIDs.size(); ++i) {
                        NodeIterDetail node = this._childAssertionNIDs.get(i);
                        if (node._willOnlyReturnEmpty) {
                            onlyEmptyNode = node;
                            continue;
                        }
                        if (node._policyElementType == 0) {
                            node._canReturnEmpty = true;
                            node.reset();
                        }
                        newChildren.add(node);
                    }
                    if (newChildren.size() == 0 && onlyEmptyNode != null) {
                        newChildren.add(onlyEmptyNode);
                    }
                    this._childAssertionNIDs = newChildren;
                }
            }
        }

        private void flagUnsupportedChildren() {
            String iterType = this._parentAlternativesIterator._iterationType;
            if ((iterType.equals(PolicyConstants.FILTER_SUPPORTED) || iterType.equals(PolicyConstants.FILTER_VOCABULARY)) && this._policyElementType != 0) {
                for (int i = 0; i < this._totalChildren; ++i) {
                    NodeIterDetail nid = this.getChildNodeForRawIndex(i);
                    if (nid.verifySupport()) continue;
                    this.setAssertionNotSupported(i);
                }
            }
        }

        private boolean verifySupport() {
            boolean result = false;
            switch (this._policyElementType) {
                case 0: {
                    try {
                        this._assertionSupported = PolicyProviderRegistry.getInstance().isSupported(this.assertion, AlternativesIterator.this._iterationType, AlternativesIterator.this.getBindingsMap());
                    }
                    catch (WSPolicyBindingsException wspbe) {
                        this._assertionSupported = false;
                    }
                    if (!this._assertionSupported && !this._canReturnEmpty) break;
                    result = true;
                    break;
                }
                case 1: {
                    result = this.allSupported();
                    break;
                }
                case 2: {
                    result = this.anySupported();
                }
            }
            return result;
        }

        public String toString() {
            StringBuffer retVal = new StringBuffer();
            retVal.append(this.getCurrentPath());
            return retVal.toString();
        }

        public String getCurrentPath() {
            String nodeType = "/";
            switch (this._policyElementType) {
                case 1: {
                    nodeType = nodeType + "A" + this._totalSupportedChildren;
                    String internals = "";
                    for (int i = 0; i < this._totalSupportedChildren; ++i) {
                        if (this._currentPointer < 0) continue;
                        internals = internals + "|" + this.getChildNodeForOrderedIndex(i).getCurrentPath();
                    }
                    if (internals.length() <= 0) break;
                    nodeType = nodeType + "(" + internals.substring(1) + ")";
                    break;
                }
                case 0: {
                    nodeType = nodeType + "V";
                    nodeType = nodeType + (this._canReturnEmpty ? "2" : "1") + "." + (this._currentPointer + 1);
                    break;
                }
                case 2: {
                    nodeType = this._exactlyOneAlreadyReturnedAnEmptyAlternative ? nodeType + "e" : nodeType + "E";
                    nodeType = nodeType + this._totalSupportedChildren + "." + (this._currentPointer + 1);
                    if (this._currentPointer < 0) break;
                    nodeType = nodeType + this.getChildNodeForOrderedIndex(this._currentPointer).getCurrentPath();
                }
            }
            return nodeType;
        }

        public PolicyElement getPolicyForTree() {
            PolicyElement node = null;
            switch (this._policyElementType) {
                case 1: {
                    AllOperator all = new AllOperator();
                    Vector<PolicyElement> allchildren = new Vector<PolicyElement>(this._totalSupportedChildren);
                    for (int i = 0; i < this._totalSupportedChildren; ++i) {
                        allchildren.add(this.getChildNodeForOrderedIndex(i).getPolicyForTree());
                    }
                    all.setChildAssertions(allchildren);
                    node = all;
                    break;
                }
                case 0: {
                    try {
                        AssertionImpl _clone = null;
                        _clone = (AssertionImpl)this.assertion.clone();
                        _clone.setOptional(this._canReturnEmpty);
                        node = _clone;
                    }
                    catch (Exception e) {
                        node = this.assertion;
                    }
                    break;
                }
                case 2: {
                    ExactlyOneOperator eo = new ExactlyOneOperator();
                    Vector<PolicyElement> eochildren = new Vector<PolicyElement>(this._totalSupportedChildren);
                    for (int i = 0; i < this._totalSupportedChildren; ++i) {
                        eochildren.add(this.getChildNodeForOrderedIndex(i).getPolicyForTree());
                    }
                    eo.setChildAssertions(eochildren);
                    node = eo;
                }
            }
            return node;
        }

        private boolean allSupported() {
            return this._unsupportedChild.nextSetBit(0) == -1;
        }

        private boolean anySupported() {
            return this._unsupportedChild.nextClearBit(0) != -1;
        }

        protected void setAssertionNotSupported(int index) {
            this._unsupportedChild.set(index);
        }

        private NodeIterDetail getChildNodeForRawIndex(int index) {
            if (this.operator == null) {
                return null;
            }
            NodeIterDetail result = null;
            result = this._childAssertionNIDs.get(index);
            return result;
        }

        protected NodeIterDetail getChildNodeForOrderedIndex(int index) {
            if (this.operator == null) {
                return null;
            }
            if (index >= this._totalSupportedChildren || index < 0) {
                return null;
            }
            NodeIterDetail result = null;
            result = this._childAssertionNIDs.get(this._ordered[index]);
            return result;
        }

        private Vector<Assertion> getCurrentAlternative() {
            return this._currentAlternative;
        }

        private boolean getNextForExactlyOne(NodeIterDetail childNID) {
            boolean nextAvailable = false;
            Vector<Assertion> childnext = null;
            boolean done = false;
            while (!done) {
                childnext = childNID.next();
                if (!this._exactlyOneAlreadyReturnedAnEmptyAlternative) {
                    if (childnext != null) {
                        if (childnext.size() == 0) {
                            this._exactlyOneAlreadyReturnedAnEmptyAlternative = true;
                        }
                        done = true;
                        nextAvailable = true;
                        continue;
                    }
                    done = true;
                    continue;
                }
                if (childnext != null && childnext.size() > 0) {
                    done = true;
                    nextAvailable = true;
                    continue;
                }
                if (childnext != null) continue;
                done = true;
            }
            return nextAvailable;
        }

        public Vector<Assertion> next() {
            block0 : switch (this._policyElementType) {
                case 0: {
                    switch (this._currentPointer) {
                        case -2: 
                        case -1: {
                            this._currentPointer = 0;
                            break block0;
                        }
                        case 0: {
                            ++this._currentPointer;
                            if (this._canReturnEmpty && this._assertionSupported) {
                                if (this._preferAbsent) {
                                    this._currentAlternative = new Vector(1);
                                    this._currentAlternative.add(this._clonedCopy);
                                    break block0;
                                }
                                this._currentAlternative = _blank;
                                break block0;
                            }
                            this._currentAlternative = null;
                            break block0;
                        }
                    }
                    this._currentAlternative = null;
                    break;
                }
                case 1: {
                    NodeIterDetail childNID;
                    int i;
                    if (this._childAssertions == null) {
                        this.reset();
                    }
                    if (this._currentPointer < 0) {
                        this._currentPointer = 0;
                        return this._currentAlternative;
                    }
                    if (!this.allSupported()) {
                        return null;
                    }
                    boolean nextAvailable = false;
                    for (i = 0; i < this._totalSupportedChildren; ++i) {
                        childNID = this.getChildNodeForOrderedIndex(i);
                        if (childNID.next() != null) {
                            nextAvailable = true;
                            break;
                        }
                        childNID.reset();
                        childNID.next();
                    }
                    if (!nextAvailable) {
                        return null;
                    }
                    this._currentAlternative = new Vector();
                    for (i = 0; i < this._totalSupportedChildren; ++i) {
                        childNID = this.getChildNodeForOrderedIndex(i);
                        this._currentAlternative.addAll(childNID.getCurrentAlternative());
                    }
                    break;
                }
                case 2: {
                    if (this._currentPointer < 0) {
                        this._currentPointer = 0;
                        if (this._currentAlternative != null && this._currentAlternative.size() == 0) {
                            this._exactlyOneAlreadyReturnedAnEmptyAlternative = true;
                        }
                        return this._currentAlternative;
                    }
                    if (!this.anySupported()) {
                        return null;
                    }
                    if (this._totalSupportedChildren == 0) {
                        return null;
                    }
                    int intCP = this._currentPointer;
                    NodeIterDetail childNID = this.getChildNodeForOrderedIndex(intCP);
                    boolean nextAvailable = this.getNextForExactlyOne(childNID);
                    if (!nextAvailable) {
                        while (++intCP < this._totalSupportedChildren && !(nextAvailable = this.getNextForExactlyOne(childNID = this.getChildNodeForOrderedIndex(intCP)))) {
                        }
                    }
                    this._currentAlternative = null;
                    if (nextAvailable) {
                        this._currentAlternative = childNID.getCurrentAlternative();
                    }
                    this._currentPointer = intCP;
                }
            }
            return this._currentAlternative;
        }

        void reset() {
            this._currentPointer = -1;
            switch (this._policyElementType) {
                case 0: {
                    if (this._currentAlternative != null) break;
                    if (this._assertionSupported) {
                        if (this._canReturnEmpty && this._preferAbsent) {
                            this._currentAlternative = _blank;
                            break;
                        }
                        this._currentAlternative = new Vector(1);
                        this._currentAlternative.add(this._clonedCopy);
                        break;
                    }
                    if (!this._canReturnEmpty) break;
                    this._currentAlternative = _blank;
                    break;
                }
                case 1: {
                    if (this.allSupported()) {
                        this._currentAlternative = new Vector();
                        for (int i = 0; i < this._totalSupportedChildren; ++i) {
                            NodeIterDetail childNID = this.getChildNodeForOrderedIndex(i);
                            childNID.reset();
                            Vector<Assertion> childVector = childNID.next();
                            if (childVector == null) {
                                this._currentAlternative = null;
                                break;
                            }
                            this._currentAlternative.addAll(childVector);
                        }
                    }
                    if (this._totalSupportedChildren != 0) break;
                    this._currentAlternative = new Vector();
                    break;
                }
                case 2: {
                    if (this._totalSupportedChildren == 0) {
                        this._currentAlternative = null;
                        return;
                    }
                    this._exactlyOneAlreadyReturnedAnEmptyAlternative = false;
                    if (!this.anySupported()) break;
                    for (int i = 0; i < this._totalSupportedChildren; ++i) {
                        NodeIterDetail childNID = this.getChildNodeForOrderedIndex(i);
                        childNID.reset();
                    }
                    NodeIterDetail childNID = this.getChildNodeForOrderedIndex(0);
                    this._currentAlternative = childNID != null ? childNID.next() : null;
                }
            }
        }

        private void buildDummyRemappingIndex() {
            this._ordered = new int[this._totalSupportedChildren];
            for (int i = 0; i < this._totalSupportedChildren; ++i) {
                this._ordered[i] = i;
            }
        }

        private void buildRemappingIndex() {
            class ScoreAndIndex {
                int score;
                int index;

                ScoreAndIndex() {
                }
            }
            ScoreAndIndex[] scidx = new ScoreAndIndex[this._totalSupportedChildren];
            int currentSupportedIndex = 0;
            int supportedNodeRawIndex = this._unsupportedChild.nextClearBit(0);
            while (supportedNodeRawIndex < this._totalChildren) {
                Policy p;
                NodeIterDetail node = this.getChildNodeForRawIndex(supportedNodeRawIndex);
                scidx[currentSupportedIndex] = new ScoreAndIndex();
                int score = 0;
                score = node._score;
                scidx[currentSupportedIndex].score = Integer.MIN_VALUE + score;
                if (node._policyElementType == 0 && node._preferWithNested && node.assertion.containsNestedAssertions() && (p = node.assertion.getPolicy()).getChildAssertions() != null && p.getChildAssertions().size() > 0) {
                    scidx[currentSupportedIndex].score = score;
                }
                scidx[currentSupportedIndex].index = supportedNodeRawIndex;
                ++currentSupportedIndex;
                supportedNodeRawIndex = this._unsupportedChild.nextClearBit(supportedNodeRawIndex + 1);
            }
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class ScoreComparator
            implements Comparator<ScoreAndIndex> {
                ScoreComparator() {
                }

                @Override
                public int compare(ScoreAndIndex object1, ScoreAndIndex object2) {
                    if (object1.score < object2.score) {
                        return 1;
                    }
                    if (object1.score > object2.score) {
                        return -1;
                    }
                    return 0;
                }
            }
            Arrays.sort(scidx, new ScoreComparator());
            this._ordered = new int[scidx.length];
            for (int i = 0; i < scidx.length; ++i) {
                this._ordered[i] = scidx[i].index;
            }
        }
    }
}

