/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wspolicy.alternatives;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.wspolicy.PolicyException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.wspolicy.Policy;
import com.ibm.ws.wspolicy.PolicyConstants;
import com.ibm.ws.wspolicy.PolicyReferenceException;
import com.ibm.ws.wspolicy.WSPolicyBindingsException;
import com.ibm.ws.wspolicy.WSPolicyInternalException;
import com.ibm.ws.wspolicy.assertions.AssertionImpl;
import com.ibm.ws.wspolicy.assertions.NestedPolicyElementUtil;
import com.ibm.ws.wspolicy.domain.Assertion;
import com.ibm.ws.wspolicy.domain.PolicyProviderRegistry;
import com.ibm.ws.wspolicy.domain.WSPolicyAssertionProcessor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Alternative
implements Serializable {
    private static final TraceComponent TRACE_COMPONENT = Tr.register(Alternative.class, "WS-Policy", "com.ibm.ws.wspolicy.resources.CWPOLMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.wspolicy.resources.CWPOLMessages");
    private Vector<Assertion> _assertions;
    private Boolean _supported;
    private String _vocabularyStr;
    private Vector<String> _vocabulary;
    private Vector _owningPolicyVocabulary;
    private Vector _negatedQnames;
    private int _cacheHash;

    public Alternative(Vector<Assertion> assertions) {
        this._assertions = assertions;
    }

    public Alternative() {
    }

    public Alternative add(Alternative alternative) throws WSPolicyInternalException {
        QName qName;
        int i;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "add", alternative);
        }
        PolicyProviderRegistry ppr = PolicyProviderRegistry.getInstance();
        Vector<QName> qNamesVocabOne = this.getVocabulary();
        Vector qNamesNegatedOne = this.getExplicitNegationQNames();
        Vector<QName> qNamesVocabTwo = alternative.getVocabulary();
        Vector qNamesNegatedTwo = alternative.getExplicitNegationQNames();
        for (i = 0; i < qNamesVocabOne.size(); ++i) {
            qName = qNamesVocabOne.get(i);
            if (!qNamesNegatedTwo.contains(qName)) continue;
            if (TRACE_COMPONENT.isErrorEnabled()) {
                Tr.error(TRACE_COMPONENT, "add", "Addition forbidden since QName[" + qName + "] is both negated and stated in a vocabulary:qNamesNegatedTwo.contains(qName)");
            }
            throw new WSPolicyInternalException();
        }
        for (i = 0; i < qNamesVocabTwo.size(); ++i) {
            qName = qNamesVocabTwo.get(i);
            if (!qNamesNegatedOne.contains(qName)) continue;
            if (TRACE_COMPONENT.isErrorEnabled()) {
                Tr.error(TRACE_COMPONENT, "add", "Addition forbidden since QName[" + qName + "] is both negated and stated in a vocabulary:qNamesNegatedOne.contains(qName)");
            }
            throw new WSPolicyInternalException();
        }
        for (i = 0; i < qNamesVocabOne.size(); ++i) {
            qName = qNamesVocabOne.get(i);
            if (!qNamesVocabTwo.contains(qName) || ppr.hasMergeBehavior(qName)) continue;
            if (TRACE_COMPONENT.isErrorEnabled()) {
                Tr.error(TRACE_COMPONENT, "add", "Addition forbidden since QName[" + qName + "] is stated in both vocabularies:qNamesVocabTwo.contains(qName)");
            }
            throw new WSPolicyInternalException();
        }
        Alternative result = new Alternative();
        Vector<Assertion> sumAssertions = new Vector<Assertion>(this.getAssertions());
        sumAssertions.addAll(alternative.getAssertions());
        result.setAssertions(sumAssertions);
        Vector sumNegatedAssertions = new Vector(this.getExplicitNegationQNames());
        sumNegatedAssertions.addAll(alternative.getExplicitNegationQNames());
        result.setExplicitNegationQNames(sumNegatedAssertions);
        this._cacheHash = 0;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "add", result);
        }
        return result;
    }

    public boolean isSupported(Map bindings) throws WSPolicyBindingsException {
        return this.isSupported(PolicyConstants.FILTER_SUPPORTED, bindings);
    }

    protected boolean isSupported(String type, Map bindings) throws WSPolicyBindingsException {
        if (this._supported != null) {
            if (!this._supported.booleanValue() && TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "isSupported false");
            }
            return this._supported;
        }
        this._supported = Boolean.TRUE;
        for (int i = 0; i < this._assertions.size(); ++i) {
            AssertionImpl leaf = (AssertionImpl)this._assertions.elementAt(i);
            if (PolicyProviderRegistry.getInstance().isSupported(leaf, type, bindings)) continue;
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "isSupported", ">>> SUPPORT for ASSERTION[" + leaf.getQName() + "] = false");
            }
            this._supported = Boolean.FALSE;
            break;
        }
        if (!this._supported.booleanValue() && TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "isSupported false");
        }
        return this._supported;
    }

    public String toString() {
        StringBuffer result = new StringBuffer("(");
        if (this._assertions == null) {
            result.append(" ... EMPTY ... ");
        } else {
            for (int i = 0; i < this._assertions.size(); ++i) {
                Assertion vpa = this._assertions.elementAt(i);
                result.append(" " + vpa.toString());
            }
        }
        result.append(")");
        return result.toString();
    }

    public Vector<Assertion> getAssertions() {
        if (this._assertions == null) {
            this._assertions = new Vector();
        }
        return this._assertions;
    }

    protected void setAssertions(Vector<Assertion> assertionVector) {
        this._vocabularyStr = null;
        this._assertions = assertionVector;
        this._cacheHash = 0;
    }

    public Vector<Assertion> getAssertions(QName qName) {
        Vector<Assertion> result = new Vector<Assertion>();
        if (qName == null) {
            return result;
        }
        for (int i = 0; i < this._assertions.size(); ++i) {
            Assertion leaf = this._assertions.get(i);
            QName leafQ = leaf.getAssertionName();
            if (!leafQ.equals(qName)) continue;
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "getAssertions", "Matching QName for assertion " + leaf.getAssertionName());
            }
            result.add(leaf);
        }
        return result;
    }

    public Vector<Assertion> getAssertions(WSPolicyAssertionProcessor domainActor, Map bindings) throws WSPolicyInternalException, WSPolicyBindingsException, PolicyException {
        if (domainActor == null) {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "getAssertions", "null PolicyDomain");
            }
            throw new WSPolicyInternalException();
        }
        if (!this.isSupported(bindings)) {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "getAssertions", "isSupported() false ");
            }
            throw new PolicyException();
        }
        Vector<Assertion> daAssertions = new Vector<Assertion>();
        PolicyProviderRegistry ppr = PolicyProviderRegistry.getInstance();
        for (int i = 0; i < this._assertions.size(); ++i) {
            Assertion leaf = this._assertions.get(i);
            WSPolicyAssertionProcessor tPolicyDomain = ppr.findSupportingWSPolicyProcessor(leaf.getAssertionName());
            if (tPolicyDomain == null || !tPolicyDomain.getClass().getName().equals(domainActor.getClass().getName())) continue;
            daAssertions.add(leaf);
        }
        return daAssertions;
    }

    public Vector<QName> getNonIgnorableVocabulary() {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getNonIgnorableVocabulary");
        }
        Vector<QName> result = new Vector<QName>();
        if (this._assertions != null) {
            for (int i = 0; i < this._assertions.size(); ++i) {
                Assertion leaf = this._assertions.get(i);
                if (leaf.isIgnorable() || result.contains(leaf.getAssertionName())) continue;
                result.add(leaf.getAssertionName());
            }
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getNonIgnorableVocabulary", result);
        }
        return result;
    }

    public Vector<QName> getVocabulary() {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getVocabulary");
        }
        Vector<QName> result = new Vector<QName>();
        if (this._assertions != null) {
            for (int i = 0; i < this._assertions.size(); ++i) {
                Assertion leaf = this._assertions.get(i);
                if (result.contains(leaf.getAssertionName())) continue;
                result.add(leaf.getAssertionName());
            }
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getVocabulary", result);
        }
        return result;
    }

    public boolean isEmpty() {
        return this._assertions == null || this._assertions.isEmpty();
    }

    public String getVocabularyStr() {
        if (this._vocabularyStr == null) {
            this._vocabulary = new Vector(this._assertions.size());
            for (int i = 0; i < this._assertions.size(); ++i) {
                Assertion la = this._assertions.get(i);
                if (this._vocabulary.contains(la.getAssertionName().toString())) continue;
                this._vocabulary.add(la.getAssertionName().toString());
            }
            Collections.sort(this._vocabulary);
            this._vocabularyStr = this._vocabulary.toString();
        }
        return this._vocabularyStr;
    }

    protected void setOwningPolicyVocabulary(Vector vector) {
        this._owningPolicyVocabulary = vector;
    }

    public Vector getExplicitNegationQNames() {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getExplicitNegationQNames");
        }
        if (this._negatedQnames == null) {
            this._negatedQnames = new Vector();
            if (this._owningPolicyVocabulary != null) {
                this._negatedQnames.addAll(this._owningPolicyVocabulary);
                this._negatedQnames.removeAll(this.getVocabulary());
            }
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getExplicitNegationQNames", this._negatedQnames);
        }
        return this._negatedQnames;
    }

    private void setExplicitNegationQNames(Vector qNames) {
        this._negatedQnames = qNames;
    }

    public boolean equals(Object obj) {
        Alternative alt = null;
        if (!(obj instanceof Alternative)) {
            return false;
        }
        alt = (Alternative)obj;
        if (alt._assertions.size() == 0 && this._assertions.size() == 0) {
            return true;
        }
        if (alt._assertions.size() != this._assertions.size()) {
            return false;
        }
        boolean result = false;
        if (alt.hashCode() == this.hashCode()) {
            result = true;
        }
        return result;
    }

    public boolean containsNestedAssertions() {
        Assertion assertion;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "containsNestedAssertions");
        }
        boolean flag = false;
        for (int i = 0; !(i >= this._assertions.size() || (assertion = this._assertions.get(i)) instanceof AssertionImpl && (flag = ((AssertionImpl)assertion).containsNestedAssertions())); ++i) {
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "containsNestedAssertions", flag + "");
        }
        return flag;
    }

    public boolean intersectAndNormalizeNested(Policy p1, Alternative alternative, String iterationType, String intersectionType) throws WSPolicyInternalException, PolicyReferenceException, WSPolicyBindingsException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "intersectAndNormalizeNested", new Object[]{alternative, iterationType});
        }
        boolean result = true;
        for (int i = 0; i < this._assertions.size(); ++i) {
            AssertionImpl assertion = (AssertionImpl)this._assertions.get(i);
            if (!assertion.containsNestedAssertions()) continue;
            Vector<Assertion> matchedAssertions = alternative.getAssertions(assertion.getAssertionName());
            if (matchedAssertions.size() > 1) {
                if (TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "More than one matched assertion");
                }
                throw new WSPolicyInternalException();
            }
            AssertionImpl na2 = (AssertionImpl)matchedAssertions.get(0);
            if ("Lax".equals(intersectionType) && assertion.isIgnorable() && na2.isIgnorable()) {
                NestedPolicyElementUtil.singularizeSubPolicies(assertion, iterationType);
                NestedPolicyElementUtil.singularizeSubPolicies(na2, iterationType);
                continue;
            }
            if (NestedPolicyElementUtil.intersectAndNormalizeSubPolicies(assertion, na2, iterationType, intersectionType)) continue;
            result = false;
            break;
        }
        this._cacheHash = 0;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "intersectAndNormalizeNested", result + "");
        }
        return result;
    }

    public Alternative intersectAndNormalizeNestedForPublish(Alternative alternative, String iterationType) throws WSPolicyInternalException, PolicyReferenceException, WSPolicyBindingsException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "intersectAndNormalizeNestedForPublish", new Object[]{alternative, iterationType});
        }
        Vector<Assertion> candidateAssertions = new Vector<Assertion>();
        ArrayList<AssertionImpl> assertionsANoSub = new ArrayList<AssertionImpl>();
        ArrayList<AssertionImpl> assertionsBNoSub = new ArrayList<AssertionImpl>();
        HashMap<QName, AssertionImpl> assertionsAWithSub = new HashMap<QName, AssertionImpl>();
        HashMap<QName, AssertionImpl> assertionsBWithSub = new HashMap<QName, AssertionImpl>();
        for (int i = 0; i < this._assertions.size(); ++i) {
            AssertionImpl assertion = (AssertionImpl)this._assertions.get(i);
            if (!assertion.containsNestedAssertions()) {
                assertionsANoSub.add(assertion);
                continue;
            }
            if (assertionsAWithSub.put(assertion.getAssertionName(), assertion) == null) continue;
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "More than one matched assertion");
            }
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "intersectAndNormalizeNestedForPublish", null);
            }
            return null;
        }
        Vector<Assertion> assertions = alternative.getAssertions();
        for (int i = 0; i < assertions.size(); ++i) {
            AssertionImpl assertion = (AssertionImpl)assertions.get(i);
            if (!assertion.containsNestedAssertions()) {
                assertionsBNoSub.add(assertion);
                continue;
            }
            if (assertionsBWithSub.put(assertion.getAssertionName(), assertion) == null) continue;
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "More than one matched assertion");
            }
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "intersectAndNormalizeNestedForPublish", null);
            }
            return null;
        }
        Set entrySet = assertionsAWithSub.entrySet();
        for (Map.Entry entry : entrySet) {
            Policy p2;
            AssertionImpl assertion = (AssertionImpl)entry.getValue();
            AssertionImpl matchedAssertion = (AssertionImpl)assertionsBWithSub.remove(assertion.getAssertionName());
            if (matchedAssertion == null) {
                if (TRACE_COMPONENT.isEntryEnabled()) {
                    Tr.exit(TRACE_COMPONENT, "intersectAndNormalizeNestedForPublish unmatched assertion in first policy", null);
                }
                return null;
            }
            Policy p1 = assertion.getPolicy();
            Policy p3 = p1.intersectForPublish(p2 = matchedAssertion.getPolicy());
            if (p3 == null) {
                if (TRACE_COMPONENT.isEntryEnabled()) {
                    Tr.exit(TRACE_COMPONENT, "intersectAndNormalizeNestedForPublish sub policy intersection failure", null);
                }
                return null;
            }
            AssertionImpl mergedAssertion = null;
            try {
                mergedAssertion = (AssertionImpl)assertion.clone();
            }
            catch (CloneNotSupportedException e) {
                WSPolicyInternalException wspie = new WSPolicyInternalException(e);
                FFDCFilter.processException((Throwable)wspie, "com.ibm.ws.wspolicy.alternatives.Alternative.intersectAndNormalizeNestedForPublish", "748", this);
                throw wspie;
            }
            mergedAssertion.setPolicy(p3);
            candidateAssertions.add(mergedAssertion);
        }
        if (!assertionsBWithSub.isEmpty()) {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "intersectAndNormalizeNestedForPublish unmatched assertion in second policy", null);
            }
            return null;
        }
        candidateAssertions.addAll(assertionsANoSub);
        candidateAssertions.addAll(assertionsBNoSub);
        Alternative result = new Alternative(candidateAssertions);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "intersectAndNormalizeNestedForPublish", result + "");
        }
        return result;
    }

    public boolean intersectAndNormalizeNestedWithClientCapabilities(Policy clientPolicy, Alternative providerAlternative, String iterationType, String intersectionType, Policy clientTopLevelPolicy) throws WSPolicyInternalException, PolicyReferenceException, WSPolicyBindingsException {
        Tr.entry(TRACE_COMPONENT, "intersectAndNormalizeNestedWithClientCapabilities", new Object[]{clientPolicy, providerAlternative, iterationType, intersectionType});
        boolean result = true;
        Vector<Assertion> providerAssertions = providerAlternative.getAssertions();
        for (int i = 0; i < providerAssertions.size(); ++i) {
            AssertionImpl clientAssertion;
            Vector<Assertion> matchedAssertions;
            AssertionImpl providerAssertion = (AssertionImpl)providerAssertions.get(i);
            if (providerAssertion.containsNestedAssertions()) {
                matchedAssertions = this.getAssertions(providerAssertion.getAssertionName());
                if (matchedAssertions.size() > 1) {
                    if (TRACE_COMPONENT.isDebugEnabled()) {
                        Tr.debug(TRACE_COMPONENT, "More than one matched assertion");
                    }
                    throw new WSPolicyInternalException();
                }
                clientAssertion = null;
                if (matchedAssertions.size() > 0) {
                    clientAssertion = (AssertionImpl)matchedAssertions.get(0);
                }
                if (clientAssertion == null || !clientAssertion.containsNestedAssertions()) {
                    NestedPolicyElementUtil.singularizeSubPolicies(providerAssertion, iterationType);
                    continue;
                }
                if ("Lax".equals(intersectionType) && providerAssertion.isIgnorable() && clientAssertion.isIgnorable()) {
                    NestedPolicyElementUtil.singularizeSubPolicies(clientAssertion, iterationType);
                    NestedPolicyElementUtil.singularizeSubPolicies(providerAssertion, iterationType);
                    continue;
                }
                if (NestedPolicyElementUtil.intersectAndNormalizeSubPoliciesWithClientCapabilities(clientAssertion, providerAssertion, iterationType, intersectionType, clientTopLevelPolicy)) continue;
                result = false;
                break;
            }
            matchedAssertions = this.getAssertions(providerAssertion.getAssertionName());
            if (matchedAssertions.size() > 1) {
                if (TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "More than one matched assertion");
                }
                throw new WSPolicyInternalException();
            }
            clientAssertion = null;
            if (matchedAssertions.size() > 0) {
                clientAssertion = (AssertionImpl)matchedAssertions.get(0);
            }
            if (clientAssertion == null || !clientAssertion.containsNestedAssertions()) continue;
            result = false;
            break;
        }
        this._cacheHash = 0;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "intersectAndNormalizeNestedWithClientCapabilities ", result + "");
        }
        return result;
    }

    public boolean singularizeSubPolicies(String iterationType) throws WSPolicyInternalException, PolicyReferenceException {
        boolean result = true;
        for (int i = 0; i < this._assertions.size(); ++i) {
            AssertionImpl assertion = (AssertionImpl)this._assertions.get(i);
            if (!assertion.containsNestedAssertions()) continue;
            NestedPolicyElementUtil.singularizeSubPolicies(assertion, iterationType);
        }
        this._cacheHash = 0;
        return result;
    }

    public Vector<Alternative> nestedNormalize() throws WSPolicyInternalException, PolicyReferenceException {
        Vector<Alternative> result = new Vector<Alternative>();
        Alternative alt = new Alternative();
        result.add(alt);
        for (int i = 0; i < this._assertions.size(); ++i) {
            AssertionImpl assertion = (AssertionImpl)this._assertions.get(i);
            if (assertion.containsNestedAssertions()) {
                Vector normalized = NestedPolicyElementUtil.normalize(assertion);
                Vector<Alternative> newResult = new Vector<Alternative>();
                for (int j = 0; j < normalized.size(); ++j) {
                    Assertion normalizedNestedAssertion = (Assertion)normalized.get(j);
                    if (result.size() > 0) {
                        for (int k = 0; k < result.size(); ++k) {
                            Vector<Assertion> copyAssertions = new Vector<Assertion>(result.get(k).getAssertions());
                            Alternative newAlternative = new Alternative(copyAssertions);
                            newAlternative.getAssertions().add(normalizedNestedAssertion);
                            newResult.add(newAlternative);
                        }
                        continue;
                    }
                    Alternative newAlternative = new Alternative();
                    newAlternative.getAssertions().add(normalizedNestedAssertion);
                    newResult.add(newAlternative);
                }
                result = newResult;
                continue;
            }
            for (int k = 0; k < result.size(); ++k) {
                Alternative alternative = result.get(k);
                alternative.getAssertions().add(assertion);
            }
        }
        this._cacheHash = 0;
        return result;
    }

    public final int hashCode() {
        if (this._cacheHash == 0) {
            this._cacheHash = this.calcNewHash();
        }
        return this._cacheHash;
    }

    private int calcNewHash() {
        Vector<Integer> hashCodes = new Vector<Integer>();
        for (int i = 0; i < this._assertions.size(); ++i) {
            Assertion tA = this._assertions.get(i);
            hashCodes.add(tA.hashCode());
        }
        Object[] sortedHashCodes = hashCodes.toArray();
        Arrays.sort(sortedHashCodes);
        StringBuffer hashBase = new StringBuffer();
        for (int j = 0; j < sortedHashCodes.length; ++j) {
            hashBase.append(sortedHashCodes[j].toString());
        }
        int retVal = hashBase.toString().hashCode();
        return retVal;
    }

    public boolean isCompatible(Alternative alternative, String mode) throws WSPolicyInternalException, PolicyReferenceException, WSPolicyBindingsException {
        boolean result = this.isCompatible(this, alternative, mode);
        if (!result) {
            return false;
        }
        result = this.isCompatible(alternative, this, mode);
        return result;
    }

    private boolean isCompatible(Alternative alternative1, Alternative alternative2, String mode) throws WSPolicyInternalException, PolicyReferenceException, WSPolicyBindingsException {
        boolean result = true;
        for (int i = 0; i < alternative1.getAssertions().size(); ++i) {
            AssertionImpl a1 = (AssertionImpl)alternative1.getAssertions().get(i);
            boolean foundCompatible = false;
            for (int j = 0; j < alternative2.getAssertions().size(); ++j) {
                AssertionImpl a2 = (AssertionImpl)alternative2.getAssertions().get(j);
                if ("Strict".equals(mode) || "Lax".equals(mode) && !a1.isIgnorable()) {
                    if (!a1.getAssertionName().equals(a2.getAssertionName())) continue;
                    if (a1.containsNestedAssertions()) {
                        if (!NestedPolicyElementUtil.isCompatible(a1, a2, mode)) continue;
                        foundCompatible = true;
                        break;
                    }
                    foundCompatible = true;
                    break;
                }
                if (!"Lax".equals(mode) || !a1.isIgnorable()) continue;
                foundCompatible = true;
                break;
            }
            if (foundCompatible) continue;
            result = false;
            break;
        }
        return result;
    }
}

