/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wspolicy.acquisition;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.policyset.runtime.PolicySetConfiguration;
import com.ibm.ws.wspolicy.WSPolicyException;
import com.ibm.ws.wspolicy.WSPolicyFormattedException;
import com.ibm.ws.wspolicy.WSPolicyInternalException;
import com.ibm.ws.wspolicy.acquisition.PolicyProvider;
import com.ibm.ws.wspolicy.attachment.PolicyExtensionRegistry;
import com.ibm.wsdl.ImportImpl;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import org.apache.axiom.om.util.Base64;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.Parameter;
import org.xml.sax.InputSource;

public class AcquireViaQWSDL
implements PolicyProvider {
    private static final TraceComponent TRACE_COMPONENT = Tr.register(AcquireViaQWSDL.class, "WS-Policy", "com.ibm.ws.wspolicy.resources.CWPOLMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.wspolicy.resources.CWPOLMessages");

    public Definition getProviderPolicy(HashMap parameters) throws WSPolicyException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getProviderPolicy");
        }
        Definition result = null;
        String endpointURI = (String)parameters.get("policyURI");
        if (endpointURI == null) {
            MessageContext mc = (MessageContext)parameters.get("messageContext");
            EndpointReference epr = mc.getTo();
            endpointURI = epr != null ? epr.getAddress() : (String)mc.getProperty("javax.xml.ws.service.endpoint.address");
            if (endpointURI == null) {
                throw new WSPolicyInternalException("Unable to determine endpoint for qwsdl request");
            }
            endpointURI = endpointURI + "?WSDL";
        }
        String wsdlAddr = endpointURI.trim() + (endpointURI.trim().toLowerCase().endsWith("?wsdl") ? "" : "?wsdl");
        Properties httpProps = this.getHttpProperties(parameters);
        try {
            if (httpProps == null) {
                result = this.aquireNoSecurity(wsdlAddr);
            } else {
                Object mcObj = parameters.get("messageContext");
                if (mcObj != null && mcObj instanceof MessageContext) {
                    MessageContext MC = (MessageContext)mcObj;
                    result = this.aquireWithSecurity(wsdlAddr, httpProps, MC, null);
                }
            }
        }
        catch (WSDLException e) {
            if (e.getCause() instanceof WSPolicyException) {
                throw (WSPolicyException)e.getCause();
            }
            if ("OTHER_ERROR".equals(e.getFaultCode())) {
                throw new WSPolicyFormattedException(nls.getFormattedMessage("CWPOL0000", new Object[]{wsdlAddr, e}, null), e);
            }
            if ("CONFIGURATION_ERROR".equals(e.getFaultCode())) {
                throw new WSPolicyInternalException(e);
            }
            throw new WSPolicyFormattedException(nls.getFormattedMessage("CWPOL0005", new Object[]{wsdlAddr}, null), e);
        }
        catch (MalformedURLException e) {
            throw new WSPolicyFormattedException(nls.getFormattedMessage("CWPOL0005", new Object[]{wsdlAddr}, null), e);
        }
        catch (IOException e) {
            throw new WSPolicyFormattedException(nls.getFormattedMessage("CWPOL0005", new Object[]{wsdlAddr}, null), e);
        }
        catch (PrivilegedActionException e) {
            throw new WSPolicyInternalException(e);
        }
        catch (Exception e) {
            throw new WSPolicyInternalException(e);
        }
        return result;
    }

    private Definition aquireNoSecurity(final String wsdlAddr) throws WSPolicyException, WSPolicyFormattedException, WSPolicyInternalException, WSDLException, PrivilegedActionException {
        WSDLReader wsdlReader = AccessController.doPrivileged(new PrivilegedExceptionAction<WSDLReader>(){

            @Override
            public WSDLReader run() throws WSDLException {
                return WSDLFactory.newInstance().newWSDLReader();
            }
        });
        wsdlReader.setFeature("javax.wsdl.verbose", TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled());
        PolicyExtensionRegistry er = new PolicyExtensionRegistry();
        wsdlReader.setExtensionRegistry(er);
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "getProviderPolicy from ", wsdlAddr);
        }
        final WSDLReader wsdlReaderFinal = wsdlReader;
        Definition def = AccessController.doPrivileged(new PrivilegedExceptionAction<Definition>(){

            @Override
            public Definition run() throws WSDLException {
                return wsdlReaderFinal.readWSDL(wsdlAddr);
            }
        });
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getProviderPolicy", def);
        }
        return def;
    }

    private Properties getHttpProperties(Map parameters) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "getHttpProperties");
        }
        Properties result = null;
        Object mcObj = parameters.get("messageContext");
        if (mcObj == null || !(mcObj instanceof MessageContext)) {
            return null;
        }
        MessageContext MC = (MessageContext)mcObj;
        AxisOperation axisOp = MC.getAxisOperation();
        if (axisOp == null) {
            return null;
        }
        Parameter param = axisOp.getParameter("WASAxis2PolicySet");
        if (param == null) {
            return null;
        }
        Object psConfig = param.getValue();
        if (psConfig == null || !(psConfig instanceof PolicySetConfiguration)) {
            return null;
        }
        Object httpObj = ((PolicySetConfiguration)psConfig).getPolicyTypeBinding("HTTP_BINDING");
        if (httpObj == null || !(httpObj instanceof Properties)) {
            return null;
        }
        result = (Properties)httpObj;
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "getHttpProperties", new Object[]{result});
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Definition aquireWithSecurity(String wsdlAddr, Properties httpProps, MessageContext msgContext, String documentBaseURI) throws WSPolicyException, WSPolicyFormattedException, WSPolicyInternalException, URISyntaxException, MalformedURLException, IOException, WSDLException, PrivilegedActionException {
        Object insObj;
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "aquireWithSecurity");
        }
        Definition result = null;
        URI uri = null;
        uri = documentBaseURI != null && wsdlAddr.indexOf("://") == -1 ? new URI(documentBaseURI + wsdlAddr) : new URI(wsdlAddr);
        String host = httpProps.getProperty("outRequestProxy:host");
        if (host == null || host.equals("")) {
            host = uri.getHost();
        }
        String port = httpProps.getProperty("outRequestProxy:port");
        int portInt = -1;
        if (port != null && !port.equals("")) {
            try {
                portInt = Integer.parseInt(port);
            }
            catch (NumberFormatException e) {
                portInt = uri.getPort();
            }
        } else {
            portInt = uri.getPort();
        }
        uri = new URI(uri.getScheme(), uri.getUserInfo(), host, portInt, uri.getPath(), uri.getQuery(), uri.getFragment());
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "target URL = " + uri.toString());
        }
        URLConnection urlConnection = uri.toURL().openConnection();
        StringBuffer basicAuthData = null;
        String Userid = httpProps.getProperty("outRequestBasicAuth:userid");
        String Password2 = httpProps.getProperty("outRequestBasicAuth:password");
        if (Userid != null && Password2 != null && !"".equals(Userid) && !"".equals(Password2)) {
            basicAuthData = new StringBuffer(Userid);
            basicAuthData.append(":").append(Password2);
        }
        if (basicAuthData != null) {
            int lastindex = basicAuthData.length();
            basicAuthData.replace(0, lastindex, Base64.encode(basicAuthData.toString().getBytes()));
            urlConnection.addRequestProperty("Authorization", basicAuthData.insert(0, "Basic ").toString());
        }
        String proxyUser = httpProps.getProperty("outRequestProxy:userid");
        String proxyPassword = httpProps.getProperty("outRequestProxy:password");
        if (proxyUser != null && proxyPassword != null && !"".equals(proxyUser) && !"".equals(proxyPassword)) {
            basicAuthData = new StringBuffer(proxyUser);
            basicAuthData.append(":").append(proxyPassword);
            int lastindex = basicAuthData.length();
            basicAuthData.replace(0, lastindex, Base64.encode(basicAuthData.toString().getBytes()));
            urlConnection.addRequestProperty("Proxy-Authorization", basicAuthData.insert(0, "Basic ").toString());
        }
        if (!((insObj = urlConnection.getContent()) instanceof InputStream)) {
            throw new WSPolicyInternalException("URL connection did not return an InputStream");
        }
        InputStream ins = (InputStream)insObj;
        final InputSource inputSource = new InputSource(ins);
        try {
            WSDLReader wsdlReader = AccessController.doPrivileged(new PrivilegedExceptionAction<WSDLReader>(){

                @Override
                public WSDLReader run() throws WSDLException {
                    return WSDLFactory.newInstance().newWSDLReader();
                }
            });
            wsdlReader.setFeature("javax.wsdl.verbose", TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled());
            PolicyExtensionRegistry er = new PolicyExtensionRegistry();
            wsdlReader.setExtensionRegistry(er);
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "getProviderPolicy from ", wsdlAddr);
            }
            final WSDLReader wsdlReaderFinal = wsdlReader;
            final String docBaseURL = uri.toURL().toString();
            result = AccessController.doPrivileged(new PrivilegedExceptionAction<Definition>(){

                @Override
                public Definition run() throws WSDLException {
                    return wsdlReaderFinal.readWSDL(docBaseURL, inputSource);
                }
            });
        }
        finally {
            ins.close();
        }
        Map imports = result.getImports();
        if (imports != null && imports.entrySet() != null) {
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "Resolving WSDL Imports");
            }
            String docBase = result.getDocumentBaseURI();
            for (Map.Entry entry : imports.entrySet()) {
                List lis = (List)entry.getValue();
                for (ImportImpl importImpl : lis) {
                    String importURLStr = importImpl.getLocationURI();
                    if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                        Tr.debug(TRACE_COMPONENT, "Resolving WSDL Import from " + importURLStr);
                    }
                    if (importURLStr == null) continue;
                    Definition importDefstr = this.aquireWithSecurity(importURLStr, httpProps, msgContext, docBase);
                    importImpl.setDefinition(importDefstr);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "aquireWithSecurity", new Object[]{result});
        }
        return result;
    }
}

