/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wspolicy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.wspolicy.Policy;
import com.ibm.ws.wspolicy.PolicyConstants;
import com.ibm.ws.wspolicy.PolicyContext;
import com.ibm.ws.wspolicy.PolicyFactory;
import com.ibm.ws.wspolicy.PolicyReader;
import com.ibm.ws.wspolicy.PolicyReference;
import com.ibm.ws.wspolicy.PolicyReferenceException;
import com.ibm.ws.wspolicy.UnknownOperationException;
import com.ibm.ws.wspolicy.UnsupportedNamespaceException;
import com.ibm.ws.wspolicy.UnsupportedPolicyElementException;
import com.ibm.ws.wspolicy.WSPolicyBindingsException;
import com.ibm.ws.wspolicy.WSPolicyException;
import com.ibm.ws.wspolicy.WSPolicyInternalException;
import com.ibm.ws.wspolicy.alternatives.Alternative;
import com.ibm.ws.wspolicy.assertions.AssertionImpl;
import com.ibm.ws.wspolicy.attachment.PolicyExtensionRegistry;
import com.ibm.ws.wspolicy.attachment.UsingPolicy;
import com.ibm.ws.wspolicy.attachment.WSDLAttachPoint;
import com.ibm.ws.wspolicy.domain.PolicyProviderRegistry;
import com.ibm.ws.wspolicy.utils.InternalUtils;
import com.ibm.wsdl.ImportImpl;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.wsdl.xml.WSDLWriter;
import javax.xml.namespace.QName;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDLProcessor {
    private static final TraceComponent TRACE_COMPONENT = Tr.register(WSDLProcessor.class, "WS-Policy", "com.ibm.ws.wspolicy.resources.CWPOLMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.wspolicy.resources.CWPOLMessages");
    private Definition _definition;
    private HashMap<WSDLAttachPoint, Vector<ExtensibilityElement>> _policiesByScope = new HashMap();
    private Set<WSDLAttachPoint> _processedScopePoints = new HashSet<WSDLAttachPoint>();
    private PolicyReader _reader;
    private HashMap<String, HashMap<String, Alternative>> _requestAlternatives = new HashMap();
    private HashMap<String, HashMap<String, Alternative>> _responseAlternatives = new HashMap();
    private HashMap<String, Alternative> _serviceAlternatives = new HashMap();
    private HashMap<String, Alternative> _endpointAlternatives = new HashMap();
    private HashMap<String, HashMap<String, Alternative>> _operationAlternatives = new HashMap();
    private HashMap<String, HashMap<String, Alternative>> _inputAlternatives = new HashMap();
    private HashMap<String, HashMap<String, Alternative>> _outputAlternatives = new HashMap();
    private PolicyContext _context;
    private String _obtainedFromAddress = null;

    public WSDLProcessor(String fileLocation) throws PolicyReferenceException, UnsupportedNamespaceException, UnsupportedPolicyElementException, WSPolicyInternalException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "EffectivePolicyWSDLEngine", "Constructor(fileLocation):" + fileLocation);
        }
        this._definition = this.readDefinition(fileLocation);
        this.initDefinition(this._definition);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "EffectivePolicyWSDLEngine");
        }
    }

    public WSDLProcessor(Definition definition) throws PolicyReferenceException, UnsupportedNamespaceException, UnsupportedPolicyElementException, WSPolicyInternalException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "EffectivePolicyWSDLEngine", definition);
        }
        this.initDefinition(definition);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "EffectivePolicyWSDLEngine");
        }
    }

    public WSDLProcessor(InputStream is) throws PolicyReferenceException, UnsupportedNamespaceException, UnsupportedPolicyElementException, WSPolicyInternalException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "EffectivePolicyWSDLEngine", is);
        }
        this._definition = this.readDefinition(is);
        this.initDefinition(this._definition);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "EffectivePolicyWSDLEngine");
        }
    }

    private void initDefinition(Definition definition) throws PolicyReferenceException, UnsupportedNamespaceException, UnsupportedPolicyElementException, WSPolicyInternalException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "initDefinition");
        }
        this._definition = definition;
        this._reader = InternalUtils.getReader(this._definition);
        if (this._reader == null) {
            this.storeReaderInDefinition(this._definition);
        } else {
            this._context = this._reader.getPolicyContext();
        }
        if (this._context == null) {
            this._context = new PolicyContext();
            this._reader.setPolicyContext(this._context);
        }
        this._reader.setLocation(this._definition.getDocumentBaseURI());
        this.extractPolicies(this._definition);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "initDefinition");
        }
    }

    private void storeReaderInDefinition(Definition definition) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "storeReaderInDefinition");
        }
        this._reader = new PolicyFactory(this._context).newPolicyReader();
        UsingPolicy usingPolicy = new UsingPolicy();
        usingPolicy.setPolicyReader(this._reader);
        usingPolicy.setSerialize(false);
        definition.addExtensibilityElement(usingPolicy);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "storeReaderInDefinition");
        }
    }

    public Definition getDefinition() {
        return this._definition;
    }

    private Definition readDefinition(String definitionLocation) throws WSPolicyInternalException, UnsupportedNamespaceException, UnsupportedPolicyElementException, PolicyReferenceException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "readDefinition", definitionLocation);
        }
        Definition definition = null;
        try {
            WSDLFactory factory = WSDLFactory.newInstance();
            WSDLReader wsdlReader = factory.newWSDLReader();
            wsdlReader.setFeature("javax.wsdl.verbose", false);
            PolicyExtensionRegistry er = new PolicyExtensionRegistry();
            wsdlReader.setExtensionRegistry(er);
            definition = wsdlReader.readWSDL(definitionLocation);
        }
        catch (WSDLException we) {
            FFDCFilter.processException((Throwable)we, this.getClass() + ".readDefinition", "358", this);
            if (we.getCause() instanceof WSPolicyInternalException) {
                throw (WSPolicyInternalException)we.getCause();
            }
            if (we.getCause() instanceof UnsupportedNamespaceException) {
                throw (UnsupportedNamespaceException)we.getCause();
            }
            if (we.getCause() instanceof UnsupportedPolicyElementException) {
                throw (UnsupportedPolicyElementException)we.getCause();
            }
            if (we.getCause() instanceof PolicyReferenceException) {
                throw (PolicyReferenceException)we.getCause();
            }
            throw new WSPolicyInternalException(we);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "readDefinition", definition);
        }
        return definition;
    }

    private Definition readDefinition(InputStream is) throws WSPolicyInternalException, UnsupportedNamespaceException, UnsupportedPolicyElementException, PolicyReferenceException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "readDefinition", "InputStream");
        }
        Definition definition = null;
        try {
            WSDLFactory factory = WSDLFactory.newInstance();
            WSDLReader wsdlReader = factory.newWSDLReader();
            wsdlReader.setFeature("javax.wsdl.verbose", false);
            PolicyExtensionRegistry er = new PolicyExtensionRegistry();
            wsdlReader.setExtensionRegistry(er);
            InputSource iSource = new InputSource(is);
            definition = wsdlReader.readWSDL(null, iSource);
        }
        catch (WSDLException we) {
            FFDCFilter.processException((Throwable)we, this.getClass() + ".readDefinition", "388", this);
            if (we.getCause() instanceof WSPolicyInternalException) {
                throw (WSPolicyInternalException)we.getCause();
            }
            if (we.getCause() instanceof UnsupportedNamespaceException) {
                throw (UnsupportedNamespaceException)we.getCause();
            }
            if (we.getCause() instanceof UnsupportedPolicyElementException) {
                throw (UnsupportedPolicyElementException)we.getCause();
            }
            if (we.getCause() instanceof PolicyReferenceException) {
                throw (PolicyReferenceException)we.getCause();
            }
            throw new WSPolicyInternalException(we);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "readDefinition", definition);
        }
        return definition;
    }

    private void handleElement(Definition definition, WSDLAttachPoint attachPoint, List extensibilityElements) throws PolicyReferenceException, UnsupportedNamespaceException, UnsupportedPolicyElementException, WSPolicyInternalException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "handleElement", new Object[]{definition, attachPoint, extensibilityElements});
        }
        if (extensibilityElements == null) {
            return;
        }
        if (this._processedScopePoints.contains(attachPoint)) {
            return;
        }
        Vector<ExtensibilityElement> policies = new Vector<ExtensibilityElement>();
        try {
            for (ExtensibilityElement ee : extensibilityElements) {
                if (ee instanceof Policy) {
                    policies.add(ee);
                    continue;
                }
                if (ee instanceof PolicyReference) {
                    policies.add(ee);
                    continue;
                }
                ExtensibilityElement p = InternalUtils.extractUnknownElement(definition, ee, this._reader, this._context);
                if (p == null) continue;
                if (TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "handleElement", "Found UnknownElement");
                }
                policies.add(p);
            }
        }
        catch (UnsupportedNamespaceException une) {
            if (une.getAttachPointName() == null) {
                une.setAttachPointName(attachPoint.toString());
            }
            throw une;
        }
        catch (UnsupportedPolicyElementException uppe) {
            if (uppe.getAttachPointName() == null) {
                uppe.setAttachPointName(attachPoint.toString());
            }
            throw uppe;
        }
        catch (PolicyReferenceException pre) {
            if (pre.getAttachPointName() == null) {
                pre.setAttachPointName(attachPoint.toString());
            }
            throw pre;
        }
        Vector<ExtensibilityElement> currentPolicies = this._policiesByScope.get(attachPoint);
        if (currentPolicies == null && policies.size() > 0) {
            this._policiesByScope.put(attachPoint, policies);
        } else if (policies.size() > 0) {
            currentPolicies.addAll(policies);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "handleElement");
        }
    }

    private static void extractAllUnknowns(Definition definition, PolicyReader argReader) throws PolicyReferenceException, UnsupportedNamespaceException, UnsupportedPolicyElementException, WSPolicyInternalException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "extractAllUnknowns");
        }
        try {
            List extensibilityElements = definition.getExtensibilityElements();
            if (extensibilityElements != null) {
                for (ExtensibilityElement ee : extensibilityElements) {
                    if (!(ee instanceof UnknownExtensibilityElement)) continue;
                    UnknownExtensibilityElement uEE = (UnknownExtensibilityElement)ee;
                    QName elementType = uEE.getElementType();
                    String elementNS = elementType.getNamespaceURI();
                    String elementLocalName = elementType.getLocalPart();
                    if ("http://www.w3.org/ns/ws-policy".equals(elementNS)) {
                        if (PolicyConstants.OPERATOR_POLICY.equals(elementLocalName) || PolicyConstants.ELEMENT_POLICYREF.equals(elementLocalName)) {
                            Element el = uEE.getElement();
                            Attr attr = el.getAttributeNodeNS("http://www.w3.org/XML/1998/namespace", "base");
                            if (attr == null) {
                                Document d = el.getOwnerDocument();
                                attr = d.createAttributeNS("http://www.w3.org/XML/1998/namespace", "base");
                                attr.setPrefix("xml");
                                String base = definition.getDocumentBaseURI();
                                if (base == null || base == "") {
                                    base = definition.getTargetNamespace();
                                }
                                attr.setValue(base);
                                el.setAttributeNode(attr);
                            }
                            if (!elementType.equals(PolicyConstants.WSP_POL_ELEMENT_QNAME)) continue;
                            argReader.readPolicy(el);
                            continue;
                        }
                        if (PolicyConstants.USING_POLICY.equals(elementLocalName)) continue;
                        if (TRACE_COMPONENT.isDebugEnabled()) {
                            Tr.debug(TRACE_COMPONENT, "extractAllUnknowns found policy namespace for unknown element " + elementLocalName);
                        }
                        throw new UnsupportedPolicyElementException(elementLocalName, definition.getQName().toString());
                    }
                    if (!"http://schemas.xmlsoap.org/ws/2004/09/policy".equals(elementNS)) continue;
                    if (TRACE_COMPONENT.isDebugEnabled()) {
                        Tr.debug(TRACE_COMPONENT, "extractAllUnknowns found old policy namespace for element " + elementLocalName);
                    }
                    throw new UnsupportedNamespaceException(elementType, definition.getQName().toString());
                }
            }
        }
        catch (UnsupportedNamespaceException une) {
            if (une.getAttachPointName() == null) {
                une.setAttachPointName(definition.getQName().toString());
            }
            throw une;
        }
        catch (UnsupportedPolicyElementException uppe) {
            if (uppe.getAttachPointName() == null) {
                uppe.setAttachPointName(definition.getQName().toString());
            }
            throw uppe;
        }
        catch (PolicyReferenceException pre) {
            if (pre.getAttachPointName() == null) {
                pre.setAttachPointName(definition.getQName().toString());
            }
            throw pre;
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "extractAllUnknowns");
        }
    }

    private void handleAttribute(WSDLAttachPoint attachPoint, Object atts) throws WSPolicyInternalException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "handleAttribute");
        }
        if (atts == null) {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "handleAttribute", "referenced policy is null");
            }
            return;
        }
        if (this._processedScopePoints.contains(attachPoint)) {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "handleAttribute", "WSDLAttachPoint already exist, so not processing");
            }
            return;
        }
        String attsAsString = "";
        if (atts instanceof QName) {
            attsAsString = ((QName)atts).getLocalPart();
        } else if (atts instanceof String) {
            attsAsString = (String)atts;
        } else {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "WSDL4J is not returning QName attributes");
            }
            throw new WSPolicyInternalException();
        }
        if (attsAsString == "") {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "handleAttribute", "No attributes found");
            }
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "handleAttribute", "No attributes found");
            }
            return;
        }
        Vector<Policy> policies = new Vector<Policy>();
        StringTokenizer attsST = new StringTokenizer(attsAsString);
        String attribute = "";
        while (attsST.hasMoreTokens()) {
            attribute = attsST.nextToken();
            Policy policyFromCache = null;
            try {
                URI uri = new URI(attribute);
                policyFromCache = this._reader.readPolicy(uri);
                if (policyFromCache == null) {
                    if (TRACE_COMPONENT.isDebugEnabled()) {
                        Tr.debug(TRACE_COMPONENT, "A WSDL Extensibility Attribute contained the ID of a policy that could not be found. Ensure that the referenced policy has an ID that matches the Extensibility Attribute: " + attribute);
                    }
                    throw new WSPolicyInternalException();
                }
            }
            catch (WSPolicyInternalException wspe) {
                if (TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "An exception was thrown when processing the WSDL Extensibility Attribute: " + attribute);
                }
                throw new WSPolicyInternalException(wspe);
            }
            catch (URISyntaxException e) {
                if (TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "A URISyntaxException was thrown when processing the WSDL Extensibility Attribute: " + attribute);
                }
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.wspolicy.EffectivePolicyWSDLEngine.handleAttribute", "597", this);
                throw new WSPolicyInternalException(e);
            }
            policies.add(policyFromCache);
        }
        Vector<ExtensibilityElement> currentPolicies = this._policiesByScope.get(attachPoint);
        if (currentPolicies == null && policies.size() > 0) {
            this._policiesByScope.put(attachPoint, policies);
        } else if (policies.size() > 0) {
            currentPolicies.addAll(policies);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "handleAttribute");
        }
    }

    private void extractPolicies(Definition definition) throws PolicyReferenceException, UnsupportedNamespaceException, UnsupportedPolicyElementException, WSPolicyInternalException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "extractPolicies");
        }
        if (definition == null) {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "WSDL Definition object is null");
            }
            throw new WSPolicyInternalException();
        }
        List extensibilityElements = definition.getExtensibilityElements();
        if (extensibilityElements != null) {
            for (ExtensibilityElement ee : extensibilityElements) {
                if (!(ee instanceof UnknownExtensibilityElement)) continue;
                WSDLProcessor.extractAllUnknowns(definition, this._reader);
                break;
            }
        }
        Map<QName, Service> services = InternalUtils.getServices(definition);
        for (Service service : services.values()) {
            extensibilityElements = service.getExtensibilityElements();
            WSDLAttachPoint attachPointService = new WSDLAttachPoint();
            attachPointService.setServiceAttachPoint(service.getQName());
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "extractPolicies", ">>> Service[]");
            }
            this.handleElement(definition, attachPointService, extensibilityElements);
            this._processedScopePoints.add(attachPointService);
            Map ports = service.getPorts();
            for (Port port : ports.values()) {
                extensibilityElements = port.getExtensibilityElements();
                WSDLAttachPoint attachPointPort = new WSDLAttachPoint();
                attachPointPort.setPortAttachPoint(service.getQName(), port.getName());
                if (TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "extractPolicies");
                }
                this.handleElement(definition, attachPointPort, extensibilityElements);
                this._processedScopePoints.add(attachPointPort);
            }
        }
        Map<QName, Binding> bindings = InternalUtils.getBindings(definition);
        for (Binding binding : bindings.values()) {
            List extensibilityElemets = binding.getExtensibilityElements();
            WSDLAttachPoint attachPointBinding = new WSDLAttachPoint();
            attachPointBinding.setBindingAttachPoint(binding.getQName());
            this.handleElement(definition, attachPointBinding, extensibilityElemets);
            this._processedScopePoints.add(attachPointBinding);
            List bindingOperations = binding.getBindingOperations();
            for (BindingOperation bindingOperation : bindingOperations) {
                BindingOutput bindingOutput;
                extensibilityElemets = bindingOperation.getExtensibilityElements();
                WSDLAttachPoint attachPointOperation = new WSDLAttachPoint();
                attachPointOperation.setBindingOperationAttachPoint(binding.getQName(), bindingOperation.getName());
                this.handleElement(definition, attachPointOperation, extensibilityElemets);
                this._processedScopePoints.add(attachPointOperation);
                BindingInput bindingInput = bindingOperation.getBindingInput();
                if (bindingInput != null) {
                    String inputName = bindingInput.getName();
                    if (inputName == "" || inputName == null) {
                        inputName = bindingOperation.getName() + "Request";
                    }
                    extensibilityElemets = bindingInput.getExtensibilityElements();
                    WSDLAttachPoint attachPointInput = new WSDLAttachPoint();
                    attachPointInput.setBindingInputMessageAttachPoint(binding.getQName(), bindingOperation.getName(), inputName);
                    this.handleElement(definition, attachPointInput, extensibilityElemets);
                    this._processedScopePoints.add(attachPointInput);
                }
                if ((bindingOutput = bindingOperation.getBindingOutput()) != null) {
                    String outputName = bindingOutput.getName();
                    if (outputName == "" || outputName == null) {
                        outputName = bindingOperation.getName() + "Response";
                    }
                    extensibilityElemets = bindingOutput.getExtensibilityElements();
                    WSDLAttachPoint attachPointOutput = new WSDLAttachPoint();
                    attachPointOutput.setBindingOutputMessageAttachPoint(binding.getQName(), bindingOperation.getName(), outputName);
                    this.handleElement(definition, attachPointOutput, extensibilityElemets);
                    this._processedScopePoints.add(attachPointOutput);
                }
                Map bindingFaults = bindingOperation.getBindingFaults();
                for (BindingFault bindingFault : bindingFaults.values()) {
                    extensibilityElemets = bindingFault.getExtensibilityElements();
                    WSDLAttachPoint attachPointFault = new WSDLAttachPoint();
                    attachPointFault.setBindingFaultMessageAttachPoint(binding.getQName(), bindingOperation.getName(), bindingFault.getName());
                    this.handleElement(definition, attachPointFault, extensibilityElemets);
                    this._processedScopePoints.add(attachPointFault);
                }
            }
        }
        Map<QName, Message> messages = InternalUtils.getMessages(definition);
        for (Message message : messages.values()) {
            WSDLAttachPoint attachPointMessage = new WSDLAttachPoint();
            attachPointMessage.setMessageAttachPoint(message.getQName());
            extensibilityElements = message.getExtensibilityElements();
            this.handleElement(definition, attachPointMessage, extensibilityElements);
            this._processedScopePoints.add(attachPointMessage);
        }
        Map<QName, PortType> portTypes = InternalUtils.getPortTypes(definition);
        for (PortType portType : portTypes.values()) {
            WSDLAttachPoint attachPointPortType = new WSDLAttachPoint();
            attachPointPortType.setPortTypeAttachPoint(portType.getQName());
            Object atts = portType.getExtensionAttribute(PolicyConstants.QNAME_POLICYURIS);
            this.handleAttribute(attachPointPortType, atts);
            extensibilityElements = portType.getExtensibilityElements();
            this.handleElement(definition, attachPointPortType, extensibilityElements);
            this._processedScopePoints.add(attachPointPortType);
            List operations = portType.getOperations();
            for (Operation operation : operations) {
                WSDLAttachPoint attachPointOperation = new WSDLAttachPoint();
                attachPointOperation.setPortTypeOperationAttachPoint(portType.getQName(), operation.getName());
                List extensibilityElemets = operation.getExtensibilityElements();
                this.handleElement(definition, attachPointOperation, extensibilityElemets);
                this._processedScopePoints.add(attachPointOperation);
                Input input = operation.getInput();
                String inputName = input.getName();
                if (inputName == "" || inputName == null) {
                    inputName = operation.getName() + "Request";
                }
                WSDLAttachPoint attachPointInput = new WSDLAttachPoint();
                attachPointInput.setPortTypeInputMessageAttachPoint(portType.getQName(), operation.getName(), inputName);
                Object attsInput = input.getExtensionAttribute(PolicyConstants.QNAME_POLICYURIS);
                this.handleAttribute(attachPointInput, attsInput);
                extensibilityElements = input.getExtensibilityElements();
                this.handleElement(definition, attachPointInput, extensibilityElements);
                this._processedScopePoints.add(attachPointInput);
                Output output = operation.getOutput();
                if (output != null) {
                    String outputName = output.getName();
                    if (outputName == "" || outputName == null) {
                        outputName = operation.getName() + "Response";
                    }
                    WSDLAttachPoint attachPointOutput = new WSDLAttachPoint();
                    attachPointOutput.setPortTypeOutputMessageAttachPoint(portType.getQName(), operation.getName(), outputName);
                    Object attsOutput = output.getExtensionAttribute(PolicyConstants.QNAME_POLICYURIS);
                    this.handleAttribute(attachPointOutput, attsOutput);
                    extensibilityElements = output.getExtensibilityElements();
                    this.handleElement(definition, attachPointOutput, extensibilityElements);
                    this._processedScopePoints.add(attachPointOutput);
                }
                Map faults = operation.getFaults();
                for (Fault fault : faults.values()) {
                    WSDLAttachPoint attachPointFault = new WSDLAttachPoint();
                    attachPointFault.setPortTypeFaultMessageAttachPoint(portType.getQName(), operation.getName(), fault.getName());
                    Object attsFault = fault.getExtensionAttribute(PolicyConstants.QNAME_POLICYURIS);
                    this.handleAttribute(attachPointFault, attsFault);
                    extensibilityElements = fault.getExtensibilityElements();
                    this.handleElement(definition, attachPointFault, extensibilityElements);
                    this._processedScopePoints.add(attachPointFault);
                }
            }
        }
        this.findPoliciesInInports(definition);
    }

    private void findPoliciesInInports(Definition def) throws PolicyReferenceException, UnsupportedNamespaceException, UnsupportedPolicyElementException, WSPolicyInternalException {
        Map imports = def.getImports();
        for (Map.Entry entry : imports.entrySet()) {
            List lis = (List)entry.getValue();
            for (ImportImpl importImpl : lis) {
                Definition defImport = importImpl.getDefinition();
                if (defImport == null) continue;
                String tmpLocation = this._reader.getLocation();
                this._reader.setLocation(importImpl.getLocationURI());
                this.extractPolicies(defImport);
                this._reader.setLocation(tmpLocation);
            }
        }
    }

    private Policy mergeMatchingPolicies(WSDLAttachPoint attachPoint, Policy policy) throws PolicyReferenceException, WSPolicyInternalException {
        Policy result = null;
        try {
            Vector<ExtensibilityElement> policies = this._policiesByScope.get(attachPoint);
            if (policies == null) {
                result = policy;
            } else {
                if (policy == null) {
                    policy = new PolicyFactory(this._context).newEmptyPolicy();
                }
                result = policy.merge((Policy)policies.get(0));
                for (int i = 1; i < policies.size(); ++i) {
                    Policy p = (Policy)policies.get(i);
                    result = result.merge(p);
                }
            }
        }
        catch (PolicyReferenceException pre) {
            if (pre.getAttachPointName() == null) {
                pre.setAttachPointName(attachPoint.toString());
            }
            throw pre;
        }
        InternalUtils.updateAssertionScope(result, attachPoint, false);
        return result;
    }

    private Port getPort(Definition definition, QName serviceQName, String portName) {
        Port port = null;
        Map services = definition.getServices();
        for (Service service : services.values()) {
            if (!service.getQName().equals(serviceQName)) continue;
            port = service.getPort(portName);
            break;
        }
        return port;
    }

    public Policy getServiceEffectivePolicy(QName serviceQName) throws PolicyReferenceException, WSPolicyInternalException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getServiceEffectivePolicy", serviceQName);
        }
        WSDLAttachPoint attachPoint = new WSDLAttachPoint();
        attachPoint.setServiceAttachPoint(serviceQName);
        attachPoint.validate(this._definition);
        Policy result = this.mergeMatchingPolicies(attachPoint, null);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getServiceEffectivePolicy", result);
        }
        return result;
    }

    public Policy getEndpointEffectivePolicy(QName serviceQName, String portName) throws PolicyReferenceException, WSPolicyInternalException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getEndpointEffectivePolicy", new Object[]{serviceQName, portName});
        }
        WSDLAttachPoint attachPointPort = new WSDLAttachPoint();
        attachPointPort.setPortAttachPoint(serviceQName, portName);
        attachPointPort.validate(this._definition);
        Policy result = this.mergeMatchingPolicies(attachPointPort, null);
        Port port = this.getPort(this._definition, serviceQName, portName);
        if (port == null) {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "getEndpointEffectivePolicy port is null");
            }
            return result;
        }
        Binding binding = port.getBinding();
        if (binding == null) {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "getEndpointEffectivePolicy binding is null");
            }
            return result;
        }
        WSDLAttachPoint attachPointBinding = new WSDLAttachPoint();
        attachPointBinding.setBindingAttachPoint(binding.getQName());
        attachPointBinding.validate(this._definition);
        result = this.mergeMatchingPolicies(attachPointBinding, result);
        PortType portType = binding.getPortType();
        if (portType == null) {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "getEndpointEffectivePolicy portType is null");
            }
            return result;
        }
        WSDLAttachPoint attachPointPortType = new WSDLAttachPoint();
        attachPointPortType.setPortTypeAttachPoint(portType.getQName());
        attachPointPortType.validate(this._definition);
        result = this.mergeMatchingPolicies(attachPointPortType, result);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getEndpointEffectivePolicy", result);
        }
        return result;
    }

    public Policy getOperationEffectivePolicy(QName serviceQName, String portName, String operationName) throws PolicyReferenceException, UnknownOperationException, WSPolicyInternalException {
        List operations;
        List operations2;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getOperationEffectivePolicy", new Object[]{portName, operationName});
        }
        Policy result = null;
        Port port = this.getPort(this._definition, serviceQName, portName);
        if (port == null) {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "WSDL Node not recognised", InternalUtils.traceStringWSDLNode("port", serviceQName, portName, null, null));
            }
            throw new WSPolicyInternalException();
        }
        Binding binding = port.getBinding();
        if (binding == null) {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "WSDL Node not recognised", InternalUtils.traceStringWSDLNode("binding", serviceQName, portName, null, null));
            }
            throw new WSPolicyInternalException();
        }
        boolean noBindingOperationsSpecified = false;
        BindingOperation bindingOperation = binding.getBindingOperation(operationName, null, null);
        if (bindingOperation == null) {
            operations2 = binding.getBindingOperations();
            if (operationName == null && operations2.size() == 1) {
                bindingOperation = (BindingOperation)operations2.get(0);
            }
        }
        if (bindingOperation != null) {
            WSDLAttachPoint attachPointBindingOperation = new WSDLAttachPoint();
            attachPointBindingOperation.setBindingOperationAttachPoint(binding.getQName(), bindingOperation.getName());
            attachPointBindingOperation.validate(this._definition);
            result = this.mergeMatchingPolicies(attachPointBindingOperation, null);
        } else {
            operations2 = binding.getBindingOperations();
            if (operations2.size() > 0) {
                if (operationName == null) {
                    Iterator operIter = operations2.iterator();
                    BindingOperation firstBo = (BindingOperation)operIter.next();
                    WSDLAttachPoint firstAttachPointBindingOperation = new WSDLAttachPoint();
                    firstAttachPointBindingOperation.setBindingOperationAttachPoint(binding.getQName(), firstBo.getName());
                    firstAttachPointBindingOperation.validate(this._definition);
                    Vector<ExtensibilityElement> policies = this._policiesByScope.get(firstAttachPointBindingOperation);
                    boolean allSame = true;
                    while (operIter.hasNext()) {
                        BindingOperation bo = (BindingOperation)operIter.next();
                        WSDLAttachPoint attachPointBindingOperation = new WSDLAttachPoint();
                        attachPointBindingOperation.setBindingOperationAttachPoint(binding.getQName(), bo.getName());
                        attachPointBindingOperation.validate(this._definition);
                        Vector<ExtensibilityElement> morePolicies = this._policiesByScope.get(attachPointBindingOperation);
                        if (morePolicies != null) {
                            if (morePolicies.equals(policies)) continue;
                            allSame = false;
                            break;
                        }
                        if (policies == null) continue;
                        allSame = false;
                        break;
                    }
                    if (allSame) {
                        bindingOperation = firstBo;
                        result = this.mergeMatchingPolicies(firstAttachPointBindingOperation, null);
                    }
                }
            } else {
                noBindingOperationsSpecified = true;
            }
        }
        PortType portType = binding.getPortType();
        if (portType == null) {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "WSDL Node not recognised", InternalUtils.traceStringWSDLNode("portType", serviceQName, portName, null, null));
            }
            throw new WSPolicyInternalException();
        }
        Operation operation = portType.getOperation(operationName, null, null);
        if (operation == null) {
            operations = portType.getOperations();
            if (operationName == null && operations.size() == 1) {
                operation = (Operation)operations.get(0);
            }
        }
        if (operation != null) {
            WSDLAttachPoint attachPointOperation = new WSDLAttachPoint();
            attachPointOperation.setPortTypeOperationAttachPoint(portType.getQName(), operation.getName());
            attachPointOperation.validate(this._definition);
            result = this.mergeMatchingPolicies(attachPointOperation, result);
        } else if (operationName == null && (operations = portType.getOperations()).size() > 0) {
            Iterator operIter = operations.iterator();
            Operation firstOperation = (Operation)operIter.next();
            WSDLAttachPoint firstAttachPointOperation = new WSDLAttachPoint();
            firstAttachPointOperation.setPortTypeOperationAttachPoint(portType.getQName(), firstOperation.getName());
            firstAttachPointOperation.validate(this._definition);
            Vector<ExtensibilityElement> policies = this._policiesByScope.get(firstAttachPointOperation);
            boolean allSame = true;
            while (operIter.hasNext()) {
                Operation op = (Operation)operIter.next();
                WSDLAttachPoint attachPointOperation = new WSDLAttachPoint();
                attachPointOperation.setPortTypeOperationAttachPoint(portType.getQName(), op.getName());
                attachPointOperation.validate(this._definition);
                Vector<ExtensibilityElement> morePolicies = this._policiesByScope.get(attachPointOperation);
                if (morePolicies != null) {
                    if (morePolicies.equals(policies)) continue;
                    allSame = false;
                    break;
                }
                if (policies == null) continue;
                allSame = false;
                break;
            }
            if (allSame) {
                operation = firstOperation;
                result = this.mergeMatchingPolicies(firstAttachPointOperation, result);
            }
        }
        if (operation == null || bindingOperation == null && !noBindingOperationsSpecified) {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "getOperationEffectivePolicy cannot find operation");
            }
            throw new UnknownOperationException();
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getOperationEffectivePolicy", result);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Policy getInputMessageEffectivePolicy(QName serviceQName, String portName, String operationName) throws PolicyReferenceException, WSPolicyInternalException, UnknownOperationException {
        Operation operation;
        BindingOperation bindingOperation;
        boolean noBindingOperationsSpecified;
        Policy result;
        block51: {
            boolean allSame;
            Vector<ExtensibilityElement> policies;
            Vector<ExtensibilityElement> policiesMessage;
            WSDLAttachPoint firstAttachPointMessage;
            WSDLAttachPoint firstAttachPointInput;
            Operation firstOp;
            Iterator operIter;
            List operations;
            Binding binding;
            block53: {
                boolean allSame2;
                Vector<ExtensibilityElement> policies2;
                WSDLAttachPoint firstAttachPointBindingInput;
                BindingOperation firstBo;
                Iterator operIter2;
                block55: {
                    block54: {
                        List operations2;
                        block52: {
                            if (TRACE_COMPONENT.isEntryEnabled()) {
                                Tr.entry(TRACE_COMPONENT, "getInputMessageEffectivePolicy", new Object[]{serviceQName, portName, operationName});
                            }
                            result = null;
                            Port port = this.getPort(this._definition, serviceQName, portName);
                            if (port == null) {
                                if (TRACE_COMPONENT.isEntryEnabled()) {
                                    Tr.exit(TRACE_COMPONENT, "WSDL Node not recognised", InternalUtils.traceStringWSDLNode("port", serviceQName, portName, null, null));
                                }
                                throw new WSPolicyInternalException();
                            }
                            binding = port.getBinding();
                            if (binding == null) {
                                if (TRACE_COMPONENT.isEntryEnabled()) {
                                    Tr.exit(TRACE_COMPONENT, "WSDL Node not recognised", InternalUtils.traceStringWSDLNode("binding", serviceQName, portName, null, null));
                                }
                                throw new WSPolicyInternalException();
                            }
                            noBindingOperationsSpecified = false;
                            bindingOperation = binding.getBindingOperation(operationName, null, null);
                            if (bindingOperation == null) {
                                operations2 = binding.getBindingOperations();
                                if (operationName == null && operations2.size() == 1) {
                                    bindingOperation = (BindingOperation)operations2.get(0);
                                }
                            }
                            if (bindingOperation == null) break block52;
                            BindingInput bindingInput = bindingOperation.getBindingInput();
                            if (bindingInput != null) {
                                String inputName = bindingInput.getName();
                                if (inputName == "" || inputName == null) {
                                    inputName = bindingOperation.getName() + "Request";
                                }
                                WSDLAttachPoint attachPointBindingInput = new WSDLAttachPoint();
                                attachPointBindingInput.setBindingInputMessageAttachPoint(binding.getQName(), bindingOperation.getName(), inputName);
                                attachPointBindingInput.validate(this._definition);
                                result = this.mergeMatchingPolicies(attachPointBindingInput, null);
                            }
                            break block53;
                        }
                        operations2 = binding.getBindingOperations();
                        if (operations2.size() <= 0) break block54;
                        if (operationName != null) break block53;
                        operIter2 = operations2.iterator();
                        firstBo = (BindingOperation)operIter2.next();
                        BindingInput firstBindingInput = firstBo.getBindingInput();
                        firstAttachPointBindingInput = null;
                        policies2 = null;
                        if (firstBindingInput != null) {
                            String firstInputName = firstBindingInput.getName();
                            if (firstInputName == "" || firstInputName == null) {
                                firstInputName = firstBo.getName() + "Request";
                            }
                            firstAttachPointBindingInput = new WSDLAttachPoint();
                            firstAttachPointBindingInput.setBindingInputMessageAttachPoint(binding.getQName(), firstBo.getName(), firstInputName);
                            firstAttachPointBindingInput.validate(this._definition);
                            policies2 = this._policiesByScope.get(firstAttachPointBindingInput);
                        }
                        allSame2 = true;
                        break block55;
                    }
                    noBindingOperationsSpecified = true;
                    break block53;
                }
                while (operIter2.hasNext()) {
                    BindingOperation bo = (BindingOperation)operIter2.next();
                    BindingInput bindingInput = bo.getBindingInput();
                    Vector<ExtensibilityElement> morePolicies = null;
                    if (bindingInput == null) continue;
                    String inputName = bindingInput.getName();
                    if (inputName == "" || inputName == null) {
                        inputName = bo.getName() + "Request";
                    }
                    WSDLAttachPoint attachPointBindingInput = new WSDLAttachPoint();
                    attachPointBindingInput.setBindingInputMessageAttachPoint(binding.getQName(), bo.getName(), inputName);
                    attachPointBindingInput.validate(this._definition);
                    if (firstAttachPointBindingInput == null) {
                        firstAttachPointBindingInput = attachPointBindingInput;
                    }
                    if ((morePolicies = this._policiesByScope.get(attachPointBindingInput)) != null) {
                        if (morePolicies.equals(policies2)) continue;
                        allSame2 = false;
                        if (!TraceComponent.isAnyTracingEnabled() || !TRACE_COMPONENT.isDebugEnabled()) break;
                        Tr.debug(TRACE_COMPONENT, "binding Inputs not the same ", new Object[]{morePolicies, policies2});
                        break;
                    }
                    if (policies2 == null) continue;
                    allSame2 = false;
                    if (!TraceComponent.isAnyTracingEnabled() || !TRACE_COMPONENT.isDebugEnabled()) break;
                    Tr.debug(TRACE_COMPONENT, "binding Inputs not the same ", new Object[]{morePolicies, policies2});
                    break;
                }
                if (allSame2) {
                    bindingOperation = firstBo;
                    if (firstAttachPointBindingInput != null) {
                        result = this.mergeMatchingPolicies(firstAttachPointBindingInput, null);
                    }
                }
            }
            PortType portType = binding.getPortType();
            if (portType == null) {
                if (TRACE_COMPONENT.isEntryEnabled()) {
                    Tr.exit(TRACE_COMPONENT, "WSDL Node not recognised", InternalUtils.traceStringWSDLNode("portType", serviceQName, portName, null, null));
                }
                throw new WSPolicyInternalException();
            }
            operation = portType.getOperation(operationName, null, null);
            if (operation == null) {
                operations = portType.getOperations();
                if (operationName == null && operations.size() == 1) {
                    operation = (Operation)operations.get(0);
                }
            }
            if (operation != null) {
                Input input = operation.getInput();
                if (input != null) {
                    String inputName = input.getName();
                    if (inputName == "" || inputName == null) {
                        inputName = operation.getName() + "Request";
                    }
                    WSDLAttachPoint attachPointInput = new WSDLAttachPoint();
                    attachPointInput.setPortTypeInputMessageAttachPoint(portType.getQName(), operation.getName(), inputName);
                    attachPointInput.validate(this._definition);
                    result = this.mergeMatchingPolicies(attachPointInput, result);
                    Message message = input.getMessage();
                    if (message == null) {
                        if (TRACE_COMPONENT.isEntryEnabled()) {
                            Tr.exit(TRACE_COMPONENT, "WSDL Node not recognised", InternalUtils.traceStringWSDLNode("message", serviceQName, portName, null, null));
                        }
                        throw new WSPolicyInternalException();
                    }
                    WSDLAttachPoint attachPointMessage = new WSDLAttachPoint();
                    attachPointMessage.addValue(PolicyConstants.ATTACH_MESSAGE, message.getQName());
                    attachPointMessage.validate(this._definition);
                    result = this.mergeMatchingPolicies(attachPointMessage, result);
                    break block51;
                } else {
                    if (TRACE_COMPONENT.isEntryEnabled()) {
                        Tr.exit(TRACE_COMPONENT, "WSDL Node not recognised", InternalUtils.traceStringWSDLNode("portTypeInput", serviceQName, portName, null, null));
                    }
                    throw new WSPolicyInternalException();
                }
            }
            if (operationName != null) break block51;
            operations = portType.getOperations();
            if (operations.size() > 0) {
                operIter = operations.iterator();
                firstOp = (Operation)operIter.next();
                Input firstInput = firstOp.getInput();
                firstAttachPointInput = null;
                firstAttachPointMessage = null;
                policiesMessage = null;
                policies = null;
                if (firstInput != null) {
                    String firstInputName = firstInput.getName();
                    if (firstInputName == "" || firstInputName == null) {
                        firstInputName = firstOp.getName() + "Request";
                    }
                    firstAttachPointInput = new WSDLAttachPoint();
                    firstAttachPointInput.setPortTypeInputMessageAttachPoint(portType.getQName(), firstOp.getName(), firstInputName);
                    firstAttachPointInput.validate(this._definition);
                    policies = this._policiesByScope.get(firstAttachPointInput);
                    Message firstMessage = firstInput.getMessage();
                    if (firstMessage == null) {
                        if (TRACE_COMPONENT.isEntryEnabled()) {
                            Tr.exit(TRACE_COMPONENT, "WSDL Node not recognised", InternalUtils.traceStringWSDLNode("message", serviceQName, portName, null, null));
                        }
                        throw new WSPolicyInternalException();
                    }
                    firstAttachPointMessage = new WSDLAttachPoint();
                    firstAttachPointMessage.addValue(PolicyConstants.ATTACH_MESSAGE, firstMessage.getQName());
                    firstAttachPointMessage.validate(this._definition);
                    policiesMessage = this._policiesByScope.get(firstAttachPointMessage);
                }
                allSame = true;
            } else {
                if (TRACE_COMPONENT.isEntryEnabled()) {
                    Tr.exit(TRACE_COMPONENT, "WSDL Node not recognised", InternalUtils.traceStringWSDLNode("portTypeInput", serviceQName, portName, null, null));
                }
                throw new WSPolicyInternalException();
            }
            while (operIter.hasNext()) {
                Vector<ExtensibilityElement> morePoliciesMessage;
                block59: {
                    Vector<ExtensibilityElement> morePolicies;
                    block57: {
                        block58: {
                            block56: {
                                Operation op = (Operation)operIter.next();
                                Input input = op.getInput();
                                morePolicies = null;
                                morePoliciesMessage = null;
                                if (input == null) break block56;
                                String inputName = input.getName();
                                if (inputName == "" || inputName == null) {
                                    inputName = op.getName() + "Request";
                                }
                                WSDLAttachPoint attachPointInput = new WSDLAttachPoint();
                                attachPointInput.setPortTypeInputMessageAttachPoint(portType.getQName(), op.getName(), inputName);
                                attachPointInput.validate(this._definition);
                                if (firstAttachPointInput == null) {
                                    firstAttachPointInput = attachPointInput;
                                }
                                morePolicies = this._policiesByScope.get(attachPointInput);
                                Message message = input.getMessage();
                                if (message == null) {
                                    if (TRACE_COMPONENT.isEntryEnabled()) {
                                        Tr.exit(TRACE_COMPONENT, "WSDL Node not recognised", InternalUtils.traceStringWSDLNode("message", serviceQName, portName, null, null));
                                    }
                                    throw new WSPolicyInternalException();
                                }
                                WSDLAttachPoint attachPointMessage = new WSDLAttachPoint();
                                attachPointMessage.addValue(PolicyConstants.ATTACH_MESSAGE, message.getQName());
                                attachPointMessage.validate(this._definition);
                                if (firstAttachPointMessage == null) {
                                    firstAttachPointMessage = attachPointMessage;
                                }
                                morePoliciesMessage = this._policiesByScope.get(attachPointMessage);
                                if (morePolicies == null) break block57;
                                break block58;
                            }
                            if (TRACE_COMPONENT.isEntryEnabled()) {
                                Tr.exit(TRACE_COMPONENT, "WSDL Node not recognised", InternalUtils.traceStringWSDLNode("portTypeInput", serviceQName, portName, null, null));
                            }
                            throw new WSPolicyInternalException();
                        }
                        if (!morePolicies.equals(policies)) {
                            allSame = false;
                            if (!TraceComponent.isAnyTracingEnabled() || !TRACE_COMPONENT.isDebugEnabled()) break;
                            Tr.debug(TRACE_COMPONENT, "Inputs not the same ", new Object[]{morePolicies, policies});
                            break;
                        }
                        break block59;
                    }
                    if (policies != null) {
                        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                            Tr.debug(TRACE_COMPONENT, "Inputs not the same ", new Object[]{morePolicies, policies});
                        }
                        allSame = false;
                        break;
                    }
                }
                if (morePoliciesMessage != null) {
                    if (morePoliciesMessage.equals(policiesMessage)) continue;
                    allSame = false;
                    if (!TraceComponent.isAnyTracingEnabled() || !TRACE_COMPONENT.isDebugEnabled()) break;
                    Tr.debug(TRACE_COMPONENT, "Input Messages not the same ", new Object[]{morePoliciesMessage, policiesMessage});
                    break;
                }
                if (policiesMessage == null) continue;
                allSame = false;
                if (!TraceComponent.isAnyTracingEnabled() || !TRACE_COMPONENT.isDebugEnabled()) break;
                Tr.debug(TRACE_COMPONENT, "Input Messages not the same ", new Object[]{morePoliciesMessage, policiesMessage});
                break;
            }
            if (allSame) {
                operation = firstOp;
                if (firstAttachPointInput != null) {
                    result = this.mergeMatchingPolicies(firstAttachPointInput, result);
                    result = this.mergeMatchingPolicies(firstAttachPointMessage, result);
                }
            }
        }
        if (operation == null || bindingOperation == null && !noBindingOperationsSpecified) {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "operation not found");
            }
            throw new UnknownOperationException();
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getInputMessageEffectivePolicy", result);
        }
        return result;
    }

    public Policy getOutputMessageEffectivePolicy(QName serviceQName, String portName, String operationName) throws PolicyReferenceException, WSPolicyInternalException, UnknownOperationException {
        List operations;
        String outputName;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getOutputMessageEffectivePolicy", new Object[]{serviceQName, portName, operationName});
        }
        Policy result = null;
        Port port = this.getPort(this._definition, serviceQName, portName);
        if (port == null) {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "WSDL Node not recognised", InternalUtils.traceStringWSDLNode("port", serviceQName, portName, null, null));
            }
            throw new WSPolicyInternalException();
        }
        Binding binding = port.getBinding();
        if (binding == null) {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "WSDL Node not recognised", InternalUtils.traceStringWSDLNode("binding", serviceQName, portName, null, null));
            }
            throw new WSPolicyInternalException();
        }
        BindingOperation bindingOperation = binding.getBindingOperation(operationName, null, null);
        if (bindingOperation == null) {
            List operations2 = binding.getBindingOperations();
            if (operationName == null && operations2.size() == 1) {
                bindingOperation = (BindingOperation)operations2.get(0);
            }
        }
        boolean noBindingOperationsSpecified = false;
        if (bindingOperation != null) {
            BindingOutput bindingOutput = bindingOperation.getBindingOutput();
            if (bindingOutput != null) {
                String outputName2 = bindingOutput.getName();
                if (outputName2 == "" || outputName2 == null) {
                    outputName2 = bindingOperation.getName() + "Response";
                }
                WSDLAttachPoint attachPointBindingOutput = new WSDLAttachPoint();
                attachPointBindingOutput.setBindingOutputMessageAttachPoint(binding.getQName(), bindingOperation.getName(), outputName2);
                attachPointBindingOutput.validate(this._definition);
                result = this.mergeMatchingPolicies(attachPointBindingOutput, result);
            }
        } else {
            List operations3 = binding.getBindingOperations();
            if (operations3.size() > 0) {
                if (operationName == null) {
                    Iterator operIter = operations3.iterator();
                    BindingOperation firstBo = (BindingOperation)operIter.next();
                    BindingOutput firstBindingOutput = firstBo.getBindingOutput();
                    Vector<ExtensibilityElement> policies = null;
                    WSDLAttachPoint firstAttachPointBindingOutput = null;
                    if (firstBindingOutput != null) {
                        String outputName3 = firstBindingOutput.getName();
                        if (outputName3 == "" || outputName3 == null) {
                            outputName3 = firstBo.getName() + "Response";
                        }
                        firstAttachPointBindingOutput = new WSDLAttachPoint();
                        firstAttachPointBindingOutput.setBindingOutputMessageAttachPoint(binding.getQName(), firstBo.getName(), outputName3);
                        firstAttachPointBindingOutput.validate(this._definition);
                        policies = this._policiesByScope.get(firstAttachPointBindingOutput);
                    }
                    boolean allSame = true;
                    while (operIter.hasNext()) {
                        BindingOperation bo = (BindingOperation)operIter.next();
                        BindingOutput bindingOutput = bo.getBindingOutput();
                        Vector<ExtensibilityElement> morePolicies = null;
                        if (bindingOutput == null) continue;
                        outputName = bindingOutput.getName();
                        if (outputName == "" || outputName == null) {
                            outputName = bo.getName() + "Response";
                        }
                        WSDLAttachPoint attachPointBindingOutput = new WSDLAttachPoint();
                        attachPointBindingOutput.setBindingOutputMessageAttachPoint(binding.getQName(), bo.getName(), outputName);
                        attachPointBindingOutput.validate(this._definition);
                        if (firstAttachPointBindingOutput == null) {
                            firstAttachPointBindingOutput = attachPointBindingOutput;
                        }
                        if ((morePolicies = this._policiesByScope.get(attachPointBindingOutput)) != null) {
                            if (morePolicies.equals(policies)) continue;
                            allSame = false;
                            if (!TraceComponent.isAnyTracingEnabled() || !TRACE_COMPONENT.isDebugEnabled()) break;
                            Tr.debug(TRACE_COMPONENT, "binding Outputs not the same ", new Object[]{morePolicies, policies});
                            break;
                        }
                        if (policies == null) continue;
                        allSame = false;
                        if (!TraceComponent.isAnyTracingEnabled() || !TRACE_COMPONENT.isDebugEnabled()) break;
                        Tr.debug(TRACE_COMPONENT, "binding Inputs not the same ", new Object[]{morePolicies, policies});
                        break;
                    }
                    if (allSame) {
                        bindingOperation = firstBo;
                        if (firstAttachPointBindingOutput != null) {
                            result = this.mergeMatchingPolicies(firstAttachPointBindingOutput, null);
                        }
                    }
                }
            } else {
                noBindingOperationsSpecified = true;
            }
        }
        PortType portType = binding.getPortType();
        if (portType == null) {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "WSDL Node not recognised", InternalUtils.traceStringWSDLNode("portType", serviceQName, portName, null, null));
            }
            throw new WSPolicyInternalException();
        }
        Operation operation = portType.getOperation(operationName, null, null);
        if (operation == null) {
            operations = portType.getOperations();
            if (operationName == null && operations.size() == 1) {
                operation = (Operation)operations.get(0);
            }
        }
        if (operation != null) {
            Output output = operation.getOutput();
            if (output != null) {
                String outputName4 = output.getName();
                if (outputName4 == "" || outputName4 == null) {
                    outputName4 = operation.getName() + "Response";
                }
                WSDLAttachPoint attachPointOutput = new WSDLAttachPoint();
                attachPointOutput.setPortTypeOutputMessageAttachPoint(portType.getQName(), operation.getName(), outputName4);
                attachPointOutput.validate(this._definition);
                result = this.mergeMatchingPolicies(attachPointOutput, result);
                Message message = output.getMessage();
                if (message == null) {
                    if (TRACE_COMPONENT.isEntryEnabled()) {
                        Tr.exit(TRACE_COMPONENT, "WSDL Node not recognised", InternalUtils.traceStringWSDLNode("message", serviceQName, portName, null, null));
                    }
                    throw new WSPolicyInternalException();
                }
                WSDLAttachPoint attachPointMessage = new WSDLAttachPoint();
                attachPointMessage.addValue(PolicyConstants.ATTACH_MESSAGE, message.getQName());
                attachPointMessage.validate(this._definition);
                result = this.mergeMatchingPolicies(attachPointMessage, result);
            }
        } else if (operationName == null && (operations = portType.getOperations()).size() > 0) {
            Iterator operIter = operations.iterator();
            Operation firstOp = (Operation)operIter.next();
            Output firstOutput = firstOp.getOutput();
            Vector<ExtensibilityElement> policies = null;
            Vector<ExtensibilityElement> policiesMessage = null;
            WSDLAttachPoint firstAttachPointOutput = null;
            WSDLAttachPoint firstAttachPointMessage = null;
            if (firstOutput != null) {
                outputName = firstOutput.getName();
                if (outputName == "" || outputName == null) {
                    outputName = firstOp.getName() + "Response";
                }
                firstAttachPointOutput = new WSDLAttachPoint();
                firstAttachPointOutput.setPortTypeOutputMessageAttachPoint(portType.getQName(), firstOp.getName(), outputName);
                firstAttachPointOutput.validate(this._definition);
                policies = this._policiesByScope.get(firstAttachPointOutput);
                Message message = firstOutput.getMessage();
                if (message == null) {
                    if (TRACE_COMPONENT.isEntryEnabled()) {
                        Tr.exit(TRACE_COMPONENT, "WSDL Node not recognised", InternalUtils.traceStringWSDLNode("message", serviceQName, portName, null, null));
                    }
                    throw new WSPolicyInternalException();
                }
                firstAttachPointMessage = new WSDLAttachPoint();
                firstAttachPointMessage.addValue(PolicyConstants.ATTACH_MESSAGE, message.getQName());
                firstAttachPointMessage.validate(this._definition);
                policiesMessage = this._policiesByScope.get(firstAttachPointMessage);
            }
            boolean allSame = true;
            while (operIter.hasNext()) {
                Operation op = (Operation)operIter.next();
                Output output = op.getOutput();
                Vector<ExtensibilityElement> morePolicies = null;
                Vector<ExtensibilityElement> morePoliciesMessage = null;
                if (output == null) continue;
                String outputName5 = output.getName();
                if (outputName5 == "" || outputName5 == null) {
                    outputName5 = op.getName() + "Response";
                }
                WSDLAttachPoint attachPointOutput = new WSDLAttachPoint();
                attachPointOutput.setPortTypeOutputMessageAttachPoint(portType.getQName(), op.getName(), outputName5);
                attachPointOutput.validate(this._definition);
                if (firstAttachPointOutput == null) {
                    firstAttachPointOutput = attachPointOutput;
                }
                morePolicies = this._policiesByScope.get(attachPointOutput);
                Message message = output.getMessage();
                if (message == null) {
                    if (TRACE_COMPONENT.isEntryEnabled()) {
                        Tr.exit(TRACE_COMPONENT, "WSDL Node not recognised", InternalUtils.traceStringWSDLNode("message", serviceQName, portName, null, null));
                    }
                    throw new WSPolicyInternalException();
                }
                WSDLAttachPoint attachPointMessage = new WSDLAttachPoint();
                attachPointMessage.addValue(PolicyConstants.ATTACH_MESSAGE, message.getQName());
                attachPointMessage.validate(this._definition);
                if (firstAttachPointMessage == null) {
                    firstAttachPointMessage = attachPointMessage;
                }
                morePoliciesMessage = this._policiesByScope.get(attachPointMessage);
                if (morePolicies != null) {
                    if (!morePolicies.equals(policies)) {
                        allSame = false;
                        if (!TraceComponent.isAnyTracingEnabled() || !TRACE_COMPONENT.isDebugEnabled()) break;
                        Tr.debug(TRACE_COMPONENT, "Outputs not the same ", new Object[]{morePolicies, policies});
                        break;
                    }
                } else if (policies != null) {
                    allSame = false;
                    if (!TraceComponent.isAnyTracingEnabled() || !TRACE_COMPONENT.isDebugEnabled()) break;
                    Tr.debug(TRACE_COMPONENT, "Outputs not the same ", new Object[]{morePolicies, policies});
                    break;
                }
                if (morePoliciesMessage != null) {
                    if (morePoliciesMessage.equals(policiesMessage)) continue;
                    allSame = false;
                    if (!TraceComponent.isAnyTracingEnabled() || !TRACE_COMPONENT.isDebugEnabled()) break;
                    Tr.debug(TRACE_COMPONENT, "Output Messages not the same ", new Object[]{morePoliciesMessage, policiesMessage});
                    break;
                }
                if (policiesMessage == null) continue;
                allSame = false;
                if (!TraceComponent.isAnyTracingEnabled() || !TRACE_COMPONENT.isDebugEnabled()) break;
                Tr.debug(TRACE_COMPONENT, "Output Messages not the same ", new Object[]{morePoliciesMessage, policiesMessage});
                break;
            }
            if (allSame) {
                operation = firstOp;
                if (firstAttachPointOutput != null) {
                    result = this.mergeMatchingPolicies(firstAttachPointOutput, result);
                    result = this.mergeMatchingPolicies(firstAttachPointMessage, result);
                }
            }
        }
        if (operation == null || bindingOperation == null && !noBindingOperationsSpecified) {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "operation not found");
            }
            throw new UnknownOperationException();
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getOutputMessageEffectivePolicy", result);
        }
        return result;
    }

    public Policy getFaultMessageEffectivePolicy(QName serviceQName, String portName, String operationName, String faultName) throws PolicyReferenceException, WSPolicyInternalException {
        Message message;
        Fault fault;
        PortType portType;
        BindingFault bindingFault;
        Policy result = null;
        Port port = this.getPort(this._definition, serviceQName, portName);
        if (port == null) {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "WSDL Node not recognised", InternalUtils.traceStringWSDLNode("port", serviceQName, portName, null, null));
            }
            throw new WSPolicyInternalException();
        }
        Binding binding = port.getBinding();
        if (binding == null) {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "WSDL Node not recognised", InternalUtils.traceStringWSDLNode("binding", serviceQName, portName, null, null));
            }
            throw new WSPolicyInternalException();
        }
        BindingOperation bindingOperation = binding.getBindingOperation(operationName, null, null);
        if (bindingOperation == null) {
            List operations = binding.getBindingOperations();
            if (operationName == null && operations.size() == 1) {
                bindingOperation = (BindingOperation)operations.get(0);
            }
        }
        boolean faultFound = false;
        if (bindingOperation != null && (bindingFault = bindingOperation.getBindingFault(faultName)) != null) {
            faultFound = true;
            WSDLAttachPoint attachPointBindingFault = new WSDLAttachPoint();
            attachPointBindingFault.setBindingFaultMessageAttachPoint(binding.getQName(), bindingOperation.getName(), bindingFault.getName());
            attachPointBindingFault.validate(this._definition);
            result = this.mergeMatchingPolicies(attachPointBindingFault, result);
        }
        if ((portType = binding.getPortType()) == null) {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "WSDL Node not recognised", InternalUtils.traceStringWSDLNode("portType", serviceQName, portName, null, null));
            }
            throw new WSPolicyInternalException();
        }
        Operation operation = portType.getOperation(operationName, null, null);
        if (operation == null) {
            List operations = portType.getOperations();
            if (operationName == null && operations.size() != 1) {
                if (TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "WSDL Node not recognised", InternalUtils.traceStringWSDLNode("portTypeOperation", serviceQName, portName, null, null));
                }
                throw new WSPolicyInternalException();
            }
            if (operationName == null && operations.size() == 1) {
                operation = (Operation)operations.get(0);
            } else {
                if (TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "WSDL Node not recognised", InternalUtils.traceStringWSDLNode("portTypeOperation", serviceQName, portName, null, null));
                }
                throw new WSPolicyInternalException();
            }
        }
        if ((fault = operation.getFault(faultName)) != null) {
            faultFound = true;
            WSDLAttachPoint attachPointFault = new WSDLAttachPoint();
            attachPointFault.setPortTypeFaultMessageAttachPoint(portType.getQName(), operation.getName(), fault.getName());
            attachPointFault.validate(this._definition);
            result = this.mergeMatchingPolicies(attachPointFault, result);
        }
        if (fault != null && (message = fault.getMessage()) != null) {
            WSDLAttachPoint attachPointMessage = new WSDLAttachPoint();
            attachPointMessage.setMessageAttachPoint(message.getQName());
            attachPointMessage.validate(this._definition);
            result = this.mergeMatchingPolicies(attachPointMessage, result);
        }
        if (!faultFound) {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "WSDL Node not recognised", InternalUtils.traceStringWSDLNode("portTypeFault", serviceQName, portName, null, null));
            }
            throw new WSPolicyInternalException();
        }
        return result;
    }

    protected PolicyReader getReader() {
        return this._reader;
    }

    protected void setReader(PolicyReader reader) {
        this._reader = reader;
    }

    public Alternative getServiceAlternative(QName serviceQName, WSDLProcessor requesterEPWE, String iterationType) throws PolicyReferenceException, WSPolicyInternalException {
        String altKey;
        Alternative myServiceAlternative;
        if (iterationType == null) {
            iterationType = PolicyConstants.FILTER_LOGICAL;
        }
        if ((myServiceAlternative = this._serviceAlternatives.get(altKey = serviceQName.toString() + ":" + iterationType)) == null || requesterEPWE != null) {
            Policy p = this.getServiceEffectivePolicy(serviceQName);
            if (requesterEPWE != null) {
                Policy requesterPolicy = requesterEPWE.getServiceEffectivePolicy(serviceQName);
                if (p != null) {
                    Policy intersectPolicy = p.intersect(requesterPolicy);
                    myServiceAlternative = intersectPolicy.getAlternative(iterationType);
                } else {
                    myServiceAlternative = requesterPolicy != null ? requesterPolicy.getAlternative(iterationType) : new Alternative();
                }
            } else if (p != null) {
                myServiceAlternative = p.getAlternative(iterationType);
                if (myServiceAlternative != null) {
                    this._serviceAlternatives.put(altKey, myServiceAlternative);
                }
            } else {
                myServiceAlternative = new Alternative();
            }
        }
        if (myServiceAlternative == null) {
            myServiceAlternative = new Alternative();
        }
        return myServiceAlternative;
    }

    public Alternative getEndpointAlternative(QName serviceQName, String portName, WSDLProcessor requesterEPWE, String iterationType) throws PolicyReferenceException, WSPolicyInternalException {
        Alternative result;
        if (iterationType == null) {
            iterationType = PolicyConstants.FILTER_LOGICAL;
        }
        String altKey = portName + ":" + iterationType;
        if (this._endpointAlternatives == null) {
            this._endpointAlternatives = new HashMap();
        }
        if ((result = this._endpointAlternatives.get(altKey)) == null || requesterEPWE != null) {
            Policy p = this.getEndpointEffectivePolicy(serviceQName, portName);
            if (requesterEPWE != null) {
                Policy requesterPolicy = requesterEPWE.getEndpointEffectivePolicy(serviceQName, portName);
                if (p != null) {
                    Policy intersectPolicy = p.intersect(requesterPolicy);
                    result = intersectPolicy.getAlternative(iterationType);
                } else {
                    result = requesterPolicy != null ? requesterPolicy.getAlternative(iterationType) : new Alternative();
                }
            } else if (p != null) {
                result = p.getAlternative(iterationType);
                if (result != null) {
                    this._endpointAlternatives.put(altKey, result);
                }
            } else {
                result = new Alternative();
            }
            if (result == null) {
                result = new Alternative();
            }
        }
        return result;
    }

    public Alternative getOperationAlternative(QName serviceQName, String portName, String operationName, WSDLProcessor requesterEPWE, String iterationType) throws PolicyReferenceException, WSPolicyInternalException, UnknownOperationException {
        Alternative result;
        String altKey;
        HashMap<String, Alternative> operations;
        if (iterationType == null) {
            iterationType = PolicyConstants.FILTER_LOGICAL;
        }
        if ((operations = this._operationAlternatives.get(altKey = portName + ":" + iterationType)) == null) {
            operations = new HashMap();
            this._operationAlternatives.put(altKey, operations);
        }
        if ((result = operations.get(operationName)) == null || requesterEPWE != null) {
            Policy p = this.getOperationEffectivePolicy(serviceQName, portName, operationName);
            if (requesterEPWE != null) {
                Policy requesterPolicy = requesterEPWE.getOperationEffectivePolicy(serviceQName, portName, operationName);
                if (p != null) {
                    Policy intersectPolicy = p.intersect(requesterPolicy);
                    result = intersectPolicy.getAlternative(iterationType);
                } else {
                    result = requesterPolicy != null ? requesterPolicy.getAlternative(iterationType) : new Alternative();
                }
            } else if (p != null) {
                result = p.getAlternative(iterationType);
                if (result != null) {
                    operations.put(operationName, result);
                }
            } else {
                result = new Alternative();
            }
            if (result == null) {
                result = new Alternative();
            }
        }
        return result;
    }

    public Alternative getInputMessageAlternative(QName serviceQName, String portName, String operationName, WSDLProcessor requesterEPWE, String iterationType) throws PolicyReferenceException, WSPolicyInternalException, UnknownOperationException {
        Alternative result;
        String altKey;
        HashMap<String, Alternative> inputs;
        if (iterationType == null) {
            iterationType = PolicyConstants.FILTER_LOGICAL;
        }
        if ((inputs = this._inputAlternatives.get(altKey = portName + ":" + iterationType)) == null) {
            inputs = new HashMap();
            this._inputAlternatives.put(altKey, inputs);
        }
        if ((result = inputs.get(operationName)) == null || requesterEPWE != null) {
            Policy p = this.getInputMessageEffectivePolicy(serviceQName, portName, operationName);
            if (requesterEPWE != null) {
                if (TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "Using Requester EPWE");
                }
                Policy requesterPolicy = requesterEPWE.getInputMessageEffectivePolicy(serviceQName, portName, operationName);
                if (p != null) {
                    Policy intersectPolicy = p.intersect(requesterPolicy);
                    result = intersectPolicy.getAlternative(iterationType);
                } else {
                    result = requesterPolicy != null ? requesterPolicy.getAlternative(iterationType) : new Alternative();
                }
            } else {
                if (TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "Using Provider EPWE only");
                }
                if (p != null) {
                    result = p.getAlternative(iterationType);
                    if (result != null) {
                        inputs.put(operationName, result);
                    }
                } else {
                    result = new Alternative();
                }
            }
            if (result == null) {
                result = new Alternative();
            }
        }
        return result;
    }

    public Alternative getOutputMessageAlternative(QName serviceQName, String portName, String operationName, WSDLProcessor requesterEPWE, String iterationType) throws PolicyReferenceException, WSPolicyInternalException, UnknownOperationException {
        Alternative result;
        String altKey;
        HashMap<String, Alternative> outputs;
        if (iterationType == null) {
            iterationType = PolicyConstants.FILTER_LOGICAL;
        }
        if ((outputs = this._outputAlternatives.get(altKey = portName + ":" + iterationType)) == null) {
            outputs = new HashMap();
            this._outputAlternatives.put(altKey, outputs);
        }
        if ((result = outputs.get(operationName)) == null || requesterEPWE != null) {
            Policy p = this.getOutputMessageEffectivePolicy(serviceQName, portName, operationName);
            if (requesterEPWE != null) {
                if (TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "Using Requester EPWE");
                }
                Policy requesterPolicy = requesterEPWE.getOutputMessageEffectivePolicy(serviceQName, portName, operationName);
                if (p != null) {
                    Policy intersectPolicy = p.intersect(requesterPolicy);
                    result = intersectPolicy.getAlternative(iterationType);
                } else {
                    result = requesterPolicy != null ? requesterPolicy.getAlternative(iterationType) : new Alternative();
                }
            } else {
                if (TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "Using Provider EPWE only");
                }
                if (p != null) {
                    result = p.getAlternative(iterationType);
                    if (result != null) {
                        outputs.put(operationName, result);
                    }
                } else {
                    result = new Alternative();
                }
            }
            if (result == null) {
                result = new Alternative();
            }
        }
        return result;
    }

    public Alternative getRequestAlternative(QName serviceQName, String portName, String operationName, WSDLProcessor requesterEPWE, String iterationType) throws PolicyReferenceException, WSPolicyInternalException, UnknownOperationException {
        Alternative result;
        String altKey;
        HashMap<String, Alternative> reqAlternatives;
        if (iterationType == null) {
            iterationType = PolicyConstants.FILTER_LOGICAL;
        }
        if ((reqAlternatives = this._requestAlternatives.get(altKey = portName + ":" + iterationType)) == null) {
            reqAlternatives = new HashMap();
            this._requestAlternatives.put(altKey, reqAlternatives);
        }
        if ((result = reqAlternatives.get(operationName)) == null || requesterEPWE != null) {
            result = new Alternative();
            Alternative tAlt = this.getServiceAlternative(serviceQName, requesterEPWE, iterationType);
            if (tAlt != null) {
                result = result.add(tAlt);
            }
            if ((tAlt = this.getEndpointAlternative(serviceQName, portName, requesterEPWE, iterationType)) != null) {
                result = result.add(tAlt);
            }
            if ((tAlt = this.getOperationAlternative(serviceQName, portName, operationName, requesterEPWE, iterationType)) != null) {
                result = result.add(tAlt);
            }
            if ((tAlt = this.getInputMessageAlternative(serviceQName, portName, operationName, requesterEPWE, iterationType)) != null) {
                result = result.add(tAlt);
            }
            if (requesterEPWE == null && result != null) {
                reqAlternatives.put(operationName, result);
            }
        }
        return result;
    }

    public Alternative getResponseAlternative(QName serviceQName, String portName, String operationName, WSDLProcessor requesterEPWE, String iterationType) throws PolicyReferenceException, WSPolicyInternalException, UnknownOperationException {
        Alternative result;
        String altKey;
        HashMap<String, Alternative> respAlternatives;
        if (iterationType == null) {
            iterationType = PolicyConstants.FILTER_LOGICAL;
        }
        if ((respAlternatives = this._responseAlternatives.get(altKey = portName + ":" + iterationType)) == null) {
            respAlternatives = new HashMap();
            this._responseAlternatives.put(altKey, respAlternatives);
        }
        if ((result = respAlternatives.get(operationName)) == null || requesterEPWE != null) {
            result = new Alternative();
            Alternative tAlt = this.getServiceAlternative(serviceQName, requesterEPWE, iterationType);
            if (tAlt != null) {
                result = result.add(tAlt);
            }
            if ((tAlt = this.getEndpointAlternative(serviceQName, portName, requesterEPWE, iterationType)) != null) {
                result = result.add(tAlt);
            }
            if ((tAlt = this.getOperationAlternative(serviceQName, portName, operationName, requesterEPWE, iterationType)) != null) {
                result = result.add(tAlt);
            }
            if ((tAlt = this.getOutputMessageAlternative(serviceQName, portName, operationName, requesterEPWE, iterationType)) != null) {
                result = result.add(tAlt);
            }
            if (requesterEPWE == null && result != null) {
                respAlternatives.put(operationName, result);
            }
        }
        return result;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("[EffectivePolicyWSDLEngine]:\n");
        if (this._policiesByScope != null) {
            Set<WSDLAttachPoint> keySet = this._policiesByScope.keySet();
            for (WSDLAttachPoint tKey : keySet) {
                Vector<ExtensibilityElement> tVector = this._policiesByScope.get(tKey);
                buffer.append("  Scope:[").append(((Object)tKey).toString()).append("]\n");
                for (int i = 0; i < tVector.size(); ++i) {
                    Policy tPol = (Policy)tVector.elementAt(i);
                    buffer.append("      Policy[").append(i).append("]:[").append(tPol.formatString()).append("]\n");
                }
            }
        }
        return buffer.toString();
    }

    public Vector<ExtensibilityElement> getPolicyAtAttachPoint(WSDLAttachPoint attachPoint) {
        return this._policiesByScope.get(attachPoint);
    }

    public boolean containsPolicy() {
        return !this._policiesByScope.isEmpty();
    }

    public Policy getAllPolicies() {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getAllPolicies");
        }
        Vector allPols = new Vector();
        Set<WSDLAttachPoint> attachpointsSet = this._policiesByScope.keySet();
        for (WSDLAttachPoint attachPoint : attachpointsSet) {
            allPols.addAll(this._policiesByScope.get(attachPoint));
        }
        Policy result = null;
        if (allPols.size() > 0) {
            result = (Policy)allPols.get(0);
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "getAllPolicies", "Have found policies: " + allPols.size());
            }
            for (int i = 1; i < allPols.size(); ++i) {
                try {
                    result.merge((Policy)allPols.get(i));
                    continue;
                }
                catch (WSPolicyException e) {
                    if (!TRACE_COMPONENT.isDebugEnabled()) continue;
                    Tr.debug(TRACE_COMPONENT, "getAllPolicies", "Error: " + e);
                }
            }
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getAllPolicies", result);
        }
        return result;
    }

    public Policy getServiceAndFirstPortEffectivePolicy(QName serviceQName) throws PolicyReferenceException, WSPolicyInternalException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getServiceAndFirstPortEffectivePolicy", new Object[]{serviceQName});
        }
        WSDLAttachPoint attachPoint = new WSDLAttachPoint();
        attachPoint.setServiceAttachPoint(serviceQName);
        attachPoint.validate(this._definition);
        Policy result = this.mergeMatchingPolicies(attachPoint, null);
        Service service2 = null;
        Port port = null;
        Map services = this._definition.getServices();
        for (Service service2 : services.values()) {
            if (!service2.getQName().equals(serviceQName)) continue;
            Map ports = service2.getPorts();
            Set portnamesSet = ports.keySet();
            Iterator portItr = portnamesSet.iterator();
            port = (Port)ports.get(portItr.next());
            break;
        }
        if (service2 == null) {
            return result;
        }
        if (port == null) {
            return result;
        }
        WSDLAttachPoint attachPointPort = new WSDLAttachPoint();
        attachPointPort.setPortAttachPoint(serviceQName, port.getName());
        attachPointPort.validate(this._definition);
        result = this.mergeMatchingPolicies(attachPointPort, result);
        Binding binding = port.getBinding();
        if (binding == null) {
            return result;
        }
        WSDLAttachPoint attachPointBinding = new WSDLAttachPoint();
        attachPointBinding.setBindingAttachPoint(binding.getQName());
        attachPointBinding.validate(this._definition);
        result = this.mergeMatchingPolicies(attachPointBinding, result);
        PortType portType = binding.getPortType();
        if (portType == null) {
            return result;
        }
        WSDLAttachPoint attachPointPortType = new WSDLAttachPoint();
        attachPointPortType.setPortTypeAttachPoint(portType.getQName());
        attachPointPortType.validate(this._definition);
        result = this.mergeMatchingPolicies(attachPointPortType, result);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getServiceAndFirstPortEffectivePolicy", result);
        }
        return result;
    }

    public List<String> getOperationNames(QName serviceQName, String portName) throws WSPolicyInternalException {
        Port port = this.getPort(this._definition, serviceQName, portName);
        if (port == null) {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "WSDL Node not recognised", InternalUtils.traceStringWSDLNode("port", serviceQName, portName, null, null));
            }
            throw new WSPolicyInternalException();
        }
        Binding binding = port.getBinding();
        if (binding == null) {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "WSDL Node not recognised", InternalUtils.traceStringWSDLNode("binding", serviceQName, portName, null, null));
            }
            throw new WSPolicyInternalException();
        }
        List operations = binding.getBindingOperations();
        ArrayList<String> result = new ArrayList<String>();
        for (BindingOperation op : operations) {
            result.add(op.getName());
        }
        return result;
    }

    public List<String> getPortNames(QName serviceQName) {
        Map ports;
        ArrayList result = null;
        Service service = this._definition.getService(serviceQName);
        if (service != null && (ports = service.getPorts()) != null) {
            result = new ArrayList(ports.keySet());
        }
        return result;
    }

    public void setBindings(Map bindings) {
        if (this._reader != null) {
            PolicyContext context = this._reader.getPolicyContext();
            if (context != null) {
                context.setProperty("bindings", bindings);
                this._context = context;
            } else if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "Unable to set bindings in WSDLProcessor");
            }
        }
    }

    public String getWSDL() {
        StringWriter stringWriter = null;
        try {
            stringWriter = new StringWriter();
            WSDLWriter writer = WSDLFactory.newInstance().newWSDLWriter();
            writer.writeWSDL(this._definition, stringWriter);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ((Object)stringWriter).toString();
    }

    public String getUnsupportedAssertions() {
        StringBuffer result = new StringBuffer();
        try {
            PolicyProviderRegistry registry = PolicyProviderRegistry.getInstance();
            Map bindings = (Map)this._context.getProperty("bindings");
            Vector<QName> allUsedQNames = new Vector<QName>();
            for (Vector<ExtensibilityElement> v : this._policiesByScope.values()) {
                for (ExtensibilityElement e : v) {
                    if (!(e instanceof Policy)) continue;
                    Policy p = (Policy)e;
                    allUsedQNames.addAll(this.getUnsupportedAssertionsFromPolicy(registry, p, bindings));
                }
            }
            for (QName qName : allUsedQNames) {
                result.append(qName);
                result.append(", ");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result.toString();
    }

    private Vector<QName> getUnsupportedAssertionsFromPolicy(PolicyProviderRegistry registry, Policy p, Map bindings) {
        Vector<QName> result = new Vector<QName>();
        Vector allAssertions = p.getAllAssertions();
        for (Object obj : allAssertions) {
            Policy subPolicy;
            if (!(obj instanceof AssertionImpl)) continue;
            try {
                if (!registry.isSupported((AssertionImpl)obj, bindings)) {
                    result.add(((AssertionImpl)obj).getQName());
                }
            }
            catch (WSPolicyBindingsException wspbe) {
                result.add(((AssertionImpl)obj).getQName());
            }
            if ((subPolicy = ((AssertionImpl)obj).getPolicy()) == null) continue;
            result.addAll(this.getUnsupportedAssertionsFromPolicy(registry, subPolicy, bindings));
        }
        return result;
    }

    public PolicyContext getPolicyContext() {
        return this._context;
    }

    public void setObtainedFromAddress(String address) {
        this._obtainedFromAddress = address;
    }

    public String getObtainedFromAddress() {
        return this._obtainedFromAddress;
    }
}

