/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wspolicy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.wspolicy.Policy;
import com.ibm.ws.wspolicy.PolicyContext;
import com.ibm.ws.wspolicy.PolicyReference;
import com.ibm.ws.wspolicy.PolicyReferenceException;
import com.ibm.ws.wspolicy.PolicyWriterContext;
import com.ibm.ws.wspolicy.WSPolicyInternalException;
import com.ibm.ws.wspolicy.assertions.AssertionExtensionRegistry;
import com.ibm.ws.wspolicy.assertions.AssertionImpl;
import com.ibm.ws.wspolicy.assertions.AssertionSerializer;
import com.ibm.ws.wspolicy.assertions.DefaultAssertion;
import com.ibm.ws.wspolicy.domain.PolicyProviderRegistry;
import com.ibm.ws.wspolicy.operators.AllOperator;
import com.ibm.ws.wspolicy.operators.ExactlyOneOperator;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolicyWriter {
    private static final TraceComponent tc = Tr.register(PolicyWriter.class, "WS-PolicyRW", "com.ibm.ws.wspolicy.resources.CWPOLMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.wspolicy.resources.CWPOLMessages");
    private boolean resolve = false;
    private AssertionExtensionRegistry assertionExtensionRegistry = AssertionExtensionRegistry.getAssertionExtensionRegistry();

    protected PolicyWriter(PolicyContext pContext) {
    }

    public void writePolicy(Policy p, Writer sink) throws WSPolicyInternalException, PolicyReferenceException {
        this.writePolicy(p, sink, null);
    }

    public void writePolicy(Policy policy, Writer sink, PolicyContext policyContext) throws WSPolicyInternalException, PolicyReferenceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "writePolicy", this);
        }
        try {
            CharArrayWriter charArrayWriter = this.policyToCharArrayWriter(policy, policyContext);
            sink.write(charArrayWriter.toCharArray());
            sink.flush();
        }
        catch (IOException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.wspolicy.PolicyWriter.writePolicy", "99", this);
            throw new WSPolicyInternalException(e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "writePolicy");
        }
    }

    public void writePolicy(Policy policy, OutputStream sink) throws WSPolicyInternalException, PolicyReferenceException {
        this.writePolicy(policy, sink, null);
    }

    public void writePolicy(Policy policy, OutputStream sink, PolicyContext policyContext) throws WSPolicyInternalException, PolicyReferenceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "writePolicy", this);
        }
        try {
            CharArrayWriter charArrayWriter = this.policyToCharArrayWriter(policy, policyContext);
            OutputStreamWriter osw = new OutputStreamWriter(sink, this.getPolicyWriterContext(policyContext).getEncoding());
            osw.write(charArrayWriter.toCharArray());
            osw.flush();
        }
        catch (IOException e) {
            throw new WSPolicyInternalException(e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "writePolicy");
        }
    }

    private CharArrayWriter policyToCharArrayWriter(Policy policy, PolicyContext policyContext) throws IOException, WSPolicyInternalException, PolicyReferenceException {
        PolicyWriterContext writerContext = this.getPolicyWriterContext(policyContext);
        CharArrayWriter result = new CharArrayWriter();
        if (!writerContext.isOmitXmlDecl()) {
            String xmldecl = "<?xml version=\"1.0\" encoding=\"" + writerContext.getEncoding() + "\"?>" + writerContext.getLineSeparator();
            result.write(xmldecl.toCharArray());
        }
        if (policy instanceof PolicyReference) {
            this.handlePolRef(result, (PolicyReference)policy, writerContext, policyContext);
        } else {
            this.handlePolicy(result, policy, writerContext, policyContext);
        }
        return result;
    }

    public PolicyWriterContext getPolicyWriterContext(PolicyContext policyContext) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getPolicyWriterContext", new Object[]{policyContext, this});
        }
        PolicyWriterContext result = null;
        if (policyContext != null) {
            result = (PolicyWriterContext)policyContext.getProperty("SerializerFormatting");
        }
        if (result == null) {
            result = new PolicyWriterContext();
            if (policyContext != null) {
                policyContext.setProperty("SerializerFormatting", result);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getPolicyWriterContext", result);
        }
        return result;
    }

    private void handlePolicy(CharArrayWriter caw, Policy policy, PolicyWriterContext writerContext, PolicyContext policyContext) throws IOException, WSPolicyInternalException, PolicyReferenceException {
        StringBuffer toAdd = new StringBuffer(writerContext.getIndent());
        toAdd.append("<wsp:Policy");
        HashMap existingNamespace2Prefix = null;
        existingNamespace2Prefix = policyContext != null ? (HashMap)policyContext.getProperty("DeclaredNamespaces") : new HashMap();
        HashMap localNamespace2Prefix = (HashMap)policy.getNamespaces();
        if (existingNamespace2Prefix == null || !existingNamespace2Prefix.containsKey("http://www.w3.org/ns/ws-policy")) {
            localNamespace2Prefix.put("http://www.w3.org/ns/ws-policy", "wsp");
        }
        if (!(policy.getId() == null || existingNamespace2Prefix != null && existingNamespace2Prefix.containsKey("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd"))) {
            localNamespace2Prefix.put("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu");
        }
        toAdd.append(this.handleNamespaces(existingNamespace2Prefix, localNamespace2Prefix));
        HashMap<String, String> completedNS2Prefix = new HashMap<String, String>();
        if (existingNamespace2Prefix != null) {
            completedNS2Prefix.putAll(existingNamespace2Prefix);
        }
        completedNS2Prefix.putAll(localNamespace2Prefix);
        HashMap<QName, String> attrs = new HashMap<QName, String>();
        Vector<QName> attrNames = policy.getAllAttributeNames();
        if (attrNames != null) {
            for (int i = 0; i < attrNames.size(); ++i) {
                QName name = attrNames.get(i);
                String value = policy.getAttribute(name);
                if (name.getLocalPart().equals("base")) {
                    if (writerContext.getBase() != null && value.equals(writerContext.getBase())) continue;
                    writerContext.setBase(value);
                    continue;
                }
                attrs.put(name, value);
            }
        }
        toAdd.append(this.handleAttributes(writerContext, attrs, completedNS2Prefix));
        toAdd.append(">" + writerContext.getLineSeparator());
        caw.write(toAdd.toString().toCharArray());
        writerContext.increaseIndentation();
        this.handleAssertions(caw, policy.getChildAssertions(), writerContext, completedNS2Prefix);
        writerContext.decreaseIndentation();
        toAdd = new StringBuffer(writerContext.getIndent());
        toAdd.append("</wsp:Policy>" + writerContext.getLineSeparator());
        caw.write(toAdd.toString().toCharArray());
    }

    private void handleExactlyOne(CharArrayWriter caw, ExactlyOneOperator eoo, PolicyWriterContext ctx, HashMap existingNamespaces) throws IOException, WSPolicyInternalException, PolicyReferenceException {
        boolean normalize = false;
        StringBuffer toAdd = null;
        if (!ctx.getIgnoreNormalize()) {
            normalize = true;
            toAdd = new StringBuffer(ctx.getIndent());
            toAdd.append("<wsp:ExactlyOne>" + ctx.getLineSeparator());
            caw.write(toAdd.toString().toCharArray());
            ctx.increaseIndentation();
        }
        this.handleAssertions(caw, eoo.getChildAssertions(), ctx, existingNamespaces);
        if (normalize) {
            ctx.decreaseIndentation();
            toAdd = new StringBuffer(ctx.getIndent());
            toAdd.append("</wsp:ExactlyOne>" + ctx.getLineSeparator());
            caw.write(toAdd.toString().toCharArray());
        }
    }

    private void handleAll(CharArrayWriter caw, AllOperator all, PolicyWriterContext ctx, HashMap existingNamespaces) throws IOException, WSPolicyInternalException, PolicyReferenceException {
        boolean normalize = false;
        StringBuffer toAdd = null;
        if (!ctx.getIgnoreNormalize()) {
            normalize = true;
            toAdd = new StringBuffer(ctx.getIndent());
            toAdd.append("<wsp:All>" + ctx.getLineSeparator());
            caw.write(toAdd.toString().toCharArray());
            ctx.increaseIndentation();
        }
        this.handleAssertions(caw, all.getChildAssertions(), ctx, existingNamespaces);
        if (normalize) {
            ctx.decreaseIndentation();
            toAdd = new StringBuffer(ctx.getIndent());
            toAdd.append("</wsp:All>" + ctx.getLineSeparator());
            caw.write(toAdd.toString().toCharArray());
        }
    }

    private void handlePolRef(CharArrayWriter caw, PolicyReference pr, PolicyWriterContext ctx, PolicyContext policyContext) throws IOException, WSPolicyInternalException, PolicyReferenceException {
        if (this.resolve) {
            Policy pol = pr.getPolicy();
            this.handlePolicy(caw, pol, ctx, policyContext);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "handlePolRef");
            }
            return;
        }
        StringBuffer toAdd = new StringBuffer(ctx.getIndent());
        String uri = pr.getUri().toString();
        String digest = pr.getDigest();
        String algorithm = pr.getDigestAlgorithm().toString();
        HashMap existingNamespace2Prefix = null;
        existingNamespace2Prefix = policyContext != null ? (HashMap)policyContext.getProperty("DeclaredNamespaces") : new HashMap();
        HashMap localNamespace2Prefix = (HashMap)pr.getNamespaces();
        if (existingNamespace2Prefix == null || !existingNamespace2Prefix.containsKey("http://www.w3.org/ns/ws-policy")) {
            localNamespace2Prefix.put("http://www.w3.org/ns/ws-policy", "wsp");
        }
        if (!(pr.getId() == null || existingNamespace2Prefix != null && existingNamespace2Prefix.containsKey("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd"))) {
            localNamespace2Prefix.put("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu");
        }
        toAdd.append("<wsp:PolicyReference");
        if (uri != null) {
            toAdd.append(" URI=\"" + uri + "\"");
        }
        if (digest != null) {
            toAdd.append(" Digest=\"" + digest + "\"");
            if (algorithm != null) {
                toAdd.append(" DigestAlgorithm=\"" + algorithm + "\"");
            }
        }
        toAdd.append(this.handleNamespaces(existingNamespace2Prefix, localNamespace2Prefix));
        toAdd.append("/>" + ctx.getLineSeparator());
        caw.write(toAdd.toString().toCharArray());
    }

    private void handleDefault(CharArrayWriter caw, DefaultAssertion assertion, PolicyWriterContext policyWriterContext, HashMap existingNamespaces) throws IOException {
        PolicyContext policyContext = new PolicyContext();
        policyContext.setProperty("SerializerFormatting", policyWriterContext);
        policyContext.setProperty("DeclaredNamespaces", existingNamespaces);
        caw.write(assertion.toString(policyContext).toCharArray());
    }

    private String handleAttributes(PolicyWriterContext ctx, Map<QName, String> attrs, HashMap<String, String> existingNS2prefix) {
        StringBuffer result = new StringBuffer("");
        if (attrs == null) {
            return result.toString();
        }
        Set<Map.Entry<QName, String>> entrySet = attrs.entrySet();
        for (Map.Entry<QName, String> entry : entrySet) {
            String value;
            QName key = entry.getKey();
            String alias = null;
            String ns = key.getNamespaceURI();
            if (ns == null || ns.length() == 0) {
                value = entry.getValue();
                result.append(" " + key.getLocalPart() + "=\"" + value + "\"");
                continue;
            }
            alias = existingNS2prefix.get(ns);
            if (alias == null) {
                alias = PolicyProviderRegistry.getInstance().getPreferredPrefix(key);
                if (alias == null || alias.equals("")) {
                    alias = key.getLocalPart().toLowerCase();
                }
                int counter = 1;
                String chosenPrefix = alias;
                while (existingNS2prefix.containsValue(alias)) {
                    alias = chosenPrefix + counter++;
                }
                existingNS2prefix.put(ns, alias);
                result.append(" xmlns:" + alias + "=\"" + key.getNamespaceURI() + "\"");
            }
            value = entry.getValue();
            result.append(" " + alias + ":" + key.getLocalPart() + "=\"" + value + "\"");
        }
        return result.toString();
    }

    private String handleNamespaces(HashMap<String, String> existingNS2Prefix, HashMap<String, String> localNS2Prefix) {
        StringBuffer result = new StringBuffer("");
        if (localNS2Prefix != null) {
            Set<Map.Entry<String, String>> entrySet = localNS2Prefix.entrySet();
            for (Map.Entry<String, String> entry : entrySet) {
                String namespace = entry.getKey();
                String alias = entry.getValue();
                if (existingNS2Prefix != null && existingNS2Prefix.containsKey(namespace)) continue;
                result.append(" xmlns:" + alias + "=\"" + namespace + "\"");
            }
        }
        return result.toString();
    }

    private void handleAssertions(CharArrayWriter caw, Vector assertions, PolicyWriterContext ctx, HashMap existingNamespaces) throws IOException, WSPolicyInternalException, PolicyReferenceException {
        if (assertions != null) {
            for (Object polElem : assertions) {
                PolicyContext policyContext;
                if (polElem instanceof PolicyReference) {
                    policyContext = new PolicyContext();
                    policyContext.setProperty("DeclaredNamespaces", existingNamespaces);
                    this.handlePolRef(caw, (PolicyReference)polElem, ctx, policyContext);
                    continue;
                }
                if (polElem instanceof ExactlyOneOperator) {
                    this.handleExactlyOne(caw, (ExactlyOneOperator)polElem, ctx, existingNamespaces);
                    continue;
                }
                if (polElem instanceof Policy) {
                    policyContext = new PolicyContext();
                    policyContext.setProperty("DeclaredNamespaces", existingNamespaces);
                    this.handlePolicy(caw, (Policy)polElem, ctx, policyContext);
                    continue;
                }
                if (polElem instanceof AllOperator) {
                    this.handleAll(caw, (AllOperator)polElem, ctx, existingNamespaces);
                    continue;
                }
                if (polElem instanceof DefaultAssertion) {
                    this.handleDefault(caw, (DefaultAssertion)polElem, ctx, existingNamespaces);
                    continue;
                }
                if (polElem instanceof AssertionImpl) {
                    this.handleCustom(caw, (AssertionImpl)polElem, ctx, existingNamespaces);
                    continue;
                }
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Unknown Element " + polElem.getClass().getName());
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleCustom(CharArrayWriter caw, AssertionImpl assertion, PolicyWriterContext policyWriterContext, HashMap existingNamespaces) throws WSPolicyInternalException {
        if (this.assertionExtensionRegistry == null) throw new WSPolicyInternalException();
        QName vocabulary = assertion.getQName();
        AssertionSerializer assertionSerializer = this.assertionExtensionRegistry.getSerializer(vocabulary);
        if (assertionSerializer == null) throw new WSPolicyInternalException();
        StringWriter sw = new StringWriter();
        PolicyContext policyContext = new PolicyContext();
        policyContext.setProperty("SerializerFormatting", policyWriterContext);
        policyContext.setProperty("DeclaredNamespaces", existingNamespaces);
        assertionSerializer.marshall(assertion, vocabulary, sw, policyContext);
        try {
            caw.write(sw.toString());
            return;
        }
        catch (IOException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.wspolicy.PolicyWriter.handleCustom", "535", this);
            throw new WSPolicyInternalException(e);
        }
    }

    public boolean getResolveReferences() {
        return this.resolve;
    }

    public void setResolveReferences(boolean flag) {
        this.resolve = flag;
    }
}

