/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wspolicy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.wspolicy.Policy;
import com.ibm.ws.wspolicy.PolicySource;
import com.ibm.ws.wspolicy.WSPolicyInternalException;
import java.net.URI;
import java.util.Iterator;
import java.util.Vector;
import sun.misc.Service;
import sun.misc.ServiceConfigurationError;

public class PolicySourceRegistry {
    private static final TraceComponent tc = Tr.register(PolicySourceRegistry.class, "WS-Policy", "com.ibm.ws.wspolicy.resources.CWPOLMessages");
    private Vector _sources = new Vector();
    private boolean _initComplete = false;

    private void initSources() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "initSources", this);
        }
        Iterator sIter = Service.providers(PolicySource.class);
        while (sIter != null && sIter.hasNext()) {
            try {
                PolicySource ps = (PolicySource)sIter.next();
                this._sources.add(ps);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug(tc, "PolicySource[" + ps.getClass().getName() + "]");
            }
            catch (ServiceConfigurationError e) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug(tc, "PolicySource class could not be found:" + e.toString());
            }
            catch (NoClassDefFoundError e) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug(tc, "PolicySource class could not be found:" + e.toString());
            }
        }
        this._initComplete = true;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "initSources");
        }
    }

    public Policy getPolicy(URI policyURI) throws WSPolicyInternalException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getPolicy", new Object[]{policyURI, this});
        }
        if (!this._initComplete) {
            this.initSources();
        }
        Policy policy = null;
        for (int i = 0; i < this._sources.size(); ++i) {
            PolicySource tSource = (PolicySource)this._sources.get(i);
            policy = tSource.getPolicy(policyURI);
            if (policy == null) continue;
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break;
            Tr.debug(tc, "Found Policy[" + policyURI + "] in PolicySource[" + tSource.getClass().getName() + "]");
            break;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getPolicy", policy);
        }
        return policy;
    }

    public void addSource(PolicySource newSource) {
        this._initComplete = true;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "addSource", new Object[]{newSource, this});
        }
        this._sources.add(newSource);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "addSource");
        }
    }

    public Vector getSources() {
        if (!this._initComplete) {
            this.initSources();
        }
        return this._sources;
    }

    public void clearSources() {
        this._initComplete = true;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "clearSources", this);
        }
        this._sources.clear();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "clearSources");
        }
    }

    public void merge(PolicySourceRegistry pSourceRegistry) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "merge", new Object[]{pSourceRegistry, this});
        }
        if (pSourceRegistry != null && !pSourceRegistry.equals(this)) {
            Vector yourSources = pSourceRegistry.getSources();
            for (int i = 0; i < yourSources.size(); ++i) {
                PolicySource pSource = (PolicySource)yourSources.get(i);
                if (this._sources.contains(pSource)) continue;
                this.addSource(pSource);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "merge");
        }
    }
}

