/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wspolicy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.wspolicy.Policy;
import com.ibm.ws.wspolicy.PolicyConstants;
import com.ibm.ws.wspolicy.PolicyContext;
import com.ibm.ws.wspolicy.PolicyFactory;
import com.ibm.ws.wspolicy.PolicyReferenceException;
import com.ibm.ws.wspolicy.WSPolicyException;
import com.ibm.ws.wspolicy.WSPolicyInternalException;
import com.ibm.ws.wspolicy.digest.PolicyDigestRegistry;
import com.ibm.ws.wspolicy.digest.PolicyDigestRegistryFactory;
import com.ibm.ws.wspolicy.operators.AllOperator;
import com.ibm.ws.wspolicy.operators.Operator;
import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.namespace.QName;

public class PolicyReference
extends Policy {
    private static final TraceComponent TRACE_COMPONENT = Tr.register(PolicyReference.class, "WS-Policy", "com.ibm.ws.wspolicy.resources.CWPOLMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.wspolicy.resources.CWPOLMessages");
    private Policy _referencedPolicy;
    private AllOperator _equivalentAllOperator;
    private String _referenceType = PolicyConstants.TYPE_URI;
    private PolicyDigestRegistry _digestRegistry;

    protected PolicyReference(QName qName, PolicyContext pContext) {
        super(pContext);
    }

    public PolicyReference(PolicyContext pContext, Policy owningPolicy) {
        super(null, owningPolicy, pContext);
        if (owningPolicy != null) {
            this._digestRegistry = owningPolicy.getPolicyDigestRegistry();
            if (this._digestRegistry == null) {
                this._digestRegistry = PolicyDigestRegistryFactory.getPolicyDigestRegistry();
                owningPolicy.setPolicyDigestRegistry(this._digestRegistry);
            }
        }
    }

    protected PolicyReference(URI uri, PolicyContext pContext) {
        super(pContext);
        this.setUri(uri);
    }

    public String getDigest() {
        QName qName = new QName("", PolicyConstants.TAG_DIGEST);
        String result = this.getAttribute(qName);
        return result;
    }

    public void setDigest(String digest) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "setDigest", "digest[" + (digest == null ? "null" : digest.toString()) + "]");
        }
        QName qName = new QName("", PolicyConstants.TAG_DIGEST);
        this.addAttribute(qName, digest);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "setDigest");
        }
    }

    public URI getDigestAlgorithm() throws PolicyReferenceException {
        QName qName;
        String uriString;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getDigestAlgorithm");
        }
        if ((uriString = this.getAttribute(qName = new QName("", PolicyConstants.TAG_DIGESTALGORITHM))) == null) {
            uriString = PolicyConstants.DEFAULT_DIGEST_ALGORITHM;
        }
        URI result = null;
        try {
            result = new URI(uriString);
        }
        catch (URISyntaxException use) {
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "Unable to recognize digest algorithm", use);
            }
            FFDCFilter.processException((Throwable)use, "com.ibm.ws.wspolicy.PolicyReference.getDigestAlgorithm", "163", this);
            throw new PolicyReferenceException(uriString);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getDigestAlgorithm", result);
        }
        return result;
    }

    public void setDigestAlgorithm(URI al) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "setDigestAlgorithm", "algorithm[" + (al == null ? "null" : al.toString()));
        }
        QName qName = new QName("", PolicyConstants.TAG_DIGESTALGORITHM);
        this.addAttribute(qName, al == null ? "null" : al.toString());
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "setDigestAlgorithm", "algorithm[" + (al == null ? "null" : al.toString()));
        }
    }

    public String getReferenceType() {
        return this._referenceType;
    }

    private void resolveReference() throws PolicyReferenceException, WSPolicyInternalException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "resolveReference");
        }
        URI referencedID = this.getUri();
        if (this.getReader() == null) {
            PolicyFactory factory = new PolicyFactory(this.getContext());
            this.setReader(factory.newPolicyReader());
        }
        try {
            this._referencedPolicy = this.getReader().readPolicy(referencedID);
        }
        catch (WSPolicyInternalException wspe) {
            FFDCFilter.processException((Throwable)wspe, "com.ibm.ws.wspolicy.PolicyReference.resolveReference", "237", this);
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "WSPolicy at URI " + this.getUri() + " could not be resolved.", wspe);
            }
            String uri = referencedID != null ? referencedID.toString() : "";
            throw new PolicyReferenceException(uri);
        }
        if (this._referencedPolicy == null) {
            Policy owner = this.getOwningPolicy();
            if (owner != null) {
                try {
                    this.getReader().findEmbeddedPolicy(new URI("#xxx"), owner);
                }
                catch (URISyntaxException e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.wspolicy.PolicyReference.resolveReference", "228", this);
                }
                this._referencedPolicy = this.getReader().readPolicy(referencedID);
            }
            if (this._referencedPolicy == null) {
                if (TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "WSPolicy at URI " + this.getUri() + " could not be resolved.");
                }
                String uri = referencedID != null ? referencedID.toString() : "";
                throw new PolicyReferenceException(uri);
            }
        }
        if (this.getDigest() != null && this.getDigest().length() != 0 && this._referencedPolicy != null) {
            String calculatedDigest = this._referencedPolicy.getReader().calculateDigest(this._referencedPolicy, this.getDigestAlgorithm());
            if (!this.getDigest().equals(calculatedDigest)) {
                if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "Mismatching Digests");
                }
                String uri = referencedID != null ? referencedID.toString() : "";
                throw new PolicyReferenceException(uri);
            }
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "resolveReference");
        }
    }

    protected Operator getEquivalentAllOperator() throws PolicyReferenceException, WSPolicyInternalException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getEquivalentAllOperator");
        }
        if (this._equivalentAllOperator != null) {
            return this._equivalentAllOperator;
        }
        if (this._referencedPolicy == null) {
            this.resolveReference();
        }
        this._equivalentAllOperator = new AllOperator();
        this._equivalentAllOperator.setOwningPolicy(this.getOwningPolicy());
        this._equivalentAllOperator.setContext(this.getContext());
        this._equivalentAllOperator.setChildAssertions(this._referencedPolicy.getChildAssertions());
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getEquivalentAllOperator");
        }
        return this._equivalentAllOperator;
    }

    public int hashCode() {
        block7: {
            try {
                Policy pol = this.getPolicy();
                if (pol != null) {
                    return pol.hashCode();
                }
            }
            catch (WSPolicyException e) {
                if (!TraceComponent.isAnyTracingEnabled() || !TRACE_COMPONENT.isDebugEnabled()) break block7;
                Tr.debug(TRACE_COMPONENT, "Exception getting Policy from PolicyReference", e);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "reverting to using hash of PolicyReference itself");
        }
        StringBuffer hashBase = new StringBuffer(PolicyConstants.TAG_WSP + PolicyConstants.TAG_POLICYREFERENCE);
        if (this.getReferenceType() == PolicyConstants.TYPE_URI) {
            hashBase.append(this.getUri().toString());
        } else if (TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "hashCode", "Unrecognized PolicyReferenceType");
        }
        int result = hashBase.toString().hashCode();
        return result;
    }

    public Policy getPolicy() throws PolicyReferenceException, WSPolicyInternalException {
        if (this._referencedPolicy == null) {
            this.resolveReference();
        }
        return this._referencedPolicy;
    }

    public String toString() {
        StringBuffer result = new StringBuffer("<wsp:PolicyReference URI=\"");
        try {
            result.append(this.getUri() + "\"");
            if (this.getDigest() != null) {
                result.append(" Digest=\"" + this.getDigest() + "\"");
                result.append(" DigestAlgorithm=\"" + this.getDigestAlgorithm() + "\"");
            }
        }
        catch (Exception e) {
            result = new StringBuffer("<Not defined");
        }
        result.append("/>");
        return result.toString();
    }

    public URI getUri() {
        URI result = null;
        String uriStr = null;
        try {
            uriStr = this.getAttribute(new QName("", PolicyConstants.TYPE_URI));
            result = new URI(uriStr);
        }
        catch (Exception e) {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.exit(TRACE_COMPONENT, "getUri", "URISyntaxException parsing " + uriStr);
            }
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.wspolicy.PolicyReference.getUri", "364", this);
            result = null;
        }
        return result;
    }

    public void setCalculatedDigest(Policy policy) throws PolicyReferenceException, WSPolicyInternalException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "setCalculatedDigest");
        }
        String digest = policy.getReader().calculateDigest(policy, this.getDigestAlgorithm());
        this.setDigest(digest);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "setCalculatedDigest", "digest[" + digest + "]");
        }
    }

    public void setUri(URI uri) {
        QName qName = new QName("", PolicyConstants.TYPE_URI);
        this.addAttribute(qName, uri.toString());
    }
}

