/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wspolicy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.wspolicy.Policy;
import com.ibm.ws.wspolicy.PolicyCache;
import com.ibm.ws.wspolicy.PolicyConstants;
import com.ibm.ws.wspolicy.PolicyContext;
import com.ibm.ws.wspolicy.PolicyElement;
import com.ibm.ws.wspolicy.PolicyLocator;
import com.ibm.ws.wspolicy.PolicyLocatorImpl;
import com.ibm.ws.wspolicy.PolicyReference;
import com.ibm.ws.wspolicy.PolicyReferenceException;
import com.ibm.ws.wspolicy.PolicySourceRegistry;
import com.ibm.ws.wspolicy.UnsupportedNamespaceException;
import com.ibm.ws.wspolicy.UnsupportedPolicyElementException;
import com.ibm.ws.wspolicy.WSPolicyInternalException;
import com.ibm.ws.wspolicy.digest.PolicyDigest;
import com.ibm.ws.wspolicy.digest.PolicyDigestRegistry;
import com.ibm.ws.wspolicy.digest.PolicyDigestRegistryFactory;
import com.ibm.ws.wspolicy.operators.Operator;
import com.ibm.ws.wspolicy.utils.dom.PolicyDOMUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolicyReader {
    private static final TraceComponent tc = Tr.register(PolicyReader.class, "WS-PolicyRW", "com.ibm.ws.wspolicy.resources.CWPOLMessages");
    private DocumentBuilder _documentBuilder = null;
    private PolicyContext _context = null;
    private PolicySourceRegistry _psr = null;
    private PolicyCache _globalCache = null;
    private PolicyCache _localCache = null;
    private String _location = "";
    private HashMap<String, Node> _digestXMLstore = new HashMap();

    protected PolicyReader(PolicyContext pContext) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "PolicyReader", pContext);
        }
        this._context = pContext;
        if (this._context != null) {
            this.extractFromContext(pContext);
        }
        if (this._globalCache == null) {
            this._globalCache = new PolicyCache();
        }
        this._localCache = new PolicyCache();
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        try {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "PolicyReader", "Build level version: " + null);
            }
            this._documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "ParserConfigurationException ", e);
            }
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.wspolicy.PolicyReader.PolicyReader", "154", this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "PolicyReader", this);
        }
    }

    public Policy readPolicy(Document d) throws WSPolicyInternalException, UnsupportedNamespaceException, UnsupportedPolicyElementException, PolicyReferenceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "readPolicy", "Starting with document " + (d == null ? null : d.getLocalName()));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "readPolicy");
        }
        return this.readPolicy(d.getDocumentElement());
    }

    public Policy readPolicy(Element element) throws WSPolicyInternalException, UnsupportedPolicyElementException, UnsupportedNamespaceException, PolicyReferenceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "readPolicy", "Starting with element " + (element == null ? null : element.getLocalName()));
        }
        Policy result = null;
        if (element.getLocalName().equalsIgnoreCase(PolicyConstants.ELEMENT_POLICY) && element.getNamespaceURI().equalsIgnoreCase("http://www.w3.org/ns/ws-policy")) {
            result = this.createPolicy(element);
        } else if (element.getLocalName().equalsIgnoreCase(PolicyConstants.ELEMENT_POLICYREF) && element.getNamespaceURI().equalsIgnoreCase("http://www.w3.org/ns/ws-policy")) {
            PolicyReference policyReference = new PolicyReference(this._context, null);
            PolicyDOMUtils.parseAttributes(policyReference, element);
            policyReference.setReader(this);
            result = policyReference.getPolicy();
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Element being read is neither a PolicyReference or a Policy " + element.getLocalName());
            }
            throw new WSPolicyInternalException();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "readPolicy", result);
        }
        return result;
    }

    private Policy createPolicy(Element element) throws WSPolicyInternalException, UnsupportedPolicyElementException, UnsupportedNamespaceException, PolicyReferenceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "createPolicy", "Starting with element " + (element == null ? null : element.getLocalName()));
        }
        Policy result = null;
        if (element.getLocalName().equalsIgnoreCase(PolicyConstants.ELEMENT_POLICY)) {
            result = new Policy(element, null, this._context);
            result.setReader(this);
            PolicyDOMUtils.parseAttributes(result, element);
            PolicyDOMUtils.parseChildAssertions(element, result);
            this.cacheInsert(result, element);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "createPolicy", result);
        }
        return result;
    }

    public Vector<Policy> readPolicies(InputStream inStream) throws WSPolicyInternalException, UnsupportedNamespaceException, UnsupportedPolicyElementException, PolicyReferenceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "readPolicies", new Object[]{inStream, this});
        }
        if (this._documentBuilder == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "_documentBuilder is null ");
            }
            throw new WSPolicyInternalException();
        }
        Vector<Policy> result = new Vector<Policy>();
        Document d = null;
        try {
            d = this._documentBuilder.parse(inStream);
        }
        catch (SAXException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "SAXParseException ", e);
            }
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.wspolicy.PolicyReader.readPolicies", "281", this);
            throw new WSPolicyInternalException(e);
        }
        catch (IOException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "IOException ", e);
            }
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.wspolicy.PolicyReader.readPolicies", "285", this);
            throw new WSPolicyInternalException(e);
        }
        Element element = d.getDocumentElement();
        if (element != null && "http://www.w3.org/ns/ws-policy".equals(element.getNamespaceURI()) && element.getLocalName().equalsIgnoreCase(PolicyConstants.ELEMENT_POLICY)) {
            Policy p = this.createPolicy(element);
            if (p != null) {
                result.add(p);
            }
        } else if (element != null) {
            result.addAll(this.readPolicies(element.getChildNodes()));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "readPolicies", result);
        }
        return result;
    }

    private Vector<Policy> readPolicies(NodeList nl) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "readPolicies", new Object[]{nl, this});
        }
        Vector<Policy> result = new Vector<Policy>();
        if (nl == null) {
            return result;
        }
        for (int i = 0; i < nl.getLength(); ++i) {
            try {
                if (nl.item(i).getNodeType() != 1) continue;
                Element element = (Element)nl.item(i);
                String childNamespace = element.getNamespaceURI();
                if (childNamespace != null && childNamespace.equals("http://www.w3.org/ns/ws-policy") && PolicyConstants.ELEMENT_POLICY.equals(element.getLocalName())) {
                    Policy p = this.createPolicy(element);
                    if (p == null) continue;
                    result.add(p);
                    continue;
                }
                result.addAll(this.readPolicies(element.getChildNodes()));
                continue;
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ex, "com.ibm.ws.wspolicy.PolicyReader.readPolicies", "296", this);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "readPolicies", result);
        }
        return result;
    }

    public Vector readPolicies(InputSource inSource) throws WSPolicyInternalException, UnsupportedNamespaceException, UnsupportedPolicyElementException, PolicyReferenceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "readPolicies", new Object[]{inSource, this});
        }
        Vector<Policy> result = null;
        if (inSource == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "readPolicies", result);
            }
            return result;
        }
        InputStream byteStream = inSource.getByteStream();
        if (byteStream != null) {
            result = this.readPolicies(byteStream);
        } else {
            Reader reader = inSource.getCharacterStream();
            if (reader != null) {
                try {
                    result = this.readPolicies(this.getByteArrayInputStream(reader));
                }
                catch (IOException e) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "IOException ", e);
                    }
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.wspolicy.PolicyReader.readPolicies", "375", this);
                    throw new WSPolicyInternalException(e);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "readPolicieswith InputSource", result);
        }
        return result;
    }

    private ByteArrayInputStream getByteArrayInputStream(Reader in) throws IOException {
        return new ByteArrayInputStream(this.getByteArray(in));
    }

    private byte[] getByteArray(Reader in) throws IOException {
        int count;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getByteArray", new Object[]{in, this});
        }
        int BUF_SIZE = 1024;
        StringBuffer everything = new StringBuffer();
        char[] polCharArray = new char[BUF_SIZE];
        while ((count = in.read(polCharArray, 0, BUF_SIZE)) > 0) {
            everything.append(new String(polCharArray, 0, count));
        }
        byte[] bytes = everything.toString().getBytes();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "byteArray size[" + bytes.length + "]");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getByteArray", bytes);
        }
        return bytes;
    }

    public Vector readPolicies(PolicyLocator pl) throws WSPolicyInternalException, UnsupportedNamespaceException, UnsupportedPolicyElementException, PolicyReferenceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "readPolicies", new Object[]{pl, this});
        }
        Vector<Policy> result = this.readPolicies(pl.getInputStream());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "readPolicies", result);
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    public Policy readPolicy(URI uri) throws WSPolicyInternalException {
        if (TraceComponent.isAnyTracingEnabled() && PolicyReader.tc.isEntryEnabled()) {
            Tr.entry(PolicyReader.tc, "readPolicy", new Object[]{uri, this});
        }
        if (uri == null) {
            return null;
        }
        result = null;
        if (!uri.toString().startsWith("#")) {
            if (this._globalCache != null) {
                result = this._globalCache.retrieve(uri.toString());
            }
            if (result == null && this._globalCache != null) {
                result = this.findEmbeddedPolicy(uri, this._globalCache);
            }
            if (result == null) {
                if (TraceComponent.isAnyTracingEnabled() && PolicyReader.tc.isDebugEnabled()) {
                    Tr.debug(PolicyReader.tc, "Policy not retrieved from cache " + uri.toString());
                }
                try {
                    if (this._psr == null) ** GOTO lbl34
                    result = this._psr.getPolicy(uri);
                    if (result == null) {
                        if (!TraceComponent.isAnyTracingEnabled() || !PolicyReader.tc.isDebugEnabled()) ** GOTO lbl34
                        Tr.debug(PolicyReader.tc, "Policy not retrieved from PolicySources " + uri.toString());
                    }
                    this._globalCache.deposit(uri.toString(), result);
                }
                catch (WSPolicyInternalException wspe) {
                    throw wspe;
                }
                catch (Exception ex) {
                    if (TraceComponent.isAnyTracingEnabled() && PolicyReader.tc.isDebugEnabled()) {
                        Tr.debug(PolicyReader.tc, "PolicySource returned unexpected exception:" + ex.toString());
                    }
                    throw new WSPolicyInternalException(ex);
                }
            }
        } else {
            if (result == null && this._localCache != null) {
                result = this._localCache.retrieve(uri.toString());
            }
            if (result == null && this._localCache != null) {
                result = this.findEmbeddedPolicy(uri, this._localCache);
            }
        }
lbl34:
        // 8 sources

        if (TraceComponent.isAnyTracingEnabled() && PolicyReader.tc.isEntryEnabled()) {
            Tr.exit(PolicyReader.tc, "readPolicy", result);
        }
        return result;
    }

    private Policy findEmbeddedPolicy(URI uri, PolicyCache policyCache) throws WSPolicyInternalException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "findEmbeddedPolicy", new Object[]{uri, policyCache, this});
        }
        Policy result = null;
        Vector allURIs = policyCache.getPolicyIdentifiers();
        String uriString = uri.toString();
        for (int i = 0; i < allURIs.size(); ++i) {
            if (allURIs.get(i).toString().endsWith(uriString)) {
                result = policyCache.retrieve((String)allURIs.get(i));
                break;
            }
            Policy p = policyCache.retrieve((String)allURIs.get(i));
            result = this.findEmbeddedPolicy(uri, p);
            if (result != null) break;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "findEmbeddedPolicy", result);
        }
        return result;
    }

    public Policy findEmbeddedPolicy(URI uri, Policy policy) throws WSPolicyInternalException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "findEmbeddedPolicy", new Object[]{uri, policy, this});
        }
        if (uri == null) {
            return null;
        }
        Policy result = null;
        if (policy.getDomElement() != null) {
            Vector<Policy> subPolicies = this.readPolicies(policy.getDomElement().getChildNodes());
            for (int i = 0; i < subPolicies.size(); ++i) {
                Policy p = subPolicies.get(i);
                if (uri.equals(p.getName())) {
                    result = p;
                    break;
                }
                if (uri.toString().equals(p.getId())) {
                    result = p;
                    break;
                }
                if (p.getId().endsWith(uri.toString())) {
                    result = p;
                    break;
                }
                if ((p = this.findEmbeddedPolicy(uri, p)) == null) continue;
                result = p;
                break;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "findEmbeddedPolicy", result);
        }
        return result;
    }

    public Vector readPolicies(URL url) throws WSPolicyInternalException, UnsupportedPolicyElementException, UnsupportedNamespaceException, PolicyReferenceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "readPolicies", new Object[]{url, this});
        }
        PolicyLocatorImpl pl = new PolicyLocatorImpl(url);
        Vector p = this.readPolicies(pl);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "readPolicies", p);
        }
        return p;
    }

    public Vector getUnresolvedReferenceURIs() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getUnresolvedReferenceURIs", this);
        }
        Vector<URI> result = new Vector<URI>();
        Vector<PolicyElement> knownReferences = new Vector<PolicyElement>();
        if (this._globalCache != null) {
            knownReferences.addAll(this.findEmbeddedPolicyReferences(this._globalCache));
        }
        if (this._localCache != null) {
            knownReferences.addAll(this.findEmbeddedPolicyReferences(this._localCache));
        }
        if (knownReferences.size() == 0) {
            return result;
        }
        for (int i = 0; i < knownReferences.size(); ++i) {
            PolicyReference policyReference = (PolicyReference)knownReferences.get(i);
            URI uri = policyReference.getUri();
            try {
                this.readPolicy(uri);
                continue;
            }
            catch (WSPolicyInternalException wspe) {
                result.add(uri);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getUnresolvedReferenceURIs", result);
        }
        return result;
    }

    private Vector<PolicyElement> findEmbeddedPolicyReferences(PolicyCache policyCache) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "findEmbeddedPolicyReferences", new Object[]{policyCache, this});
        }
        Vector<PolicyElement> result = new Vector<PolicyElement>();
        Vector allURIs = policyCache.getPolicyIdentifiers();
        for (int i = 0; i < allURIs.size(); ++i) {
            Policy p = policyCache.retrieve((String)allURIs.get(i));
            result.addAll(this.readReferences(p));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "findEmbeddedPolicyReferences", result);
        }
        return result;
    }

    public void setPolicyCache(PolicyCache pCache) {
        this._globalCache = pCache;
    }

    public PolicyCache getPolicyCache() {
        return this._globalCache;
    }

    public PolicyContext getPolicyContext() {
        return this._context;
    }

    public void setPolicyContext(PolicyContext pContext) {
        if (pContext != null) {
            this._context = pContext;
            this.extractFromContext(this._context);
        }
    }

    public void cacheInsert(Policy policy, Element element) {
        String id;
        QName name;
        String strName;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "cacheInsert", new Object[]{policy, element, this});
        }
        if ((strName = policy.getAttribute(name = new QName("Name"))) != null) {
            this._globalCache.deposit(strName, policy);
            this._digestXMLstore.put(strName, element);
        }
        if ((id = policy.getId()).indexOf(35) == -1) {
            id = '#' + id;
        }
        String key = null;
        if (!"".equals(this._location)) {
            key = this._location + id;
            this._globalCache.deposit(key, policy);
            this._digestXMLstore.put(key, element);
        }
        key = id;
        this._localCache.deposit(key, policy);
        this._digestXMLstore.put(key, element);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "cacheInsert");
        }
    }

    private void extractFromContext(PolicyContext pContext) {
        this._globalCache = (PolicyCache)pContext.getProperty("PolicyCache");
        this._psr = (PolicySourceRegistry)pContext.getProperty("PolicySourceRegistry");
    }

    public void setLocation(String location) {
        this._location = location;
    }

    public String getLocation() {
        return this._location;
    }

    private Vector<PolicyElement> readReferences(Operator operator) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "readReferences", new Object[]{operator, this});
        }
        if (operator.getChildAssertions() == null || operator.getChildAssertions().size() == 0) {
            return null;
        }
        Vector<PolicyElement> result = new Vector<PolicyElement>();
        for (int i = 0; i < operator.getChildAssertions().size(); ++i) {
            Vector<PolicyElement> subChildren;
            PolicyElement child = (PolicyElement)operator.getChildAssertions().get(i);
            if (child instanceof PolicyReference) {
                result.add(child);
                continue;
            }
            if (!(child instanceof Operator) || (subChildren = this.readReferences((Operator)child)) == null) continue;
            result.addAll(subChildren);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "readReferences", result);
        }
        return result;
    }

    public String calculateDigest(Policy policy, URI algorithm) throws WSPolicyInternalException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "calculateDigest", new Object[]{policy, algorithm, this});
        }
        String digest = null;
        Node node = null;
        URI uri = policy.getName();
        if (uri != null) {
            node = this._digestXMLstore.get(uri.toString());
        } else {
            String id = policy.getId();
            if (id.indexOf(35) == -1) {
                id = '#' + id;
            }
            node = this._digestXMLstore.get(id);
        }
        PolicyDigestRegistry pdr = PolicyDigestRegistryFactory.getPolicyDigestRegistry();
        PolicyDigest pd = pdr.getPolicyDigest(algorithm);
        digest = pd.getDigest(algorithm, node);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "calculateDigest", digest);
        }
        return digest;
    }
}

