/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wspolicy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.wspolicy.PolicyLocator;
import com.ibm.ws.wspolicy.WSPolicyInternalException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;

class PolicyLocatorImpl
implements PolicyLocator {
    private static final TraceComponent TRACE_COMPONENT = Tr.register(PolicyLocatorImpl.class, "WS-Policy", "com.ibm.ws.wspolicy.resources.CWPOLMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.wspolicy.resources.CWPOLMessages");
    private InputStream _baseInputStream;
    private URL _urlSource;

    public PolicyLocatorImpl(URL url) {
        this._urlSource = url;
    }

    public void close() throws IOException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "close");
        }
        if (this._baseInputStream != null) {
            this._baseInputStream.close();
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "close");
        }
    }

    private InputStream getContentAsInputStream(URL url) throws SecurityException, IllegalArgumentException, IOException {
        if (url == null) {
            throw new IllegalArgumentException("URL cannot be null.");
        }
        try {
            Object obj = url.getContent();
            if (obj == null) {
                throw new IllegalArgumentException("No content.");
            }
            if (obj instanceof InputStream) {
                return (InputStream)obj;
            }
            throw new IllegalArgumentException(obj instanceof String ? (String)obj : "This URL points to a: " + this.getClassName(obj.getClass()));
        }
        catch (SecurityException _ex) {
            FFDCFilter.processException((Throwable)_ex, "com.ibm.ws.wspolicy.PolicyLocatorImpl.getContentAsInputStream", "121", this);
            throw new SecurityException("Your JVM's SecurityManager has disallowed this.");
        }
        catch (FileNotFoundException _ex) {
            FFDCFilter.processException((Throwable)_ex, "com.ibm.ws.wspolicy.PolicyLocatorImpl.getContentAsInputStream", "124", this);
            throw new FileNotFoundException("This file was not found: " + url);
        }
    }

    public InputStream getInputStream() throws WSPolicyInternalException {
        try {
            URL url = this._urlSource;
            if ("file".equals(url.getProtocol())) {
                this._baseInputStream = this.getContentAsInputStream(url);
            } else {
                URLConnection con = url.openConnection();
                this._baseInputStream = con.getInputStream();
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.wspolicy.PolicyLocatorImpl.getInputStream", "147", this);
            throw new WSPolicyInternalException(e);
        }
        return this._baseInputStream;
    }

    private String getClassName(Class class1) {
        String result;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getClassName");
        }
        String s = class1.getName();
        String string = result = class1.isArray() ? this.parseDescriptor(s) : s;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getClassName", "result[" + result + "]");
        }
        return result;
    }

    private String parseDescriptor(String descriptor) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "parseDescriptor", "descriptor[" + descriptor + "]");
        }
        char[] ac = descriptor.toCharArray();
        int i = 0;
        int j = 0;
        while (ac[j] == '[') {
            ++i;
            ++j;
        }
        StringBuffer decodedString = new StringBuffer();
        switch (ac[j++]) {
            case 'B': {
                decodedString.append("byte");
                break;
            }
            case 'C': {
                decodedString.append("char");
                break;
            }
            case 'D': {
                decodedString.append("double");
                break;
            }
            case 'F': {
                decodedString.append("float");
                break;
            }
            case 'I': {
                decodedString.append("int");
                break;
            }
            case 'J': {
                decodedString.append("long");
                break;
            }
            case 'S': {
                decodedString.append("short");
                break;
            }
            case 'Z': {
                decodedString.append("boolean");
                break;
            }
            case 'L': {
                decodedString.append(ac, j, ac.length - j - 1);
            }
        }
        for (int k = 0; k < i; ++k) {
            decodedString.append("[]");
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "parseDescriptor", "decodedString[" + decodedString + "]");
        }
        return decodedString.toString();
    }
}

