/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wspolicy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.wspolicy.Policy;
import com.ibm.ws.wspolicy.PolicyContext;
import com.ibm.ws.wspolicy.PolicyFactory;
import com.ibm.ws.wspolicy.PolicyReferenceException;
import com.ibm.ws.wspolicy.PolicyWriter;
import com.ibm.ws.wspolicy.PolicyWriterContext;
import com.ibm.ws.wspolicy.UnsupportedNamespaceException;
import com.ibm.ws.wspolicy.UnsupportedPolicyElementException;
import com.ibm.ws.wspolicy.WSPolicyInternalException;
import com.ibm.ws.wspolicy.domain.PolicyInputStreamHolder;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.Vector;

public class PolicyHolder {
    private static final TraceComponent TRACE_COMPONENT = Tr.register(PolicyHolder.class, "WS-Policy", "com.ibm.ws.wspolicy.resources.CWPOLMessages");
    private Policy _input = null;
    private Policy _output = null;
    private Policy _main = null;

    public PolicyHolder() {
    }

    public PolicyHolder(PolicyInputStreamHolder policyStream) throws WSPolicyInternalException, UnsupportedPolicyElementException, UnsupportedNamespaceException, PolicyReferenceException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "PolicyHolder", new Object[]{policyStream});
        }
        if (policyStream != null) {
            InputStream ins = policyStream.getMain();
            this._main = this.inputStreamToPolicy(ins);
            ins = policyStream.getInput();
            this._input = this.inputStreamToPolicy(ins);
            ins = policyStream.getOutput();
            this._output = this.inputStreamToPolicy(ins);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "PolicyHolder");
        }
    }

    public Policy getInput() {
        return this._input;
    }

    public void setInput(Policy input) {
        this._input = input;
    }

    public Policy getMain() {
        return this._main;
    }

    public void setMain(Policy neutral) {
        this._main = neutral;
    }

    public Policy getOutput() {
        return this._output;
    }

    public void setOutput(Policy output) {
        this._output = output;
    }

    public boolean isAllEmpty() throws PolicyReferenceException, WSPolicyInternalException {
        boolean result = false;
        if (this._input.isEmpty() && this._main.isEmpty() && this._output.isEmpty()) {
            result = true;
        }
        return result;
    }

    private Policy inputStreamToPolicy(InputStream polIns) throws WSPolicyInternalException, UnsupportedPolicyElementException, UnsupportedNamespaceException, PolicyReferenceException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "inputStreamToPolicy", new Object[]{polIns});
        }
        PolicyFactory factory = new PolicyFactory();
        Policy policy = null;
        if (polIns == null) {
            policy = factory.newEmptyPolicy();
        } else {
            Vector<Policy> pols = factory.newPolicyReader().readPolicies(polIns);
            if (pols != null && !pols.isEmpty()) {
                if (pols.size() == 1) {
                    policy = pols.get(0);
                } else {
                    policy = pols.get(0);
                    if (TRACE_COMPONENT.isDebugEnabled()) {
                        Tr.debug(TRACE_COMPONENT, "Additional unexpected Policy elements have been found", new Object[]{pols});
                    }
                }
            } else {
                policy = factory.newEmptyPolicy();
                if (TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "No Policy elements have been found, returning empty policy");
                }
            }
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "inputStreamToPolicy");
        }
        return policy;
    }

    public PolicyInputStreamHolder toPolicyInputStreamHolder(boolean deNormalize) throws PolicyReferenceException, WSPolicyInternalException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "toPolicyInputStreamHolder");
        }
        PolicyInputStreamHolder result = new PolicyInputStreamHolder();
        result.setMain(this.policyToInputStream(this._main, deNormalize));
        result.setInput(this.policyToInputStream(this._input, deNormalize));
        result.setOutput(this.policyToInputStream(this._output, deNormalize));
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "toPolicyInputStreamHolder");
        }
        return result;
    }

    private InputStream policyToInputStream(Policy policy, boolean deNormalize) throws PolicyReferenceException, WSPolicyInternalException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "policyToInputStream");
        }
        PolicyFactory factory = new PolicyFactory();
        PolicyWriter writer = factory.newPolicyWriter();
        PolicyContext pc = policy.getContext();
        PolicyWriterContext pwc = writer.getPolicyWriterContext(pc);
        pwc.setIgnoreNormalize(deNormalize);
        StringWriter stringWriter = new StringWriter();
        writer.writePolicy(policy, stringWriter, pc);
        String policyAsStr = stringWriter.toString();
        ByteArrayInputStream bais = new ByteArrayInputStream(policyAsStr.getBytes());
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "policyToInputStream");
        }
        return bais;
    }
}

