/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wspolicy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.wspolicy.Policy;
import com.ibm.ws.wspolicy.PolicyContext;
import com.ibm.ws.wspolicy.PolicyReader;
import com.ibm.ws.wspolicy.PolicyReference;
import com.ibm.ws.wspolicy.PolicyWriter;
import com.ibm.ws.wspolicy.operators.AllOperator;
import com.ibm.ws.wspolicy.operators.ExactlyOneOperator;
import java.net.URI;
import java.util.List;
import java.util.Vector;

public class PolicyFactory {
    private static final TraceComponent tc = Tr.register(PolicyFactory.class, "WS-PolicyRW", "com.ibm.ws.wspolicy.resources.CWPOLMessages");
    private PolicyContext _context = null;

    public PolicyFactory(PolicyContext context) {
        this._context = context;
    }

    public PolicyFactory() {
        this._context = new PolicyContext();
    }

    public Policy newPolicy() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "newPolicy", this);
        }
        Policy pol = new Policy(this._context);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "newPolicy", pol);
        }
        return pol;
    }

    public Policy newEmptyPolicy() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "newEmptyPolicy", this);
        }
        Policy pol = new Policy(this._context);
        ExactlyOneOperator eo = new ExactlyOneOperator();
        Vector<ExactlyOneOperator> topLevelAssertion = new Vector<ExactlyOneOperator>();
        topLevelAssertion.add(eo);
        Vector<AllOperator> vEO = new Vector<AllOperator>();
        eo.setChildAssertions(vEO);
        AllOperator ao = new AllOperator();
        vEO.add(ao);
        pol.setChildAssertions(topLevelAssertion);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "newEmptyPolicy", pol);
        }
        return pol;
    }

    public Policy newPolicy(Vector children) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "newPolicy", new Object[]{children, this});
        }
        Policy pol = new Policy(this._context);
        pol.setChildAssertions(children);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "newPolicy", pol);
        }
        return pol;
    }

    public Policy newPolicy(ExactlyOneOperator child) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "newPolicy", new Object[]{child, this});
        }
        Policy pol = new Policy(this._context);
        Vector<ExactlyOneOperator> children = new Vector<ExactlyOneOperator>();
        children.add(child);
        pol.setChildAssertions(children);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "newPolicy", pol);
        }
        return pol;
    }

    public Policy newNormalizedPolicy(List assertions) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "newEOALLPolicy", new Object[]{assertions, this});
        }
        Policy pol = new Policy(this._context);
        ExactlyOneOperator eo = new ExactlyOneOperator();
        Vector<ExactlyOneOperator> topLevelAssertion = new Vector<ExactlyOneOperator>();
        topLevelAssertion.add(eo);
        Vector<AllOperator> vEO = new Vector<AllOperator>();
        eo.setChildAssertions(vEO);
        AllOperator ao = new AllOperator();
        if (assertions != null) {
            ao.setChildAssertions(new Vector(assertions));
        }
        vEO.add(ao);
        pol.setChildAssertions(topLevelAssertion);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "newEOALLPolicy", pol);
        }
        return pol;
    }

    public PolicyReference newPolicyReference(URI uri) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "newPolicyReference", new Object[]{uri, this});
        }
        PolicyReference polRef = new PolicyReference(uri, this._context);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "newPolicyReference", polRef);
        }
        return polRef;
    }

    public PolicyReader newPolicyReader() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "newPolicyReader", this);
        }
        PolicyReader polReader = new PolicyReader(this._context);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "newPolicyReader", polReader);
        }
        return polReader;
    }

    public PolicyWriter newPolicyWriter() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "newPolicyWriter", this);
        }
        PolicyWriter polWriter = new PolicyWriter(this._context);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "newPolicyWriter", polWriter);
        }
        return polWriter;
    }
}

