/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wspolicy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.wspolicy.Policy;
import java.util.Hashtable;
import java.util.Vector;

public class PolicyCache {
    private static final TraceComponent tc = Tr.register(PolicyCache.class, "WS-Policy", "com.ibm.ws.wspolicy.resources.CWPOLMessages");
    private Hashtable<String, Policy> _cache = new Hashtable();

    public void deposit(String identifier, Policy policy) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "deposit", new Object[]{identifier, policy, this});
        }
        if (identifier == null) {
            return;
        }
        this._cache.put(identifier, policy);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "deposit");
        }
    }

    public Policy retrieve(String identifier) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "retrieve", new Object[]{identifier, this});
        }
        Policy entry = this._cache.get(identifier);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "retrieve", entry);
        }
        return entry;
    }

    public boolean contains(String identifier) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "contains", new Object[]{identifier, this});
        }
        boolean result = this._cache.containsKey(identifier);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "contains", result);
        }
        return result;
    }

    public Vector getPolicyIdentifiers() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getPolicyIdentifiers", this);
        }
        Vector<String> result = new Vector<String>(this._cache.keySet());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getPolicyIdentifiers", result);
        }
        return result;
    }

    public void clear() {
        this._cache.clear();
    }

    public void merge(PolicyCache pCache) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "merge", new Object[]{pCache, this});
        }
        Vector yourKeys = pCache.getPolicyIdentifiers();
        for (int i = 0; i < yourKeys.size(); ++i) {
            String tKey = (String)yourKeys.get(i);
            Policy tPol = pCache.retrieve(tKey);
            this.deposit(tKey, tPol);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "merge");
        }
    }
}

