/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wspolicy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.wspolicy.PolicyConstants;
import com.ibm.ws.wspolicy.PolicyContext;
import com.ibm.ws.wspolicy.PolicyElement;
import com.ibm.ws.wspolicy.PolicyFactory;
import com.ibm.ws.wspolicy.PolicyReader;
import com.ibm.ws.wspolicy.PolicyReference;
import com.ibm.ws.wspolicy.PolicyReferenceException;
import com.ibm.ws.wspolicy.PolicyWriter;
import com.ibm.ws.wspolicy.PolicyWriterContext;
import com.ibm.ws.wspolicy.WSPolicyBindingsException;
import com.ibm.ws.wspolicy.WSPolicyException;
import com.ibm.ws.wspolicy.WSPolicyInternalException;
import com.ibm.ws.wspolicy.alternatives.Alternative;
import com.ibm.ws.wspolicy.alternatives.AlternativesIterator;
import com.ibm.ws.wspolicy.alternatives.AssertionCombinations;
import com.ibm.ws.wspolicy.assertions.AssertionExtensionRegistry;
import com.ibm.ws.wspolicy.assertions.AssertionImpl;
import com.ibm.ws.wspolicy.digest.PolicyDigestRegistry;
import com.ibm.ws.wspolicy.domain.Assertion;
import com.ibm.ws.wspolicy.domain.PolicyProviderRegistry;
import com.ibm.ws.wspolicy.operators.AllOperator;
import com.ibm.ws.wspolicy.operators.ExactlyOneOperator;
import delete.PolicyConverter;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Policy
extends AllOperator
implements ExtensibilityElement {
    private static final TraceComponent TRACE_COMPONENT = Tr.register(Policy.class, "WS-Policy", "com.ibm.ws.wspolicy.resources.CWPOLMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.wspolicy.resources.CWPOLMessages");
    private PolicyProviderRegistry _policyProviderRegistry = PolicyProviderRegistry.getInstance();
    private boolean _policyReferenceElements;
    private AssertionCombinations _assCom;
    private int _amended;
    private int _cacheHash;
    private PolicyReader _reader;
    private AssertionExtensionRegistry _assertionExtensionRegistry;
    private PolicyDigestRegistry _policyDigestRegistry;
    private HashMap<QName, String> _attributes;
    private Map<String, String> _namespaces;
    private Boolean _required;
    private Alternative _alternative;
    public static final String LAX = "Lax";
    public static final String STRICT = "Strict";
    public static final String DEFAULT_MODE = "Lax";

    protected Policy(Element el, Policy owningPolicy, PolicyContext pContext) {
        super(new QName("http://www.w3.org/ns/ws-policy", PolicyConstants.TAG_WSP + ":" + PolicyConstants.TAG_POLICY), el, owningPolicy, pContext);
        if (owningPolicy != null) {
            this._reader = owningPolicy.getReader();
        } else {
            this.setOwningPolicy(this);
        }
    }

    protected Policy(PolicyContext pContext) {
        super(new QName("http://www.w3.org/ns/ws-policy", PolicyConstants.TAG_WSP + ":" + PolicyConstants.TAG_POLICY), null, null, pContext);
    }

    public String getId() {
        QName name = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
        String idString = this.getAttribute(name);
        if (idString == null) {
            idString = "";
        }
        return idString;
    }

    public void setId(String id) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "setId", "idString[" + id + "]");
        }
        QName name = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
        if (id == null || id.length() == 0) {
            this.removeAttribute(name);
        } else {
            this.addAttribute(name, id);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "setId");
        }
    }

    public URI getName() throws WSPolicyInternalException {
        QName name = new QName("Name");
        String retVal = this.getAttribute(name);
        if (retVal == null) {
            return null;
        }
        URI retvalURI = null;
        try {
            retvalURI = new URI(retVal);
        }
        catch (URISyntaxException e) {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "getURI", "Syntax error trying to construct a URI[" + retVal + "]:" + e.toString());
            }
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.wspolicy.Policy.getName", "218", this);
            throw new WSPolicyInternalException(e);
        }
        return retvalURI;
    }

    public void setName(URI name) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "setName", "name[" + name + "]");
        }
        QName qName = new QName("Name");
        if (name == null) {
            this.removeAttribute(qName);
        } else {
            this.addAttribute(qName, name.toString());
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "setName");
        }
    }

    public void addAttribute(QName name, String value) {
        if (this._attributes == null) {
            this._attributes = new HashMap();
        }
        this._attributes.put(name, value);
    }

    public void removeAttribute(QName name) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "removeAttribute", name);
        }
        if (this._attributes == null) {
            return;
        }
        this._attributes.remove(name);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "removeAttribute");
        }
    }

    public String getAttribute(QName name) {
        if (this._attributes == null) {
            return null;
        }
        String result = this._attributes.get(name);
        return result;
    }

    public void clearAllAttributes() {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "clearAllAttributes");
        }
        if (this._attributes == null) {
            return;
        }
        this._attributes.clear();
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "clearAllAttributes");
        }
    }

    public Vector<QName> getAllAttributeNames() {
        if (this._attributes == null) {
            return new Vector<QName>();
        }
        Vector<QName> keySet = new Vector<QName>(this._attributes.keySet());
        return keySet;
    }

    @Override
    public String toString() {
        String value = null;
        try {
            PolicyFactory factory = new PolicyFactory(this.getContext());
            PolicyWriter writer = factory.newPolicyWriter();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintWriter pw = new PrintWriter(baos);
            PolicyContext policyContext = new PolicyContext();
            PolicyWriterContext policyWriterContext = new PolicyWriterContext();
            policyWriterContext.setIndentLevel(2);
            policyWriterContext.setIndenting(true);
            policyContext.setProperty("SerializerFormatting", policyWriterContext);
            writer.writePolicy(this, pw, policyContext);
            value = baos.toString();
        }
        catch (Exception e) {
            value = this.getId();
        }
        if (value == null) {
            value = "";
        }
        return value;
    }

    public void setReader(PolicyReader reader) {
        this._reader = reader;
    }

    public PolicyReader getReader() {
        return this._reader;
    }

    protected boolean hasPolicyReferenceElements() {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "hasPolicyReferenceElements");
        }
        boolean result = this.hasPolicyReferenceElements(this.getDomElement());
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "hasPolicyReferenceElements", "result=" + result);
        }
        return result;
    }

    private boolean hasPolicyReferenceElements(Element el) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "hasPolicyReferenceElements");
        }
        boolean result = false;
        NodeList nl = el.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node child = nl.item(i);
            if (child.getNodeType() != 1) continue;
            if (child.getLocalName().equalsIgnoreCase(PolicyConstants.TAG_POLICYREFERENCE) && child.getNamespaceURI().equalsIgnoreCase("http://www.w3.org/ns/ws-policy")) {
                result = true;
                break;
            }
            if (child.hasChildNodes()) {
                result = this.hasPolicyReferenceElements((Element)child);
            }
            if (result) break;
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "hasPolicyReferenceElements", result);
        }
        return result;
    }

    @Override
    public int hashCode() {
        if (this._cacheHash == 0) {
            this._cacheHash = this.calcNewHash();
        }
        return this._cacheHash;
    }

    private int calcNewHash() {
        int retVal = 0;
        Vector<QName> names = this.getAllAttributeNames();
        for (int i = 0; i < names.size(); ++i) {
            QName name = names.get(i);
            String value = this.getAttribute(name);
            if (name.getNamespaceURI().equals("http://www.w3.org/ns/ws-policy") || name.getNamespaceURI().equals(PolicyConstants.TAG_XMLNS) || "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd".equals(name.getNamespaceURI()) && "Id".equalsIgnoreCase(name.getLocalPart())) continue;
            retVal ^= (name + value).toUpperCase().hashCode();
        }
        AlternativesIterator aIt = null;
        try {
            aIt = this.iterator();
        }
        catch (WSPolicyException e) {
            return 0;
        }
        while (aIt.hasNext()) {
            Alternative tAlt = (Alternative)aIt.next();
            retVal ^= tAlt.hashCode();
        }
        return retVal;
    }

    public Vector<QName> getVocabulary() {
        Vector assertions = this.getAllAssertions();
        Vector<QName> qNames = new Vector<QName>(assertions.size());
        for (int i = 0; i < assertions.size(); ++i) {
            PolicyElement ass = (PolicyElement)assertions.get(i);
            QName qName = ass.getQName();
            if (qNames.contains(qName)) continue;
            boolean success = qNames.add(qName);
        }
        return qNames;
    }

    public AlternativesIterator iterator(String iteratorType) throws WSPolicyInternalException, PolicyReferenceException {
        AlternativesIterator aIter = new AlternativesIterator(this, iteratorType);
        return aIter;
    }

    public AlternativesIterator iterator() throws WSPolicyInternalException, PolicyReferenceException {
        AlternativesIterator aIter = new AlternativesIterator(this, PolicyConstants.FILTER_LOGICAL);
        return aIter;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public Vector getAllAssertions() {
        Vector<PolicyElement> al = this.getLeafChildren();
        Collections.sort(al);
        Vector<PolicyElement> result = new Vector<PolicyElement>(al.size());
        result.addAll(al);
        return result;
    }

    public void normalize() throws WSPolicyInternalException, PolicyReferenceException {
        this.normalize(PolicyConstants.FILTER_LOGICAL);
    }

    public void normalize(String iterationType) throws WSPolicyInternalException, PolicyReferenceException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "normalize", iterationType);
        }
        ExactlyOneOperator eo = new ExactlyOneOperator();
        Vector<ExactlyOneOperator> topLevelAssertion = new Vector<ExactlyOneOperator>();
        topLevelAssertion.add(eo);
        Vector<AllOperator> vEO = new Vector<AllOperator>();
        eo.setChildAssertions(vEO);
        AlternativesIterator altItr = this.iterator(iterationType);
        while (altItr.hasNext()) {
            Alternative a = (Alternative)altItr.next();
            if (a.containsNestedAssertions()) {
                Vector<Alternative> alternativesNormalized = a.nestedNormalize();
                for (int i = 0; i < alternativesNormalized.size(); ++i) {
                    Alternative normalizedAlternative = alternativesNormalized.get(i);
                    AllOperator ao = new AllOperator();
                    ao.setChildAssertions(normalizedAlternative.getAssertions());
                    vEO.add(ao);
                }
                continue;
            }
            AllOperator ao = new AllOperator();
            ao.setChildAssertions(a.getAssertions());
            vEO.add(ao);
        }
        this.setChildAssertions(topLevelAssertion);
        this.setChildAssertions(topLevelAssertion);
        this._policyReferenceElements = false;
        this._cacheHash = 0;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "normalize", "Number of alternatives found :" + vEO.size());
        }
    }

    public Alternative getAlternative() throws WSPolicyInternalException, PolicyReferenceException {
        AlternativesIterator aIter = this.iterator();
        Alternative result = (Alternative)aIter.next();
        return result;
    }

    public Vector<Alternative> getAlternatives() throws WSPolicyInternalException, PolicyReferenceException {
        Vector<Alternative> alternatives = new Vector<Alternative>();
        AlternativesIterator aIter = this.iterator();
        while (aIter.hasNext()) {
            alternatives.add((Alternative)aIter.next());
        }
        return alternatives;
    }

    public Alternative getAlternative(String iterationType) throws WSPolicyInternalException, PolicyReferenceException {
        AlternativesIterator aIter = this.iterator(iterationType);
        Alternative result = (Alternative)aIter.next();
        return result;
    }

    public Alternative getIntersectedAlternative(Policy pol, String iterationType) throws WSPolicyInternalException, PolicyReferenceException {
        return this.getIntersectedAlternative(pol, iterationType, "Lax");
    }

    public Alternative getIntersectedAlternative(Policy pol, String iterationType, String intersectionType) throws WSPolicyInternalException, PolicyReferenceException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getIntersectedAlternative", new Object[]{this, pol, iterationType});
        }
        Alternative result = null;
        AlternativesIterator altItr1 = this.iterator();
        AlternativesIterator altItr2 = pol.iterator();
        Vector<Assertion> mergedAlternatives = null;
        while (altItr1.hasNext()) {
            Alternative a1 = (Alternative)altItr1.next();
            altItr2.reset();
            while (altItr2.hasNext()) {
                Alternative a2 = (Alternative)altItr2.next();
                if ((!"Lax".equals(intersectionType) || !a1.getVocabulary().containsAll(a2.getNonIgnorableVocabulary()) || !a2.getVocabulary().containsAll(a1.getNonIgnorableVocabulary())) && (!STRICT.equals(intersectionType) || !a1.getVocabularyStr().equals(a2.getVocabularyStr()))) continue;
                if (a1.containsNestedAssertions()) {
                    try {
                        if (!a1.intersectAndNormalizeNested(this, a2, iterationType, intersectionType)) {
                            continue;
                        }
                    }
                    catch (WSPolicyInternalException pex) {
                        FFDCFilter.processException((Throwable)pex, "com.ibm.ws.wspolicy.Policy.getIntersectedAlternative", "805", this);
                        if (TRACE_COMPONENT.isDebugEnabled()) {
                            Tr.debug(TRACE_COMPONENT, "Detected an internal exception intersecting nested");
                        }
                        throw pex;
                    }
                    catch (WSPolicyBindingsException wspbe) {
                        if (!TRACE_COMPONENT.isDebugEnabled()) continue;
                        Tr.debug(TRACE_COMPONENT, "One or more of the nested Assertions are not supported due to an incompatibility with the bindings");
                        continue;
                    }
                }
                mergedAlternatives = new Vector<Assertion>(a1.getAssertions());
                mergedAlternatives.addAll(a2.getAssertions());
                result = new Alternative(mergedAlternatives);
                if (result == null) continue;
                try {
                    boolean support = this.alternativeCheck(result, iterationType, intersectionType);
                    if (support) break;
                    result = null;
                }
                catch (WSPolicyBindingsException wspbe) {
                    result = null;
                }
            }
            if (result == null) continue;
            break;
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getIntersectedAlternative", result);
        }
        return result;
    }

    public Policy intersectForPublish(Policy pol) throws WSPolicyInternalException, PolicyReferenceException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "intersectForPublish", new Object[]{this, pol});
        }
        String iterationType = PolicyConstants.FILTER_SUPPORTED;
        String intersectionType = STRICT;
        Policy result = null;
        ArrayList<Alternative> alternatives = new ArrayList<Alternative>();
        AlternativesIterator altItr1 = this.iterator();
        AlternativesIterator altItr2 = pol.iterator();
        Vector<Assertion> mergedAlternatives = null;
        while (altItr1.hasNext()) {
            Alternative a1 = (Alternative)altItr1.next();
            altItr2.reset();
            while (altItr2.hasNext()) {
                Alternative candidate;
                block14: {
                    Alternative a2 = (Alternative)altItr2.next();
                    if (!a1.getVocabularyStr().equals(a2.getVocabularyStr())) continue;
                    candidate = null;
                    if (a1.containsNestedAssertions() || a2.containsNestedAssertions()) {
                        try {
                            candidate = a1.intersectAndNormalizeNestedForPublish(a2, iterationType);
                            if (candidate == null) {
                                continue;
                            }
                            break block14;
                        }
                        catch (WSPolicyInternalException pex) {
                            FFDCFilter.processException((Throwable)pex, "com.ibm.ws.wspolicy.Policy.intersectForPublish", "947", this);
                            if (TRACE_COMPONENT.isEntryEnabled()) {
                                Tr.exit(TRACE_COMPONENT, "intersectForPublish", pex);
                            }
                            throw pex;
                        }
                        catch (WSPolicyBindingsException wspbe) {
                            if (!TRACE_COMPONENT.isDebugEnabled()) continue;
                            Tr.debug(TRACE_COMPONENT, "One or more of the nested Assertions are not supported due to an incompatibility with the bindings", wspbe);
                            continue;
                        }
                    }
                    mergedAlternatives = new Vector<Assertion>(a1.getAssertions());
                    mergedAlternatives.addAll(a2.getAssertions());
                    candidate = new Alternative(mergedAlternatives);
                }
                if (candidate == null) continue;
                try {
                    boolean support = this.alternativeCheck(candidate, iterationType, intersectionType);
                    if (!support) continue;
                    alternatives.add(candidate);
                }
                catch (WSPolicyBindingsException wspbe) {}
            }
        }
        if (!alternatives.isEmpty()) {
            result = new Policy(this.getContext());
            ExactlyOneOperator eo = new ExactlyOneOperator();
            Vector<ExactlyOneOperator> topLevelAssertion = new Vector<ExactlyOneOperator>();
            topLevelAssertion.add(eo);
            Vector<AllOperator> vEO = new Vector<AllOperator>();
            eo.setChildAssertions(vEO);
            for (Alternative alternative : alternatives) {
                AllOperator ao = new AllOperator();
                ao.setChildAssertions(alternative.getAssertions());
                vEO.add(ao);
            }
            result._policyReferenceElements = false;
            result.setChildAssertions(topLevelAssertion);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "intersectForPublish", result);
        }
        return result;
    }

    public Alternative intersectWithClientCapabilities(Policy providerPolicy, String iterationType) throws PolicyReferenceException, WSPolicyInternalException, WSPolicyBindingsException {
        return this.intersectWithClientCapabilities(providerPolicy, iterationType, "Lax");
    }

    public Alternative intersectWithClientCapabilities(Policy providerPolicy, String iterationType, String intersectionType) throws PolicyReferenceException, WSPolicyInternalException, WSPolicyBindingsException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "intersectWithClientCapabilities", new Object[]{this, providerPolicy, iterationType});
        }
        Alternative result = null;
        AlternativesIterator clientAltIt = this.iterator();
        AlternativesIterator providerAltIt = providerPolicy.iterator();
        Vector<Assertion> mergedAlternatives = null;
        WSPolicyBindingsException wspbe = null;
        while (clientAltIt.hasNext()) {
            Alternative clientAlternative = (Alternative)clientAltIt.next();
            providerAltIt.reset();
            while (providerAltIt.hasNext()) {
                Alternative providerAlternative;
                block14: {
                    providerAlternative = (Alternative)providerAltIt.next();
                    Vector<QName> providerVocab = providerAlternative.getVocabulary();
                    Vector<QName> clientVocab = null;
                    clientVocab = "Lax".equals(intersectionType) ? clientAlternative.getNonIgnorableVocabulary() : clientAlternative.getVocabulary();
                    if (!providerVocab.containsAll(clientVocab)) continue;
                    providerVocab.removeAll(clientAlternative.getVocabulary());
                    boolean capabilitiesOK = true;
                    for (QName qn : providerVocab) {
                        if (this._policyProviderRegistry.isClientCapability(qn, this)) continue;
                        capabilitiesOK = false;
                        break;
                    }
                    if (!capabilitiesOK) continue;
                    if (providerAlternative.containsNestedAssertions() || clientAlternative.containsNestedAssertions()) {
                        try {
                            if (!clientAlternative.intersectAndNormalizeNestedWithClientCapabilities(this, providerAlternative, iterationType, intersectionType, this)) {
                            }
                            break block14;
                        }
                        catch (WSPolicyInternalException pex) {
                            FFDCFilter.processException((Throwable)pex, "com.ibm.ws.wspolicy.Policy.intersectWithClientCapabilities", "946", this);
                            if (!TRACE_COMPONENT.isDebugEnabled()) continue;
                            Tr.debug(TRACE_COMPONENT, "Detected a null intersection between Nested Assertions");
                        }
                        catch (WSPolicyBindingsException e) {
                            wspbe = e;
                            if (!TRACE_COMPONENT.isDebugEnabled()) continue;
                            Tr.debug(TRACE_COMPONENT, "One or more of the nested Assertions are not supported due to an incompatibility with the bindings");
                        }
                        continue;
                    }
                }
                mergedAlternatives = new Vector<Assertion>(clientAlternative.getAssertions());
                mergedAlternatives.addAll(providerAlternative.getAssertions());
                result = new Alternative(mergedAlternatives);
                if (result == null) continue;
                try {
                    boolean support = this.alternativeCheck(result, iterationType, intersectionType);
                    if (support) break;
                    result = null;
                }
                catch (WSPolicyBindingsException e) {
                    wspbe = e;
                    result = null;
                }
            }
            if (result == null) continue;
            break;
        }
        if (result == null && wspbe != null) {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "intersectWithClientCapabilities null intersection with bad bindings");
            }
            throw wspbe;
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "intersectWithClientCapabilities", result);
        }
        return result;
    }

    public boolean alternativeCheck(Alternative alternative, String iterationType, String intersectionType) throws WSPolicyBindingsException {
        boolean support;
        block4: {
            Vector<Assertion> assertions;
            block5: {
                block3: {
                    support = false;
                    assertions = alternative.getAssertions();
                    if (assertions.size() != 0) break block3;
                    support = true;
                    if (!TRACE_COMPONENT.isDebugEnabled()) break block4;
                    Tr.debug(TRACE_COMPONENT, ">>> [" + support + "]: Alternative is EMPTY");
                    break block4;
                }
                if (!PolicyConstants.FILTER_LOGICAL.equals(iterationType)) break block5;
                support = true;
                if (!TRACE_COMPONENT.isDebugEnabled()) break block4;
                Tr.debug(TRACE_COMPONENT, ">>> [" + support + "]: Filter is LOGICAL");
                break block4;
            }
            for (int i = 0; i < assertions.size(); ++i) {
                AssertionImpl assertion = (AssertionImpl)assertions.get(i);
                support = this._policyProviderRegistry.isSupported(assertion, iterationType, this.getBindingsMap());
                if (support) continue;
                if (!TRACE_COMPONENT.isDebugEnabled()) break;
                Tr.debug(TRACE_COMPONENT, ">>> [" + support + "]: ASSERTION [" + assertion + "] is not supported");
                break;
            }
        }
        if (support && !PolicyConstants.FILTER_LOGICAL.equals(iterationType)) {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "Alternative passed initial tests; examining the COMBINATIONS");
            }
            support = AlternativesIterator.checkAlternative(this.getAssertionCombinations(), alternative, iterationType, intersectionType, this.getBindingsMap());
        }
        return support;
    }

    public Policy merge(Policy policy) throws PolicyReferenceException, WSPolicyInternalException {
        boolean policy2NotNull;
        if (policy instanceof PolicyReference) {
            policy = ((PolicyReference)policy).getPolicy();
        }
        HashMap<String, String> bothNS = this.mergeNamespaces(policy);
        Policy result = new Policy(this.getContext());
        result.setNamespaces(bothNS);
        result.setDomElement(policy.getDomElement());
        ExactlyOneOperator eo = new ExactlyOneOperator();
        Vector<ExactlyOneOperator> topLevelAssertion = new Vector<ExactlyOneOperator>();
        topLevelAssertion.add(eo);
        Vector<AllOperator> vEO = new Vector<AllOperator>();
        eo.setChildAssertions(vEO);
        AlternativesIterator altItr1 = this.iterator();
        AlternativesIterator altItr2 = policy.iterator();
        boolean policy1NotNull = altItr1.hasNext();
        boolean bl = policy2NotNull = altItr2.hasNext();
        if (policy1NotNull && policy2NotNull) {
            while (altItr1.hasNext()) {
                Alternative a1 = (Alternative)altItr1.next();
                altItr2.reset();
                while (altItr2.hasNext()) {
                    Alternative a2 = (Alternative)altItr2.next();
                    Vector<Assertion> mergedAlternatives = new Vector<Assertion>(a1.getAssertions());
                    mergedAlternatives.addAll(a2.getAssertions());
                    AllOperator ao = new AllOperator();
                    ao.setChildAssertions(mergedAlternatives);
                    vEO.add(ao);
                }
            }
        } else if (TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "merge", "One or more of the Policies has no alternatives");
        }
        result.setChildAssertions(topLevelAssertion);
        if (TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "merge result ", result);
        }
        return result;
    }

    private HashMap mergeElements(Policy policy) {
        return null;
    }

    private HashMap<String, String> mergeNamespaces(Policy policy) {
        Map<String, String> namespacePolicy = policy.getNamespaces();
        Map<String, String> namespaceThis = this.getNamespaces();
        HashMap<String, String> bothNS = new HashMap<String, String>();
        if (namespacePolicy != null) {
            bothNS.putAll(namespacePolicy);
        }
        if (namespaceThis != null) {
            Set<Map.Entry<String, String>> entrySet = namespaceThis.entrySet();
            for (Map.Entry<String, String> entry : entrySet) {
                String namespace = entry.getKey();
                String alias = entry.getValue();
                if (!bothNS.containsValue(alias)) {
                    bothNS.put(namespace, alias);
                    continue;
                }
                Set<Map.Entry<String, String>> entrySet2 = bothNS.entrySet();
                Iterator<Map.Entry<String, String>> iter2 = entrySet2.iterator();
                String namespace2 = "";
                while (iter2.hasNext()) {
                    Map.Entry<String, String> entry2 = iter2.next();
                    namespace2 = entry2.getKey();
                    String alias2 = entry2.getValue();
                    if (!alias.equals(alias2)) continue;
                    break;
                }
                if (namespace.equals(namespace2)) continue;
                int counter = 1;
                while (bothNS.containsValue(alias + counter)) {
                    ++counter;
                }
                bothNS.put(namespace, alias + counter);
            }
        }
        return bothNS;
    }

    public Policy intersect(Policy policy) throws WSPolicyInternalException, PolicyReferenceException {
        return this.intersect(policy, "Lax");
    }

    public Policy intersect(Policy policy, String mode) throws WSPolicyInternalException, PolicyReferenceException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "intersect", policy);
        }
        Policy result = new Policy(this.getContext());
        ExactlyOneOperator eo = new ExactlyOneOperator();
        Vector<ExactlyOneOperator> topLevelAssertion = new Vector<ExactlyOneOperator>();
        topLevelAssertion.add(eo);
        Vector<AllOperator> vEO = new Vector<AllOperator>();
        eo.setChildAssertions(vEO);
        AlternativesIterator altItr1 = this.iterator();
        AlternativesIterator altItr2 = policy.iterator();
        while (altItr1.hasNext()) {
            Alternative a1 = (Alternative)altItr1.next();
            altItr2.reset();
            while (altItr2.hasNext()) {
                Alternative a2 = (Alternative)altItr2.next();
                try {
                    if (!a1.isCompatible(a2, mode)) continue;
                    Vector<Assertion> mergedAlternatives = new Vector<Assertion>(a1.getAssertions());
                    mergedAlternatives.addAll(a2.getAssertions());
                    AllOperator ao = new AllOperator();
                    ao.setChildAssertions(mergedAlternatives);
                    vEO.add(ao);
                }
                catch (WSPolicyBindingsException wspbe) {}
            }
        }
        result._policyReferenceElements = false;
        result.setChildAssertions(topLevelAssertion);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "intersect", result);
        }
        return result;
    }

    private void replaceNamespaces(Policy policy, Policy result) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "replaceNamespaces", new Object[]{policy, result});
        }
        HashMap<String, String> bothNS = this.mergeNamespaces(policy);
        Vector vocabulary = policy.getAllAssertions();
        HashMap<String, String> newNamespaces = new HashMap<String, String>();
        for (int i = 0; i < vocabulary.size(); ++i) {
            String namespace = ((Assertion)vocabulary.get(i)).getAssertionName().getNamespaceURI();
            String alias = bothNS.get(namespace);
            if (alias == null) continue;
            newNamespaces.put(namespace, alias);
        }
        if (newNamespaces.size() > 0) {
            result.setNamespaces(newNamespaces);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "replaceNamespaces");
        }
    }

    public void signalAmended() {
        ++this._amended;
        this._cacheHash = 0;
    }

    public boolean isEmpty() throws WSPolicyInternalException, PolicyReferenceException {
        Alternative altFirst;
        Vector<Assertion> assertions;
        boolean result = false;
        AlternativesIterator it = this.iterator(PolicyConstants.FILTER_LOGICAL);
        if (it != null && it.hasNext() && (assertions = (altFirst = (Alternative)it.next()).getAssertions()).size() == 0) {
            result = true;
        }
        return result;
    }

    public boolean isNull() throws WSPolicyInternalException, PolicyReferenceException {
        boolean result = false;
        AlternativesIterator it = this.iterator(PolicyConstants.FILTER_LOGICAL);
        if (it != null && !it.hasNext()) {
            result = true;
        }
        return result;
    }

    public int getAmended() {
        return this._amended;
    }

    public AssertionExtensionRegistry getAssertionExtensionRegistry() {
        if (this._assertionExtensionRegistry == null) {
            this._assertionExtensionRegistry = AssertionExtensionRegistry.getAssertionExtensionRegistry();
        }
        return this._assertionExtensionRegistry;
    }

    protected void setAssertionExtensionRegistry(AssertionExtensionRegistry registry) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "setAssertionExtensionRegistry");
        }
        this._assertionExtensionRegistry = registry;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "setAssertionExtensionRegistry");
        }
    }

    public AssertionCombinations getAssertionCombinations() {
        if (this._assCom == null) {
            this._assCom = AssertionCombinations.getInstance();
        }
        return this._assCom;
    }

    protected void setPolicyDigestRegistry(PolicyDigestRegistry policyDigestRegistry) {
        this._policyDigestRegistry = policyDigestRegistry;
    }

    protected PolicyDigestRegistry getPolicyDigestRegistry() {
        return this._policyDigestRegistry;
    }

    protected void setNamespaces(Map<String, String> namespaces) {
        this._namespaces = namespaces;
    }

    public boolean contains(Alternative alternative) throws WSPolicyInternalException, PolicyReferenceException {
        AlternativesIterator altItr = this.iterator();
        while (altItr.hasNext()) {
            Alternative a = (Alternative)altItr.next();
            if (!a.equals(alternative)) continue;
            return true;
        }
        return false;
    }

    public String formatString() {
        boolean idSet = false;
        StringBuffer buffer = new StringBuffer("<Policy");
        String result = null;
        try {
            if (this.getId() != null && !this.getId().equals("")) {
                buffer.append(" ID=").append(this.getId());
                idSet = true;
            }
            if (!idSet) {
                AlternativesIterator altItr = this.iterator();
                int altCount = 0;
                while (altItr.hasNext()) {
                    Alternative alt = (Alternative)altItr.next();
                    buffer.append(" Alternative[").append(altCount).append("]").append(alt.toString());
                    ++altCount;
                }
            }
            buffer = buffer.append(">");
            result = buffer.toString();
        }
        catch (WSPolicyException pex) {
            result = pex.toString();
        }
        return result;
    }

    public boolean equals(Object o2) {
        Policy policy;
        boolean equal = false;
        if (o2 instanceof Policy && (policy = (Policy)o2).hashCode() == this.hashCode()) {
            equal = true;
        }
        return equal;
    }

    private boolean containsNestedAssertions() {
        Assertion assertion;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "containsNestedAssertions");
        }
        boolean result = false;
        Vector allAssertions = this.getAllAssertions();
        for (int i = 0; !(i >= allAssertions.size() || (assertion = (Assertion)allAssertions.get(i)) instanceof AssertionImpl && (result = ((AssertionImpl)assertion).containsNestedAssertions())); ++i) {
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "containsNestedAssertions", result + "");
        }
        return result;
    }

    @Override
    public QName getElementType() {
        return PolicyConstants.WSP_POL_ELEMENT_QNAME;
    }

    @Override
    public Boolean getRequired() {
        return this._required;
    }

    @Override
    public void setElementType(QName elementType) {
    }

    @Override
    public void setRequired(Boolean required) {
        this._required = required;
    }

    public Map<String, String> getNamespaces() {
        if (this._namespaces == null) {
            this._namespaces = new HashMap<String, String>();
        }
        return this._namespaces;
    }

    public org.apache.neethi.Policy getNeethiPolicy() {
        return PolicyConverter.getPolicy(this);
    }

    public Map getBindingsMap() {
        Map result = null;
        PolicyContext context = this.getContext();
        if (context == null && this._reader != null) {
            context = this._reader.getPolicyContext();
            this.setContext(context);
        }
        if (context != null) {
            result = (Map)context.getProperty("bindings");
        }
        return result;
    }
}

