/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wspolicy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.wspolicy.Policy;
import com.ibm.ws.wspolicy.PolicyContext;
import com.ibm.ws.wspolicy.WSPolicyInternalException;
import com.ibm.ws.wspolicy.assertions.AssertionDeserializer;
import com.ibm.ws.wspolicy.assertions.AssertionImpl;
import com.ibm.ws.wspolicy.assertions.AssertionSerializer;
import com.ibm.ws.wspolicy.assertions.DefaultAssertion;
import com.ibm.ws.wspolicy.utils.InternalUtils;
import com.ibm.ws.wspolicy.utils.dom.PolicyDOMUtils;
import java.io.IOException;
import java.io.Writer;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssertionSerializerImpl
implements AssertionSerializer,
AssertionDeserializer {
    private static final TraceComponent tc = Tr.register(AssertionSerializerImpl.class, "WS-Policy", "com.ibm.ws.wspolicy.resources.CWPOLMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.wspolicy.resources.CWPOLMessages");

    @Override
    public AssertionImpl unmarshall(Element element, QName elementType, Policy owningPolicy) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "unmarshall", new Object[]{element, elementType, owningPolicy, this});
        }
        DefaultAssertion assertion = null;
        String prefix = element.getPrefix();
        QName qName = null;
        qName = prefix == null || prefix.equals("") ? new QName(element.getNamespaceURI(), element.getLocalName()) : new QName(element.getNamespaceURI(), element.getLocalName(), prefix);
        assertion = PolicyDOMUtils.hasNestedPolicy(element) ? new DefaultAssertion(element, qName) : new DefaultAssertion(qName);
        assertion.setComment(PolicyDOMUtils.getComments(element));
        assertion.parseParameters(element);
        InternalUtils.parseAttributes(assertion, element);
        assertion.setOwningPolicy(owningPolicy);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "unmarshall", assertion);
        }
        return assertion;
    }

    @Override
    public void marshall(AssertionImpl assertion, QName elementType, Writer writer, PolicyContext policyContext) throws WSPolicyInternalException {
        if (assertion instanceof DefaultAssertion) {
            DefaultAssertion defaultAssertion = (DefaultAssertion)assertion;
            try {
                writer.write("<!--" + defaultAssertion.getComment() + "-->\n");
                writer.write(defaultAssertion.toString(policyContext));
            }
            catch (IOException e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Unexpected exception " + e.toString());
                }
                throw new WSPolicyInternalException(e);
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Cannot handle " + assertion.getClass().getName());
        }
    }

    @Override
    public Vector<QName> getSupportedElementType() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getSupportedElementType", this);
        }
        Vector<QName> result = new Vector<QName>();
        QName defaultAssertion = new QName("http://www.w3.org/ns/ws-policy", "WSDLAttachPoint");
        result.add(defaultAssertion);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getSupportedElementType", result);
        }
        return result;
    }
}

