/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsaddressing.urimap.security;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SecurityInfo {
    private static TraceComponent _tc = Tr.register(SecurityInfo.class, "WS-Addressing", "com.ibm.ws.wsaddressing.WSAddressingMessages");
    static int EXACT_MATCH = 0;
    static int PATHNAME_MATCH = 1;
    static int EXTENSION_MATCH = 2;
    private static String NO_MATCHING_URI = "";
    private List<String> _urls;
    private int _transportGuarantee;

    SecurityInfo(List<String> urls, int transportGuarantee) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "SecurityInfo<init>", new Object[]{urls, transportGuarantee});
        }
        this._urls = urls;
        this._transportGuarantee = transportGuarantee;
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "SecurityInfo<init>");
        }
    }

    int getTransportGuarantee() {
        return this._transportGuarantee;
    }

    public static int getMatchType(String pattern) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getMatchType", new Object[]{pattern});
        }
        int matchType = pattern.startsWith("/") && pattern.endsWith("/*") ? PATHNAME_MATCH : (pattern.startsWith("*.") ? EXTENSION_MATCH : EXACT_MATCH);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getMatchType");
        }
        return matchType;
    }

    public String matches(String uriName) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "matches", new Object[]{uriName});
        }
        String[] url_list = this._urls.toArray(new String[this._urls.size()]);
        String currentMatchingPathNameURI = NO_MATCHING_URI;
        String currentMatchingExtensionURI = NO_MATCHING_URI;
        for (int i = 0; i < url_list.length; ++i) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Checking URL: " + url_list[i]);
            }
            if (url_list[i].equals(uriName)) {
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "matches", url_list[i]);
                }
                return url_list[i];
            }
            if (this.matches_pathname(uriName, url_list[i])) {
                if (url_list[i].length() <= currentMatchingPathNameURI.length()) continue;
                currentMatchingPathNameURI = url_list[i];
                continue;
            }
            if (!this.matches_extension(uriName, url_list[i])) continue;
            currentMatchingExtensionURI = url_list[i];
        }
        if (currentMatchingPathNameURI != NO_MATCHING_URI) {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "matches", currentMatchingPathNameURI);
            }
            return currentMatchingPathNameURI;
        }
        if (currentMatchingExtensionURI != NO_MATCHING_URI) {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "matches", currentMatchingExtensionURI);
            }
            return currentMatchingExtensionURI;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "matches NULL");
        }
        return null;
    }

    private boolean matches_pathname(String incomingPattern, String storedPattern) {
        if (storedPattern.startsWith("/") && storedPattern.endsWith("/*")) {
            String s = storedPattern.substring(0, storedPattern.length() - 1);
            if (s.equalsIgnoreCase(incomingPattern)) {
                return true;
            }
            if (incomingPattern.equalsIgnoreCase(s.substring(0, s.length() - 1))) {
                return true;
            }
            if (incomingPattern.startsWith(s)) {
                return true;
            }
        }
        return false;
    }

    private boolean matches_extension(String incomingPattern, String storedPattern) {
        String ext;
        return storedPattern.startsWith("*.") && incomingPattern.endsWith(ext = storedPattern.substring(1));
    }
}

