/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsaddressing.urimap.security;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.wsaddressing.integration.WSAddressingBaseService;
import com.ibm.ws.wsaddressing.urimap.security.SecurityInfo;
import java.util.ArrayList;

public class SecurityHelperImpl
implements WSAddressingBaseService.SecurityHelper {
    private static TraceComponent _tc = Tr.register(SecurityHelperImpl.class, "WS-Addressing", "com.ibm.ws.wsaddressing.WSAddressingMessages");
    private ArrayList<SecurityInfo> securityInfoList = new ArrayList();
    private static String NO_MATCH = "";

    SecurityHelperImpl() {
    }

    void addSecurityInfo(SecurityInfo si) {
        this.securityInfoList.add(si);
    }

    public boolean isSSLEnabled(String uriPattern) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "isSSLEnabled", new Object[]{uriPattern});
        }
        String currentMatchingURI = NO_MATCH;
        String exactMatchingURI = NO_MATCH;
        int transportGuaranteeExact = 0;
        int transportGuarantee = 0;
        int transportGuaranteeExtension = 0;
        for (SecurityInfo si : this.securityInfoList) {
            int tg;
            String matchingPattern = si.matches(uriPattern);
            if (matchingPattern == null) continue;
            int matchType = SecurityInfo.getMatchType(matchingPattern);
            if (matchType == SecurityInfo.EXACT_MATCH) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "found exact match");
                }
                currentMatchingURI = matchingPattern;
                transportGuaranteeExact = si.getTransportGuarantee();
                exactMatchingURI = matchingPattern;
                if (transportGuaranteeExact == 0) continue;
                break;
            }
            if (matchType == SecurityInfo.PATHNAME_MATCH && matchingPattern.length() == currentMatchingURI.length()) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "found pathname match same length");
                }
                tg = si.getTransportGuarantee();
                if (transportGuarantee == 0) {
                    transportGuarantee = tg;
                }
                currentMatchingURI = matchingPattern;
                continue;
            }
            if (matchType == SecurityInfo.PATHNAME_MATCH && matchingPattern.length() > currentMatchingURI.length()) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "found pathname match larger length");
                }
                currentMatchingURI = matchingPattern;
                transportGuarantee = si.getTransportGuarantee();
                continue;
            }
            if (matchType != SecurityInfo.EXTENSION_MATCH) continue;
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "found extension match");
            }
            tg = si.getTransportGuarantee();
            if (transportGuaranteeExtension != 0) continue;
            transportGuaranteeExtension = tg;
        }
        if (!NO_MATCH.equals(exactMatchingURI)) {
            transportGuarantee = transportGuaranteeExact;
        } else if (NO_MATCH.equals(currentMatchingURI)) {
            transportGuarantee = transportGuaranteeExtension;
        }
        if (transportGuarantee == 0) {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "isSSLEnabled", false);
            }
            return false;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "isSSLEnabled", true);
        }
        return true;
    }
}

