/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsaddressing.urimap.security;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.security.core.SecurityContext;
import com.ibm.ws.wsaddressing.integration.WSAddressingBaseService;
import com.ibm.ws.wsaddressing.urimap.security.SecurityHelperImpl;
import com.ibm.ws.wsaddressing.urimap.security.SecurityInfo;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.webapplication.HTTPMethodTypeEnum;
import org.eclipse.jst.j2ee.webapplication.SecurityConstraint;
import org.eclipse.jst.j2ee.webapplication.UserDataConstraint;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.jst.j2ee.webapplication.WebResourceCollection;

public abstract class SecurityHelperFactory {
    private static final String CLASSNAME = SecurityHelperFactory.class.getName();
    private static TraceComponent _tc = Tr.register(CLASSNAME, "WS-Addressing", "com.ibm.ws.wsaddressing.WSAddressingMessages");

    public static WSAddressingBaseService.SecurityHelper createSecurityHelper(WebApp webApp) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "createSecurityHelper", new Object[]{webApp});
        }
        if (webApp == null) {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "createSecurityHelper", "Provided webApp was null");
            }
            return null;
        }
        EList constraints = webApp.getConstraints();
        EList list = null;
        SecurityHelperImpl sit = new SecurityHelperImpl();
        if (constraints != null && SecurityContext.isSecurityEnabled()) {
            if (_tc.isDebugEnabled()) {
                Tr.warning(_tc, "createSecurityHelper found some Contraints");
            }
            Iterator citr = constraints.iterator();
            while (citr.hasNext()) {
                if (_tc.isDebugEnabled()) {
                    Tr.warning(_tc, "createSecurityHelper processing a Contraints");
                }
                SecurityConstraint sc = (SecurityConstraint)citr.next();
                UserDataConstraint dataConstraint = sc.getUserDataConstraint();
                int transportGuarantee = 0;
                if (dataConstraint != null) {
                    if (_tc.isDebugEnabled()) {
                        Tr.warning(_tc, "createSecurityHelper found a UserConstraint");
                    }
                    if (dataConstraint.isSetTransportGuarantee()) {
                        transportGuarantee = dataConstraint.getTransportGuarantee().getValue();
                    }
                }
                list = sc.getWebResourceCollections();
                Iterator wrc = list.iterator();
                while (wrc.hasNext()) {
                    if (_tc.isDebugEnabled()) {
                        Tr.warning(_tc, "createSecurityHelper processing a WebResourceCollection");
                    }
                    WebResourceCollection rc = (WebResourceCollection)wrc.next();
                    EList method_list = rc.getHttpMethod();
                    Iterator methodItr = method_list.iterator();
                    boolean foundPOST = false;
                    if (method_list.size() == 0) {
                        foundPOST = true;
                    }
                    while (methodItr.hasNext() && !foundPOST) {
                        if (_tc.isDebugEnabled()) {
                            Tr.warning(_tc, "createSecurityHelper processing an HTTPMethod");
                        }
                        if (1 != ((HTTPMethodTypeEnum)methodItr.next()).getValue()) continue;
                        foundPOST = true;
                    }
                    if (!foundPOST) continue;
                    EList url_list = rc.getUrlPattern();
                    SecurityInfo sInfo = new SecurityInfo(url_list, transportGuarantee);
                    sit.addSecurityInfo(sInfo);
                    if (!_tc.isDebugEnabled()) continue;
                    Tr.warning(_tc, "createSecurityHelper found POST - added SInfo to Table");
                }
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "createSecurityHelper");
        }
        return sit;
    }
}

