/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsaddressing.urimap;

import com.ibm.ejs.models.base.bindings.webappbnd.WebAppBinding;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.WARFile;
import com.ibm.etools.webservice.wsbnd.RouterModule;
import com.ibm.etools.webservice.wsbnd.WSBinding;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.wsaddressing.urimap.WebModuleData;
import com.ibm.wsspi.webservices.models.WSModels;
import java.io.FileNotFoundException;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.application.Application;
import org.eclipse.jst.j2ee.application.Module;
import org.eclipse.jst.j2ee.application.WebModule;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.webapplication.WebApp;

public class WebMetaDataLoader {
    private static TraceComponent _tc = Tr.register(WebMetaDataLoader.class, "WS-Addressing", "com.ibm.ws.wsaddressing.WSAddressingMessages");
    private static final String CLASSNAME = "com.ibm.ws.wsaddressing.urimap.WebMetaDataLoader";

    public static WebModuleData load(ModuleFile servicesModuleFile) {
        EARFile earFile;
        if (TraceComponent.isAnyTracingEnabled() && _tc.isEntryEnabled()) {
            Tr.entry(_tc, "load");
        }
        if ((earFile = (EARFile)servicesModuleFile.getEARFile()) == null) {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "load", "No EARFile found");
            }
            return null;
        }
        Application app = earFile.getDeploymentDescriptor();
        Module m = WebMetaDataLoader.getModuleForModuleFile(servicesModuleFile);
        WebModule wm = null;
        WARFile webModuleFile = null;
        boolean isHTTPRouter = false;
        if (m.isWebModule()) {
            wm = (WebModule)m;
            webModuleFile = (WARFile)servicesModuleFile;
        } else if (m.isEjbModule()) {
            wm = WebMetaDataLoader.getHTTPRouterModuleForEJBModule(m, servicesModuleFile, app);
            if (wm != null) {
                webModuleFile = (WARFile)earFile.getModuleRef((Module)wm).getModuleFile();
                isHTTPRouter = true;
            } else if (TraceComponent.isAnyTracingEnabled() && _tc.isDebugEnabled()) {
                Tr.debug(_tc, "No HTTP Router Module for Web Services module, not returning a moduleData");
            }
        }
        WebModuleData moduleData = null;
        if (wm != null) {
            try {
                moduleData = new WebModuleData();
                moduleData.setApplicationName(earFile.getName());
                moduleData.setIsHTTPRouterModule(isHTTPRouter);
                moduleData.setContextRoot(wm.getContextRoot());
                WebAppBinding webAppBinding = webModuleFile.getBindings();
                String virtualHostName = webAppBinding.getVirtualHostName();
                moduleData.setVirtualHostName(virtualHostName);
                WebApp webApp = earFile.getDeploymentDescriptor(wm);
                moduleData.setWebApp(webApp);
                moduleData.setWebModule(wm);
            }
            catch (Exception e) {
                FFDCFilter.processException(e, CLASSNAME, "1:112:1.2");
                if (TraceComponent.isAnyTracingEnabled() && _tc.isDebugEnabled()) {
                    Tr.debug(_tc, "load", "Exception caught setting up WebModuleData");
                }
                moduleData = null;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && _tc.isEntryEnabled()) {
            Tr.exit(_tc, "load", moduleData);
        }
        return moduleData;
    }

    private static WebModule getHTTPRouterModuleForEJBModule(Module ejbModule, ModuleFile ejbModuleFile, Application app) {
        WSBinding wsb;
        block15: {
            if (TraceComponent.isAnyTracingEnabled() && _tc.isEntryEnabled()) {
                Tr.entry(_tc, "getHTTPRouterModuleForEJBModule", new Object[]{ejbModule, ejbModuleFile, app});
            }
            wsb = null;
            try {
                wsb = WSModels.getWSBinding(ejbModuleFile.getLoadStrategy(), "META-INF/ibm-webservices-bnd.xmi");
            }
            catch (Exception e) {
                FFDCFilter.processException(e, CLASSNAME, "1:134:1.2");
                if (!TraceComponent.isAnyTracingEnabled() || !_tc.isDebugEnabled()) break block15;
                Tr.debug(_tc, "getExplicitPrefix", "Exception caught whilst accessing the Endpoint override");
            }
        }
        String httpRouterModuleName = null;
        if (wsb != null) {
            for (RouterModule router : wsb.getRouterModules()) {
                if (!"http".equals(router.getTransport())) continue;
                httpRouterModuleName = router.getName();
                break;
            }
        }
        if (httpRouterModuleName != null) {
            Module m1 = app.getModule(httpRouterModuleName, null);
            if (m1 == null) {
                if (TraceComponent.isAnyTracingEnabled() && _tc.isDebugEnabled()) {
                    Tr.debug(_tc, "No HTTP Router Module for Web Services module, not returning a moduleData");
                }
            } else {
                if (m1.isWebModule()) {
                    if (TraceComponent.isAnyTracingEnabled() && _tc.isEntryEnabled()) {
                        Tr.exit(_tc, "getHTTPRouterModuleForEJBModule", m1);
                    }
                    return (WebModule)m1;
                }
                if (TraceComponent.isAnyTracingEnabled() && _tc.isDebugEnabled()) {
                    Tr.debug(_tc, "HTTP Router not a Web Module, not returning a moduleData");
                }
            }
        } else if (TraceComponent.isAnyTracingEnabled() && _tc.isDebugEnabled()) {
            Tr.debug(_tc, "No HTTP Router Module for Web Services module, not returning a moduleData");
        }
        if (TraceComponent.isAnyTracingEnabled() && _tc.isEntryEnabled()) {
            Tr.exit(_tc, "getHTTPRouterModuleForEJBModule", null);
        }
        return null;
    }

    private static Module getModuleForModuleFile(ModuleFile mf) {
        if (TraceComponent.isAnyTracingEnabled() && _tc.isEntryEnabled()) {
            Tr.entry(_tc, "getModuleForModuleFile", mf);
        }
        EARFile earFile = (EARFile)mf.getEARFile();
        Application app = earFile.getDeploymentDescriptor();
        EList el = app.getModules();
        Iterator iter = el.iterator();
        Module result = null;
        while (iter.hasNext() && result == null) {
            Module current = (Module)iter.next();
            ModuleFile currentmf = earFile.getModuleRef(current).getModuleFile();
            try {
                if (!mf.getAbsolutePath().equals(currentmf.getAbsolutePath())) continue;
                if (TraceComponent.isAnyTracingEnabled() && _tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Found module for modulefile " + current);
                }
                result = current;
            }
            catch (FileNotFoundException e) {
                FFDCFilter.processException(e, CLASSNAME, "1:195:1.2");
                if (!TraceComponent.isAnyTracingEnabled() || !_tc.isDebugEnabled()) continue;
                Tr.debug(_tc, "getExplicitPrefix", "Exception caught whilst accessing the Endpoint override");
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && _tc.isEntryEnabled()) {
            Tr.exit(_tc, "getModuleForModuleFile", result);
        }
        return result;
    }
}

