/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsaddressing.urimap;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.webservice.wsbnd.DefaultEndpointURIPrefix;
import com.ibm.etools.webservice.wsbnd.WSBinding;
import com.ibm.etools.webservice.wsbnd.WSDescBinding;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.wsaddressing.integration.WSAddressingBaseService;
import com.ibm.ws.wsaddressing.urimap.Prefix;
import com.ibm.ws.wsaddressing.urimap.WebserviceDescriptionInfo;
import com.ibm.wsspi.webservices.models.WSModels;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.webapplication.Servlet;
import org.eclipse.jst.j2ee.webapplication.ServletMapping;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.jst.j2ee.webservice.wsdd.PortComponent;
import org.eclipse.jst.j2ee.webservice.wsdd.ServletLink;
import org.eclipse.jst.j2ee.webservice.wsdd.WSDLPort;
import org.eclipse.jst.j2ee.webservice.wsdd.WebServiceDescription;
import org.eclipse.jst.j2ee.webservice.wsdd.WebServices;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSAConfigModelHelper {
    private static TraceComponent _tc = Tr.register(WSAConfigModelHelper.class, "WS-Addressing", "com.ibm.ws.wsaddressing.WSAddressingMessages");
    private static final String CLASSNAME = "com.ibm.ws.wsaddressing.urimap.WSAConfigModelHelper";
    private static final String SERVLET_URL_PATTERN_ROOT = "services/";

    public static WSAddressingBaseService.Prefix getExplicitPrefix(ModuleFile moduleFile) {
        Prefix result;
        block7: {
            if (TraceComponent.isAnyTracingEnabled() && _tc.isEntryEnabled()) {
                Tr.entry(_tc, "getExplicitPrefix", moduleFile);
            }
            result = null;
            String bindFileName = "META-INF/ibm-webservices-bnd.xmi";
            if (moduleFile.isWARFile()) {
                bindFileName = "WEB-INF/ibm-webservices-bnd.xmi";
            }
            try {
                DefaultEndpointURIPrefix defaultHTTPPrefix;
                String defaultHTTPPrefixString;
                WSDescBinding firstBinding;
                EList defaultPrefixes;
                WSBinding wsb = WSModels.getWSBinding(moduleFile.getLoadStrategy(), bindFileName);
                EList wsDescBindings = wsb.getWsdescBindings();
                if (wsDescBindings.size() > 0 && (defaultPrefixes = (firstBinding = (WSDescBinding)wsDescBindings.get(0)).getDefaultEndpointURIPrefixes()).size() >= 1 && (defaultHTTPPrefixString = (defaultHTTPPrefix = (DefaultEndpointURIPrefix)defaultPrefixes.get(0)).getText()) != null && defaultHTTPPrefixString.length() != 0) {
                    URI uri = URI.create(defaultHTTPPrefixString);
                    result = new Prefix(uri.getScheme(), uri.getHost(), uri.getPort() + "", true);
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Explicit Prefix found: " + defaultHTTPPrefixString);
                    }
                }
            }
            catch (Exception e) {
                FFDCFilter.processException(e, CLASSNAME, "1:103:1.2");
                if (!TraceComponent.isAnyTracingEnabled() || !_tc.isDebugEnabled()) break block7;
                Tr.debug(_tc, "getExplicitPrefix", "Exception caught whilst accessing the Endpoint override");
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && _tc.isEntryEnabled()) {
            Tr.exit(_tc, "getExplicitPrefix", result);
        }
        return result;
    }

    public static WebServices loadWebservices(ModuleFile intendedModule) {
        if (TraceComponent.isAnyTracingEnabled() && _tc.isEntryEnabled()) {
            Tr.entry(_tc, "loadWebservices", intendedModule);
        }
        String filePath = "META-INF/webservices.xml";
        if (intendedModule.isWARFile()) {
            filePath = "WEB-INF/webservices.xml";
        }
        WebServices webservices = WSModels.getWebServices(intendedModule.getLoadStrategy(), filePath);
        if (TraceComponent.isAnyTracingEnabled() && _tc.isEntryEnabled()) {
            Tr.exit(_tc, "loadWebservices", webservices);
        }
        return webservices;
    }

    public static List<WebserviceDescriptionInfo> buildWebServiceDescriptions(WebServices webservices, WebApp webApp, boolean isWebModule) {
        if (TraceComponent.isAnyTracingEnabled() && _tc.isEntryEnabled()) {
            Tr.entry(_tc, "buildWebServiceDescriptions", new Object[]{webservices, webApp, isWebModule});
        }
        ArrayList<WebserviceDescriptionInfo> wsds = new ArrayList<WebserviceDescriptionInfo>();
        for (Object wsdObj : webservices.getWebServiceDescriptions()) {
            WebServiceDescription wsd = (WebServiceDescription)wsdObj;
            String webServicesDescriptionName = wsd.getWebServiceDescriptionName();
            if (TraceComponent.isAnyTracingEnabled() && _tc.isDebugEnabled()) {
                Tr.debug(_tc, "buildWebServiceDescriptions: webServicesDescriptionName=" + webServicesDescriptionName);
            }
            WebserviceDescriptionInfo wsdInfo = new WebserviceDescriptionInfo(webServicesDescriptionName);
            wsds.add(wsdInfo);
            for (Object pcObj : wsd.getPortComponents()) {
                PortComponent pc = (PortComponent)pcObj;
                WSDLPort port = pc.getWsdlPort();
                QName qname = new QName(port.getNamespaceURI(), port.getLocalPart());
                String url = WSAConfigModelHelper.getURLPattern(pc, webApp, isWebModule);
                if (url == null) continue;
                wsdInfo.addPortToURLPatternMapping(qname, url);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && _tc.isEntryEnabled()) {
            Tr.exit(_tc, "buildWebServiceDescriptions", wsds);
        }
        return wsds;
    }

    private static String getURLPattern(PortComponent pc, WebApp webApp, boolean isWebModule) {
        ServletLink link;
        if (TraceComponent.isAnyTracingEnabled() && _tc.isEntryEnabled()) {
            Tr.entry(_tc, "getURLPattern", new Object[]{pc, webApp, isWebModule});
        }
        String servletName = (link = pc.getServiceImplBean().getEServletLink()) != null ? link.getServletLink() : pc.getPortComponentName();
        Servlet servlet = webApp.getServletNamed(servletName);
        ServletMapping mapping = webApp.getServletMapping(servlet);
        String url = null;
        if (mapping != null) {
            url = mapping.getUrlPattern();
        }
        if (isWebModule && url == null) {
            url = SERVLET_URL_PATTERN_ROOT + pc.getPortComponentName();
        }
        url = WSAConfigModelHelper.trimSlash(url);
        if (TraceComponent.isAnyTracingEnabled() && _tc.isEntryEnabled()) {
            Tr.exit(_tc, "getURLPattern", url);
        }
        return url;
    }

    private static String trimSlash(String in) {
        if (in == null) {
            return in;
        }
        while (in.startsWith("/")) {
            in = in.substring(1);
        }
        while (in.endsWith("/")) {
            in = in.substring(0, in.length() - 1);
        }
        return in;
    }
}

