/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsaddressing.urimap;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.deploy.DeployedModule;
import com.ibm.ws.runtime.deploy.DeployedObject;
import com.ibm.ws.runtime.metadata.MetaData;
import com.ibm.ws.runtime.metadata.MetaDataEvent;
import com.ibm.ws.runtime.metadata.MetaDataListener;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import com.ibm.ws.wsaddressing.integration.EndpointMapService;
import com.ibm.ws.wsaddressing.integration.WSAddressingBaseService;
import com.ibm.ws.wsaddressing.urimap.WSAConfigModelHelper;
import com.ibm.ws.wsaddressing.urimap.WebMetaDataLoader;
import com.ibm.ws.wsaddressing.urimap.WebModuleData;
import com.ibm.ws.wsaddressing.urimap.security.SecurityHelperFactory;
import com.ibm.ws.wsaddressing.urimap.service.SimpleEndpointData;
import com.ibm.wsspi.webcontainer.metadata.WebModuleMetaData;
import com.ibm.wsspi.webcontainer.webapp.WebAppConfig;
import com.ibm.wsspi.websvcs.desc.WSDescriptionBuilder;
import com.ibm.wsspi.websvcs.desc.WSDescriptionBuilderFactory;
import com.ibm.wsspi.websvcs.desc.WSEndpointDescriptor;
import com.ibm.wsspi.websvcs.desc.WSModuleDescriptor;
import com.ibm.wsspi.websvcs.desc.WSServiceDescriptor;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;

public class EndpointMappingListener
implements MetaDataListener {
    private static final String CLASSNAME = "com.ibm.ws.wsaddressing.urimap.EndpointMappingListener";
    private static TraceComponent _tc = Tr.register(EndpointMappingListener.class, "WS-Addressing", "com.ibm.ws.wsaddressing.WSAddressingMessages");
    private EndpointMapService endpointMapService;
    private WSAddressingBaseService baseService;
    private WSDescriptionBuilder builder;

    public EndpointMappingListener(WSAddressingBaseService bs, EndpointMapService ems) {
        if (TraceComponent.isAnyTracingEnabled() && _tc.isEntryEnabled()) {
            Tr.entry(_tc, "EndpointMappingListener", ems);
        }
        this.baseService = bs;
        this.endpointMapService = ems;
        this.builder = WSDescriptionBuilderFactory.getBuilder();
        if (TraceComponent.isAnyTracingEnabled() && _tc.isEntryEnabled()) {
            Tr.exit(_tc, "EndpointMappingListener");
        }
    }

    public void metaDataCreated(MetaDataEvent metaDataEvent) throws RuntimeWarning, RuntimeError {
        block10: {
            if (TraceComponent.isAnyTracingEnabled() && _tc.isEntryEnabled()) {
                Tr.entry(_tc, "metaDataCreated", new Object[]{metaDataEvent});
            }
            try {
                MetaData metaData = metaDataEvent.getMetaData();
                if (metaData instanceof ModuleMetaData) {
                    DeployedObject dobj;
                    ModuleFile mf;
                    WSModuleDescriptor wsmd;
                    if (TraceComponent.isAnyTracingEnabled() && _tc.isDebugEnabled()) {
                        Tr.debug(_tc, "metaDataCreated", "Processing a ModuleMetaData event");
                    }
                    if ((wsmd = this.builder.getModuleDescriptor(mf = (dobj = metaDataEvent.getDeployedObject()).getModuleFile())).containsJAXRPCWebServices()) {
                        if (TraceComponent.isAnyTracingEnabled() && _tc.isDebugEnabled()) {
                            Tr.debug(_tc, "metaDataCreated", "JAX-RPC Web Services found for the module.");
                        }
                        WebModuleData webmd = WebMetaDataLoader.load(mf);
                        WSAddressingBaseService.Prefix explicitPrefix = WSAConfigModelHelper.getExplicitPrefix(mf);
                        this.processLoadedInformation(wsmd, webmd, explicitPrefix);
                    } else if (TraceComponent.isAnyTracingEnabled() && _tc.isDebugEnabled()) {
                        Tr.debug(_tc, "metaDataCreated", "No JAX-RPC Web Services found for the module.");
                    }
                }
            }
            catch (Exception e) {
                FFDCFilter.processException(e, CLASSNAME, "1:109:1.5");
                if (!TraceComponent.isAnyTracingEnabled() || !_tc.isDebugEnabled()) break block10;
                Tr.debug(_tc, "metaDataCreated", "Exception caught whilst adding information to the EndpointMap");
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && _tc.isEntryEnabled()) {
            Tr.exit(_tc, "metaDataCreated");
        }
    }

    protected void processLoadedInformation(WSModuleDescriptor wsmd, WebModuleData webmd, WSAddressingBaseService.Prefix explicitPrefix) {
        if (TraceComponent.isAnyTracingEnabled() && _tc.isEntryEnabled()) {
            Tr.entry(_tc, "processLoadedInformation", new Object[]{wsmd, webmd, explicitPrefix});
        }
        WSAddressingBaseService.SecurityHelper sh = SecurityHelperFactory.createSecurityHelper(webmd.getWebApp());
        Iterator services = wsmd.getServices();
        while (services.hasNext()) {
            WSServiceDescriptor service = (WSServiceDescriptor)services.next();
            if (service.isJAXWSService()) continue;
            Iterator endpoints = service.getEndpoints();
            while (endpoints.hasNext()) {
                WSEndpointDescriptor endpoint = (WSEndpointDescriptor)endpoints.next();
                String appName = webmd.getApplicationName();
                String virtualHostName = webmd.getVirtualHostName();
                String contextRoot = webmd.getContextRoot();
                WSAddressingBaseService.Prefix httpPrefix = this.baseService.getPrefix("http", virtualHostName);
                WSAddressingBaseService.Prefix httpsPrefix = this.baseService.getPrefix("https", virtualHostName);
                if (explicitPrefix != null && "http".equals(explicitPrefix.getProtocol())) {
                    httpPrefix = explicitPrefix;
                }
                if (explicitPrefix != null && "https".equals(explicitPrefix.getProtocol())) {
                    httpPrefix = explicitPrefix;
                }
                boolean intermediaryPresent = false;
                String address = null;
                QName webServiceName = service.getQName();
                String portName = endpoint.getName();
                String urlPattern = endpoint.getURLPattern();
                boolean isHTTPS = sh.isSSLEnabled(urlPattern);
                if (httpPrefix != null && !isHTTPS) {
                    intermediaryPresent = httpPrefix.isIntermediary();
                    address = httpPrefix + "/" + contextRoot + urlPattern;
                }
                if (httpsPrefix != null && isHTTPS) {
                    intermediaryPresent = httpsPrefix.isIntermediary();
                    address = httpsPrefix + "/" + contextRoot + urlPattern;
                }
                SimpleEndpointData sed = new SimpleEndpointData(appName, webServiceName, portName, address, virtualHostName, intermediaryPresent, true);
                this.endpointMapService.addEndpointData(sed);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && _tc.isEntryEnabled()) {
            Tr.exit(_tc, "processLoadedInformation");
        }
    }

    public void metaDataDestroyed(MetaDataEvent mde) {
        block5: {
            if (TraceComponent.isAnyTracingEnabled() && _tc.isEntryEnabled()) {
                Tr.entry(_tc, "metaDataDestroyed", mde);
            }
            try {
                DeployedObject dobj;
                MetaData metaData = mde.getMetaData();
                if (metaData instanceof WebModuleMetaData && (dobj = mde.getDeployedObject()) instanceof DeployedModule && dobj.getModuleFile().isWARFile()) {
                    WebAppConfig config2 = ((WebModuleMetaData)((Object)metaData)).getConfiguration();
                    this.endpointMapService.removeEndpointData(config2.getApplicationName());
                }
            }
            catch (Exception e) {
                FFDCFilter.processException(e, CLASSNAME, "1:185:1.5");
                if (!TraceComponent.isAnyTracingEnabled() || !_tc.isDebugEnabled()) break block5;
                Tr.debug(_tc, "metaDataDestroyed caught exception" + e);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && _tc.isEntryEnabled()) {
            Tr.exit(_tc, "metaDataDestroyed");
        }
    }
}

