/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsaddressing.jaxws21.client.config;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.wsaddressing.jaxws21.SubmissionAddressingFeature;
import javax.xml.ws.soap.AddressingFeature;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.binding.SOAPBinding;
import org.apache.axis2.jaxws.core.MessageContext;
import org.apache.axis2.jaxws.feature.ClientConfigurator;
import org.apache.axis2.jaxws.spi.Binding;
import org.apache.axis2.jaxws.spi.BindingProvider;

public class AddressingConfigurator
implements ClientConfigurator {
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.wsaddressing.jaxws.CWWARMessages");
    private static final TraceComponent TRACE_COMPONENT = Tr.register(AddressingConfigurator.class, "WS-Addressing", "com.ibm.ws.wsaddressing.jaxws.CWWARMessages");

    public AddressingConfigurator() {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "<init>");
            Tr.exit(TRACE_COMPONENT, "<init>", this);
        }
    }

    public void configure(MessageContext messageContext, BindingProvider provider) {
        boolean w3cAddressingEnabled;
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "configure", new Object[]{messageContext, provider});
        }
        Binding bnd = (Binding)provider.getBinding();
        AddressingFeature addressingFeature = (AddressingFeature)bnd.getFeature("http://www.w3.org/2005/08/addressing/module");
        SubmissionAddressingFeature submissionAddressingFeature = (SubmissionAddressingFeature)bnd.getFeature("http://schemas.xmlsoap.org/ws/2004/08/addressing");
        String addressingNamespace = bnd.getAddressingNamespace();
        Boolean disableAddressing = (Boolean)messageContext.getProperty("disableAddressingForOutMessages");
        if (addressingFeature != null && submissionAddressingFeature != null) {
            w3cAddressingEnabled = addressingFeature.isEnabled();
            boolean submissionAddressingEnabled = submissionAddressingFeature.isEnabled();
            if (w3cAddressingEnabled && submissionAddressingEnabled) {
                if (addressingNamespace == null) {
                    addressingNamespace = "http://www.w3.org/2005/08/addressing";
                }
                disableAddressing = Boolean.FALSE;
            } else if (w3cAddressingEnabled) {
                if ("http://schemas.xmlsoap.org/ws/2004/08/addressing".equals(addressingNamespace)) {
                    throw ExceptionFactory.makeWebServiceException(nls.getFormattedMessage("NAMESPACE_MISMATCH_CWWAR0007", new Object[]{addressingFeature.getID(), addressingNamespace}, null));
                }
                addressingNamespace = "http://www.w3.org/2005/08/addressing";
                disableAddressing = Boolean.FALSE;
            } else if (submissionAddressingEnabled) {
                if ("http://www.w3.org/2005/08/addressing".equals(addressingNamespace)) {
                    throw ExceptionFactory.makeWebServiceException(nls.getFormattedMessage("NAMESPACE_MISMATCH_CWWAR0007", new Object[]{submissionAddressingFeature.getID(), addressingNamespace}, null));
                }
                addressingNamespace = "http://schemas.xmlsoap.org/ws/2004/08/addressing";
                disableAddressing = Boolean.FALSE;
            } else {
                disableAddressing = Boolean.TRUE;
            }
        } else if (addressingFeature != null) {
            w3cAddressingEnabled = addressingFeature.isEnabled();
            if (w3cAddressingEnabled) {
                if ("http://schemas.xmlsoap.org/ws/2004/08/addressing".equals(addressingNamespace)) {
                    throw ExceptionFactory.makeWebServiceException(nls.getFormattedMessage("NAMESPACE_MISMATCH_CWWAR0007", new Object[]{addressingFeature.getID(), addressingNamespace}, null));
                }
                addressingNamespace = "http://www.w3.org/2005/08/addressing";
                disableAddressing = Boolean.FALSE;
            } else {
                disableAddressing = Boolean.TRUE;
            }
        } else if (submissionAddressingFeature != null) {
            boolean submissionAddressingEnabled = submissionAddressingFeature.isEnabled();
            if (submissionAddressingEnabled) {
                if ("http://www.w3.org/2005/08/addressing".equals(addressingNamespace)) {
                    throw ExceptionFactory.makeWebServiceException(nls.getFormattedMessage("NAMESPACE_MISMATCH_CWWAR0007", new Object[]{submissionAddressingFeature.getID(), addressingNamespace}, null));
                }
                addressingNamespace = "http://schemas.xmlsoap.org/ws/2004/08/addressing";
                disableAddressing = Boolean.FALSE;
            } else {
                disableAddressing = Boolean.TRUE;
            }
        } else {
            throw ExceptionFactory.makeWebServiceException(nls.getString("CONFIGURATOR_ERROR_CWWAR0005"));
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "WS-Addressing version: " + addressingNamespace);
            Tr.debug(TRACE_COMPONENT, "WS-Addressing disabled: " + disableAddressing);
        }
        if (!disableAddressing.booleanValue()) {
            EndpointReference epr = bnd.getAxis2EndpointReference();
            org.apache.axis2.context.MessageContext axis2MessageContext = messageContext.getAxisMessageContext();
            axis2MessageContext.setTo(epr);
        }
        messageContext.setProperty("WSAddressingVersion", addressingNamespace);
        messageContext.setProperty("disableAddressingForOutMessages", disableAddressing);
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "configure");
        }
    }

    public boolean supports(Binding binding) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "supports", new Object[]{binding});
        }
        boolean result = binding instanceof SOAPBinding;
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "supports", result);
        }
        return result;
    }
}

