/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsaddressing.jaxws.urimap;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.wsaddressing.integration.WSAddressingBaseService;
import com.ibm.wsspi.runtime.config.ConfigScope;
import com.ibm.wsspi.runtime.config.ConfigService;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import java.io.File;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExplicitPrefixLoader {
    private static final TraceComponent TRACE_COMPONENT = Tr.register(ExplicitPrefixLoader.class, "WS-Addressing", "com.ibm.ws.wsaddressing.WSAddressingMessages");

    public static HashMap<String, WSAddressingBaseService.Prefix> extractMappedPrefix(String applicationName, String moduleName, boolean isHTTPRouterModule) {
        File fileObj;
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "extractMappedPrefix", new Object[]{applicationName, moduleName, isHTTPRouterModule});
        }
        ConfigService configService = null;
        try {
            configService = WsServiceRegistry.getService(ExplicitPrefixLoader.class, ConfigService.class);
        }
        catch (Exception e) {
            FFDCFilter.processException(e, ExplicitPrefixLoader.class.toString(), "1:84:1.2");
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "extractMappedPrefix", "ConfigService unavailable. Returning null");
            }
            return null;
        }
        ConfigScope cscope = configService.createScope(1);
        cscope.set(1, applicationName);
        String infDir = "WEB-INF";
        if (isHTTPRouterModule) {
            infDir = "META-INF";
        }
        String relativePath = "deployments" + File.separator + applicationName + File.separator + moduleName + File.separator + infDir + File.separator + "URLPrefixMap";
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "Attempting to acces relativepath: " + relativePath);
        }
        String filename = cscope.getAbsolutePath(relativePath);
        HashMap urlPrefixMap = null;
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "extractMappedPrefix: using filename " + filename);
        }
        if (filename != null && (fileObj = new File(filename)).exists()) {
            try {
                FileInputStream fis = new FileInputStream(fileObj);
                ObjectInputStream oi = new ObjectInputStream(fis);
                urlPrefixMap = (HashMap)oi.readObject();
                fis.close();
            }
            catch (Exception e) {
                FFDCFilter.processException(e, ExplicitPrefixLoader.class.toString(), "1:117:1.2");
            }
        }
        if (urlPrefixMap == null || urlPrefixMap.isEmpty()) {
            urlPrefixMap = new HashMap();
            Tr.debug(TRACE_COMPONENT, "extractMappedPrefix: found no persistent prefix store.");
        }
        HashMap<String, WSAddressingBaseService.Prefix> prefixMap = new HashMap<String, WSAddressingBaseService.Prefix>();
        for (Map.Entry entry : urlPrefixMap.entrySet()) {
            prefixMap.put((String)entry.getKey(), new ExplicitPrefix((String)entry.getValue()));
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "extractMappedPrefix", prefixMap);
        }
        return prefixMap;
    }

    private static class ExplicitPrefix
    implements WSAddressingBaseService.Prefix {
        String host;
        String port;
        String protocol;

        ExplicitPrefix(String pfx) {
            URI uri = URI.create(pfx);
            this.host = uri.getHost();
            this.port = "" + uri.getPort();
            this.protocol = uri.getScheme();
        }

        public String getHost() {
            return this.host;
        }

        public String getPort() {
            return this.port;
        }

        public String getProtocol() {
            return this.protocol;
        }

        public boolean isIntermediary() {
            return true;
        }

        public String toString() {
            return this.protocol + "://" + this.host + ":" + this.port;
        }
    }
}

