/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsaddressing.jaxws.urimap;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.metadata.annotations.AnnotationConfigReader;
import com.ibm.ws.runtime.deploy.DeployedObject;
import com.ibm.ws.runtime.metadata.ApplicationMetaData;
import com.ibm.ws.runtime.metadata.MetaData;
import com.ibm.ws.runtime.metadata.MetaDataEvent;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import com.ibm.ws.runtime.service.MetaDataService;
import com.ibm.ws.wsaddressing.integration.EndpointMapService;
import com.ibm.ws.wsaddressing.integration.WSAddressingBaseService;
import com.ibm.ws.wsaddressing.jaxws.RoutingReferenceParameterHelper;
import com.ibm.ws.wsaddressing.jaxws.urimap.EndpointData;
import com.ibm.ws.wsaddressing.jaxws.urimap.ExplicitPrefixLoader;
import com.ibm.ws.wsaddressing.jaxws21.adapters.SubmissionAddressingAdapter;
import com.ibm.ws.wsaddressing.jaxws21.client.config.AddressingConfigurator;
import com.ibm.ws.wsaddressing.jaxws21.factory.impl.Axis2EndpointReferenceFactoryImpl;
import com.ibm.ws.wsaddressing.jaxws21.factory.impl.JAXWSEndpointReferenceFactoryImpl;
import com.ibm.ws.wsaddressing.jaxws21.urimap.MetaDataHelper;
import com.ibm.wsspi.websvcs.runtime.JAXWSMetaDataListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.jaxws.addressing.factory.Axis2EndpointReferenceFactory;
import org.apache.axis2.jaxws.addressing.factory.JAXWSEndpointReferenceFactory;
import org.apache.axis2.jaxws.addressing.util.EndpointContextMap;
import org.apache.axis2.jaxws.addressing.util.EndpointKey;
import org.apache.axis2.jaxws.registry.ClientConfiguratorRegistry;
import org.apache.axis2.jaxws.registry.FactoryRegistry;
import org.apache.axis2.jaxws.registry.ServerConfiguratorRegistry;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;

public class EndpointMappingListener
implements JAXWSMetaDataListener {
    private static final TraceComponent TRACE_COMPONENT = Tr.register(EndpointMappingListener.class, "WS-Addressing", "com.ibm.ws.wsaddressing.jaxws.CWWARMessages");
    private EndpointMapService endpointInformationMap;
    private WSAddressingBaseService baseService;
    private MetaDataHelper metaDataHelper;

    public EndpointMappingListener(WSAddressingBaseService bs, EndpointMapService eim, MetaDataService mds) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "EndpointMappingListener<init>", new Object[]{bs, eim, mds});
        }
        this.baseService = bs;
        this.endpointInformationMap = eim;
        this.metaDataHelper = new MetaDataHelper(mds);
        this.initialize();
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "EndpointMappingListener<init>");
        }
    }

    public void metaDataCreated(MetaDataEvent mde, ConfigurationContext configContext) {
        block8: {
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                Tr.entry(TRACE_COMPONENT, "metaDataCreated", new Object[]{mde, configContext});
            }
            try {
                MetaData metaData = mde.getMetaData();
                DeployedObject dobj = mde.getDeployedObject();
                ModuleFile moduleFile = dobj.getModuleFile();
                WSAddressingBaseService.WebModuleData wmd = this.baseService.loadWebModuleData(moduleFile);
                if (wmd != null) {
                    if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                        Tr.debug(TRACE_COMPONENT, "metaDataCreated", "WebModuleData generated for module: " + wmd);
                    }
                    WSAddressingBaseService.SecurityHelper securityHelper = this.baseService.createSecurityHelper(wmd.getWebApp());
                    ModuleMetaData mmd = (ModuleMetaData)metaData;
                    ApplicationMetaData amd = mmd.getApplicationMetaData();
                    String applicationName = amd.getName();
                    HashMap<String, WSAddressingBaseService.Prefix> prefixes = ExplicitPrefixLoader.extractMappedPrefix(applicationName, moduleFile.getName(), wmd.isHTTPRouterModule());
                    WSAddressingBaseService.Prefix httpPrefix = prefixes.get("http");
                    WSAddressingBaseService.Prefix httpsPrefix = prefixes.get("https");
                    if (httpPrefix == null) {
                        httpPrefix = this.baseService.getPrefix("http", wmd.getVirtualHostName());
                    }
                    if (httpsPrefix == null) {
                        httpsPrefix = this.baseService.getPrefix("https", wmd.getVirtualHostName());
                    }
                    this.processEndpoints(amd, mmd, configContext, securityHelper, wmd, moduleFile, httpPrefix, httpsPrefix);
                    this.addEPRDecoratorInfoToContext(configContext, wmd.getVirtualHostName());
                }
            }
            catch (Exception e) {
                FFDCFilter.processException(e, this.getClass().getName(), "1:166:1.24");
                if (!TraceComponent.isAnyTracingEnabled() || !TRACE_COMPONENT.isDebugEnabled()) break block8;
                Tr.debug(TRACE_COMPONENT, "metaDataCreated", "Exception caught whilst adding information to the EndpointMap");
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "metaDataCreated");
        }
    }

    private void initialize() {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "initialize");
        }
        JAXWSEndpointReferenceFactoryImpl jaxwsEPRFactory = new JAXWSEndpointReferenceFactoryImpl();
        FactoryRegistry.setFactory(JAXWSEndpointReferenceFactory.class, jaxwsEPRFactory);
        Axis2EndpointReferenceFactoryImpl axis2EPRFactory = new Axis2EndpointReferenceFactoryImpl();
        FactoryRegistry.setFactory(Axis2EndpointReferenceFactory.class, axis2EPRFactory);
        AddressingConfigurator clientConfigurator = new AddressingConfigurator();
        ClientConfiguratorRegistry.setConfigurator("http://www.w3.org/2005/08/addressing/module", clientConfigurator);
        ClientConfiguratorRegistry.setConfigurator("http://schemas.xmlsoap.org/ws/2004/08/addressing", clientConfigurator);
        com.ibm.ws.wsaddressing.jaxws21.server.config.AddressingConfigurator serverConfigurator = new com.ibm.ws.wsaddressing.jaxws21.server.config.AddressingConfigurator();
        ServerConfiguratorRegistry.setConfigurator("http://www.w3.org/2005/08/addressing/module", serverConfigurator);
        ServerConfiguratorRegistry.setConfigurator("http://schemas.xmlsoap.org/ws/2004/08/addressing", serverConfigurator);
        AnnotationConfigReader.addAnnotationAdapterClass((String)"Lcom/ibm/websphere/wsaddressing/jaxws21/SubmissionAddressing;", SubmissionAddressingAdapter.class);
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "initialize");
        }
    }

    private void addEPRDecoratorInfoToContext(ConfigurationContext configContext, String virtualHostName) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "addEPRDecoratorInfoToContext", new Object[]{configContext, virtualHostName});
        }
        OMElement fragileIdentityReferenceParameter = RoutingReferenceParameterHelper.createFragileIdentityReferenceParameter(this.baseService.getFragileIdentity());
        configContext.setProperty("fragileIdentityReferenceParameter", fragileIdentityReferenceParameter);
        OMElement virtualHostNameReferenceParameter = RoutingReferenceParameterHelper.createVirtualHostName(virtualHostName);
        configContext.setProperty("virtualHostNameReferenceParameter", virtualHostNameReferenceParameter);
        OMElement intermediaryPresentReferenceParameter = RoutingReferenceParameterHelper.createIntermediaryPresent();
        configContext.setProperty("intermediaryPresentReferenceParameter", intermediaryPresentReferenceParameter);
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "addEPRDecoratorInfoToContext");
        }
    }

    private void processEndpoints(ApplicationMetaData applicationMetaData, ModuleMetaData moduleMetaData, ConfigurationContext configContext, WSAddressingBaseService.SecurityHelper securityHelper, WSAddressingBaseService.WebModuleData moduleData, ModuleFile moduleFile, WSAddressingBaseService.Prefix httpPrefix, WSAddressingBaseService.Prefix httpsPrefix) {
        String moduleName;
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "processEndpoints", new Object[]{applicationMetaData, moduleMetaData, configContext, securityHelper, moduleData, moduleFile, httpPrefix, httpsPrefix});
        }
        AxisConfiguration axisConfig = configContext.getAxisConfiguration();
        HashMap services = axisConfig.getServices();
        Set names = services.keySet();
        Iterator iterator = names.iterator();
        J2EEName jName = moduleMetaData.getJ2EEName();
        String string = moduleName = jName != null ? jName.getModule() : "";
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.debug(TRACE_COMPONENT, "processEndpoints", "Module name: " + moduleName);
        }
        EndpointContextMap endpointContextMap = this.metaDataHelper.getEndpointContextMap(applicationMetaData);
        configContext.setProperty("org.apache.axis2.jaxws.addressing.util.EndpointContextMap", endpointContextMap);
        while (iterator.hasNext()) {
            AxisService axisService = (AxisService)services.get(iterator.next());
            String applicationName = applicationMetaData.getName();
            EndpointData endpointData = new EndpointData(applicationName, moduleName, axisService, securityHelper, moduleData, moduleFile, httpPrefix, httpsPrefix);
            this.endpointInformationMap.addEndpointData(endpointData);
            QName serviceName = endpointData.getWebServiceName();
            QName portName = new QName(serviceName.getNamespaceURI(), endpointData.getEndpointName());
            EndpointKey key = new EndpointKey(serviceName, portName);
            ArrayList<EndpointData> list = (ArrayList<EndpointData>)endpointContextMap.get(key);
            if (list == null) {
                list = new ArrayList<EndpointData>();
                endpointContextMap.put(key, list);
            }
            list.add(endpointData);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "processEndpoints");
        }
    }

    public void metaDataDestroyed(MetaDataEvent mde, ConfigurationContext configContext) {
        MetaData metaData;
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "metaDataDestroyed", new Object[]{mde, configContext});
        }
        if ((metaData = mde.getMetaData()) instanceof ModuleMetaData) {
            ModuleMetaData mmd = (ModuleMetaData)metaData;
            String applicationName = mmd.getApplicationMetaData().getName();
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "metaDataDestroyed", "Module contains JAX-WS Web Services. Removing Mappings. ApplicationName=" + applicationName);
            }
            this.endpointInformationMap.removeEndpointData(applicationName);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "metaDataDestroyed");
        }
    }
}

