/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsaddressing.jaxws.urimap;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.websvcs.utils.Axis2Utils;
import com.ibm.ws.wsaddressing.integration.EndpointMapService;
import com.ibm.ws.wsaddressing.integration.WSAddressingBaseService;
import javax.xml.namespace.QName;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;

class EndpointData
implements EndpointMapService.EndpointData {
    private static final TraceComponent TRACE_COMPONENT = Tr.register(EndpointData.class, "WS-Addressing", "com.ibm.ws.wsaddressing.WSAddressingMessages");
    String appName;
    String modName;
    String address;
    private AxisService axisService;
    private WSAddressingBaseService.WebModuleData moduleData;
    WSAddressingBaseService.Prefix chosenPrefix;

    EndpointData(String applicationName, String moduleName, AxisService axisService, WSAddressingBaseService.SecurityHelper securityHelper, WSAddressingBaseService.WebModuleData moduleData, ModuleFile moduleFile, WSAddressingBaseService.Prefix httpPrefix, WSAddressingBaseService.Prefix httpsPrefix) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "EndpointData<init>", new Object[]{applicationName, moduleName, axisService, securityHelper, moduleData, moduleFile, httpPrefix, httpsPrefix});
        }
        this.appName = applicationName;
        this.modName = moduleName;
        this.axisService = axisService;
        this.moduleData = moduleData;
        this.address = "";
        String httpPrefixStr = httpPrefix != null ? httpPrefix.toString() : null;
        String httpsPrefixStr = httpsPrefix != null ? httpsPrefix.toString() : null;
        boolean hasHttpPrefix = httpPrefix != null;
        boolean hasHttpsPrefix = httpsPrefix != null;
        String contextRoot = moduleData.getContextRoot();
        String urlPattern = Axis2Utils.getURLPattern(axisService, moduleFile);
        boolean isHTTPS = securityHelper.isSSLEnabled(urlPattern);
        if (hasHttpPrefix && !isHTTPS) {
            this.address = httpPrefixStr + "/" + contextRoot + urlPattern;
            this.chosenPrefix = httpPrefix;
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "buildEndpointURL: HTTP URL Constructed", this.address);
            }
        }
        if (hasHttpsPrefix && isHTTPS) {
            this.address = httpsPrefixStr + "/" + contextRoot + urlPattern;
            this.chosenPrefix = httpsPrefix;
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "buildEndpointURL: HTTPS URL Constructed", this.address);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "EndpointData<init>");
        }
    }

    public String getApplicationName() {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "getApplicationName", this.appName);
        }
        return this.appName;
    }

    public String getModuleName() {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "getModuleName", this.modName);
        }
        return this.modName;
    }

    public String getAddress() {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "getAddress", this.address);
        }
        return this.address;
    }

    public String getVirtualHost() {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "getVirtualHost", this.moduleData.getVirtualHostName());
        }
        return this.moduleData.getVirtualHostName();
    }

    public boolean isIntermediaryPresent() {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "isIntermediaryPresent", this.chosenPrefix.isIntermediary());
        }
        return this.chosenPrefix.isIntermediary();
    }

    public boolean isWLMable() {
        boolean result;
        Parameter param;
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "isWLMable");
        }
        if ((param = this.axisService.getParameter("preventWLM")) == null) {
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "isWLMable", "Retrieved parameter not found.  Return true");
            }
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "isWLMable", "true");
            }
            return true;
        }
        String value = (String)param.getValue();
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "isWLMable", "Retrieved parameter " + value);
        }
        boolean bl = result = Boolean.valueOf(value) == false;
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "isWLMable", result);
        }
        return result;
    }

    public String getEndpointName() {
        return Axis2Utils.getPortName(this.axisService);
    }

    public QName getWebServiceName() {
        return Axis2Utils.getServiceQName(this.axisService);
    }
}

