/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsaddressing.jaxws.policyset;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.policyset.runtime.PolicySetConfiguration;
import com.ibm.ws.policyset.runtime.PolicyTypeLoader;
import com.ibm.ws.policyset.runtime.VariableExpander;
import com.ibm.ws.wsaddressing.jaxws.Constants;
import com.ibm.ws.wsaddressing.jaxws.policyset.PolicyTypeFileHelper;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;

public class WSAPolicyTypeLoader
implements PolicyTypeLoader {
    private static final TraceComponent TRACE_COMPONENT = Tr.register(WSAPolicyTypeLoader.class, "WS-Addressing", "com.ibm.ws.wsaddressing.WSAddressingMessages");
    PolicyTypeFileHelper helper = new PolicyTypeFileHelper();

    public WSAPolicyTypeLoader() {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "WSAPolicyTypeLoader CTOR");
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "WSAPolicyTypeLoader CTOR", this);
        }
    }

    public void destroy() throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "destroy");
        }
    }

    public String getType() throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "getType", "WSAddressing");
        }
        return "WSAddressing";
    }

    public void init(Map properties) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "init");
        }
    }

    public void load(ClassLoader sysCL, VariableExpander expander, InputStream input, PolicySetConfiguration psConfig) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "load", new Object[]{sysCL, expander, input, psConfig});
        }
        String wsaddressingFlag = "unspecified";
        String wsaMode = "WSA_BOTH";
        Properties attributes = this.helper.readPolicyType(input);
        if (attributes != null) {
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "load", "Getting value from Properties object");
            }
            wsaddressingFlag = attributes.getProperty("usingaddressing", "unspecified");
            wsaMode = attributes.getProperty("wsaMode", "WSA_BOTH");
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "load", "Setting " + Constants.POLICY_TYPE_CONFIGURATION_KEY + " value: " + wsaddressingFlag);
            Tr.debug(TRACE_COMPONENT, "load", "Setting wsaMode value: " + wsaMode);
        }
        psConfig.setPolicyTypeConfiguration(Constants.POLICY_TYPE_CONFIGURATION_KEY, wsaddressingFlag);
        psConfig.setPolicyTypeConfiguration("wsaMode", wsaMode);
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "load");
        }
    }
}

