/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsaddressing.jaxws.policyset;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.wsaddressing.jaxws.policyset.WSAPolicyTypeProvider;
import com.ibm.ws.wspolicy.PolicyReferenceException;
import com.ibm.ws.wspolicy.WSPolicyInternalException;
import com.ibm.ws.wspolicy.lightweight.WSPolicyExternalizer;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Properties;

public abstract class PolicyTypeFileHelperBase {
    private static final TraceComponent TRACE_COMPONENT = Tr.register(PolicyTypeFileHelperBase.class, "WS-Addressing", "com.ibm.ws.wsaddressing.WSAddressingMessages");
    private static final String CLASSNAME = PolicyTypeFileHelperBase.class.getCanonicalName();

    public boolean writePolicyType(String policyTypePath, Properties attributes, Map context) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "writePolicyType", new Object[]{policyTypePath, attributes, context});
        }
        boolean success = false;
        if (this.validateAttributesForWrite(attributes)) {
            try {
                WSPolicyExternalizer.Policy policy = this.buildPolicy(attributes);
                success = this.writePolicy(policyTypePath, policy, context);
            }
            catch (Exception e) {
                FFDCFilter.processException(e, CLASSNAME, "1:1.7:70");
                if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "writePolicyType", "Exception caught during marshalling: " + e);
                }
                success = false;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "writePolicyType", success);
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean writePolicy(String policyTypePath, WSPolicyExternalizer.Policy policy, Map context) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "writePolicy", new Object[]{policyTypePath, policy});
        }
        boolean result = true;
        if (policy != null) {
            File policyFile = new File(policyTypePath);
            if (policyFile.createNewFile() && TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "writePolicyType", "File does not exist. Will be created: " + policyTypePath);
            }
            FileOutputStream outputStream = null;
            try {
                outputStream = new FileOutputStream(policyFile);
                WSPolicyExternalizer.writePolicy(policy, outputStream);
            }
            finally {
                if (outputStream != null) {
                    ((OutputStream)outputStream).close();
                }
            }
        } else {
            result = false;
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "writePolicy");
        }
        return result;
    }

    public Properties readPolicyType(String policyTypePath) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "readPolicyType", policyTypePath);
        }
        Properties result = this.readPolicyType(this.getInputStreamForRead(policyTypePath));
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "readPolicyType", result);
        }
        return result;
    }

    protected InputStream getInputStreamForRead(String policyTypePath) {
        FileInputStream policyFileStream;
        block7: {
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                Tr.entry(TRACE_COMPONENT, "getInputStream", policyTypePath);
            }
            policyFileStream = null;
            try {
                File policyFile = new File(policyTypePath);
                if (!policyFile.exists()) {
                    if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                        Tr.debug(TRACE_COMPONENT, "readPolicyType", "File does not exist: " + policyTypePath);
                    }
                } else {
                    policyFileStream = new FileInputStream(policyFile);
                }
            }
            catch (Exception e) {
                FFDCFilter.processException(e, CLASSNAME, "1:146:1.7");
                if (!TraceComponent.isAnyTracingEnabled() || !TRACE_COMPONENT.isDebugEnabled()) break block7;
                Tr.debug(TRACE_COMPONENT, "readPolicyType", "Exception caught during file load: " + e);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getInputStream", policyFileStream);
        }
        return policyFileStream;
    }

    public Properties readPolicyType(InputStream input) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "readPolicyType", input);
        }
        ByteArrayInputStream bais = null;
        if (input != null) {
            try {
                byte[] bytes = WSAPolicyTypeProvider.transformpolicy12to15(input);
                bais = new ByteArrayInputStream(bytes);
            }
            catch (Exception e) {
                FFDCFilter.processException(e, CLASSNAME, "1:173:1.7");
                if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "readPolicyType", "Exception caught during file load: " + e);
                }
                throw e;
            }
        }
        WSPolicyExternalizer.Policy policy = null;
        if (bais != null) {
            policy = WSPolicyExternalizer.readPolicy(bais);
        }
        Properties resultProperties = this.processPolicy(policy);
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "readPolicyType", resultProperties);
        }
        return resultProperties;
    }

    abstract Properties processPolicy(WSPolicyExternalizer.Policy var1) throws PolicyReferenceException, WSPolicyInternalException;

    abstract boolean validateAttributesForWrite(Properties var1);

    abstract WSPolicyExternalizer.Policy buildPolicy(Properties var1) throws PolicyReferenceException, WSPolicyInternalException;
}

