/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsaddressing.jaxws.policyset;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.wsaddressing.jaxws.policyset.PolicyTypeFileHelperBase;
import com.ibm.ws.wsaddressing.jaxws.policyset.WSAPolicyTypeProvider;
import com.ibm.ws.wspolicy.PolicyReferenceException;
import com.ibm.ws.wspolicy.WSPolicyInternalException;
import com.ibm.ws.wspolicy.domain.Assertion;
import com.ibm.ws.wspolicy.lightweight.WSPolicyExternalizer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Properties;
import javax.xml.namespace.QName;

public class PolicyTypeBndFileHelper
extends PolicyTypeFileHelperBase {
    private static final TraceComponent TRACE_COMPONENT = Tr.register(PolicyTypeBndFileHelper.class, "WS-Addressing", "com.ibm.ws.wsaddressing.WSAddressingMessages");
    private static final String CLASSNAME = PolicyTypeBndFileHelper.class.getCanonicalName();
    private static final QName PREVENT_WLM_QNAME = new QName("http://www.ibm.com/ws/wsaddressing/jaxws/policyset/wlmset_200608", "preventWLM");
    private static final String DEFAULT_VALUE = "false";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean writePolicy(String policyTypePath, WSPolicyExternalizer.Policy policy, Map context) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "writePolicy", new Object[]{policyTypePath, policy, context});
        }
        boolean result = true;
        if (policy != null) {
            File policyFile = new File(policyTypePath);
            if (policyFile.createNewFile() && TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "writePolicy", "File does not exist. Will be created: " + policyTypePath);
            }
            String version = null;
            if (context != null) {
                version = (String)context.get("version");
            }
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "writePolicy", "Requested version: " + version);
            }
            if (version != null && !version.startsWith("7.0")) {
                if (version.startsWith("6.1")) {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    WSPolicyExternalizer.writePolicy(policy, baos);
                    ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
                    byte[] bytes = WSAPolicyTypeProvider.transformpolicy15to12(bais);
                    policy = WSPolicyExternalizer.readPolicy(new ByteArrayInputStream(bytes));
                } else {
                    throw new IllegalStateException();
                }
            }
            FileOutputStream outputStream = null;
            try {
                outputStream = new FileOutputStream(policyFile);
                WSPolicyExternalizer.writePolicy(policy, outputStream);
            }
            finally {
                if (outputStream != null) {
                    ((OutputStream)outputStream).close();
                }
            }
        } else {
            result = false;
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "writePolicy");
        }
        return result;
    }

    WSPolicyExternalizer.Policy buildPolicy(Properties attributes) throws WSPolicyInternalException, PolicyReferenceException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "buildPolicy", attributes);
        }
        String wlmFlag = DEFAULT_VALUE;
        if (attributes != null) {
            wlmFlag = attributes.getProperty("preventWLM");
        }
        boolean preventFlag = Boolean.valueOf(wlmFlag);
        WSPolicyExternalizer.Alternative alternative = null;
        if (preventFlag) {
            Assertion assertion = WSPolicyExternalizer.createAssertion(PREVENT_WLM_QNAME, null, null, false, null);
            alternative = WSPolicyExternalizer.createAlternative(assertion);
        } else {
            alternative = WSPolicyExternalizer.createAlternative(new Assertion[0]);
        }
        WSPolicyExternalizer.Policy policy = WSPolicyExternalizer.createPolicy(alternative);
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "buildPolicy", policy);
        }
        return policy;
    }

    Properties processPolicy(WSPolicyExternalizer.Policy policy) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "processPolicy", policy);
        }
        String preventWLM = DEFAULT_VALUE;
        if (policy != null) {
            for (WSPolicyExternalizer.Alternative alternative : policy) {
                for (Assertion assertion : alternative) {
                    if (PREVENT_WLM_QNAME.equals(assertion.getAssertionName())) {
                        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                            Tr.debug(TRACE_COMPONENT, "readPolicyType", "preventWLM assertion found");
                        }
                        preventWLM = "true";
                        continue;
                    }
                    if (!TraceComponent.isAnyTracingEnabled() || !TRACE_COMPONENT.isDebugEnabled()) continue;
                    Tr.debug(TRACE_COMPONENT, "Unrecognised assertion encountered: " + assertion.getAssertionName());
                }
            }
        }
        Properties resultProperties = new Properties();
        resultProperties.put("preventWLM", preventWLM);
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "processPolicy", resultProperties);
        }
        return resultProperties;
    }

    boolean validateAttributesForWrite(Properties attributes) {
        String preventWLM = DEFAULT_VALUE;
        if (attributes != null) {
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "writePolicyType", "Properties object not null. Getting value from object.");
            }
            if ((preventWLM = attributes.getProperty("preventWLM")) == null && attributes.size() > 0) {
                if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "writePolicyType", "Unrecognised attribute. Returning false");
                }
                return false;
            }
        }
        return true;
    }
}

