/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsaddressing.jaxws.handlers;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.wsaddressing.integration.WSAddressingBaseService;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import java.security.PrivilegedExceptionAction;
import java.util.Iterator;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.AddressingConstants;
import org.apache.axis2.addressing.AddressingFaultsHelper;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.handlers.AbstractHandler;
import org.apache.axis2.util.JavaUtils;

public class AddressingClusterSupportHandler
extends AbstractHandler
implements AddressingConstants {
    private static final TraceComponent TRACE_COMPONENT = Tr.register(AddressingClusterSupportHandler.class, "WS-Addressing", "com.ibm.ws.wsaddressing.jaxws.CWWARMessages");
    WSAddressingBaseService baseService = null;

    public AddressingClusterSupportHandler() {
        try {
            this.baseService = (WSAddressingBaseService)AccessController.doPrivileged(new PrivilegedExceptionAction<WSAddressingBaseService>(){

                @Override
                public WSAddressingBaseService run() throws Exception {
                    return WsServiceRegistry.getService(this, WSAddressingBaseService.class);
                }
            });
        }
        catch (Exception e) {
            String message = "An Exception occurred attempting to access the WSAddressingBaseService: " + e;
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, message);
            }
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.wsaddressing.jaxws.handlers.AddressingClusterSupportHandler.<init>", "1:72:1.8", this);
        }
    }

    public Handler.InvocationResponse invoke(MessageContext msgContext) throws AxisFault {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "invoke", new Object[]{msgContext});
        }
        Object flag = msgContext.getProperty("IsAddressingProcessed");
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "IS_ADDR_INFO_ALREADY_PROCESSED=" + flag);
        }
        if (JavaUtils.isTrueExplicitly(flag)) {
            this.checkClusterId(msgContext);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "invoke");
        }
        return Handler.InvocationResponse.CONTINUE;
    }

    private void checkClusterId(MessageContext msgContext) throws AxisFault {
        SOAPHeader header;
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "checkClusterId", new Object[]{msgContext});
        }
        if ((header = msgContext.getEnvelope().getHeader()) != null) {
            OMElement routingInformation = null;
            Iterator iter = header.getChildElements();
            while (iter.hasNext() && routingInformation == null) {
                String namespace;
                OMElement next = (OMElement)iter.next();
                if (!"RoutingInformation".equals(next.getLocalName()) || !"http://ucf.wsaddressing.ws.ibm.com".equals(namespace = next.getNamespace().getNamespaceURI())) continue;
                routingInformation = next;
            }
            if (routingInformation != null) {
                boolean isMember;
                String clusterIdentString = null;
                Iterator children = routingInformation.getChildElements();
                while (clusterIdentString == null && children.hasNext()) {
                    Object nextChild = children.next();
                    if (!(nextChild instanceof OMElement)) continue;
                    OMElement ome = (OMElement)nextChild;
                    clusterIdentString = ome.getText();
                }
                if (this.baseService != null && !(isMember = this.baseService.isIdentityValidForCurrentServer(clusterIdentString))) {
                    EndpointReference epr;
                    String message = "This server is not a member of the cluster identified by the wsaucf:RoutingInformation";
                    if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                        Tr.debug(TRACE_COMPONENT, message);
                    }
                    AddressingFaultsHelper.triggerDestinationUnreachableFault(msgContext, (epr = msgContext.getTo()) != null ? epr.getAddress() : null);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "checkClusterId");
        }
    }
}

