/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsaddressing.jaxws.converters;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.wsaddressing.jaxws.converters.EndpointReferenceConverter;
import com.ibm.wsspi.wsaddressing.AttributedURI;
import com.ibm.wsspi.wsaddressing.EndpointReference;
import com.ibm.wsspi.wsaddressing.Relationship;
import java.util.Map;
import java.util.Set;
import javax.xml.ws.WebServiceException;
import org.apache.axis2.client.Options;
import org.apache.axis2.jaxws.core.MessageContext;
import org.apache.axis2.jaxws.spi.migrator.ApplicationContextMigrator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSAContextMigrator
implements ApplicationContextMigrator {
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.wsaddressing.jaxws.CWWARMessages");
    private static final TraceComponent TRACE_COMPONENT = Tr.register(WSAContextMigrator.class, "WS-Addressing", "com.ibm.ws.wsaddressing.jaxws.CWWARMessages");
    private static final String[] INBOUND_PROPERTIES = new String[]{"com.ibm.wsspi.wsaddressing.inbound.Action", "com.ibm.wsspi.wsaddressing.inbound.FaultToEPR", "com.ibm.wsspi.wsaddressing.inbound.FromEPR", "com.ibm.wsspi.wsaddressing.inbound.MessageID", "com.ibm.ws.wsaddressing.InboundNamespace", "com.ibm.wsspi.wsaddressing.inbound.RelationshipSet", "com.ibm.wsspi.wsaddressing.inbound.ReplyToEPR", "com.ibm.wsspi.wsaddressing.inbound.To"};

    @Override
    public void migratePropertiesFromMessageContext(Map<String, Object> userContextMap, MessageContext messageContext) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "migratePropertiesFromMessageContext", new Object[]{userContextMap, messageContext});
        }
        Options options = messageContext.getAxisMessageContext().getOptions();
        for (String property : INBOUND_PROPERTIES) {
            Object o = options.getProperty(property);
            if (o != null) {
                userContextMap.put(property, o);
            }
            if (!TraceComponent.isAnyTracingEnabled() || !TRACE_COMPONENT.isDebugEnabled()) continue;
            Tr.debug(TRACE_COMPONENT, "Property: " + property + " Value: " + o);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "migratePropertiesFromMessageContext");
        }
    }

    @Override
    public void migratePropertiesToMessageContext(Map<String, Object> userContextMap, MessageContext messageContext) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "migratePropertiesToMessageContext", new Object[]{userContextMap, messageContext});
        }
        WSAProperties props = new WSAProperties();
        props.destinationEPR = (EndpointReference)this.getProperty(userContextMap, "com.ibm.websphere.wsaddressing.destinationEPR", EndpointReference.class);
        props.fromEPR = (EndpointReference)this.getProperty(userContextMap, "com.ibm.wsspi.wsaddressing.fromEPR", EndpointReference.class);
        props.replyToEPR = (EndpointReference)this.getProperty(userContextMap, "com.ibm.wsspi.wsaddressing.replyToEPR", EndpointReference.class);
        props.faultToEPR = (EndpointReference)this.getProperty(userContextMap, "com.ibm.wsspi.wsaddressing.faultToEPR", EndpointReference.class);
        props.action = (AttributedURI)this.getProperty(userContextMap, "com.ibm.wsspi.wsaddressing.action", AttributedURI.class);
        props.messageID = (AttributedURI)this.getProperty(userContextMap, "com.ibm.wsspi.wsaddressing.messageId", AttributedURI.class);
        props.version = (String)this.getProperty(userContextMap, "com.ibm.wsspi.wsaddressing.OutboundNamespace", String.class);
        props.relationships = (Set)this.getProperty(userContextMap, "com.ibm.wsspi.wsaddressing.relationshipSet", Set.class);
        props.addMustUnderstand = (Boolean)this.getProperty(userContextMap, "com.ibm.wsspi.wsaddressing.mustunderstand", Boolean.class);
        if (!props.isEmpty()) {
            messageContext.setProperty("WSAProperties", props);
            if (props.destinationEPR != null) {
                try {
                    org.apache.axis2.addressing.EndpointReference axis2EPR = EndpointReferenceConverter.toAxis2(props.destinationEPR);
                    messageContext.getAxisMessageContext().setTo(axis2EPR);
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, this.getClass() + ".migratePropertiesToMessageContext", "1:117:1.3", this);
                    if (TRACE_COMPONENT.isDebugEnabled()) {
                        Tr.debug(TRACE_COMPONENT, "A problem occurred during conversion from an IBM endpoint reference to an Axis2 endpoint reference.", e);
                    }
                    throw new WebServiceException(nls.getString("EPR_CONVERSION_ERROR_CWWAR0102"), (Throwable)e);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "migratePropertiesToMessageContext");
        }
    }

    private Object getProperty(Map<String, Object> userContextMap, String propertyName, Class clazz) {
        Object object = userContextMap.get(propertyName);
        if (object != null && !clazz.isInstance(object)) {
            throw new WebServiceException(nls.getFormattedMessage("INCORRECT_IBM_TYPE_CWWAR0101", new Object[]{propertyName, clazz, object.getClass()}, null));
        }
        return object;
    }

    public static class WSAProperties {
        public static String WSA_PROPERTIES = "WSAProperties";
        EndpointReference destinationEPR;
        EndpointReference fromEPR;
        EndpointReference replyToEPR;
        EndpointReference faultToEPR;
        AttributedURI action;
        AttributedURI messageID;
        Set<Relationship> relationships;
        String version;
        Boolean addMustUnderstand;

        public boolean isEmpty() {
            return this.destinationEPR == null && this.fromEPR == null && this.replyToEPR == null && this.faultToEPR == null && this.action == null && this.messageID == null && this.relationships == null && this.version == null && this.addMustUnderstand == null;
        }
    }
}

