/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsaddressing.jaxws.converters;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.wsaddressing.jaxws.converters.LazyRelationshipImpl;
import com.ibm.ws.wsaddressing.jaxws.converters.RelationshipConverter;
import com.ibm.wsspi.wsaddressing.Relationship;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.xml.soap.SOAPException;
import org.apache.axis2.addressing.RelatesTo;

public class RelationshipSetConverter {
    private static final TraceComponent TRACE_COMPONENT = Tr.register(RelationshipSetConverter.class, "WS-Addressing", "com.ibm.ws.wsaddressing.WSAddressingMessages");

    protected static RelatesTo[] toAxis2(Set ibmRelationshipSet) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "toAxis2", new Object[]{ibmRelationshipSet});
        }
        RelatesTo[] axis2RelatesToArray = null;
        if (ibmRelationshipSet != null) {
            int size = ibmRelationshipSet.size();
            axis2RelatesToArray = new RelatesTo[size];
            Iterator iterator = ibmRelationshipSet.iterator();
            int i = 0;
            while (iterator.hasNext()) {
                Relationship ibmRelationship = (Relationship)iterator.next();
                axis2RelatesToArray[i] = RelationshipConverter.toAxis2(ibmRelationship);
                ++i;
            }
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "toAxis2", axis2RelatesToArray);
        }
        return axis2RelatesToArray;
    }

    protected static Set fromAxis2(RelatesTo[] axis2RelatesToArray) throws URISyntaxException, SOAPException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "fromAxis2", new Object[]{axis2RelatesToArray});
        }
        LinkedHashSet<Relationship> ibmRelationshipSet = null;
        if (axis2RelatesToArray != null) {
            int length = axis2RelatesToArray.length;
            ibmRelationshipSet = new LinkedHashSet<Relationship>(length << 1);
            for (int i = 0; i < length; ++i) {
                RelatesTo axis2RelatesTo = axis2RelatesToArray[i];
                Relationship ibmRelationship = RelationshipConverter.fromAxis2(axis2RelatesTo);
                ibmRelationshipSet.add(ibmRelationship);
            }
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "fromAxis2", ibmRelationshipSet);
        }
        return ibmRelationshipSet;
    }

    protected static Set fromAxis2Lazy(RelatesTo[] axis2RelatesToArray) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "fromAxis2Lazy", new Object[]{axis2RelatesToArray});
        }
        LinkedHashSet<LazyRelationshipImpl> ibmRelationshipSet = null;
        if (axis2RelatesToArray != null) {
            int length = axis2RelatesToArray.length;
            ibmRelationshipSet = new LinkedHashSet<LazyRelationshipImpl>(length << 1);
            for (int i = 0; i < length; ++i) {
                ibmRelationshipSet.add(new LazyRelationshipImpl(axis2RelatesToArray[i]));
            }
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "fromAxis2Lazy", ibmRelationshipSet);
        }
        return ibmRelationshipSet;
    }
}

