/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsaddressing.jaxws.converters;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.wsaddressing.jaxws.converters.RelationshipConverter;
import com.ibm.wsspi.wsaddressing.Relationship;
import java.net.URI;
import java.util.Iterator;
import javax.xml.soap.Name;
import javax.xml.ws.WebServiceException;
import org.apache.axis2.addressing.RelatesTo;

public class LazyRelationshipImpl
implements Relationship {
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.wsaddressing.jaxws.CWWARMessages");
    private static final TraceComponent TRACE_COMPONENT = Tr.register(LazyRelationshipImpl.class, "WS-Addressing", "com.ibm.ws.wsaddressing.jaxws.CWWARMessages");
    RelatesTo _relatesTo;
    Relationship _relationship;
    boolean isConstructed = false;

    public LazyRelationshipImpl(RelatesTo relatesTo) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "LazyRelationshipImpl", relatesTo);
        }
        this._relatesTo = relatesTo;
        if (this._relatesTo == null) {
            throw new IllegalArgumentException("Null RelatesTo not permitted.");
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "LazyRelationshipImpl");
        }
    }

    private void construct() {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "construct");
        }
        try {
            this._relationship = RelationshipConverter.fromAxis2(this._relatesTo);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, this.getClass() + ".construct()", "1:64:1.2", this);
            if (TRACE_COMPONENT.isErrorEnabled()) {
                Tr.error(TRACE_COMPONENT, "A problem occurred during conversion from an Axis2 RelatesTo to an IBM Relationship.", e);
            }
            throw new WebServiceException(nls.getString("URI_CONVERSION_ERROR_CWWAR0104"), (Throwable)e);
        }
        this.isConstructed = true;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "construct");
        }
    }

    public URI getRelationshipType() {
        if (!this.isConstructed) {
            this.construct();
        }
        return this._relationship.getRelationshipType();
    }

    public URI getURI() {
        if (!this.isConstructed) {
            this.construct();
        }
        return this._relationship.getURI();
    }

    public void setRelationshipType(URI arg0) {
        if (!this.isConstructed) {
            this.construct();
        }
        this._relationship.setRelationshipType(arg0);
    }

    public void setURI(URI arg0) {
        if (!this.isConstructed) {
            this.construct();
        }
        this._relationship.setURI(arg0);
    }

    public void addAttribute(Name arg0, String arg1) {
        if (!this.isConstructed) {
            this.construct();
        }
        this._relationship.addAttribute(arg0, arg1);
    }

    public Iterator getAttributeNames() {
        if (!this.isConstructed) {
            this.construct();
        }
        return this._relationship.getAttributeNames();
    }

    public String getAttributeValue(Name arg0) {
        if (!this.isConstructed) {
            this.construct();
        }
        return this._relationship.getAttributeValue(arg0);
    }

    public Object clone() throws CloneNotSupportedException {
        return new LazyRelationshipImpl(this._relatesTo);
    }

    public boolean equals(Object o) {
        if (o instanceof LazyRelationshipImpl) {
            LazyRelationshipImpl other = (LazyRelationshipImpl)o;
            if (!this.isConstructed) {
                this.construct();
            }
            if (!other.isConstructed) {
                other.construct();
            }
            return this._relationship.equals(other._relationship);
        }
        if (o instanceof Relationship) {
            if (!this.isConstructed) {
                this.construct();
            }
            return this._relationship.equals(o);
        }
        return false;
    }

    public int hashCode() {
        if (!this.isConstructed) {
            this.construct();
        }
        return this._relationship.hashCode();
    }
}

