/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsaddressing.jaxws.component;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.ws.exception.ComponentDisabledException;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.runtime.service.MetaDataService;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.ws.wsaddressing.integration.EndpointMapService;
import com.ibm.ws.wsaddressing.integration.Registry;
import com.ibm.ws.wsaddressing.integration.WSAddressingBaseService;
import com.ibm.ws.wsaddressing.jaxws.JaxwsReferenceParameterReader;
import com.ibm.ws.wsaddressing.jaxws.urimap.EndpointMappingListener;
import com.ibm.wsspi.runtime.component.WsComponentImpl;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import com.ibm.wsspi.websvcs.WASAxis2Service;

public class WSAddressingComponentImpl
extends WsComponentImpl {
    private static final TraceComponent TRACE_COMPONENT = Tr.register(WSAddressingComponentImpl.class, "WS-Addressing", "com.ibm.ws.wsaddressing.jaxws.CWWARMessages");

    public WSAddressingComponentImpl() {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "WSAddressingComponentImpl<init>");
        }
        this.setName("WSAddressingComponentImpl");
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "WSAddressingComponentImpl<init>");
        }
    }

    public void initialize(Object obj) throws ComponentDisabledException, ConfigurationWarning, ConfigurationError {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "initialize", new Object[]{obj, this});
        }
        super.initialize(obj);
        if (PlatformHelperFactory.getPlatformHelper().isCRAJvm()) {
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "WebServices Server disabled in z/OS CRA.");
            }
            throw new ComponentDisabledException("WebServices Server disabled in z/OS CRA.");
        }
        if (AdminServiceFactory.getAdminService().getProcessType().equals("DeploymentManager")) {
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "Disabling component in DMGR process.");
            }
            throw new ComponentDisabledException("Disabling component in DMGR process.");
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "initialize");
        }
    }

    public void destroy() {
        super.destroy();
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "destroy");
        }
    }

    public void start() throws RuntimeError, RuntimeWarning {
        super.start();
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "start");
        }
        try {
            WSAddressingBaseService baseService = WsServiceRegistry.getService(this, WSAddressingBaseService.class);
            EndpointMapService endpointMapService = WsServiceRegistry.getService(this, EndpointMapService.class);
            MetaDataService metaDataService = WsServiceRegistry.getService(this, MetaDataService.class);
            WASAxis2Service service = WsServiceRegistry.getService(this, WASAxis2Service.class);
            if (baseService == null || endpointMapService == null || metaDataService == null || service == null) {
                if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "Dependecy component not available", new Object[]{baseService, endpointMapService, metaDataService, service});
                }
            } else {
                EndpointMappingListener listener = new EndpointMappingListener(baseService, endpointMapService, metaDataService);
                service.addJAXWSMetaDataListener(listener);
                JaxwsReferenceParameterReader rpr = new JaxwsReferenceParameterReader();
                Registry.addReferenceParameterReader(rpr);
            }
        }
        catch (Exception e) {
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "start", e);
            }
            throw new RuntimeException(e);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "start");
        }
    }

    public void stop() {
        super.stop();
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "stop");
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "stop");
        }
    }
}

