/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsaddressing.jaxws;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.wsaddressing.ReferenceParameterCreationException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.wsaddressing.integration.ReferenceParameterReader;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.ws.WebServiceException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.jaxws.message.factory.SAAJConverterFactory;
import org.apache.axis2.jaxws.message.util.SAAJConverter;
import org.apache.axis2.jaxws.registry.FactoryRegistry;

public class JaxwsReferenceParameterReader
implements ReferenceParameterReader {
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.wsaddressing.jaxws.CWWARMessages");
    private static final TraceComponent TRACE_COMPONENT = Tr.register(JaxwsReferenceParameterReader.class, "WS-Addressing", "com.ibm.ws.wsaddressing.jaxws.CWWARMessages");
    private static final String CLASSNAME = "com.ibm.ws.wsaddressing.JaxwsReferenceParameterReader";
    private static ThreadLocal<MessageContext> currentThreadMessageContext = new ThreadLocal();
    private static QName wsaIsRefParamQN = new QName("http://www.w3.org/2005/08/addressing", "IsReferenceParameter");
    private static SAAJConverterFactory f = (SAAJConverterFactory)FactoryRegistry.getFactory(SAAJConverterFactory.class);
    private static SAAJConverter converter = f.getSAAJConverter();

    public String getReferenceParameterFromMessageContext(QName name) throws ReferenceParameterCreationException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getReferenceParameterFromMessageContext", new Object[]{name});
        }
        String result = null;
        MessageContext msgCtx = JaxwsReferenceParameterReader.getCurrentThreadsContext();
        if (msgCtx == null) {
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "getReferenceParameterFromMessageContext", "MessageContext is null");
            }
        } else {
            OMElement omElement = this.extractOMElementFromOMContext(msgCtx, name);
            if (omElement != null) {
                result = omElement.getText();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getReferenceParameterFromMessageContext", result);
        }
        return result;
    }

    public SOAPElement getSOAPElementReferenceParameterFromMessageContext(QName name) throws ReferenceParameterCreationException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getSOAPElementReferenceParameterFromMessageContext", new Object[]{name});
        }
        SOAPElement result = null;
        MessageContext msgCtx = JaxwsReferenceParameterReader.getCurrentThreadsContext();
        if (msgCtx == null) {
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "getSOAPElementReferenceParameterFromMessageContext", "MessageContext is null");
            }
        } else {
            OMElement omElement = this.extractOMElementFromOMContext(msgCtx, name);
            if (omElement != null) {
                try {
                    SOAPFactory sf = SOAPFactory.newInstance();
                    SOAPElement se = sf.createElement("parent");
                    result = converter.toSAAJ(omElement, se, sf);
                }
                catch (SOAPException e) {
                    String param = ((Object)omElement).toString();
                    FFDCFilter.processException(e, CLASSNAME, "1:1.8:148");
                    if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                        Tr.debug(TRACE_COMPONENT, "Unable to convert Axiom Element " + param, (Object)e);
                    }
                    throw new ReferenceParameterCreationException(nls.getFormattedMessage("SOAPELEMENT_CREATION_EXCEPTION_CWWAR0001", new Object[]{param}, null), e);
                }
                catch (WebServiceException e1) {
                    String param = ((Object)omElement).toString();
                    FFDCFilter.processException(e1, CLASSNAME, "1:1.8:156");
                    if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                        Tr.debug(TRACE_COMPONENT, "Unable to convert Axiom Element " + param, (Object)e1);
                    }
                    throw new ReferenceParameterCreationException(nls.getFormattedMessage("SOAPELEMENT_CREATION_EXCEPTION_CWWAR0001", new Object[]{param}, null), e1);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getSOAPElementReferenceParameterFromMessageContext", result);
        }
        return result;
    }

    private static MessageContext getCurrentThreadsContext() {
        return currentThreadMessageContext.get();
    }

    public static void setThreadLocalMessageContext(MessageContext context) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "setThreadLocalMessageContext", context);
        }
        currentThreadMessageContext.set(context);
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "setThreadLocalMessageContext");
        }
    }

    public static void removeThreadLocalMessageContext() {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "removeThreadLocalMessageContext");
        }
        currentThreadMessageContext.set(null);
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "removeThreadLocalMessageContext");
        }
    }

    private OMElement extractOMElementFromOMContext(MessageContext msgContext, QName referenceParameterQName) throws ReferenceParameterCreationException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "extractOMElementFromOMContext", new Object[]{msgContext, referenceParameterQName});
        }
        if (msgContext == null) {
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "extractOMElementFromOMContext", "MessageContext is null. ");
            }
            return null;
        }
        if (referenceParameterQName == null) {
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "extractOMElementFromOMContext", "QName for ReferenceParameter is null.");
            }
            return null;
        }
        String wsaNamespace = (String)msgContext.getProperty("WSAddressingVersion");
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "extractOMElementFromOMContext", "WSANamespace retrieved from msgCtx " + wsaNamespace);
        }
        if (wsaNamespace == null) {
            wsaNamespace = "http://www.w3.org/2005/08/addressing";
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "extractOMElementFromOMContext", "Set default WSANamespace " + wsaNamespace);
            }
        } else if (!"http://schemas.xmlsoap.org/ws/2004/08/addressing".equals(wsaNamespace) && !"http://www.w3.org/2005/08/addressing".equals(wsaNamespace)) {
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "extractOMElementFromOMContext", "Unable to recognize WSA Namespace " + wsaNamespace);
            }
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "extractOMElementFromOMContext", "Unrecognizable WSA namespace.");
            }
            throw new ReferenceParameterCreationException(nls.getString("UNRECOGNIZED_WSA_NAMESPACE_CWWAR0002"));
        }
        SOAPHeader soapHeader = null;
        SOAPEnvelope soapEnvelope = msgContext.getEnvelope();
        if (soapEnvelope == null) {
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "extractOMElementFromOMContext", "Cannot find SOAPEnvelope in messageContext. Throwing ReferenceParameterCreationException");
            }
            throw new ReferenceParameterCreationException(nls.getString("MISSING_SOAP_ENVELOPE_CWWAR0003"));
        }
        soapHeader = soapEnvelope.getHeader();
        if (soapHeader == null) {
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "extractOMElementFromOMContext", "SOAP Header from Envelope is null.");
            }
            return null;
        }
        OMElement referenceParameterValue = null;
        Iterator referenceParameterIterator = soapHeader.getChildrenWithName(referenceParameterQName);
        if (referenceParameterIterator.hasNext()) {
            String attrVal;
            OMElement omElement = (OMElement)referenceParameterIterator.next();
            boolean isRefParam = false;
            isRefParam = wsaNamespace.equals("http://www.w3.org/2005/08/addressing") ? ((attrVal = omElement.getAttributeValue(wsaIsRefParamQN)) != null ? Boolean.valueOf(attrVal) : false) : true;
            if (isRefParam) {
                if (omElement.getNamespace() != null) {
                    if (omElement.getNamespace().getNamespaceURI().equals(referenceParameterQName.getNamespaceURI())) {
                        referenceParameterValue = omElement;
                    } else if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                        Tr.debug(TRACE_COMPONENT, "extractOMElementFromOMContext: Namespace of found ReferenceParameter does not match the search criteria: " + referenceParameterQName.getNamespaceURI() + ", " + omElement.getNamespace().getNamespaceURI(), referenceParameterQName);
                    }
                } else {
                    referenceParameterValue = omElement;
                }
            }
        }
        if (referenceParameterIterator.hasNext()) {
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "extractOMElementFromOMContext: Multiple reference parameters exist with the same name", referenceParameterQName);
            }
            throw new ReferenceParameterCreationException(nls.getString("PARAMETER_NAME_CLASH_CWWAR0004"));
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "extractOMElementFromOMContext", referenceParameterValue);
        }
        return referenceParameterValue;
    }
}

