/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsaddressing.component;

import com.ibm.CORBA.iiop.ORB;
import com.ibm.ejs.oa.EJSORB;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.http.Alias;
import com.ibm.ws.http.VirtualHost;
import com.ibm.ws.runtime.service.Server;
import com.ibm.ws.runtime.service.VirtualHostMgr;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.wlm.ClusterIdentityHelper;
import com.ibm.ws.wsaddressing.HAResource;
import com.ibm.ws.wsaddressing.UCFRoutingHelper;
import com.ibm.ws.wsaddressing.integration.WSAddressingBaseService;
import com.ibm.ws.wsaddressing.urimap.MetaDataChannelHelper;
import com.ibm.ws.wsaddressing.urimap.WebMetaDataLoader;
import com.ibm.ws.wsaddressing.urimap.WebModuleData;
import com.ibm.ws.wsaddressing.urimap.security.SecurityHelperFactory;
import com.ibm.wsspi.cluster.ClusterMemberService;
import com.ibm.wsspi.cluster.ClusterService;
import com.ibm.wsspi.cluster.ClusterServiceFactory;
import com.ibm.wsspi.cluster.Identity;
import com.ibm.wsspi.cluster.adapter.IdentityMapping;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import java.rmi.Remote;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.webapplication.WebApp;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSAddressingBaseServiceImpl
implements WSAddressingBaseService {
    private static TraceComponent TRACE_COMPONENT = Tr.register(WSAddressingBaseService.class, "WS-Addressing", "com.ibm.ws.wsaddressing.WSAddressingMessages");
    private static WSAddressingBaseService instance;

    private WSAddressingBaseServiceImpl() {
    }

    public static WSAddressingBaseService getInstance() {
        if (instance == null) {
            instance = new WSAddressingBaseServiceImpl();
        }
        return instance;
    }

    @Override
    public WSAddressingBaseService.SecurityHelper createSecurityHelper(WebApp webApp) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "createSecurityHelper", webApp);
        }
        WSAddressingBaseService.SecurityHelper result = SecurityHelperFactory.createSecurityHelper(webApp);
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "createSecurityHelper", result);
        }
        return result;
    }

    @Override
    public String getFragileIdentity() {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getFragileIdentity", this);
        }
        Identity identity = this.getStaticSingletonClusterId();
        String result = this.getClusterIdAsString(identity);
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getFragileIdentity", result);
        }
        return result;
    }

    private Identity getStaticSingletonClusterId() {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getStaticSingletonClusterId");
        }
        Identity result = null;
        try {
            result = (Identity)AccessController.doPrivileged(new PrivilegedExceptionAction<Identity>(){

                @Override
                public Identity run() throws Exception {
                    Server process = WSAddressingBaseServiceImpl.this.getCurrentServer();
                    String cellName = process.getCellName();
                    String nodeName = process.getNodeName();
                    String processName = process.getName();
                    return IdentityMapping.getServerInstanceCluster(cellName, nodeName, processName);
                }
            });
        }
        catch (Exception e) {
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "getStaticSingletonClusterId", "Unable to obtain clusterId :" + e);
            }
            FFDCFilter.processException(e, this.getClass().toString(), "1:118:1.6");
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getStaticSingletonClusterId", result);
        }
        return result;
    }

    @Override
    public String getWLMClusterIdentity() {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getWLMClusterIdentity", this);
        }
        Identity containingClusterIdentity = null;
        try {
            Server process = this.getCurrentServer();
            String cellName = process.getCellName();
            String clusterName = process.getClusterName();
            if (cellName != null && clusterName != null) {
                containingClusterIdentity = IdentityMapping.getApplicationServerCluster(cellName, clusterName);
            } else if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "getWLMClusterIdentity", "Unable to obtain clusterId. Either the cellName or the clusterName was null. cellName=" + cellName + " clusterName=" + clusterName);
            }
        }
        catch (Exception e) {
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "getWLMClusterIdentity", "Unable to obtain clusterId :" + e);
            }
            FFDCFilter.processException(e, this.getClass().toString(), "1:145:1.6");
        }
        String result = this.getClusterIdAsString(containingClusterIdentity);
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getWLMClusterIdentity", result);
        }
        return result;
    }

    @Override
    public String getHAIdentity(Object haSupportedObject) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getHAIdentity", new Object[]{haSupportedObject, this});
        }
        String result = null;
        if (haSupportedObject instanceof Remote) {
            if (haSupportedObject != null) {
                Identity identity = ClusterIdentityHelper.getClusterIdentity((Remote)((Remote)haSupportedObject), (ORB)EJSORB.getORBInstance());
                result = this.getClusterIdAsString(identity);
            }
        } else if (haSupportedObject instanceof HAResource) {
            Identity identity = ((HAResource)haSupportedObject).getAffinityKey();
            result = this.getClusterIdAsString(identity);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getHAIdentity", result);
        }
        return result;
    }

    private String getClusterIdAsString(Identity affinityKey) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getClusterIdAsString", affinityKey);
        }
        String clusterIDAsString = null;
        if (affinityKey != null) {
            ClusterService clusterService = ClusterServiceFactory.getClusterService();
            if (clusterService == null) {
                if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.error(TRACE_COMPONENT, "Unable to acquire cluster Service");
                }
                if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                    Tr.exit(TRACE_COMPONENT, "getClusterIdAsString", null);
                }
                return null;
            }
            clusterIDAsString = clusterService.identityToString(affinityKey);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getClusterIdAsString", clusterIDAsString);
        }
        return clusterIDAsString;
    }

    @Override
    public WSAddressingBaseService.Prefix getPrefix(String protocol, String virtualHostName) {
        WSAddressingBaseService.Prefix result;
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getBestPrefix", new Object[]{protocol, virtualHostName});
        }
        if ((result = this.getFirstMatchingPrefix(MetaDataChannelHelper.getProxyPortList(), protocol, virtualHostName)) == null) {
            result = this.getFirstMatchingPrefix(MetaDataChannelHelper.getWebContainerPortList(), protocol, virtualHostName);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getBestPrefix", result);
        }
        return result;
    }

    private WSAddressingBaseService.Prefix getFirstMatchingPrefix(List<WSAddressingBaseService.Prefix> prefixes, String scheme, String virtualHostName) {
        WSAddressingBaseService.Prefix result;
        block8: {
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                Tr.entry(TRACE_COMPONENT, "getFirstMatchingPrefix", new Object[]{prefixes, scheme, virtualHostName, this});
            }
            result = null;
            try {
                VirtualHostMgr vhm = WsServiceRegistry.getService(this, VirtualHostMgr.class);
                VirtualHost vh = vhm.getVirtualHost(virtualHostName);
                if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "VirtualHost obtained: ", vh);
                }
                if (vh != null) {
                    Alias[] has = vh.getAliases();
                    for (WSAddressingBaseService.Prefix prefix : prefixes) {
                        if (!scheme.equals(prefix.getProtocol())) continue;
                        boolean valid = false;
                        for (Alias alias : has) {
                            if (!"*".equals(alias.getHostname()) && !prefix.getHost().equals(alias.getHostname()) || !"*".equals(alias.getPort()) && !prefix.getPort().equals(alias.getPort())) continue;
                            valid = true;
                            break;
                        }
                        if (!valid) continue;
                        result = prefix;
                    }
                }
            }
            catch (Exception e) {
                FFDCFilter.processException(e, this.getClass().getName() + ".getFirstMatchingPrefix", "1:247:1.6");
                if (!TraceComponent.isAnyTracingEnabled() || !TRACE_COMPONENT.isDebugEnabled()) break block8;
                Tr.debug(TRACE_COMPONENT, "getFirstMatchingPrefix", "Exception caught whilst accessing the VirtualHostMgr: " + e.getMessage());
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getFirstMatchingPrefix", result);
        }
        return result;
    }

    @Override
    public WSAddressingBaseService.WebModuleData loadWebModuleData(ModuleFile servicesModuleFile) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "loadWebModuleData", new Object[]{servicesModuleFile, this});
        }
        WebModuleData result = WebMetaDataLoader.load(servicesModuleFile);
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "loadWebModuleData", result);
        }
        return result;
    }

    @Override
    public boolean isIdentityValidForCurrentServer(String clusterIdentityString) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "isIdentityValidForCurrentServer", new Object[]{clusterIdentityString, this});
        }
        boolean isMember = false;
        try {
            Identity identity = (Identity)UCFRoutingHelper.getClusterIdentityFromString(clusterIdentityString);
            ClusterMemberService cms = WsServiceRegistry.getService(this, ClusterMemberService.class);
            isMember = cms.getServerClusterContextListener().validateClusterResidency(identity);
        }
        catch (Exception e) {
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "isIdentityValidForCurrentServer", "Unable to obtain ClusterMemberService :" + e);
            }
            FFDCFilter.processException(e, this.getClass().toString(), "1:274:1.6");
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "isIdentityValidForCurrentServer", isMember);
        }
        return isMember;
    }

    @Override
    public Server getCurrentServer() {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getCurrentServer", this);
        }
        Server process = null;
        try {
            process = (Server)AccessController.doPrivileged(new PrivilegedExceptionAction<Server>(){

                @Override
                public Server run() throws Exception {
                    return WsServiceRegistry.getService(this, Server.class);
                }
            });
        }
        catch (Exception e) {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "getCurrentServer", "Unable to obtain server :" + e);
            }
            FFDCFilter.processException(e, this.getClass().toString(), "1:298:1.6");
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getCurrentServer", process);
        }
        return process;
    }
}

