/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsaddressing;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.cluster.Identity;
import java.util.Map;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UCFRoutingHelper {
    private static UCFRoutingHelperInterface _delegatedHelper = null;
    private static final String CONCRETE_HELPER_CLASSNAME = "com.ibm.ws.wsaddressing.UCFRoutingHelperImpl";
    private static final String CLASSNAME = "com.ibm.ws.wsaddressing.UCFRoutingHelper";
    private static final TraceComponent TRACE_COMPONENT = Tr.register(UCFRoutingHelper.class, "WS-Addressing", "com.ibm.ws.wsaddressing.WSAddressingMessages");
    public static final String HEADER_IDENTITY = "com.ibm.ws.wsaddressing.header.identity";
    public static final String HEADER_IDENTITY_STRING = "com.ibm.ws.wsaddressing.header.identityString";
    public static final String HEADER_ROUTING_TYPE = "com.ibm.ws.wsaddressing.header.routingType";
    public static final String ROUTING_TYPE_HA = "HA";
    public static final String ROUTING_TYPE_WLM = "WLM";
    public static final String ROUTING_TYPE_FRAGILE = "Fragile";
    public static final String HEADER_VIRTUAL_HOST_NAME = "com.ibm.ws.wsaddressing.header.virtualHostName";
    public static final String HEADER_INTERMEDIARY_PRESENT = "com.ibm.ws.wsaddressing.header.intermediaryPresent";

    public static String getVirtualHostForDestinationEPR(MessageContext messageContext) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getVirtualHostForDestinationEPR", messageContext);
        }
        String vHost = _delegatedHelper.getVirtualHostForDestinationEPR(messageContext);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getVirtualHostForDestinationEPR", vHost);
        }
        return vHost;
    }

    public static Identity getWLMClusterIdForDestinationEPR(MessageContext messageContext) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getWLMClusterIdForDestinationEPR", messageContext);
        }
        Identity returnedIdentity = _delegatedHelper.getWLMClusterIdForDestinationEPR(messageContext);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getWLMClusterIdForDestinationEPR", returnedIdentity);
        }
        return returnedIdentity;
    }

    public static Identity getHAClusterIdForDestinationEPR(MessageContext messageContext) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getHAClusterIdForDestinationEPR", messageContext);
        }
        Identity returnedIdentity = _delegatedHelper.getHAClusterIdForDestinationEPR(messageContext);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getHAClusterIdForDestinationEPR", returnedIdentity);
        }
        return returnedIdentity;
    }

    public static boolean isDestinationEPRFragile(MessageContext messageContext) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "isDestinationEPRFragile", messageContext);
        }
        boolean isFragile = _delegatedHelper.concreteIsDestinationEPRFragile(messageContext);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "isDestinationEPRFragile", isFragile);
        }
        return isFragile;
    }

    public static Identity getWLMClusterIdForProxy(SOAPMessageContext messageContext) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getWLMClusterIdForProxy", messageContext);
        }
        Identity returnedIdentity = _delegatedHelper.getWLMClusterIdForProxy(messageContext);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getWLMClusterIdForProxy", returnedIdentity);
        }
        return returnedIdentity;
    }

    public static String getVirtualHostForProxy(SOAPMessageContext messageContext) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getVirtualHostForProxy", messageContext);
        }
        String virtualHost = _delegatedHelper.getVirtualHostForProxy(messageContext);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getVirtualHostForProxy", virtualHost);
        }
        return virtualHost;
    }

    public static Identity getHAClusterIdForProxy(SOAPMessageContext messageContext) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getHAClusterIdForProxy", messageContext);
        }
        Identity returnedIdentity = _delegatedHelper.getHAClusterIdForProxy(messageContext);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getHAClusterIdForProxy", returnedIdentity);
        }
        return returnedIdentity;
    }

    public static String getHAClusterIdStrForEndpoint(SOAPMessageContext messageContext) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getHAClusterIdStrForEndpoint", messageContext);
        }
        String returnedIdentityStr = _delegatedHelper.getHAClusterIdStrForEndpoint(messageContext);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getHAClusterIdStrForEndpoint", returnedIdentityStr);
        }
        return returnedIdentityStr;
    }

    public static boolean isMarkedFragileForProxy(SOAPMessageContext messageContext) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "isMarkedFragileForProxy", messageContext);
        }
        boolean isFragile = _delegatedHelper.concreteIsMarkedFragileForProxy(messageContext);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "isMarkedFragileForProxy", isFragile);
        }
        return isFragile;
    }

    public static Identity getFragileClusterIdForDestinationEPR(MessageContext messageContext) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getFragileClusterIdForDestinationEPR", messageContext);
        }
        Identity returnedIdentity = _delegatedHelper.getFragileClusterIdForDestinationEPR(messageContext);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getFragileClusterIdForDestinationEPR", returnedIdentity);
        }
        return returnedIdentity;
    }

    public static Identity getFragileClusterIdForProxy(SOAPMessageContext messageContext) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getFragileClusterIdForProxy", messageContext);
        }
        Identity returnedIdentity = _delegatedHelper.getFragileClusterIdForProxy(messageContext);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getFragileClusterIdForProxy", returnedIdentity);
        }
        return returnedIdentity;
    }

    public static Identity getClusterIdentityFromSOAPElementText(SOAPElement soapElement) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getClusterIdentityFromSOAPElementText", soapElement);
        }
        Identity returnedIdentity = _delegatedHelper.getClusterIdentityFromSOAPElementText(soapElement);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getClusterIdentityFromSOAPElementText", returnedIdentity);
        }
        return returnedIdentity;
    }

    public static Object getClusterIdentityFromString(String clusterIdentityString) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getClusterIdentityFromString", clusterIdentityString);
        }
        Object returnedIdentity = _delegatedHelper.getClusterIdentityFromString(clusterIdentityString);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getClusterIdentityFromString", returnedIdentity);
        }
        return returnedIdentity;
    }

    public static Map<String, Object> extractRoutingInformation(SOAPMessage message) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "extractRoutingInformation", message);
        }
        Map<String, Object> map = _delegatedHelper.extractRoutingInformation(message);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "extractRoutingInformation", map);
        }
        return map;
    }

    private static void traceAndFFDCException(Exception e) {
        String exceptionName = e.getClass().getName();
        String exceptionMessage = e.getMessage();
        String message = "Caught a " + exceptionName + ": " + exceptionMessage + " when trying to create a new " + CONCRETE_HELPER_CLASSNAME + " instance within a static initializer";
        Tr.warning(TRACE_COMPONENT, message);
        FFDCFilter.processException(e, CLASSNAME, "1:398:1.16");
    }

    static {
        try {
            _delegatedHelper = (UCFRoutingHelperInterface)Class.forName(CONCRETE_HELPER_CLASSNAME).newInstance();
        }
        catch (InstantiationException e) {
            UCFRoutingHelper.traceAndFFDCException(e);
        }
        catch (IllegalAccessException e) {
            UCFRoutingHelper.traceAndFFDCException(e);
        }
        catch (ClassNotFoundException e) {
            UCFRoutingHelper.traceAndFFDCException(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static interface UCFRoutingHelperInterface {
        public Identity getWLMClusterIdForDestinationEPR(MessageContext var1);

        public Identity getHAClusterIdForDestinationEPR(MessageContext var1);

        public Identity getFragileClusterIdForDestinationEPR(MessageContext var1);

        public boolean concreteIsDestinationEPRFragile(MessageContext var1);

        public Identity getWLMClusterIdForProxy(SOAPMessageContext var1);

        public String getVirtualHostForProxy(SOAPMessageContext var1);

        public Identity getHAClusterIdForProxy(SOAPMessageContext var1);

        public String getHAClusterIdStrForEndpoint(SOAPMessageContext var1);

        public Identity getFragileClusterIdForProxy(SOAPMessageContext var1);

        public boolean concreteIsMarkedFragileForProxy(SOAPMessageContext var1);

        public Identity getClusterIdentityFromSOAPElementText(SOAPElement var1);

        public Object getClusterIdentityFromString(String var1);

        public String getVirtualHostForDestinationEPR(MessageContext var1);

        public Map<String, Object> extractRoutingInformation(SOAPMessage var1);
    }
}

