/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsaddressing;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.wsaddressing.EndpointReferenceCreationException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.wsaddressing.EndpointReferenceImpl;
import com.ibm.ws.wsaddressing.binders.EndpointReferenceTypeBinder;
import com.ibm.ws.wsaddressing.integration.EndpointMap;
import com.ibm.ws.wsaddressing.integration.Registry;
import com.ibm.ws.wsaddressing.integration.WSAddressingBaseService;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import com.ibm.wsspi.wsaddressing.AttributedURI;
import com.ibm.wsspi.wsaddressing.EndpointReference;
import com.ibm.wsspi.wsaddressing.EndpointReferenceManager;
import com.ibm.wsspi.wsaddressing.Metadata;
import com.ibm.wsspi.wsaddressing.ServiceName;
import com.ibm.wsspi.wsaddressing.URIGenerationException;
import com.ibm.wsspi.wsaddressing.WSAddressingFactory;
import java.net.URI;
import java.rmi.Remote;
import java.security.PrivilegedExceptionAction;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;

public class EndpointReferenceManagerImpl
extends EndpointReferenceManager {
    private static final String CLASSNAME = "com.ibm.ws.wsaddressing.EndpointReferenceManagerImpl";
    private static final TraceComponent TRACE_COMPONENT = Tr.register(EndpointReferenceManagerImpl.class, "WS-Addressing", "com.ibm.ws.wsaddressing.WSAddressingMessages");
    WSAddressingBaseService baseService;

    public EndpointReferenceManagerImpl() {
        try {
            this.baseService = (WSAddressingBaseService)AccessController.doPrivileged(new PrivilegedExceptionAction<WSAddressingBaseService>(){

                @Override
                public WSAddressingBaseService run() throws Exception {
                    return WsServiceRegistry.getService(this, WSAddressingBaseService.class);
                }
            });
        }
        catch (Exception e) {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "EndpointReferenceManagerImpl", "Unable to obtain WSAddressingBaseService :" + e);
            }
            FFDCFilter.processException(e, CLASSNAME, "1:1.53:122");
        }
    }

    public com.ibm.websphere.wsaddressing.EndpointReference createConcreteEndpointReference(QName serviceName, String endpointName) throws EndpointReferenceCreationException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Object[] params = new Object[]{serviceName, endpointName};
            Tr.entry(TRACE_COMPONENT, "createConcreteEndpointReference", params);
        }
        if (serviceName == null) {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "createConcreteEndpointReference", "Service passed to createEndpointReference was null");
            }
            throw new EndpointReferenceCreationException("Service Name specified was null");
        }
        if (endpointName == null) {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "createConcreteEndpointReference", "Port name passed to createEndpointReference was null");
            }
            throw new EndpointReferenceCreationException("Port name specified was null");
        }
        String serviceDescriptionName = serviceName.getLocalPart();
        QName port = new QName(serviceName.getNamespaceURI(), endpointName);
        EndpointMap endpointMap = Registry.getCombinedEndpointMap();
        URI uri = null;
        try {
            uri = endpointMap.getSOAPAddressForPort(serviceDescriptionName, port);
        }
        catch (URIGenerationException e) {
            String message = "Check the serviceName and endpointName.  An EndpointReferenceCreationException was thrown. " + e.getMessage();
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "createConcreteEndpointReference", message);
            }
            FFDCFilter.processException(e, CLASSNAME, "1:181:1.53");
            throw new EndpointReferenceCreationException(e);
        }
        if (uri == null) {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "createConcreteEndpointReference", "URI for port could not be found");
            }
            throw new EndpointReferenceCreationException("URI for port could not be found");
        }
        AttributedURI attributedURI = WSAddressingFactory.createAttributedURI(uri);
        EndpointReferenceImpl endpointReference = null;
        if (attributedURI == null) {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "createConcreteEndpointReference", "AttributedURI is null");
            }
            throw new EndpointReferenceCreationException("AttributedURI is null");
        }
        if (attributedURI.getURI() == null) {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "createConcreteEndpointReference", "AttributedURI is null");
            }
            throw new EndpointReferenceCreationException("URI in AttributedURI is null");
        }
        try {
            endpointReference = (EndpointReferenceImpl)this.createConcreteEndpointReference(attributedURI);
            if (serviceName != null) {
                Metadata metadata = WSAddressingFactory.createMetadata();
                ServiceName svrNam = WSAddressingFactory.createServiceName(serviceName);
                if (endpointName != null) {
                    svrNam.setEndpointName(endpointName);
                }
                metadata.setServiceName(svrNam);
                endpointReference.setMetadata(metadata);
            }
        }
        catch (EndpointReferenceCreationException e) {
            String message = "Check the serviceName and endpointName.  An EndpointReferenceCreationException was thrown. " + e.getMessage();
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "createConcreteEndpointReference", message);
            }
            FFDCFilter.processException(e, CLASSNAME, "1:236:1.53");
            throw new EndpointReferenceCreationException(e);
        }
        boolean intermediaryConfigured = false;
        String virtualHostName = null;
        intermediaryConfigured = endpointMap.intermediaryConfigured(serviceDescriptionName, port);
        virtualHostName = endpointMap.getVirtualHostForPort(serviceDescriptionName, port);
        if (intermediaryConfigured) {
            endpointReference.addIntermediaryPresent();
        }
        endpointReference.setVirtualHostName(virtualHostName);
        boolean wlmRequired = endpointMap.workLoadManaged(serviceDescriptionName, port);
        if (wlmRequired) {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "createConcreteEndpointReference", "Set wlm details");
            }
            if (this.baseService != null) {
                String wlmClusterId = this.baseService.getWLMClusterIdentity();
                if (TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "createConcreteEndpointReference", wlmClusterId);
                }
                if (wlmClusterId != null) {
                    endpointReference.addWLMRoutingInformation(wlmClusterId);
                }
            }
        } else if (TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "createConcreteEndpointReference", "No setting of wlm details");
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "createConcreteEndpointReference", endpointReference);
        }
        return endpointReference;
    }

    protected com.ibm.websphere.wsaddressing.EndpointReference createConcreteEndpointReference(QName serviceName, String endpointName, Remote statefulSessionBean) throws EndpointReferenceCreationException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Object[] params = new Object[]{serviceName, endpointName, statefulSessionBean};
            Tr.entry(TRACE_COMPONENT, "createConcreteEndpointReference", params);
        }
        EndpointReferenceImpl endpointReference = (EndpointReferenceImpl)this.createConcreteEndpointReference(serviceName, endpointName);
        endpointReference.setSFSBAffinity(statefulSessionBean);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "createConcreteEndpointReference", endpointReference);
        }
        return endpointReference;
    }

    public EndpointReference createConcreteEndpointReference(SOAPElement soapElement) throws EndpointReferenceCreationException {
        EndpointReference endpointReference = null;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "createConcreteEndpointReference", soapElement);
        }
        EndpointReferenceTypeBinder endpointReferenceCustomBinder = new EndpointReferenceTypeBinder();
        try {
            endpointReference = (EndpointReference)endpointReferenceCustomBinder.deserialize(soapElement, null);
        }
        catch (SOAPException e) {
            FFDCFilter.processException(e, EndpointReferenceManagerImpl.class.getName() + ".EndpointReferenceManagerImpl", "1:340:1.53");
            throw new EndpointReferenceCreationException("SOAPException thrown during de-serialization of EPR", e);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "createConcreteEndpointReference", endpointReference);
        }
        return endpointReference;
    }

    protected EndpointReference createConcreteEndpointReference(URI address) throws EndpointReferenceCreationException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "createConcreteEndpointReference", address);
        }
        if (address == null) {
            throw new EndpointReferenceCreationException("Unable to create EndpointReference: Null address passed to method");
        }
        EndpointReference epr = null;
        AttributedURI attributedAddress = WSAddressingFactory.createAttributedURI(address);
        epr = this.createConcreteEndpointReference(attributedAddress);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "createConcreteEndpointReference", epr);
        }
        return epr;
    }

    protected EndpointReference createConcreteEndpointReference(AttributedURI address) throws EndpointReferenceCreationException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "createConcreteEndpointReference", address);
        }
        EndpointReferenceImpl epr = null;
        if (address == null) {
            throw new EndpointReferenceCreationException("Unable to create EndpointReference: Null address passed to method");
        }
        epr = new EndpointReferenceImpl(address);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "createConcreteEndpointReference", epr);
        }
        return epr;
    }

    protected URI getConcreteURIForEndpoint(QName serviceName, String endpointName) throws URIGenerationException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Object[] params = new Object[]{serviceName, endpointName};
            Tr.entry(TRACE_COMPONENT, "getConcreteURIForEndpoint", params);
        }
        if (serviceName == null) {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "getConcreteURIForEndpoint", "Service passed to getConcreteURIForEndpoint was null");
            }
            throw new URIGenerationException("Service Name specified was null");
        }
        if (endpointName == null) {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "getConcreteURIForEndpoint", "Port name passed to getConcreteURIForEndpoint was null");
            }
            throw new URIGenerationException("Port name specified was null");
        }
        String serviceDescriptionName = serviceName.getLocalPart();
        QName port = new QName(serviceName.getNamespaceURI(), endpointName);
        URI uri = Registry.getCombinedEndpointMap().getSOAPAddressForPort(serviceDescriptionName, port);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getConcreteURIForEndpoint", uri);
        }
        return uri;
    }
}

