/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsaddressing;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.wsspi.wsaddressing.AttributedType;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.soap.Name;

public abstract class AttributedTypeImpl
implements AttributedType,
Cloneable {
    private Map<Name, String> _attributes = null;
    private static final TraceComponent TRACE_COMPONENT = Tr.register(AttributedTypeImpl.class, "WS-Addressing", "com.ibm.ws.wsaddressing.WSAddressingMessages");

    public AttributedTypeImpl() {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "AttributedTypeImpl");
        }
        this._attributes = new HashMap<Name, String>();
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "AttributedTypeImpl");
        }
    }

    public String getAttributeValue(Name attributeName) {
        return this._attributes.get(attributeName);
    }

    public void addAttribute(Name attributeName, String value) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "addAttribute", new Object[]{attributeName, value});
        }
        this._attributes.put(attributeName, value);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "addAttribute");
        }
    }

    public Iterator getAttributeNames() {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getAttributeNames");
        }
        Iterator<Name> itForAttributeNames = this._attributes.keySet().iterator();
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getAttributeNames", itForAttributeNames);
        }
        return itForAttributeNames;
    }

    public String toString() {
        StringBuffer stringbuffer = new StringBuffer();
        for (Map.Entry<Name, String> entry : this._attributes.entrySet()) {
            Name attributeName = entry.getKey();
            if (attributeName == null) {
                stringbuffer.append("([null],");
            } else {
                stringbuffer.append("(" + attributeName + ",");
            }
            String attributeValue = entry.getValue();
            if (attributeValue == null) {
                stringbuffer.append("[null] )");
                continue;
            }
            stringbuffer.append(attributeValue + ")");
        }
        return stringbuffer.toString();
    }

    public boolean equals(Object object) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "equals", object);
        }
        boolean equals = true;
        if (object != null && object instanceof AttributedTypeImpl) {
            AttributedType yourAttributedType = (AttributedType)object;
            for (Map.Entry<Name, String> entry : this._attributes.entrySet()) {
                if (entry.getKey() == null) {
                    if (this.checkEquality(entry.getValue(), yourAttributedType.getAttributeValue(null))) continue;
                    equals = false;
                    break;
                }
                if (entry.getKey().getLocalName().startsWith("xmlns:") || this.checkEquality(entry.getValue(), yourAttributedType.getAttributeValue(entry.getKey()))) continue;
                equals = false;
                break;
            }
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "equals", Boolean.toString(equals));
        }
        return equals;
    }

    private boolean checkEquality(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    public Object clone() throws CloneNotSupportedException {
        AttributedTypeImpl ati = (AttributedTypeImpl)super.clone();
        Iterator attributeNames = this.getAttributeNames();
        while (attributeNames.hasNext()) {
            Name name = (Name)attributeNames.next();
            ati.addAttribute(name, this.getAttributeValue(name));
        }
        return ati;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        for (Map.Entry<Name, String> entry : this._attributes.entrySet()) {
            if (entry.getKey() != null && entry.getKey().getLocalName().startsWith("xmlns:")) continue;
            result = 31 * result + ((Object)entry).hashCode();
        }
        return result;
    }
}

