/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wlm.threadmanager;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.util.ThreadPool;
import java.util.SortedSet;
import java.util.TreeSet;

public class SleeperThreadPool
implements Runnable {
    private static final TraceComponent tc = Tr.register(SleeperThreadPool.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private ThreadPool tPool = null;
    private SortedSet order = new TreeSet();

    public SleeperThreadPool(ThreadPool tPool) {
        this.tPool = tPool;
    }

    public int getMinimumPoolSize() {
        return this.tPool.getMinimumPoolSize();
    }

    public void setMinimumPoolSize(int newMinimum) {
        this.tPool.setMinimumPoolSize(newMinimum);
    }

    public int getMaximumPoolSize() {
        return this.tPool.getMaximumPoolSize();
    }

    public void setMaximumPoolSize(int newMaximum) {
        this.tPool.setMaximumPoolSize(newMaximum);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Run(Runnable command) {
        SortedSet sortedSet = this.order;
        synchronized (sortedSet) {
            this.order.add(new TimedQueueEntry(command, 0L));
            this.order.notifyAll();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SleeperThreadPool TreeSet size is (in Run)" + this.order.size());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void RunInTimeOrder(Runnable command) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "RunInTimeOrder");
        }
        SortedSet sortedSet = this.order;
        synchronized (sortedSet) {
            this.order.add(new TimedQueueEntry(command));
            this.order.notifyAll();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SleeperThreadPool TreeSet size is " + this.order.size());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "RunInTimeOrder");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void RunInTimeOrder(Runnable command, int sleepTime) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "RunInTimeOrder", String.valueOf(sleepTime));
        }
        SortedSet sortedSet = this.order;
        synchronized (sortedSet) {
            this.order.add(new TimedQueueEntry(command, System.currentTimeMillis() + (long)sleepTime));
            this.order.notifyAll();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SleeperThreadPool TreeSet size is " + this.order.size());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "RunInTimeOrder");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void RunAfterLast(Runnable command) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "RunAfterLast");
        }
        SortedSet sortedSet = this.order;
        synchronized (sortedSet) {
            if (this.order.isEmpty()) {
                this.order.add(new TimedQueueEntry(command));
            } else {
                TimedQueueEntry last = (TimedQueueEntry)this.order.last();
                this.order.add(new TimedQueueEntry(command, last.dTime + 1L));
            }
            this.order.notifyAll();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SleeperThreadPool TreeSet size is " + this.order.size());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "RunAfterLast");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void RunAfterLast(Runnable command, int sleepTime) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "RunAfterLast", String.valueOf(sleepTime));
        }
        SortedSet sortedSet = this.order;
        synchronized (sortedSet) {
            if (this.order.isEmpty()) {
                this.order.add(new TimedQueueEntry(command, sleepTime));
            } else {
                TimedQueueEntry last = (TimedQueueEntry)this.order.last();
                this.order.add(new TimedQueueEntry(command, last.dTime + (long)sleepTime));
            }
            this.order.notifyAll();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SleeperThreadPool TreeSet size is " + this.order.size());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "RunAfterLast");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (tc.isEventEnabled()) {
            Tr.event(tc, "run", this.tPool);
        }
        while (true) {
            try {
                while (true) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Checking for commands to execute", this);
                    }
                    boolean execute = false;
                    TimedQueueEntry command = null;
                    SortedSet sortedSet = this.order;
                    synchronized (sortedSet) {
                        if (this.order.isEmpty()) {
                            this.order.wait();
                        } else {
                            command = (TimedQueueEntry)this.order.first();
                            long delay = command.dTime - System.currentTimeMillis();
                            if (delay > 0L) {
                                this.order.wait(delay);
                            } else {
                                this.order.remove(command);
                                execute = true;
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "SleeperThreadPool TreeSet size is " + this.order.size());
                                }
                            }
                        }
                    }
                    if (!execute || command == null) continue;
                    this.tPool.execute(command.command);
                }
            }
            catch (Exception e) {
                if (!tc.isEventEnabled()) continue;
                Tr.debug(tc, "unexpected exception in thread", e);
                continue;
            }
            break;
        }
    }

    public final int getLongestSleepTime() {
        long time = 0L;
        try {
            time = ((TimedQueueEntry)this.order.last()).dTime;
        }
        catch (Exception e) {
            if (tc.isEventEnabled()) {
                Tr.debug(tc, "exception in getLongestSleepTime", e);
            }
            return 0;
        }
        return (int)(time - System.currentTimeMillis());
    }

    public final int queueLength() {
        return this.order.size();
    }

    public int getNumberOfFreeThread() {
        return this.tPool.getMaximumPoolSize() - this.tPool.getPoolSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean inQueue(Runnable command) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "inQueue", command);
        }
        boolean result = false;
        SortedSet sortedSet = this.order;
        synchronized (sortedSet) {
            for (TimedQueueEntry entry : this.order) {
                if (!entry.command.equals(command)) continue;
                result = true;
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "inQueue", String.valueOf(result));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer sb = new StringBuffer(super.toString());
        SortedSet sortedSet = this.order;
        synchronized (sortedSet) {
            sb.append(this.order);
        }
        return sb.toString();
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.11.1.2 ");
        }
    }

    private class TimedQueueEntry
    implements Comparable {
        long dTime;
        Runnable command;

        TimedQueueEntry(Runnable command) {
            this(command, System.currentTimeMillis());
        }

        TimedQueueEntry(Runnable command, long sleepTime) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "TimedQueueEntry.<init>", String.valueOf(sleepTime) + " : " + command);
            }
            this.dTime = sleepTime;
            this.command = command;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "TimedQueueEntry.<init>");
            }
        }

        public String toString() {
            return "delta sleep time (ms)= " + this.dTime + " : Runnable command=" + this.command;
        }

        public int compareTo(Object o) {
            int ires;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "compareTo");
            }
            TimedQueueEntry timeQ = (TimedQueueEntry)o;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "compareTo", new Object[]{new Long(this.dTime), new Long(timeQ.dTime)});
            }
            if (this.command.equals(timeQ.command)) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "compareTo", "0");
                }
                return 0;
            }
            long result = this.dTime - timeQ.dTime;
            int n = result > Integer.MAX_VALUE ? Integer.MAX_VALUE : (ires = result < Integer.MIN_VALUE ? Integer.MIN_VALUE : (int)result);
            if (ires == 0 && !this.command.equals(timeQ.command) && (ires = this.command.hashCode() - timeQ.command.hashCode()) == 0) {
                ires = -1;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "compareTo", String.valueOf(ires));
            }
            return ires;
        }
    }
}

