/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.wsdl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.webservices.shared.cache.CacheRootDirectoryTLS;
import com.ibm.ws.websvcs.Constants;
import com.ibm.ws.websvcs.deployment.WASWSDLReaderConfigurator;
import com.ibm.ws.websvcs.resources.NLSProvider;
import com.ibm.ws.websvcs.utils.Axis2Utils;
import com.ibm.ws.websvcs.wsdl.BaseWSDLGenerator;
import com.sun.tools.internal.ws.spi.WSToolsObjectFactory;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceException;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axis2.jaxws.description.EndpointDescription;
import org.apache.axis2.jaxws.description.builder.WsdlComposite;
import org.apache.axis2.jaxws.description.builder.WsdlGenerator;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WASWSDLGenerator
extends BaseWSDLGenerator
implements Constants,
WsdlGenerator {
    private static final TraceComponent _tc = Tr.register(WASWSDLGenerator.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    private String classPath;
    private final String outputDirectory;
    private String localOutputDirectory;
    private String applicationName;
    private String moduleName;
    private static WASWSDLReaderConfigurator wsdlReaderConfigurator = new WASWSDLReaderConfigurator();

    public WASWSDLGenerator(String outputDirectory, String applicationName, Archive moduleFile) {
        this.outputDirectory = outputDirectory;
        this.applicationName = applicationName;
        this.moduleFile = moduleFile;
        this.moduleName = moduleFile.getName();
    }

    @Override
    public WsdlComposite generateWsdl(String className, EndpointDescription endpointDesc) throws WebServiceException {
        String tempDir;
        String bindingType = endpointDesc.getBindingType();
        this.classPath = Axis2Utils.getWsGenClassPath(this.moduleFile);
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "For implementation class " + className + " in module " + this.moduleName + " WsGen classpath: " + this.classPath);
        }
        this.localOutputDirectory = (tempDir = CacheRootDirectoryTLS.get()) != null ? tempDir + className : this.outputDirectory + className;
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Output directory for generated WSDL file: " + this.localOutputDirectory);
        }
        WsdlComposite composite = new WsdlComposite();
        try {
            HashMap<String, OMDocument> docMap;
            HashMap<String, Definition> wsdlDefMap = null;
            List<File> wsdlFiles = this.getWSDLFiles();
            if (wsdlFiles != null && !wsdlFiles.isEmpty()) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Found generated WSDL files");
                }
                try {
                    wsdlDefMap = this.readInWSDL(endpointDesc, composite, wsdlFiles, true);
                    docMap = this.readInSchema();
                    composite.setSchemaMap(docMap);
                    composite.setWsdlDefinition(wsdlDefMap);
                    Axis2Utils.deleteTempExtractDir(this.moduleFile);
                }
                catch (Exception e) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Reading in WSDL from cache failed due to the following error: " + e.toString() + ". The WSDL will be regenerated.");
                    }
                    wsdlFiles = null;
                }
            }
            if (wsdlFiles == null || wsdlFiles.isEmpty()) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Generating new WSDL Definition");
                }
                this.createOutputDirectory();
                WSToolsObjectFactory factory = WSToolsObjectFactory.newInstance();
                String[] arguments = this.getWsGenArguments(className, bindingType, endpointDesc);
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                factory.wsgen((OutputStream)os, arguments);
                ((OutputStream)os).close();
                wsdlDefMap = this.readInWSDL(endpointDesc, composite, this.getWSDLFiles(), false);
                if (wsdlDefMap.isEmpty()) {
                    throw new Exception("A WSDL Definition could not be generated for the implementation class: " + className);
                }
                docMap = this.readInSchema();
                composite.setSchemaMap(docMap);
                composite.setWsdlDefinition(wsdlDefMap);
                Axis2Utils.deleteTempExtractDir(this.moduleFile);
            }
            return composite;
        }
        catch (Throwable t) {
            Object[] inserts = new Object[]{className, t};
            String msg = NLSProvider.getNLS().getFormattedMessage("wsdlGenFail00", inserts, "Error occurred generating WSDL file for Web service implementation class {0}: {1}");
            Tr.error(_tc, msg);
            throw new WebServiceException(msg, t);
        }
    }

    private String[] getWsGenArguments(String className, String bindingType, EndpointDescription endpointDesc) throws WebServiceException {
        String[] arguments = null;
        QName serviceQName = endpointDesc.getServiceQName();
        QName portQName = endpointDesc.getPortQName();
        ArrayList<String> argList = new ArrayList<String>();
        argList.add("-cp");
        argList.add(this.classPath);
        argList.add(className);
        argList.add("-keep");
        argList.add("-d");
        argList.add(this.localOutputDirectory);
        if (serviceQName != null) {
            argList.add("-servicename");
            argList.add(serviceQName.toString());
        }
        if (portQName != null) {
            argList.add("-portname");
            argList.add(portQName.toString());
        }
        if (bindingType == null || bindingType.equals("") || bindingType.equals("http://schemas.xmlsoap.org/wsdl/soap/http") || bindingType.equals("http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true")) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Generating WSDL with SOAP 1.1 binding type");
            }
            argList.add("-wsdl:soap1.1");
        } else if (bindingType.equals("http://www.w3.org/2003/05/soap/bindings/HTTP/") || bindingType.equals("http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true")) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Generating WSDL with SOAP 1.2 binding type");
            }
            argList.add("-wsdl:Xsoap1.2");
        } else {
            throw new WebServiceException("The binding " + bindingType + " specified by the " + "class " + className + " cannot be used to generate a WSDL. Please choose " + "a supported binding type.");
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Using the following arguments for wsgen: " + argList);
        }
        arguments = new String[argList.size()];
        for (int i = 0; i < arguments.length; ++i) {
            arguments[i] = (String)argList.get(i);
        }
        return arguments;
    }

    private HashMap<String, Definition> readInWSDL(EndpointDescription endpointDesc, WsdlComposite composite, List<File> wsdlFiles, boolean readingCache) throws Exception {
        HashMap<String, Definition> wsdlDefMap = new HashMap<String, Definition>();
        String baseWsdlFile = this.getBaseWSDLFileName(endpointDesc);
        boolean oneWsdl = false;
        if (wsdlFiles == null || wsdlFiles.isEmpty()) {
            return wsdlDefMap;
        }
        if (wsdlFiles.size() == 1) {
            oneWsdl = true;
        }
        for (File wsdlFile : wsdlFiles) {
            String msg;
            Object[] inserts;
            if (wsdlFile == null) continue;
            try {
                Definition definition;
                block19: {
                    WSDLFactory wsdlFactory = WSDLFactory.newInstance();
                    WSDLReader wsdlReader = wsdlFactory.newWSDLReader();
                    wsdlReaderConfigurator.configureReaderInstance(wsdlReader);
                    wsdlReader.setFeature("javax.wsdl.verbose", false);
                    InputStream is = wsdlFile.toURL().openStream();
                    definition = wsdlReader.readWSDL(this.localOutputDirectory, new InputSource(is));
                    try {
                        definition.setDocumentBaseURI(wsdlFile.toURI().toString());
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Set base document URI for generated WSDL: " + wsdlFile.toURI().toString());
                        }
                    }
                    catch (Throwable t) {
                        if (!_tc.isDebugEnabled()) break block19;
                        Tr.debug(_tc, "Could not set base document URI for generated WSDL: " + wsdlFile.getAbsolutePath() + " : " + t.toString());
                    }
                }
                if (oneWsdl) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Setting base generated WSDL file name on one WSDL: " + wsdlFile.getName());
                    }
                    composite.setWsdlFileName(wsdlFile.getName());
                } else if (wsdlFile.getName().equalsIgnoreCase(baseWsdlFile)) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Setting base generated WSDL file name based on service name: " + wsdlFile.getName());
                    }
                    composite.setWsdlFileName(wsdlFile.getName());
                } else if (definition.getTargetNamespace() != null && definition.getTargetNamespace().equals(endpointDesc.getTargetNamespace())) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Setting base generated WSDL file name based on tns: " + wsdlFile.getName());
                    }
                    composite.setWsdlFileName(wsdlFile.getName());
                }
                wsdlDefMap.put(wsdlFile.getName(), definition);
            }
            catch (WSDLException e) {
                if (!readingCache) {
                    inserts = new Object[]{wsdlFile.getName(), e};
                    msg = NLSProvider.getNLS().getFormattedMessage("createWsdlDefFail00", inserts, "Error occurred while attempting to create Definition from generated WSDL file {0}: {1}");
                    Tr.error(_tc, msg);
                    throw new Exception(msg);
                }
                throw e;
            }
            catch (IOException e) {
                if (!readingCache) {
                    inserts = new Object[]{wsdlFile.getName(), e};
                    msg = NLSProvider.getNLS().getFormattedMessage("createWsdlDefFail00", inserts, "Error occurred while attempting to create Definition from generated WSDL file {0}: {1}");
                    Tr.error(_tc, msg);
                    throw new Exception(msg);
                }
                throw e;
            }
        }
        return wsdlDefMap;
    }

    private List<File> getWSDLFiles() {
        File classDirectory = new File(this.localOutputDirectory);
        ArrayList<File> wsdlFiles = new ArrayList<File>();
        if (classDirectory.isDirectory()) {
            File[] files;
            for (File file : files = classDirectory.listFiles()) {
                String fileName = file.getName();
                if (!fileName.endsWith(".wsdl")) continue;
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Located generated WSDL file: " + fileName);
                }
                wsdlFiles.add(file);
            }
        }
        return wsdlFiles;
    }

    private void createOutputDirectory() {
        File directory = new File(this.localOutputDirectory);
        if (!directory.isDirectory()) {
            directory.mkdirs();
        }
    }

    private HashMap<String, OMDocument> readInSchema() throws Exception {
        try {
            HashMap<String, OMDocument> docMap = new HashMap<String, OMDocument>();
            List<File> schemaFiles = this.getSchemaFiles();
            for (File schemaFile : schemaFiles) {
                InputStream is = schemaFile.toURL().openStream();
                StAXOMBuilder builder = new StAXOMBuilder(is);
                is.close();
                OMDocument doc = builder.getDocument();
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Read in schema file: " + schemaFile.getName());
                }
                docMap.put(schemaFile.getName(), doc);
            }
            return docMap;
        }
        catch (Exception e) {
            Object[] inserts = new Object[]{e};
            String msg = NLSProvider.getNLS().getFormattedMessage("readSchemaFail00", inserts, "Error occurred while attempting to read generated schema file {0}");
            Tr.error(_tc, msg);
            throw new Exception(msg);
        }
    }

    private List<File> getSchemaFiles() {
        ArrayList<File> schemaFiles = new ArrayList<File>();
        File classDirectory = new File(this.localOutputDirectory);
        if (classDirectory.isDirectory()) {
            File[] files;
            for (File file : files = classDirectory.listFiles()) {
                String fileName = file.getName();
                if (!fileName.endsWith(".xsd")) continue;
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Located generated schema file: " + fileName);
                }
                schemaFiles.add(file);
            }
        }
        return schemaFiles;
    }

    String getBaseWSDLFileName(EndpointDescription endpointDesc) {
        String baseWsdlFile = endpointDesc.getServiceQName() != null ? endpointDesc.getServiceQName().getLocalPart() + ".wsdl" : null;
        return baseWsdlFile;
    }
}

