/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.utils;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.websvcs.Constants;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.axis2.jaxws.utility.JAXWSThreadFactory;

public class WASAxis2Executor
implements Executor,
Constants {
    private static final TraceComponent _tc = Tr.register(WASAxis2Executor.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    private Executor theExecutor = null;

    WASAxis2Executor() {
        Exception e2;
        int n;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "WASAxis2Executor");
        }
        int coreThreads = com.ibm.websphere.webservices.jaxws.Constants.DEFAULT_CORE_THREADS;
        int maxThreads = com.ibm.websphere.webservices.jaxws.Constants.DEFAULT_MAX_THREADS;
        String t = System.getProperty(com.ibm.websphere.webservices.jaxws.Constants.CORE_THREADS_PROPERTY);
        if (t != null) {
            try {
                n = Integer.parseInt(t);
                if (n > 0) {
                    coreThreads = n;
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Using core threads property value: " + t);
                    }
                } else if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Invalid value for core threads property:" + t + ". Will use default value of: " + coreThreads);
                }
            }
            catch (NumberFormatException e) {
                e2 = new Exception("An error occurred while parsing the value of property '" + com.ibm.websphere.webservices.jaxws.Constants.CORE_THREADS_PROPERTY + "': " + t, e);
                FFDCFilter.processException((Throwable)e2, "com.ibm.ws.websvcs.utils.WASAxis2Executor.ctor", "71", this);
            }
        }
        if ((t = System.getProperty(com.ibm.websphere.webservices.jaxws.Constants.MAX_THREADS_PROPERTY)) != null) {
            try {
                n = Integer.parseInt(t);
                if (n > 0) {
                    maxThreads = n;
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Using max threads property value: " + t);
                    }
                } else if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Invalid value for max threads property:" + t + ". Will use default value of: " + maxThreads);
                }
            }
            catch (NumberFormatException e) {
                e2 = new Exception("An error occurred while parsing the value of property '" + com.ibm.websphere.webservices.jaxws.Constants.MAX_THREADS_PROPERTY + "': " + t, e);
                FFDCFilter.processException((Throwable)e2, "com.ibm.ws.websvcs.utils.WASAxis2Executor.ctor", "94", this);
            }
        }
        if (maxThreads < coreThreads) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Max threads must be greater than or equal to core threads.   Setting max threads to " + coreThreads);
            }
            maxThreads = coreThreads;
        }
        this.theExecutor = new ThreadPoolExecutor(coreThreads, maxThreads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new JAXWSThreadFactory());
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Created new Executor instance: " + this.theExecutor.toString());
            Tr.debug(_tc, "core threads: " + coreThreads);
            Tr.debug(_tc, "max threads:  " + maxThreads);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "WASAxis2Executor");
        }
    }

    public void execute(Runnable command) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "execute, command=" + command.toString());
        }
        this.theExecutor.execute(command);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "execute");
        }
    }
}

