/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.utils;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.webservice.wsbnd.RouterModule;
import com.ibm.etools.webservice.wsbnd.WSBinding;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.webservices.jaxws.Constants;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.service.Server;
import com.ibm.ws.webcontainer.component.ComponentUtil;
import com.ibm.ws.webservices.SharedConstants;
import com.ibm.ws.webservices.deployment.WSDLPostProcessorPluginMgr;
import com.ibm.ws.webservices.exception.WSDLPostProcessingException;
import com.ibm.ws.webservices.management.Endpoint;
import com.ibm.ws.webservices.shared.cache.CacheRootDirectoryTLS;
import com.ibm.ws.webservices.utils.WebServiceUtils;
import com.ibm.ws.websvcs.resources.NLSProvider;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import com.ibm.wsspi.webservices.management.EndpointManagerMBean;
import com.ibm.wsspi.webservices.models.WSModels;
import com.ibm.wsspi.websvcs.WASAxis2Service;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.jar.Attributes;
import javax.management.ObjectName;
import javax.servlet.http.HttpServletRequest;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.jaxws.description.builder.WsdlComposite;
import org.eclipse.jst.j2ee.application.Application;
import org.eclipse.jst.j2ee.application.WebModule;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ApplicationClientFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EJBJarFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.WARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveManifest;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.RuntimeClasspathEntry;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.webapplication.Servlet;
import org.eclipse.jst.j2ee.webapplication.ServletMapping;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.jst.j2ee.webservice.wsdd.PortComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Axis2Utils {
    private static final TraceComponent _tc = Tr.register(Axis2Utils.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    private static final String WSFP_MAIN_JAR = "com.ibm.wsfp.main.jar";
    private static final String WSFP_JAXWS_JAR = "com.ibm.jaxws.tools.jar";
    private static final String WSFP_AXIS2_JAR = "org.apache.axis2.jar";
    private static final String WSFP_JAXB_JAR = "com.ibm.jaxb.tools.jar";
    private static final String WAS_J2EE_EJB_JAR = "javax.j2ee.ejb.jar";
    private static final String WAS_RUNTIME_JAR = "com.ibm.ws.runtime.jar";
    private static final String WAS_JTA_JAR = "javax.j2ee.jta.jar";
    private static final String WAS_PERSISTENCE_JAR = "javax.j2ee.persistence.jar";
    private static final String WAS_SERVLET_JAR = "javax.j2ee.servlet.jar";
    private static final String WAS_JSP_JAR = "javax.j2ee.jsp.jar";
    private static final String WAS_DB2_JAR = "com.ibm.ws.prereq.db2.intf.jar";
    private static final String WAS_J2EE_ANNOTATIONS_JAR = "javax.j2ee.annotation.jar";
    private static final String WAS_MAIL_JAR = "com.ibm.ws.prereq.javamail.jar";
    private static final String serverRoot;
    private static final String serverScanPolicy;
    private static Boolean scanAccordingToConfig;
    private static String WSDL_GEN_EXTRA_CP;

    public static void setServiceImplClass(AxisService axisService, String implClass) throws AxisFault {
        Axis2Utils.setParameter(axisService, "ServiceClass", implClass);
    }

    public static String getServiceImplClass(AxisService axisService) {
        return (String)Axis2Utils.getParameter(axisService, "ServiceClass");
    }

    public static void setServiceQName(AxisService axisService, QName serviceQName) throws AxisFault {
        Axis2Utils.setParameter(axisService, "WSDL_SERVICE_QNAME", serviceQName);
    }

    public static QName getServiceQName(AxisService axisService) {
        QName qName;
        block5: {
            qName = (QName)Axis2Utils.getParameter(axisService, "WSDL_SERVICE_QNAME");
            if (qName == null) {
                qName = (QName)Axis2Utils.getParameter(axisService, "WSDL_SERVICE_QNAME");
            }
            if (qName == null) {
                qName = new QName("", axisService.getName());
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Adding default QName: " + qName.toString() + " to axisService: " + axisService.getName() + "@" + axisService.hashCode());
                }
                try {
                    Axis2Utils.setServiceQName(axisService, qName);
                }
                catch (AxisFault axisFault) {
                    if (!_tc.isDebugEnabled()) break block5;
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    axisFault.printStackTrace(pw);
                    Tr.debug(_tc, "An error occurred while trying to store the service QName on the AxisService: " + axisService.getName() + "@" + axisService.hashCode() + "\n" + sw.toString());
                }
            }
        }
        return qName;
    }

    public static String getServiceName(AxisService axisService) {
        QName qName = Axis2Utils.getServiceQName(axisService);
        if (qName != null) {
            return qName.getLocalPart();
        }
        return null;
    }

    public static void setPortName(AxisService axisService, String portName) throws AxisFault {
        Axis2Utils.setParameter(axisService, "WSDL_PORT", portName);
    }

    public static String getPortName(AxisService axisService) {
        return (String)Axis2Utils.getParameter(axisService, "WSDL_PORT");
    }

    public static void setWSDLLocation(AxisService axisService, String wsdlLocation) throws AxisFault {
        Axis2Utils.setParameter(axisService, "WSDL_LOCATION", wsdlLocation);
    }

    public static String getWSDLLocation(AxisService axisService) {
        if ((String)Axis2Utils.getParameter(axisService, "WSDL_LOCATION") != null) {
            return (String)Axis2Utils.getParameter(axisService, "WSDL_LOCATION");
        }
        WsdlComposite composite = Axis2Utils.getWsdlComposite(axisService);
        if (composite != null) {
            return composite.getWsdlFileName();
        }
        return null;
    }

    public static Definition getWSDLDefinition(AxisService axisService) {
        return (Definition)Axis2Utils.getParameter(axisService, "wsdl4jDefinition");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Definition getAnnotatedWSDLDefinition(AxisService axisService, ConfigurationContext cc, HttpServletRequest req) throws AxisFault, WSDLPostProcessingException {
        Definition definition;
        block11: {
            Definition definition2;
            block10: {
                Definition definition3;
                block9: {
                    if (_tc.isEntryEnabled()) {
                        Tr.entry(_tc, "Axis2Utils.getAnnotatedWSDLDefinition()...", axisService);
                    }
                    if (axisService == null) {
                        return null;
                    }
                    try {
                        Boolean alreadyAnnotated = (Boolean)Axis2Utils.getParameter(axisService, "ANNOTATED_WSDL_FLAG");
                        if (alreadyAnnotated != null && alreadyAnnotated.booleanValue()) {
                            definition3 = (Definition)Axis2Utils.getParameter(axisService, "wsdl4jDefinition");
                            Object var11_6 = null;
                            if (!_tc.isEntryEnabled()) return definition3;
                            break block9;
                        }
                        AxisService axisService2 = axisService;
                        synchronized (axisService2) {
                            alreadyAnnotated = (Boolean)Axis2Utils.getParameter(axisService, "ANNOTATED_WSDL_FLAG");
                            if (alreadyAnnotated != null && alreadyAnnotated.booleanValue()) {
                                definition2 = (Definition)Axis2Utils.getParameter(axisService, "wsdl4jDefinition");
                                // MONITOREXIT @DISABLED, blocks:[0, 3, 7] lbl18 : MonitorExitStatement: MONITOREXIT : var4_5
                                break block10;
                            }
                            HashMap<String, Object> params = new HashMap<String, Object>();
                            params.put("APP_NAME_KEY", Axis2Utils.getApplicationName(axisService.getAxisConfiguration()));
                            params.put("MODULE_NAME_KEY", Axis2Utils.getModuleName(axisService.getAxisConfiguration()));
                            params.put("SERVICE_NAME_KEY", Axis2Utils.getServiceQName(axisService));
                            params.put("AXIS_SERVICE_KEY", axisService);
                            params.put("CONFIGURATION_CONTEXT_KEY", cc);
                            params.put("SERVLET_REQUEST_KEY", req);
                            Definition def = (Definition)Axis2Utils.getParameter(axisService, "wsdl4jDefinition");
                            WSDLPostProcessorPluginMgr wsdlPostProcMgr = WSDLPostProcessorPluginMgr.getInstance();
                            wsdlPostProcMgr.runPostProcessWSDL(def, params);
                            Axis2Utils.setParameter(axisService, "ANNOTATED_WSDL_FLAG", Boolean.TRUE);
                            definition = def;
                        }
                        break block11;
                    }
                    catch (Throwable throwable) {
                        Object var11_9 = null;
                        if (!_tc.isEntryEnabled()) throw throwable;
                        Tr.exit(_tc, "...Axis2Utils.getAnnotatedWSDLDefinition()");
                        throw throwable;
                    }
                }
                Tr.exit(_tc, "...Axis2Utils.getAnnotatedWSDLDefinition()");
                return definition3;
            }
            Object var11_7 = null;
            if (!_tc.isEntryEnabled()) return definition2;
            Tr.exit(_tc, "...Axis2Utils.getAnnotatedWSDLDefinition()");
            return definition2;
        }
        Object var11_8 = null;
        if (!_tc.isEntryEnabled()) return definition;
        Tr.exit(_tc, "...Axis2Utils.getAnnotatedWSDLDefinition()");
        return definition;
    }

    public static Service getWSDLService(AxisService axisService) {
        Definition def = Axis2Utils.getWSDLDefinition(axisService);
        QName qName = Axis2Utils.getServiceQName(axisService);
        if (def != null && qName != null) {
            return def.getService(qName);
        }
        return null;
    }

    public static Port getWSDLPort(AxisService axisService) {
        Service service = Axis2Utils.getWSDLService(axisService);
        String portName = Axis2Utils.getPortName(axisService);
        if (service != null && portName != null) {
            return service.getPort(portName);
        }
        return null;
    }

    public static void setURLPattern(AxisService axisService, String urlPattern) throws AxisFault {
        Axis2Utils.setParameter(axisService, "com.ibm.ws.websvcs.AxisServiceUrlPattern", urlPattern);
    }

    public static String getURLPattern(AxisService axisService) {
        return (String)Axis2Utils.getParameter(axisService, "com.ibm.ws.websvcs.AxisServiceUrlPattern");
    }

    public static void setOperationValidated(AxisOperation axisOperation) throws AxisFault {
        Axis2Utils.setParameter(axisOperation, "Validated", "true");
    }

    public static Parameter getOperationValidated(AxisOperation axisOperation) {
        return axisOperation.getParameter("Validated");
    }

    public static void setPolicySet(AxisDescription axisDescription, Object policySet) throws AxisFault {
        Axis2Utils.setParameter(axisDescription, "WASAxis2PolicySet", policySet);
    }

    public static Object getPolicySet(AxisDescription axisDescription) {
        return Axis2Utils.getParameter(axisDescription, "WASAxis2PolicySet");
    }

    public static void setApplicationName(AxisConfiguration axisCfg, String appName) throws AxisFault {
        Axis2Utils.setParameter(axisCfg, "ApplicationName", appName);
    }

    public static String getApplicationName(AxisConfiguration axisCfg) {
        return (String)Axis2Utils.getParameter(axisCfg, "ApplicationName");
    }

    public static void setModuleName(AxisConfiguration axisCfg, String modName) throws AxisFault {
        Axis2Utils.setParameter(axisCfg, "ModuleName", modName);
    }

    public static String getModuleName(AxisConfiguration axisCfg) {
        return (String)Axis2Utils.getParameter(axisCfg, "ModuleName");
    }

    public static void setPortComponentName(AxisService service, String name) throws AxisFault {
        Axis2Utils.setParameter(service, "WSDL_PORTTYPE_NAME", name);
    }

    public static String getPortComponentName(AxisService service) {
        return (String)Axis2Utils.getParameter(service, "WSDL_PORTTYPE_NAME");
    }

    public static void setConstrainService(AxisService service, Boolean bool) throws AxisFault {
        Axis2Utils.setParameter(service, "com.ibm.ws.websvcs.contrain_service", bool);
    }

    public static boolean isServiceConstrained(AxisService service) {
        Boolean bool = (Boolean)Axis2Utils.getParameter(service, "com.ibm.ws.websvcs.contrain_service");
        if (bool == null) {
            return false;
        }
        return bool;
    }

    public static void setEndpointManagerMBean(ConfigurationContext configContext, EndpointManagerMBean mbean) {
        if (configContext != null) {
            configContext.setProperty("com.ibm.ws.websvcs.ENDPOINT_MANAGER_MBEAN", mbean);
        }
    }

    public static EndpointManagerMBean getEndpointManagerMBean(ConfigurationContext configContext) {
        if (configContext != null) {
            return (EndpointManagerMBean)configContext.getProperty("com.ibm.ws.websvcs.ENDPOINT_MANAGER_MBEAN");
        }
        return null;
    }

    private static Object getParameter(AxisDescription desc, String key) {
        Parameter parameter = desc.getParameter(key);
        if (parameter != null) {
            return parameter.getValue();
        }
        return null;
    }

    private static void setParameter(AxisDescription desc, String key, Object value) throws AxisFault {
        Parameter param = desc.getParameter(key);
        if (param != null) {
            param.setValue(value);
        } else {
            param = new Parameter();
            param.setName(key);
            param.setValue(value);
            desc.addParameter(param);
        }
    }

    public static boolean isServerEnv() {
        Boolean isServerEnv;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "isServerEnv");
        }
        if ((isServerEnv = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                try {
                    WASAxis2Service service = WsServiceRegistry.getService(new Object(), WASAxis2Service.class);
                    if (service != null) {
                        return new Boolean(service.isServerEnv());
                    }
                    return new Boolean(false);
                }
                catch (Throwable t) {
                    return new Boolean(false);
                }
            }
        })) == null) {
            isServerEnv = false;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "isServerEnv= " + isServerEnv);
        }
        return isServerEnv;
    }

    public static boolean isThinClientEnv() {
        Boolean bool = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    WASAxis2Service service = WsServiceRegistry.getService(new Object(), WASAxis2Service.class);
                    if (service != null) {
                        return new Boolean(!service.isServerEnv());
                    }
                    return new Boolean(true);
                }
                catch (Throwable t) {
                    return new Boolean(true);
                }
            }
        });
        return bool;
    }

    public static boolean isAbsolutePath(String uri) {
        boolean absolute = false;
        if (uri != null) {
            if (uri.indexOf(":/") != -1) {
                absolute = true;
            } else if (uri.indexOf(":\\") != -1) {
                absolute = true;
            }
        }
        return absolute;
    }

    public static String getCacheDirectory() {
        StringBuffer path = Axis2Utils.getProfileRoot();
        if (path != null) {
            path = path.append("temp").append(java.io.File.separator).append("wscache").append(java.io.File.separator);
            return path.toString();
        }
        return null;
    }

    private static StringBuffer getProfileRoot() {
        return WebServiceUtils.getProfileRoot();
    }

    private static String getServerRoot() {
        if (serverRoot != null) {
            return serverRoot + java.io.File.separator;
        }
        String envServerRoot = System.getenv("WAS_HOME");
        return envServerRoot + java.io.File.separator;
    }

    public static String getCellName() {
        Server server = Axis2Utils.getServer();
        String cellName = null;
        cellName = server != null ? server.getCellName() : (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("local.cell");
            }
        });
        return cellName;
    }

    public static String getServerName() {
        return Axis2Utils.getServer() != null ? Axis2Utils.getServer().getName() : "server1";
    }

    static Server getServer() {
        return (Server)ComponentUtil.getService(Axis2Utils.class, Server.class);
    }

    public static WsdlComposite getWsdlComposite(AxisService axisService) {
        return (WsdlComposite)Axis2Utils.getParameter(axisService, "WSDL_COMPOSITE");
    }

    public static String getWsGenClassPath(Archive moduleFile) {
        String systemClassPath = Axis2Utils.getSystemClassPath();
        String applicationClassPath = Axis2Utils.getApplicationClassPath(moduleFile);
        String fullClassPath = systemClassPath + applicationClassPath;
        return fullClassPath;
    }

    private static String getSystemClassPath() {
        String sysClassPath = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("WSGEN_SYSTEM_CLASSPATH");
            }
        });
        if (sysClassPath != null && !"".equals(sysClassPath)) {
            if (!sysClassPath.endsWith(java.io.File.pathSeparator)) {
                sysClassPath = sysClassPath + java.io.File.pathSeparator;
            }
            return sysClassPath;
        }
        sysClassPath = Axis2Utils.getDefaultSystemClassPath();
        return sysClassPath;
    }

    private static String getDefaultSystemClassPath() {
        String WSFP_MAIN_PATH = Axis2Utils.getServerRoot() + "plugins" + java.io.File.separator + WSFP_MAIN_JAR;
        String WSFP_JAXWS_PATH = Axis2Utils.getServerRoot() + "plugins" + java.io.File.separator + WSFP_JAXWS_JAR;
        String WSFP_AXIS2_PATH = Axis2Utils.getServerRoot() + "plugins" + java.io.File.separator + WSFP_AXIS2_JAR;
        String WSFP_JAXB_PATH = Axis2Utils.getServerRoot() + "plugins" + java.io.File.separator + WSFP_JAXB_JAR;
        String WAS_J2EE_EJB_PATH = Axis2Utils.getServerRoot() + "plugins" + java.io.File.separator + WAS_J2EE_EJB_JAR;
        String WAS_RUNTIME_PATH = Axis2Utils.getServerRoot() + "plugins" + java.io.File.separator + WAS_RUNTIME_JAR;
        String WAS_JTA_PATH = Axis2Utils.getServerRoot() + "plugins" + java.io.File.separator + WAS_JTA_JAR;
        String WAS_PERSISTENCE_PATH = Axis2Utils.getServerRoot() + "plugins" + java.io.File.separator + WAS_PERSISTENCE_JAR;
        String WAS_SERVLET_PATH = Axis2Utils.getServerRoot() + "plugins" + java.io.File.separator + WAS_SERVLET_JAR;
        String WAS_JSP_PATH = Axis2Utils.getServerRoot() + "plugins" + java.io.File.separator + WAS_JSP_JAR;
        String WAS_DB2_PATH = Axis2Utils.getServerRoot() + "plugins" + java.io.File.separator + WAS_DB2_JAR;
        String WAS_J2EE_ANNOT_PATH = Axis2Utils.getServerRoot() + "plugins" + java.io.File.separator + WAS_J2EE_ANNOTATIONS_JAR;
        String WAS_MAIL_PATH = Axis2Utils.getServerRoot() + "plugins" + java.io.File.separator + WAS_MAIL_JAR;
        String defaultPath = WSFP_MAIN_PATH + java.io.File.pathSeparator + WSFP_JAXWS_PATH + java.io.File.pathSeparator + WSFP_AXIS2_PATH + java.io.File.pathSeparator + WSFP_JAXB_PATH + java.io.File.pathSeparator + WAS_J2EE_EJB_PATH + java.io.File.pathSeparator + WAS_RUNTIME_PATH + java.io.File.pathSeparator + WAS_JTA_PATH + java.io.File.pathSeparator + WAS_PERSISTENCE_PATH + java.io.File.pathSeparator + WAS_SERVLET_PATH + java.io.File.pathSeparator + WAS_JSP_PATH + java.io.File.pathSeparator + WAS_DB2_PATH + java.io.File.pathSeparator + WAS_J2EE_ANNOT_PATH + java.io.File.pathSeparator + WAS_MAIL_PATH + java.io.File.pathSeparator;
        if (WSDL_GEN_EXTRA_CP != null && !WSDL_GEN_EXTRA_CP.equals("")) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Adding WSDL Generation extra classpath: " + WSDL_GEN_EXTRA_CP);
            }
            defaultPath = defaultPath + WSDL_GEN_EXTRA_CP + java.io.File.pathSeparator;
        }
        return defaultPath;
    }

    private static String getApplicationClassPath(Archive moduleFile) {
        String appClassPath = null;
        try {
            RuntimeClasspathEntry[] entries = moduleFile.getFullRuntimeClassPath();
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Module file " + moduleFile.getName() + " is extracted: " + String.valueOf(moduleFile.getLoadStrategy().isDirectory()));
            }
            if (moduleFile.getLoadStrategy().isDirectory() && entries != null && entries.length > 0) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Using module full runtime classpath for wsgen compilation");
                }
                for (RuntimeClasspathEntry entry : entries) {
                    String entryPath = entry.getAbsolutePath();
                    java.io.File file = new java.io.File(entryPath);
                    if (!file.isFile() && !file.isDirectory()) continue;
                    appClassPath = appClassPath == null ? entryPath + java.io.File.pathSeparator : appClassPath + entryPath + java.io.File.pathSeparator;
                }
            }
            if (appClassPath == null) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Temporarily extracting module file for wsgen compilation");
                }
                String tempExtractLoc = Axis2Utils.getTempExtractLoc(moduleFile);
                java.io.File tempExtractFile = new java.io.File(tempExtractLoc);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Temporary extract root for WsGen " + tempExtractLoc);
                }
                if (!tempExtractFile.isDirectory()) {
                    tempExtractFile.mkdirs();
                }
                moduleFile.extractTo(tempExtractFile.getAbsolutePath(), 0);
                if (moduleFile.isWARFile()) {
                    appClassPath = tempExtractFile.getAbsolutePath() + java.io.File.pathSeparator;
                    appClassPath = tempExtractFile.getAbsolutePath() + java.io.File.separator + "WEB-INF/classes";
                    appClassPath = appClassPath + java.io.File.pathSeparator + tempExtractFile.getAbsolutePath() + java.io.File.separator + "WEB-INF/lib";
                    appClassPath = Axis2Utils.addJarsToClassPath(tempExtractFile.getAbsolutePath(), appClassPath);
                } else if (moduleFile.isEJBJarFile()) {
                    appClassPath = tempExtractFile.getAbsolutePath() + java.io.File.pathSeparator;
                    appClassPath = appClassPath + tempExtractFile.getAbsolutePath() + java.io.File.separator + "META-INF/classes";
                }
                List<String> classPathList = Axis2Utils.getManifestClassPath(moduleFile);
                if (classPathList != null && !classPathList.isEmpty()) {
                    appClassPath = Axis2Utils.setupManifestClassPath(moduleFile, classPathList, appClassPath, tempExtractFile);
                } else if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "No manifest classpath for module: " + moduleFile.getName());
                }
            }
        }
        catch (Exception e) {
            String msg = NLSProvider.getNLS().getFormattedMessage("wsdlGenFail01", new Object[]{moduleFile.getName(), e}, "Web Services Description Language (WSDL) files for the {0} module will not be generated due to the following error: {1}");
            Tr.error(_tc, msg);
            FFDCFilter.processException(e, "com.ibm.ws.websvcs.utils.Axis2Utils.getApplicationClassPath", "874");
        }
        return appClassPath;
    }

    private static String addJarsToClassPath(String parentPath, String appClassPath) {
        String jarPath = parentPath + java.io.File.separator + "WEB-INF/lib";
        java.io.File jarDirectory = new java.io.File(jarPath);
        if (jarDirectory != null && jarDirectory.isDirectory() && jarDirectory.listFiles() != null && jarDirectory.listFiles().length > 0) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Found non-empty JARs in extracted WEB-INF/lib directory: " + jarPath);
            }
            for (java.io.File file : jarDirectory.listFiles()) {
                String pathToJar = file.getAbsolutePath();
                appClassPath = appClassPath + java.io.File.pathSeparator + pathToJar;
            }
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "After adding JARs to module classpath: " + appClassPath);
            }
        } else if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "No JARs found in extracted WEB-INF/lib directory. No entries added to wsgen classpath.");
        }
        return appClassPath;
    }

    private static String setupManifestClassPath(Archive moduleFile, List<String> classPathList, String appClassPath, java.io.File tempExtractFile) throws Exception {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Found manifest classpath entries for: " + moduleFile.getName());
        }
        if (moduleFile instanceof ModuleFile && ((ModuleFile)moduleFile).getEARFile() != null) {
            EARFile earFile = ((ModuleFile)moduleFile).getEARFile();
            String manifestClassPathDir = tempExtractFile.getAbsolutePath() + java.io.File.separator + "ear" + java.io.File.separator;
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Extracting application: " + earFile.getName() + " to diretory: " + manifestClassPathDir);
            }
            earFile.extractTo(manifestClassPathDir, 0);
            java.io.File earDir = new java.io.File(manifestClassPathDir);
            if (earDir.isDirectory()) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Found extracted ear file location");
                }
                String earPath = earDir.getAbsolutePath() + java.io.File.separator;
                for (String cpEntry : classPathList) {
                    java.io.File cpFile;
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Checking for classpath entry: " + earPath + cpEntry + " for module: " + moduleFile.getName());
                    }
                    if (!(cpFile = new java.io.File(earPath + cpEntry)).exists()) continue;
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Found classpath entry: " + cpFile.getAbsolutePath() + " for moudle: " + moduleFile.getName());
                    }
                    appClassPath = appClassPath + java.io.File.pathSeparator + cpFile.getAbsolutePath();
                }
            }
            return appClassPath;
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Found manifest classpath entries but could not find EAR for module: " + moduleFile.getName());
        }
        return appClassPath;
    }

    private static List<String> getManifestClassPath(Archive moduleFile) {
        ArrayList<String> cpEntryList = null;
        ArchiveManifest manifest = moduleFile.getManifest();
        if (manifest != null) {
            String[] cpEntries;
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Checking manifest classpath for module: " + moduleFile.getName());
            }
            if ((cpEntries = manifest.getClassPathTokenized()) != null && cpEntries.length > 0) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Found entries in manifest classpath for module: " + moduleFile.getName());
                }
                cpEntryList = new ArrayList<String>();
                for (String cpEntry : cpEntries) {
                    cpEntryList.add(cpEntry);
                }
                return cpEntryList;
            }
        }
        return cpEntryList;
    }

    public static String getApplicationName(Archive archive) {
        String appName = null;
        if (archive instanceof ModuleFile) {
            ModuleFile moduleFile = (ModuleFile)archive;
            if (moduleFile.getEARFile() != null && moduleFile.getEARFile().getDeploymentDescriptor() != null) {
                appName = moduleFile.getEARFile().getDeploymentDescriptor().getDisplayName();
            }
        } else if (archive instanceof ApplicationClientFile) {
            EARFile earFile = ((ApplicationClientFile)archive).getEARFile();
            if (earFile != null && earFile.getDeploymentDescriptor() != null) {
                appName = earFile.getDeploymentDescriptor().getDisplayName();
            }
        } else {
            appName = archive.getName();
            if (archive.getContainer() instanceof EARFile) {
                appName = ((EARFile)archive.getContainer()).getName();
            }
        }
        return appName;
    }

    private static String getTempExtractLoc(Archive moduleFile) {
        String tempExtractLoc = null;
        String appName = Axis2Utils.getApplicationName(moduleFile);
        String root = CacheRootDirectoryTLS.get();
        if (root == null) {
            root = Axis2Utils.getCacheDirectory();
        }
        tempExtractLoc = appName != null ? root + appName + java.io.File.separator + moduleFile.getName() + java.io.File.separator + "module" : root + java.io.File.separator + moduleFile.getName() + java.io.File.separator + "module";
        return tempExtractLoc;
    }

    public static void deleteTempExtractDir(Archive moduleFile) {
        java.io.File tempExtractRoot;
        String tempExtractLoc = Axis2Utils.getTempExtractLoc(moduleFile);
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Removing temporary module extraction root " + tempExtractLoc);
        }
        if ((tempExtractRoot = new java.io.File(tempExtractLoc)).isDirectory()) {
            Axis2Utils.removeDirectory(tempExtractRoot);
        } else if (tempExtractRoot.isFile()) {
            tempExtractRoot.delete();
        }
    }

    public static void deleteExtractedApp(String appName, String moduleName) {
        String sep = java.io.File.separator;
        String extractedAppLocation = Axis2Utils.getCacheDirectory();
        java.io.File file = new java.io.File(extractedAppLocation = extractedAppLocation + appName + sep + moduleName + sep + "installExtract");
        if (file != null && file.isDirectory()) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Deleting temporary application extraction location: " + file.getAbsolutePath());
            }
            Axis2Utils.removeDirectory(file);
        }
    }

    private static void removeDirectory(java.io.File directory) {
        java.io.File[] files;
        for (java.io.File file : files = directory.listFiles()) {
            if (file.isDirectory()) {
                Axis2Utils.removeDirectory(file);
            }
            file.delete();
        }
        directory.delete();
    }

    public static String getApplicationNameFromModule(Archive archive) {
        return Axis2Utils.getApplicationName(archive);
    }

    public static String getFileContainerPath(File file) {
        String containerPath = null;
        ArrayList<String> pathParts = new ArrayList<String>();
        while (file.getLoadingContainer() != null && !file.getLoadingContainer().isEARFile()) {
            pathParts.add(file.getLoadingContainer().getName());
            file = file.getLoadingContainer();
        }
        for (int i = pathParts.size() - 1; i > -1; --i) {
            containerPath = i == pathParts.size() - 1 ? (String)pathParts.get(i) : containerPath + "/" + (String)pathParts.get(i);
        }
        return containerPath;
    }

    public static Object getParameterValue(AxisDescription axisDescription, String paramKey) {
        Parameter param = Axis2Utils.getAxisParameter(axisDescription, paramKey);
        if (param != null) {
            return param.getValue();
        }
        return null;
    }

    private static Parameter getAxisParameter(AxisDescription axisDescription, String paramKey) {
        return axisDescription.getParameter(paramKey);
    }

    public static boolean createAndSetAxisParameter(AxisDescription axisDescription, String paramName, Object value) {
        try {
            Parameter param = new Parameter();
            param.setName(paramName);
            param.setValue(value);
            axisDescription.addParameter(param);
            return true;
        }
        catch (Throwable t) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Error creating and storing Parameter object on AxisDescription: " + t.toString());
            }
            return false;
        }
    }

    public static String getServletLinkValue(AxisService axisService) {
        String linkValue = null;
        if (linkValue == null || "".equals(linkValue)) {
            linkValue = (String)Axis2Utils.getParameterValue(axisService, "com.ibm.ws.websvcs.SERVLET_LINK_VALUE");
        }
        if (linkValue == null || "".equals(linkValue)) {
            linkValue = Axis2Utils.getServiceImplClass(axisService);
        }
        return linkValue;
    }

    public static String getLinkValue(AxisService axisService) {
        String linkValue = null;
        linkValue = (String)Axis2Utils.getParameterValue(axisService, "STATELESS_NAME");
        if (linkValue == null || "".equals(linkValue)) {
            linkValue = (String)Axis2Utils.getParameterValue(axisService, "com.ibm.ws.websvcs.EJB_LINK_VALUE");
        }
        if (linkValue == null || "".equals(linkValue)) {
            linkValue = (String)Axis2Utils.getParameterValue(axisService, "com.ibm.ws.websvcs.SERVLET_LINK_VALUE");
        }
        if (linkValue == null || "".equals(linkValue)) {
            linkValue = Axis2Utils.getServiceImplClass(axisService);
        }
        return linkValue;
    }

    public static String getSimpleName(String className) {
        String simpleName = null;
        if (className != null && className.indexOf(".") != -1) {
            int start = className.lastIndexOf(".") + 1;
            simpleName = className.substring(start, className.length());
        } else if (className != null && className.indexOf("/") != -1) {
            int start = className.lastIndexOf("/") + 1;
            simpleName = className.substring(start, className.length());
        }
        return simpleName;
    }

    public static List<Endpoint> generateEndpoints(ConfigurationContext configContext) {
        Endpoint endpoint = null;
        ArrayList<Endpoint> endpoints = new ArrayList<Endpoint>();
        int hash = SharedConstants.runtimeHash;
        AxisConfiguration ac = configContext.getAxisConfiguration();
        String appName = Axis2Utils.getApplicationName(ac);
        String modName = Axis2Utils.getModuleName(ac);
        Iterator svcGroupIter = ac.getServiceGroups();
        while (svcGroupIter.hasNext()) {
            AxisServiceGroup svcGroup = (AxisServiceGroup)svcGroupIter.next();
            Iterator svcIter = svcGroup.getServices();
            while (svcIter.hasNext()) {
                AxisService axisService = (AxisService)svcIter.next();
                String serviceName = Axis2Utils.getServiceQName(axisService) != null ? Axis2Utils.getServiceQName(axisService).toString() : "";
                String portName = Axis2Utils.getPortName(axisService);
                String urlPattern = Axis2Utils.getURLPattern(axisService);
                endpoint = new Endpoint();
                endpoint.setType("webservices.type.jaxws");
                endpoint.setMbeanId(hash + "_" + appName + "#" + modName);
                endpoint.setApplicationName(appName);
                endpoint.setModuleName(modName);
                endpoint.setServiceName(serviceName);
                endpoint.setPortName(portName);
                endpoint.setUrlPattern(urlPattern);
                endpoint.setPortComponentName(Axis2Utils.getPortComponentName(axisService));
                endpoints.add(endpoint);
            }
        }
        return endpoints;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getContextRoot(ModuleFile moduleFile) {
        String contextRoot = null;
        try {
            if (moduleFile.isWARFile()) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Looking for context-root in WAR module: " + moduleFile.getName());
                }
                WARFile warFile = (WARFile)moduleFile;
                return Axis2Utils.getContextRoot(warFile);
            }
            if (!moduleFile.isEJBJarFile()) return contextRoot;
        }
        catch (Exception e) {
            Object[] inserts = new Object[]{e};
            Tr.error(_tc, "caughtException", inserts);
        }
        return contextRoot;
    }

    private static String getContextRoot(WARFile warFile) throws Exception {
        String contextRoot = null;
        EARFile earFile = warFile.getEARFile();
        Application app = earFile.getDeploymentDescriptor();
        for (Object obj : app.getModules()) {
            WebModule wm;
            if (!(obj instanceof WebModule) || (wm = (WebModule)obj).getUri() == null || !wm.getUri().equals(warFile.getOriginalURI())) continue;
            contextRoot = ((WebModule)obj).getContextRoot();
            break;
        }
        return contextRoot;
    }

    public static String getWSImplementationClassName(PortComponent portComponent, ModuleFile moduleFile) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getWSImplementationClassName");
        }
        String implClassName = null;
        String linkValue = null;
        if (moduleFile.isEJBJarFile()) {
            EJBJarFile ejbJarFile = (EJBJarFile)moduleFile;
            if (portComponent.getServiceImplBean() != null && portComponent.getServiceImplBean().getEEJBLink() != null) {
                linkValue = portComponent.getServiceImplBean().getEEJBLink().getEjbLink();
                if (ejbJarFile.getDeploymentDescriptor() != null) {
                    EnterpriseBean bean = ejbJarFile.getDeploymentDescriptor().getEnterpriseBeanNamed(linkValue);
                    if (bean != null) {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Found EnterpriseBean for port component: " + portComponent.getPortComponentName() + " with " + "link value: " + linkValue);
                        }
                        implClassName = bean.getEjbClassName();
                    } else if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Did not find EnterpriseBean for port component: " + portComponent.getPortComponentName() + " with " + "link value: " + linkValue);
                    }
                } else if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Could not find deployment information for EJB module: " + moduleFile.getName());
                }
            } else if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Did not find ejb-link in the port component: " + portComponent.getPortComponentName() + " within the " + "EJB module: " + moduleFile.getName());
            }
        } else if (moduleFile.isWARFile()) {
            WARFile warFile = (WARFile)moduleFile;
            if (portComponent.getServiceImplBean() != null && portComponent.getServiceImplBean().getEServletLink() != null) {
                linkValue = portComponent.getServiceImplBean().getEServletLink().getServletLink();
                if (warFile.getDeploymentDescriptor() != null) {
                    Servlet servlet = warFile.getDeploymentDescriptor().getServletNamed(linkValue);
                    if (servlet != null) {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Found servlet for port component: " + portComponent.getPortComponentName() + " with link value: " + linkValue);
                        }
                        if (servlet.getServletClass() != null) {
                            implClassName = servlet.getServletClass().getQualifiedName();
                        } else if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "The servlet: " + linkValue + " in the WAR " + "module: " + moduleFile.getName() + " does not have " + "a <servlet-class> element");
                        }
                    } else if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Did not find servlet for port component: " + portComponent.getPortComponentName() + " with " + "link value: " + linkValue);
                    }
                } else if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Could not find deployment information for WAR module: " + moduleFile.getName());
                }
            } else if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Did not find servlet-link in the port component: " + portComponent.getPortComponentName() + " within the WAR " + "module: " + moduleFile.getName());
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getWSImplementationClassName");
        }
        return implClassName;
    }

    public static void setContextRoot(ConfigurationContext configContext, String contextRoot) {
        if (configContext != null) {
            configContext.setProperty("com.ibm.ws.websvcs.CONFIG_CONTEXT_ROOT", contextRoot);
        }
    }

    public static String getContextRoot(ConfigurationContext configContext) {
        if (configContext != null) {
            return (String)configContext.getProperty("com.ibm.ws.websvcs.CONFIG_CONTEXT_ROOT");
        }
        return null;
    }

    public static boolean scanModule(ModuleFile moduleFile) {
        return Axis2Utils.scanModule(moduleFile, serverScanPolicy);
    }

    static boolean scanModule(ModuleFile moduleFile, String serverScanPolicy) {
        Attributes attrs;
        String value;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "scanModule, module= " + moduleFile.getName());
        }
        Boolean scanModule = null;
        Boolean serverProperty = null;
        Boolean manifestProperty = null;
        if (serverScanPolicy != null) {
            serverProperty = Boolean.valueOf(serverScanPolicy);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "UseWSFEP61ScanPolicy set to: " + serverScanPolicy + " in server process");
            }
        }
        if (!Axis2Utils.isServerEnv() && serverScanPolicy == null) {
            if (scanAccordingToConfig == null) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Looking for annotation scanning property in server.xml");
                }
                scanAccordingToConfig = Axis2Utils.scanAccordingToConfig();
            }
            serverProperty = scanAccordingToConfig;
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "UseWSFEP61ScanPolicy set to: " + serverProperty + " in server configuration");
            }
        }
        if ((value = (attrs = moduleFile.getManifest().getMainAttributes()).getValue("UseWSFEP61ScanPolicy")) != null) {
            manifestProperty = Boolean.valueOf(value);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "For module: " + moduleFile.getName() + " UseWSFEP61ScanPolicy set " + "to: " + value + " in MANIFEST.MF");
            }
        }
        Integer ddId = null;
        Integer j2EE5Id = null;
        if (moduleFile instanceof WARFile) {
            j2EE5Id = 25;
            ddId = ((WARFile)moduleFile).getDeploymentDescriptor(false).getVersionID();
        } else if (moduleFile instanceof EJBJarFile) {
            ddId = ((EJBJarFile)moduleFile).getDeploymentDescriptor(false).getVersionID();
            j2EE5Id = 30;
        } else if (moduleFile instanceof ApplicationClientFile) {
            ddId = ((ApplicationClientFile)moduleFile).getDeploymentDescriptor(false).getVersionID();
            j2EE5Id = 50;
        }
        if (ddId != null) {
            if (ddId < j2EE5Id) {
                if (manifestProperty != null && manifestProperty.booleanValue()) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "The module " + moduleFile.getName() + " is not a J2EE 5 or higher " + "module, but it will be scanned for annotations because the " + "UseWSFEP61ScanPolicy property was set to true in the module's MANIFEST.MF");
                    }
                    scanModule = true;
                } else if (manifestProperty != null && !manifestProperty.booleanValue()) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "The module " + moduleFile.getName() + " is not a J2EE 5 or higher " + "module, and will not be scanned for annotations because the " + "UseWSFEP61ScanPolicy property was set to false in the module's MANIFEST.MF");
                    }
                    scanModule = false;
                } else if (manifestProperty == null && serverProperty != null && serverProperty.booleanValue()) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "The module " + moduleFile.getName() + " is not a J2EE 5 or higher " + "module, but it will be scanned for annotations because the " + "UseWSFEP61ScanPolicy property was set to true in the server process");
                    }
                    scanModule = true;
                } else if (manifestProperty == null && serverProperty != null && !serverProperty.booleanValue()) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "The module " + moduleFile.getName() + " is not a J2EE 5 or higher " + "module, and will not be scanned for annotations because the " + "UseWSFEP61ScanPolicy property was set to false in the server process");
                    }
                    scanModule = false;
                } else {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "The module " + moduleFile.getName() + " is not a J2EE 5 or higher " + "module, and it will not be scanned for annotations because the " + "UseWSFEP61ScanPolicy property was not set to true in the module's " + "MANIFEST.MF or in the server process");
                    }
                    scanModule = false;
                }
            } else {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "The module " + moduleFile.getName() + " is a J2EE 5 or higher " + "module, and it will be scanned for annotations");
                }
                scanModule = true;
            }
        } else {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "The module " + moduleFile.getName() + " did not indicate a version ID. " + "It will not be scanned for annotations");
            }
            scanModule = false;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "scanModule, module= " + moduleFile.getName() + ", scan= " + scanModule);
        }
        return scanModule;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    static Boolean scanAccordingToConfig() {
        Boolean scan;
        block25: {
            scan = null;
            ConfigService configService = ConfigServiceFactory.getConfigService();
            Session session = null;
            if (configService == null) {
                return scan;
            }
            session = new Session();
            ObjectName query = ConfigServiceHelper.createObjectName(null, "Server");
            ObjectName[] server = configService.queryConfigObjects(session, null, query, null);
            if (server != null && server.length > 0) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Querying server objects with length: " + server.length);
                }
                for (ObjectName objServer : server) {
                    ObjectName comp;
                    ObjectName jvmEntObj = ConfigServiceHelper.createObjectName(null, "JavaVirtualMachine");
                    ObjectName[] comps = configService.queryConfigObjects(session, objServer, jvmEntObj, null);
                    ObjectName objectName = comp = comps != null && comps.length > 0 ? comps[0] : null;
                    if (comp != null) {
                        String args = (String)configService.getAttribute(session, comp, "genericJvmArguments");
                        if (args != null) {
                            Tr.debug(_tc, "Found the following genericJvmArguments in server.xml: " + args);
                            scan = args.contains("com.ibm.websphere.webservices.UseWSFEP61ScanPolicy=true");
                        }
                        if (scan == null || !scan.booleanValue()) {
                            ObjectName systemPropsObj = ConfigServiceHelper.createObjectName(null, "Property");
                            ObjectName[] systemProps = configService.queryConfigObjects(session, comp, systemPropsObj, null);
                            if (systemProps != null && systemProps.length > 0) {
                                for (ObjectName systemProp : systemProps) {
                                    String name = (String)configService.getAttribute(session, systemProp, "name");
                                    String value = (String)configService.getAttribute(session, systemProp, "value");
                                    if (!"com.ibm.websphere.webservices.UseWSFEP61ScanPolicy".equals(name) || !Boolean.valueOf(value).booleanValue()) continue;
                                    if (_tc.isDebugEnabled()) {
                                        Tr.debug(_tc, "Found JAX-WS annotation scanning property set to true in server.xml");
                                    }
                                    scan = true;
                                    break;
                                }
                            } else if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "ObjectNames not found for systemProperties in server.xml");
                            }
                        }
                    }
                    if (scan != null && scan.booleanValue()) break;
                }
            }
            Object var22_24 = null;
            try {
                if (session != null) {
                    configService.discard(session);
                }
                break block25;
            }
            catch (Throwable tt) {
                Tr.error(_tc, "Throwable caught when trying to discard the Session " + tt.toString());
            }
            break block25;
            {
                catch (Throwable t) {
                    if (_tc.isDebugEnabled()) {
                        StringWriter sw = new StringWriter();
                        PrintWriter pw = new PrintWriter(sw);
                        t.printStackTrace(pw);
                        Tr.debug(_tc, "The annotation scanning policy could not be read from the server config due to the following error: \n" + sw.toString());
                    }
                    Object var22_25 = null;
                    try {
                        if (session != null) {
                            configService.discard(session);
                        }
                        break block25;
                    }
                    catch (Throwable tt) {
                        Tr.error(_tc, "Throwable caught when trying to discard the Session " + tt.toString());
                    }
                }
            }
            catch (Throwable throwable) {
                Object var22_26 = null;
                try {
                    if (session != null) {
                        configService.discard(session);
                    }
                }
                catch (Throwable tt) {
                    Tr.error(_tc, "Throwable caught when trying to discard the Session " + tt.toString());
                }
                throw throwable;
            }
        }
        return scan;
    }

    public static String getServletFilePath(String fullPath) {
        String parsedPath = null;
        try {
            URL url = new URL(fullPath);
            if (!url.getProtocol().equals("file")) {
                return null;
            }
            parsedPath = url.getFile();
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (parsedPath == null) {
            try {
                java.io.File file = new java.io.File(fullPath);
                parsedPath = file.toURI().toURL().getFile();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (parsedPath != null) {
            if (parsedPath.contains(":")) {
                parsedPath = parsedPath.substring(parsedPath.indexOf(":") + 1, parsedPath.length());
            }
            if (parsedPath.startsWith("/")) {
                parsedPath = parsedPath.substring(1);
            }
            parsedPath = parsedPath.replace("\\", "/");
        }
        return parsedPath;
    }

    public static String getServletFilePathPrefix(String fullPath) {
        String parsedProtocol = null;
        String parsedPath = Axis2Utils.getServletFilePath(fullPath = fullPath.replace("\\", "/"));
        if (parsedPath != null && fullPath.indexOf(parsedPath) != -1) {
            parsedProtocol = fullPath.substring(0, fullPath.indexOf(parsedPath));
        }
        if (parsedProtocol != null && !parsedProtocol.startsWith("file:") && !parsedProtocol.startsWith("/")) {
            parsedProtocol = parsedProtocol.replace("/", java.io.File.separator);
        }
        return parsedProtocol;
    }

    public static WARFile getRouterWAR(EJBJarFile ejbJarFile) {
        File routerWAR;
        block7: {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "getRouterWAR, ejbJar= " + ejbJarFile.getName());
            }
            routerWAR = null;
            try {
                List warFiles;
                String httpRouterModuleName = null;
                WSBinding wsb = WSModels.getWSBinding(ejbJarFile.getLoadStrategy(), "META-INF/ibm-webservices-bnd.xmi");
                if (wsb != null) {
                    for (RouterModule router : wsb.getRouterModules()) {
                        String transport = router.getTransport();
                        if (transport == null || !transport.equals("http")) continue;
                        httpRouterModuleName = router.getName();
                        break;
                    }
                }
                if (ejbJarFile.getEARFile() == null || httpRouterModuleName == null || (warFiles = ejbJarFile.getEARFile().getWARFiles()) == null || warFiles.isEmpty()) break block7;
                for (WARFile mf : warFiles) {
                    if (!mf.getName().equals(httpRouterModuleName)) continue;
                    routerWAR = mf;
                    break;
                }
            }
            catch (Throwable t) {
                if (!_tc.isDebugEnabled()) break block7;
                Tr.debug(_tc, "Could not find router WAR for the " + ejbJarFile.getName() + " EJB " + "because of the following error: " + t.toString());
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getRouterWAR, ejbJar= " + ejbJarFile.getName() + ", routerWAR= " + (routerWAR != null ? routerWAR.getName() : null));
        }
        return routerWAR;
    }

    public static String getURLPattern(AxisService axisService, ModuleFile moduleFile) {
        WebApp webApp;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getURLPattern, axisService= " + axisService.getName() + ", moduleFile= " + moduleFile.getName());
        }
        String endpointURL = Axis2Utils.getURLPattern(axisService);
        WARFile warFile = null;
        if (moduleFile.isEJBJarFile()) {
            warFile = Axis2Utils.getRouterWAR((EJBJarFile)moduleFile);
        } else if (moduleFile.isWARFile()) {
            warFile = (WARFile)moduleFile;
        }
        if (warFile != null && (webApp = warFile.getDeploymentDescriptor()) != null) {
            Servlet servlet;
            String serviceImplClass = Axis2Utils.getServiceImplClass(axisService);
            String servletLink = Axis2Utils.getLinkValue(axisService);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Looking for servlet for class: " + serviceImplClass + " with " + "link value: " + servletLink);
            }
            if ((servlet = Axis2Utils.locateServlet(webApp, servletLink)) == null && !servletLink.equals(serviceImplClass)) {
                servlet = Axis2Utils.locateServlet(webApp, serviceImplClass);
            }
            if (servlet != null) {
                ServletMapping servletMapping;
                List mappingList;
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Found matching servlet: " + servlet.getServletName());
                }
                if ((mappingList = servlet.getMappings()) != null && !mappingList.isEmpty() && (servletMapping = (ServletMapping)mappingList.get(0)).getUrlPattern() != null && !"".equals(servletMapping.getUrlPattern())) {
                    endpointURL = servletMapping.getUrlPattern();
                }
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getURLPattern, axisService= " + axisService.getName() + ", moduleFile= " + moduleFile.getName() + ", endpointURL= " + endpointURL);
        }
        return endpointURL;
    }

    static Servlet locateServlet(WebApp webApp, String value) {
        for (Servlet servlet : webApp.getServlets()) {
            String svClassName;
            String string = svClassName = servlet.getServletClass() != null ? servlet.getServletClass().getQualifiedName() : "";
            if (value.equals(servlet.getServletName())) {
                return servlet;
            }
            if (!value.equals(svClassName)) continue;
            return servlet;
        }
        return null;
    }

    static {
        scanAccordingToConfig = null;
        serverRoot = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("was.install.root");
            }
        });
        serverScanPolicy = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("com.ibm.websphere.webservices.UseWSFEP61ScanPolicy");
            }
        });
        WSDL_GEN_EXTRA_CP = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(Constants.WSDL_GENERATION_EXTRA_CLASSPATH);
            }
        });
    }
}

