/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.transport.security;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.policyset.runtime.PolicySetConfiguration;
import com.ibm.ws.websvcs.resources.NLSProvider;
import com.ibm.ws.websvcs.utils.Axis2Utils;
import com.ibm.wsspi.websvcs.Axis2ServiceConfigPluginBase;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;

public class SSLConfigPlugin
extends Axis2ServiceConfigPluginBase {
    private static final TraceComponent _tc = Tr.register(SSLConfigPlugin.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");

    public void config(HashMap hm) throws AxisFault, DeploymentException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "SSLConfigPlugin.config()...", hm);
        }
        AxisService service = (AxisService)hm.get("com.ibm.wsspi.websvcs.AxisServiceKey");
        this.checkSSLPolicySets(service);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...SSLConfigPlugin.config()");
        }
    }

    private void checkSSLPolicySets(AxisService service) throws AxisFault, DeploymentException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "SSLConfigPlugin.checkSSLPolicySets()...");
        }
        if (service != null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "AxisService found: " + service);
            }
            Iterator operIter = service.getOperations();
            PolicySetConfiguration policySet = null;
            int opersWithSSL = 0;
            int totalOpers = 0;
            while (operIter.hasNext()) {
                AxisOperation operation = (AxisOperation)operIter.next();
                policySet = (PolicySetConfiguration)Axis2Utils.getPolicySet(operation);
                String operationName = operation.getName().getLocalPart();
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "    Policy Set found for operation: " + operationName);
                }
                if (this.isWASOperation(operation)) continue;
                if (policySet != null) {
                    Properties type = (Properties)policySet.getPolicyTypeConfiguration("SSL_POLICY");
                    Properties bind = (Properties)policySet.getPolicyTypeBinding("SSL_BINDING");
                    if (type != null) {
                        ++opersWithSSL;
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "    Policy Type found for operation.");
                        }
                    }
                    if (bind != null && _tc.isDebugEnabled()) {
                        Tr.debug(_tc, "    Policy Binding found for operation.");
                    }
                }
                ++totalOpers;
            }
            if (opersWithSSL != 0 && opersWithSSL != totalOpers) {
                Object[] inserts = new Object[]{Axis2Utils.getServiceName(service)};
                String msg = NLSProvider.getNLS().getFormattedMessage("invalidOperationsSSL", inserts, "All operations for service {0} do not have an SSL policy set attached.");
                throw new DeploymentException(msg);
            }
            if (opersWithSSL != 0) {
                Axis2Utils.setConstrainService(service, Boolean.TRUE);
            }
            if ((policySet = (PolicySetConfiguration)Axis2Utils.getPolicySet(service)) != null) {
                Properties type = (Properties)policySet.getPolicyTypeConfiguration("SSL_POLICY");
                Properties bind = (Properties)policySet.getPolicyTypeBinding("SSL_BINDING");
                if (_tc.isDebugEnabled()) {
                    if (type != null) {
                        Tr.debug(_tc, "    Policy Type found for service.");
                    }
                    if (bind != null) {
                        Tr.debug(_tc, "    Policy Binding found for service.");
                    }
                }
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...SSLConfigPlugin.checkSSLPolicySets()");
        }
    }

    private boolean isWASOperation(AxisOperation operation) {
        QName opName;
        return operation == null || (opName = operation.getName()) == null || opName.getNamespaceURI() == null || opName.getNamespaceURI().equals("");
    }
}

