/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.transport.policyset;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.policyset.runtime.BindingLoader;
import com.ibm.ws.policyset.runtime.DefaultBinding;
import com.ibm.ws.policyset.runtime.PolicySetConfiguration;
import com.ibm.ws.policyset.runtime.VariableExpander;
import com.ibm.ws.websvcs.transport.policyset.PolicySetUtils;
import com.ibm.ws.websvcs.transport.policyset.PolicyTypeFileHelper;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;

public class SSLDefaultBindingLoader
implements BindingLoader {
    private static final TraceComponent _tc = Tr.register(SSLDefaultBindingLoader.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");

    public void init(Map properties) throws Exception {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "init");
        }
    }

    public void loadCustom(ClassLoader appCL, ClassLoader sysCL, VariableExpander expander, InputStream input, DefaultBinding defaultBinding, PolicySetConfiguration psConfig) throws Exception {
        Properties attributes;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "loadCustom", new Object[]{appCL, sysCL, expander, input, defaultBinding, psConfig});
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Reading custom binding policy from " + input);
        }
        if ((attributes = PolicyTypeFileHelper.readBinding(input)) == null || attributes.isEmpty()) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Custom binding is not available...reading default binding policy...");
            }
            attributes = (Properties)defaultBinding.getDefaultBinding("SSL_BINDING");
        }
        if (attributes != null && !attributes.isEmpty() && psConfig != null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Setting binding properties to PolicySet configuration...");
            }
            PolicySetUtils.expandAttributes(attributes, expander);
            psConfig.setPolicyTypeBinding("SSL_BINDING", attributes);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "loadCustom");
        }
    }

    public void loadDefault(ClassLoader sysCL, VariableExpander expander, InputStream input, DefaultBinding defaultBinding) throws Exception {
        Properties attributes;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "loadDefault", new Object[]{sysCL, expander, input, defaultBinding});
        }
        if ((attributes = PolicyTypeFileHelper.readBinding(input)) != null && !attributes.isEmpty()) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Read default binding properties from: " + input);
            }
            PolicySetUtils.expandAttributes(attributes, expander);
            if (defaultBinding != null) {
                defaultBinding.setDefaultBinding("SSL_BINDING", attributes);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "loadDefault");
        }
    }

    public String getType() throws Exception {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "getType", "SSLTransport");
        }
        return "SSLTransport";
    }

    public void destroy() throws Exception {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "destroy");
        }
    }
}

